import { PaginationService } from "./pagination.service";
import * as ɵngcc0 from '@angular/core';
export declare type Collection<T> = T[] | ReadonlyArray<T>;
export interface PaginatePipeArgs {
    id?: string;
    itemsPerPage?: string | number;
    currentPage?: string | number;
    totalItems?: string | number;
}
export interface PipeState {
    collection: any[];
    size: number;
    start: number;
    end: number;
    slice: any[];
}
export declare class PaginatePipe {
    private service;
    private state;
    constructor(service: PaginationService);
    transform<T, U extends Collection<T>>(collection: U, args: PaginatePipeArgs): U;
    /**
     * Create an PaginationInstance object, using defaults for any optional properties not supplied.
     */
    private createInstance;
    /**
     * Ensure the argument passed to the filter contains the required properties.
     */
    private checkConfig;
    /**
     * To avoid returning a brand new array each time the pipe is run, we store the state of the sliced
     * array for a given id. This means that the next time the pipe is run on this collection & id, we just
     * need to check that the collection, start and end points are all identical, and if so, return the
     * last sliced array.
     */
    private saveState;
    /**
     * For a given id, returns true if the collection, size, start and end values are identical.
     */
    private stateIsIdentical;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<PaginatePipe, never>;
    static ɵpipe: ɵngcc0.ɵɵPipeDefWithMeta<PaginatePipe, "paginate">;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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