(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs/operators'), require('@angular/common'), require('rxjs')) :
    typeof define === 'function' && define.amd ? define('ngx-stripe', ['exports', '@angular/core', 'rxjs/operators', '@angular/common', 'rxjs'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global['ngx-stripe'] = {}, global.ng.core, global.rxjs.operators, global.ng.common, global.rxjs));
}(this, (function (exports, core, operators, common, rxjs) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (Object.prototype.hasOwnProperty.call(b, p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try {
                step(generator.next(value));
            }
            catch (e) {
                reject(e);
            } }
            function rejected(value) { try {
                step(generator["throw"](value));
            }
            catch (e) {
                reject(e);
            } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () { if (t[0] & 1)
                throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    var __createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                __createBinding(o, m, p);
    }
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    function __spreadArray(to, from) {
        for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
            to[j] = from[i];
        return to;
    }
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n])
            i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try {
            step(g[n](v));
        }
        catch (e) {
            settle(q[0][3], e);
        } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length)
            resume(q[0][0], q[0][1]); }
    }
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }

    var STRIPE_PUBLISHABLE_KEY = new core.InjectionToken('Stripe Publishable Key');
    var STRIPE_OPTIONS = new core.InjectionToken('Stripe Options');
    var NGX_STRIPE_VERSION = new core.InjectionToken('NGX_STRIPE_VERSION');

    var WindowRef = /** @class */ (function () {
        function WindowRef(platformId) {
            this.platformId = platformId;
        }
        WindowRef.prototype.getNativeWindow = function () {
            if (common.isPlatformBrowser(this.platformId)) {
                return window;
            }
            return {};
        };
        return WindowRef;
    }());
    WindowRef.decorators = [
        { type: core.Injectable }
    ];
    WindowRef.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: core.Inject, args: [core.PLATFORM_ID,] }] }
    ]; };

    var DocumentRef = /** @class */ (function () {
        function DocumentRef(platformId) {
            this.platformId = platformId;
        }
        DocumentRef.prototype.getNativeDocument = function () {
            if (common.isPlatformBrowser(this.platformId)) {
                return document;
            }
            return {};
        };
        return DocumentRef;
    }());
    DocumentRef.decorators = [
        { type: core.Injectable }
    ];
    DocumentRef.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: core.Inject, args: [core.PLATFORM_ID,] }] }
    ]; };

    var LazyStripeAPILoader = /** @class */ (function () {
        function LazyStripeAPILoader(platformId, window, document) {
            this.platformId = platformId;
            this.window = window;
            this.document = document;
            this.status = new rxjs.BehaviorSubject({
                error: false,
                loaded: false,
                loading: false
            });
        }
        LazyStripeAPILoader.prototype.asStream = function () {
            this.load();
            return this.status.asObservable();
        };
        LazyStripeAPILoader.prototype.isReady = function () {
            return this.status.getValue().loaded;
        };
        LazyStripeAPILoader.prototype.load = function () {
            var _this = this;
            if (common.isPlatformServer(this.platformId)) {
                return;
            }
            var status = this.status.getValue();
            if (this.window.getNativeWindow().hasOwnProperty('Stripe')) {
                this.status.next({
                    error: false,
                    loaded: true,
                    loading: false
                });
            }
            else if (!status.loaded && !status.loading) {
                this.status.next(Object.assign(Object.assign({}, status), { loading: true }));
                var script = this.document.getNativeDocument().createElement('script');
                script.type = 'text/javascript';
                script.async = true;
                script.defer = true;
                script.src = 'https://js.stripe.com/v3/';
                script.onload = function () {
                    _this.status.next({
                        error: false,
                        loaded: true,
                        loading: false
                    });
                };
                script.onerror = function () {
                    _this.status.next({
                        error: true,
                        loaded: false,
                        loading: false
                    });
                };
                this.document.getNativeDocument().body.appendChild(script);
            }
        };
        return LazyStripeAPILoader;
    }());
    LazyStripeAPILoader.decorators = [
        { type: core.Injectable }
    ];
    LazyStripeAPILoader.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: core.Inject, args: [core.PLATFORM_ID,] }] },
        { type: WindowRef },
        { type: DocumentRef }
    ]; };

    var StripeInstance = /** @class */ (function () {
        function StripeInstance(version, loader, window, key, options) {
            var _this = this;
            this.version = version;
            this.loader = loader;
            this.window = window;
            this.key = key;
            this.options = options;
            this.stripe$ = new rxjs.BehaviorSubject(undefined);
            this.stripe = this.stripe$
                .asObservable()
                .pipe(operators.filter(function (stripe) { return Boolean(stripe); }));
            this.loader
                .asStream()
                .pipe(operators.filter(function (status) { return status.loaded === true; }), operators.first(), operators.map(function () { return _this.window.getNativeWindow().Stripe; }))
                .subscribe(function (stripeInstance) {
                var stripe = _this.options
                    ? stripeInstance(_this.key, _this.options)
                    : stripeInstance(_this.key);
                stripe.registerAppInfo(_this.getNgxStripeAppInfo(_this.version));
                _this.stripe$.next(stripe);
            });
        }
        StripeInstance.prototype.getInstance = function () {
            return this.stripe$.getValue();
        };
        StripeInstance.prototype.elements = function (options) {
            return this.stripe$.asObservable().pipe(operators.filter(function (stripe) { return Boolean(stripe); }), operators.map(function (stripe) { return stripe.elements(options); }), operators.first());
        };
        StripeInstance.prototype.redirectToCheckout = function (options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.redirectToCheckout(options)); }), operators.first());
        };
        StripeInstance.prototype.confirmAuBecsDebitPayment = function (clientSecret, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmAuBecsDebitPayment(clientSecret, data)); }), operators.first());
        };
        StripeInstance.prototype.confirmBancontactPayment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmBancontactPayment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmCardPayment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmCardPayment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmEpsPayment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmEpsPayment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmFpxPayment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmFpxPayment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmGiropayPayment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmGiropayPayment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmIdealPayment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmIdealPayment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmP24Payment = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmP24Payment(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmSepaDebitPayment = function (clientSecret, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmSepaDebitPayment(clientSecret, data)); }), operators.first());
        };
        StripeInstance.prototype.handleCardAction = function (clientSecret) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.handleCardAction(clientSecret)); }), operators.first());
        };
        StripeInstance.prototype.createPaymentMethod = function (paymentMethodData) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.createPaymentMethod(paymentMethodData)); }), operators.first());
        };
        StripeInstance.prototype.retrievePaymentIntent = function (clientSecret) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.retrievePaymentIntent(clientSecret)); }), operators.first());
        };
        StripeInstance.prototype.confirmAuBecsDebitSetup = function (clientSecret, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmAuBecsDebitSetup(clientSecret, data)); }), operators.first());
        };
        StripeInstance.prototype.confirmCardSetup = function (clientSecret, data, options) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmCardSetup(clientSecret, data, options)); }), operators.first());
        };
        StripeInstance.prototype.confirmSepaDebitSetup = function (clientSecret, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmSepaDebitSetup(clientSecret, data)); }), operators.first());
        };
        StripeInstance.prototype.retrieveSetupIntent = function (clientSecret) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.retrieveSetupIntent(clientSecret)); }), operators.first());
        };
        StripeInstance.prototype.paymentRequest = function (options) {
            var stripe = this.getInstance();
            return stripe ? stripe.paymentRequest(options) : undefined;
        };
        StripeInstance.prototype.createToken = function (tokenType, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.createToken(tokenType, data)); }), operators.first());
        };
        StripeInstance.prototype.createSource = function (a, b) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.createSource(a, b)); }), operators.first());
        };
        StripeInstance.prototype.retrieveSource = function (source) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.retrieveSource(source)); }), operators.first());
        };
        /**
         * @deprecated
         */
        StripeInstance.prototype.handleCardPayment = function (clientSecret, element, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.handleCardPayment(clientSecret, element, data)); }), operators.first());
        };
        /**
         * @deprecated
         */
        StripeInstance.prototype.confirmPaymentIntent = function (clientSecret, element, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmPaymentIntent(clientSecret, element, data)); }), operators.first());
        };
        /**
         * @deprecated
         */
        StripeInstance.prototype.handleCardSetup = function (clientSecret, element, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.handleCardSetup(clientSecret, element, data)); }), operators.first());
        };
        /**
         * @deprecated
         */
        StripeInstance.prototype.confirmSetupIntent = function (clientSecret, element, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.confirmSetupIntent(clientSecret, element, data)); }), operators.first());
        };
        /**
         * @deprecated
         */
        StripeInstance.prototype.handleFpxPayment = function (clientSecret, element, data) {
            return this.stripe.pipe(operators.switchMap(function (stripe) { return rxjs.from(stripe.handleFpxPayment(clientSecret, element, data)); }), operators.first());
        };
        StripeInstance.prototype.getNgxStripeAppInfo = function (version) {
            return {
                name: 'ngx-stripe',
                url: 'https://ngx-stripe.dev',
                partner_id: 'pp_partner_JR4l1rmvUoPP4V',
                version: version
            };
        };
        return StripeInstance;
    }());

    var StripeService = /** @class */ (function () {
        function StripeService(version, key, options, loader, window) {
            this.version = version;
            this.key = key;
            this.options = options;
            this.loader = loader;
            this.window = window;
            if (key) {
                this.stripe = new StripeInstance(this.version, this.loader, this.window, key, options);
            }
        }
        StripeService.prototype.getStripeReference = function () {
            var _this = this;
            return this.loader.asStream().pipe(operators.filter(function (status) { return status.loaded === true; }), operators.map(function () { return _this.window.getNativeWindow().Stripe; }));
        };
        StripeService.prototype.getInstance = function () {
            return this.stripe.getInstance();
        };
        StripeService.prototype.setKey = function (key, options) {
            return this.changeKey(key, options);
        };
        StripeService.prototype.changeKey = function (key, options) {
            this.stripe = new StripeInstance(this.version, this.loader, this.window, key, options);
            return this.stripe;
        };
        StripeService.prototype.elements = function (options) {
            return this.stripe.elements(options);
        };
        StripeService.prototype.redirectToCheckout = function (options) {
            return this.stripe.redirectToCheckout(options);
        };
        StripeService.prototype.confirmAuBecsDebitPayment = function (clientSecret, data) {
            return this.stripe.confirmAuBecsDebitPayment(clientSecret, data);
        };
        StripeService.prototype.confirmBancontactPayment = function (clientSecret, data, options) {
            return this.stripe.confirmBancontactPayment(clientSecret, data, options);
        };
        StripeService.prototype.confirmCardPayment = function (clientSecret, data, options) {
            return this.stripe.confirmCardPayment(clientSecret, data, options);
        };
        StripeService.prototype.confirmEpsPayment = function (clientSecret, data, options) {
            return this.stripe.confirmEpsPayment(clientSecret, data, options);
        };
        StripeService.prototype.confirmFpxPayment = function (clientSecret, data, options) {
            return this.stripe.confirmFpxPayment(clientSecret, data, options);
        };
        StripeService.prototype.confirmGiropayPayment = function (clientSecret, data, options) {
            return this.stripe.confirmGiropayPayment(clientSecret, data, options);
        };
        StripeService.prototype.confirmIdealPayment = function (clientSecret, data, options) {
            return this.stripe.confirmIdealPayment(clientSecret, data, options);
        };
        StripeService.prototype.confirmP24Payment = function (clientSecret, data, options) {
            return this.stripe.confirmP24Payment(clientSecret, data, options);
        };
        StripeService.prototype.confirmSepaDebitPayment = function (clientSecret, data) {
            return this.stripe.confirmSepaDebitPayment(clientSecret, data);
        };
        StripeService.prototype.handleCardAction = function (clientSecret) {
            return this.stripe.handleCardAction(clientSecret);
        };
        StripeService.prototype.createPaymentMethod = function (paymentMethodData) {
            return this.stripe.createPaymentMethod(paymentMethodData);
        };
        StripeService.prototype.retrievePaymentIntent = function (clientSecret) {
            return this.stripe.retrievePaymentIntent(clientSecret);
        };
        StripeService.prototype.confirmAuBecsDebitSetup = function (clientSecret, data) {
            return this.stripe.confirmAuBecsDebitSetup(clientSecret, data);
        };
        StripeService.prototype.confirmCardSetup = function (clientSecret, data, options) {
            return this.stripe.confirmCardSetup(clientSecret, data, options);
        };
        StripeService.prototype.confirmSepaDebitSetup = function (clientSecret, data) {
            return this.stripe.confirmSepaDebitSetup(clientSecret, data);
        };
        StripeService.prototype.retrieveSetupIntent = function (clientSecret) {
            return this.stripe.retrieveSetupIntent(clientSecret);
        };
        StripeService.prototype.paymentRequest = function (options) {
            return this.stripe.paymentRequest(options);
        };
        StripeService.prototype.createToken = function (tokenType, data) {
            return this.stripe.createToken(tokenType, data);
        };
        StripeService.prototype.createSource = function (a, b) {
            return this.stripe.createSource(a, b);
        };
        StripeService.prototype.retrieveSource = function (source) {
            return this.stripe.retrieveSource(source);
        };
        /**
         * @deprecated
         */
        StripeService.prototype.handleCardPayment = function (clientSecret, element, data) {
            return this.stripe.handleCardPayment(clientSecret, element, data);
        };
        /**
         * @deprecated
         */
        StripeService.prototype.confirmPaymentIntent = function (clientSecret, element, data) {
            return this.stripe.confirmPaymentIntent(clientSecret, element, data);
        };
        /**
         * @deprecated
         */
        StripeService.prototype.handleCardSetup = function (clientSecret, element, data) {
            return this.stripe.handleCardSetup(clientSecret, element, data);
        };
        /**
         * @deprecated
         */
        StripeService.prototype.confirmSetupIntent = function (clientSecret, element, data) {
            return this.stripe.confirmSetupIntent(clientSecret, element, data);
        };
        /**
         * @deprecated
         */
        StripeService.prototype.handleFpxPayment = function (clientSecret, element, data) {
            return this.stripe.handleFpxPayment(clientSecret, element, data);
        };
        return StripeService;
    }());
    StripeService.decorators = [
        { type: core.Injectable }
    ];
    StripeService.ctorParameters = function () { return [
        { type: String, decorators: [{ type: core.Inject, args: [NGX_STRIPE_VERSION,] }] },
        { type: String, decorators: [{ type: core.Inject, args: [STRIPE_PUBLISHABLE_KEY,] }] },
        { type: undefined, decorators: [{ type: core.Inject, args: [STRIPE_OPTIONS,] }] },
        { type: LazyStripeAPILoader },
        { type: WindowRef }
    ]; };

    var StripeElementsService = /** @class */ (function () {
        function StripeElementsService(stripeService) {
            this.stripeService = stripeService;
        }
        StripeElementsService.prototype.elements = function (stripe, options) {
            if (options === void 0) { options = {}; }
            if (stripe) {
                if (Object.keys(options).length > 0) {
                    return stripe.elements(options);
                }
                return stripe.elements();
            }
            else {
                if (Object.keys(options).length > 0) {
                    return this.stripeService.elements(options);
                }
                return this.stripeService.elements();
            }
        };
        StripeElementsService.prototype.paymentRequest = function (stripe, options) {
            return stripe
                ? stripe.paymentRequest(options)
                : this.stripeService.paymentRequest(options);
        };
        StripeElementsService.prototype.mergeOptions = function (options, containerClass) {
            if (!containerClass || (options && options.classes)) {
                return options || {};
            }
            if (!options || !options.classes) {
                return Object.assign(Object.assign({}, (options || {})), { classes: {
                        base: containerClass,
                        complete: containerClass + "--complete",
                        empty: containerClass + "--empty",
                        focus: containerClass + "--focus",
                        invalid: containerClass + "--invalid",
                        webkitAutoFill: containerClass + "--webkit-autoFill"
                    } });
            }
            return options || {};
        };
        return StripeElementsService;
    }());
    StripeElementsService.decorators = [
        { type: core.Injectable }
    ];
    StripeElementsService.ctorParameters = function () { return [
        { type: StripeService }
    ]; };

    var StripeCardComponent = /** @class */ (function () {
        function StripeCardComponent(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
            this.state = 'notready';
        }
        StripeCardComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var options, updateElements, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            this.state = 'starting';
                            options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
                            updateElements = false;
                            if (!(changes.elementsOptions || changes.stripe || !this.elements)) return [3 /*break*/, 2];
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe, this.elementsOptions)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            updateElements = true;
                            _b.label = 2;
                        case 2:
                            if (changes.options ||
                                changes.containerClass ||
                                !this.element ||
                                updateElements) {
                                if (this.element && !updateElements) {
                                    this.update(options);
                                }
                                else if (this.elements && updateElements) {
                                    this.createElement(options);
                                }
                            }
                            this.state = 'ready';
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripeCardComponent.prototype.ngOnInit = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(this.state === 'notready')) return [3 /*break*/, 2];
                            this.state = 'starting';
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            this.createElement();
                            this.state = 'ready';
                            _b.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        };
        StripeCardComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
        };
        StripeCardComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeCardComponent.prototype.getCard = function () {
            return this.element;
        };
        StripeCardComponent.prototype.createElement = function (options) {
            var _this = this;
            if (options === void 0) { options = {}; }
            this.element = this.elements.create('card', options);
            this.element.on('change', function (ev) { return _this.change.emit(ev); });
            this.element.on('blur', function () { return _this.blur.emit(); });
            this.element.on('focus', function () { return _this.focus.emit(); });
            this.element.on('ready', function () { return _this.ready.emit(); });
            this.element.on('escape', function () { return _this.escape.emit(); });
            this.element.mount(this.stripeElementRef.nativeElement);
            this.load.emit(this.element);
        };
        return StripeCardComponent;
    }());
    StripeCardComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-card',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeCardComponent.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripeCardComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeCardGroupDirective = /** @class */ (function () {
        function StripeCardGroupDirective(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.elements = new core.EventEmitter();
            this.state = 'notready';
        }
        StripeCardGroupDirective.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var elementsOptions, stripe, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            this.state = 'starting';
                            elementsOptions = this.elementsOptions;
                            stripe = this.stripe;
                            if (!(changes.elementsOptions || changes.stripe || !this._elements)) return [3 /*break*/, 2];
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(stripe, elementsOptions)
                                    .toPromise()];
                        case 1:
                            _a._elements = _b.sent();
                            this.elements.emit(this._elements);
                            _b.label = 2;
                        case 2:
                            this.state = 'ready';
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripeCardGroupDirective.prototype.ngOnInit = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(this.state === 'notready')) return [3 /*break*/, 2];
                            this.state = 'starting';
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe)
                                    .toPromise()];
                        case 1:
                            _a._elements = _b.sent();
                            this.elements.emit(this._elements);
                            this.state = 'ready';
                            _b.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        };
        return StripeCardGroupDirective;
    }());
    StripeCardGroupDirective.decorators = [
        { type: core.Directive, args: [{
                    selector: 'ngx-stripe-card-group,[ngxStripeCardGroup]'
                },] }
    ];
    StripeCardGroupDirective.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripeCardGroupDirective.propDecorators = {
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        elements: [{ type: core.Output }]
    };

    var StripeCardNumberComponent = /** @class */ (function () {
        function StripeCardNumberComponent(stripeElementsService, cardGroup) {
            this.stripeElementsService = stripeElementsService;
            this.cardGroup = cardGroup;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
        }
        StripeCardNumberComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (changes.options || changes.containerClass) {
                        this.setupElement('options');
                    }
                    return [2 /*return*/];
                });
            });
        };
        StripeCardNumberComponent.prototype.ngOnInit = function () {
            var _this = this;
            if (this.cardGroup) {
                this.cardGroupSubscription = this.cardGroup.elements.subscribe(function (elements) {
                    _this.elements = elements;
                    _this.setupElement('elements');
                });
            }
            else {
                throw new Error('StripeCardNumberComponent must have StripeCardGroupDirective parent');
            }
        };
        StripeCardNumberComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
            if (this.cardGroupSubscription) {
                this.cardGroupSubscription.unsubscribe();
            }
        };
        StripeCardNumberComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeCardNumberComponent.prototype.getCardNumber = function () {
            return this.element;
        };
        StripeCardNumberComponent.prototype.setupElement = function (source) {
            var _this = this;
            var options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            if (this.element && source === 'options') {
                this.update(options);
            }
            else if (this.elements && source === 'elements') {
                this.element = this.elements.create('cardNumber', options);
                this.element.on('change', function (ev) { return _this.change.emit(ev); });
                this.element.on('blur', function () { return _this.blur.emit(); });
                this.element.on('focus', function () { return _this.focus.emit(); });
                this.element.on('ready', function () { return _this.ready.emit(); });
                this.element.on('escape', function () { return _this.escape.emit(); });
                this.element.mount(this.stripeElementRef.nativeElement);
                this.load.emit(this.element);
            }
        };
        return StripeCardNumberComponent;
    }());
    StripeCardNumberComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-card-number',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeCardNumberComponent.ctorParameters = function () { return [
        { type: StripeElementsService },
        { type: StripeCardGroupDirective, decorators: [{ type: core.Optional }] }
    ]; };
    StripeCardNumberComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeCardExpiryComponent = /** @class */ (function () {
        function StripeCardExpiryComponent(stripeElementsService, cardGroup) {
            this.stripeElementsService = stripeElementsService;
            this.cardGroup = cardGroup;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
        }
        StripeCardExpiryComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (changes.options || changes.containerClass) {
                        this.setupElement('options');
                    }
                    return [2 /*return*/];
                });
            });
        };
        StripeCardExpiryComponent.prototype.ngOnInit = function () {
            var _this = this;
            if (this.cardGroup) {
                this.cardGroupSubscription = this.cardGroup.elements.subscribe(function (elements) {
                    _this.elements = elements;
                    _this.setupElement('elements');
                });
            }
            else {
                throw new Error('StripeCardExpiryComponent must have StripeCardGroupDirective parent');
            }
        };
        StripeCardExpiryComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
            if (this.cardGroupSubscription) {
                this.cardGroupSubscription.unsubscribe();
            }
        };
        StripeCardExpiryComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeCardExpiryComponent.prototype.getCardExpiry = function () {
            return this.element;
        };
        StripeCardExpiryComponent.prototype.setupElement = function (source) {
            var _this = this;
            var options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            if (this.element && source === 'options') {
                this.update(options);
            }
            else if (this.elements && source === 'elements') {
                this.element = this.elements.create('cardExpiry', options);
                this.element.on('change', function (ev) { return _this.change.emit(ev); });
                this.element.on('blur', function () { return _this.blur.emit(); });
                this.element.on('focus', function () { return _this.focus.emit(); });
                this.element.on('ready', function () { return _this.ready.emit(); });
                this.element.on('escape', function () { return _this.escape.emit(); });
                this.element.mount(this.stripeElementRef.nativeElement);
                this.load.emit(this.element);
            }
        };
        return StripeCardExpiryComponent;
    }());
    StripeCardExpiryComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-card-expiry',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeCardExpiryComponent.ctorParameters = function () { return [
        { type: StripeElementsService },
        { type: StripeCardGroupDirective, decorators: [{ type: core.Optional }] }
    ]; };
    StripeCardExpiryComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeCardCvcComponent = /** @class */ (function () {
        function StripeCardCvcComponent(stripeElementsService, cardGroup) {
            this.stripeElementsService = stripeElementsService;
            this.cardGroup = cardGroup;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
        }
        StripeCardCvcComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (changes.options || changes.containerClass) {
                        this.setupElement('options');
                    }
                    return [2 /*return*/];
                });
            });
        };
        StripeCardCvcComponent.prototype.ngOnInit = function () {
            var _this = this;
            if (this.cardGroup) {
                this.cardGroupSubscription = this.cardGroup.elements.subscribe(function (elements) {
                    _this.elements = elements;
                    _this.setupElement('elements');
                });
            }
            else {
                throw new Error('StripeCardCvcComponent must have StripeCardGroupDirective parent');
            }
        };
        StripeCardCvcComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
            if (this.cardGroupSubscription) {
                this.cardGroupSubscription.unsubscribe();
            }
        };
        StripeCardCvcComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeCardCvcComponent.prototype.getCardCvc = function () {
            return this.element;
        };
        StripeCardCvcComponent.prototype.setupElement = function (source) {
            var _this = this;
            var options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            if (this.element && source === 'options') {
                this.update(options);
            }
            else if (this.elements && source === 'elements') {
                this.element = this.elements.create('cardCvc', options);
                this.element.on('change', function (ev) { return _this.change.emit(ev); });
                this.element.on('blur', function () { return _this.blur.emit(); });
                this.element.on('focus', function () { return _this.focus.emit(); });
                this.element.on('ready', function () { return _this.ready.emit(); });
                this.element.on('escape', function () { return _this.escape.emit(); });
                this.element.mount(this.stripeElementRef.nativeElement);
                this.load.emit(this.element);
            }
        };
        return StripeCardCvcComponent;
    }());
    StripeCardCvcComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-card-cvc',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeCardCvcComponent.ctorParameters = function () { return [
        { type: StripeElementsService },
        { type: StripeCardGroupDirective, decorators: [{ type: core.Optional }] }
    ]; };
    StripeCardCvcComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeFpxBankComponent = /** @class */ (function () {
        function StripeFpxBankComponent(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
            this.state = 'notready';
        }
        StripeFpxBankComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var options, updateElements, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            this.state = 'starting';
                            options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
                            updateElements = false;
                            if (!(changes.elementsOptions || changes.stripe || !this.elements)) return [3 /*break*/, 2];
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe, this.elementsOptions)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            updateElements = true;
                            _b.label = 2;
                        case 2:
                            if (changes.options ||
                                changes.containerClass ||
                                !this.element ||
                                updateElements) {
                                if (this.element && !updateElements) {
                                    this.update(options);
                                }
                                else if (this.elements && updateElements) {
                                    this.createElement(options);
                                }
                            }
                            this.state = 'ready';
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripeFpxBankComponent.prototype.ngOnInit = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(this.state === 'notready')) return [3 /*break*/, 2];
                            this.state = 'starting';
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            this.createElement();
                            this.state = 'ready';
                            _b.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        };
        StripeFpxBankComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
        };
        StripeFpxBankComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeFpxBankComponent.prototype.getFpxBank = function () {
            return this.element;
        };
        StripeFpxBankComponent.prototype.createElement = function (options) {
            var _this = this;
            if (options === void 0) { options = { accountHolderType: 'individual' }; }
            this.element = this.elements.create('fpxBank', options);
            this.element.on('change', function (ev) { return _this.change.emit(ev); });
            this.element.on('blur', function () { return _this.blur.emit(); });
            this.element.on('focus', function () { return _this.focus.emit(); });
            this.element.on('ready', function () { return _this.ready.emit(); });
            this.element.on('escape', function () { return _this.escape.emit(); });
            this.element.mount(this.stripeElementRef.nativeElement);
            this.load.emit(this.element);
        };
        return StripeFpxBankComponent;
    }());
    StripeFpxBankComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-fpx-bank',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeFpxBankComponent.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripeFpxBankComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeIdealBankComponent = /** @class */ (function () {
        function StripeIdealBankComponent(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
            this.state = 'notready';
        }
        StripeIdealBankComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var options, updateElements, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            this.state = 'starting';
                            options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
                            updateElements = false;
                            if (!(changes.elementsOptions || changes.stripe || !this.elements)) return [3 /*break*/, 2];
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe, this.elementsOptions)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            updateElements = true;
                            _b.label = 2;
                        case 2:
                            if (changes.options ||
                                changes.containerClass ||
                                !this.element ||
                                updateElements) {
                                if (this.element && !updateElements) {
                                    this.update(options);
                                }
                                else if (this.elements && updateElements) {
                                    this.createElement(options);
                                }
                            }
                            this.state = 'ready';
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripeIdealBankComponent.prototype.ngOnInit = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(this.state === 'notready')) return [3 /*break*/, 2];
                            this.state = 'starting';
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            this.createElement();
                            this.state = 'ready';
                            _b.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        };
        StripeIdealBankComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
        };
        StripeIdealBankComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeIdealBankComponent.prototype.getIdealBank = function () {
            return this.element;
        };
        StripeIdealBankComponent.prototype.createElement = function (options) {
            var _this = this;
            if (options === void 0) { options = {}; }
            this.element = this.elements.create('idealBank', options);
            this.element.on('change', function (ev) { return _this.change.emit(ev); });
            this.element.on('blur', function () { return _this.blur.emit(); });
            this.element.on('focus', function () { return _this.focus.emit(); });
            this.element.on('ready', function () { return _this.ready.emit(); });
            this.element.on('escape', function () { return _this.escape.emit(); });
            this.element.mount(this.stripeElementRef.nativeElement);
            this.load.emit(this.element);
        };
        return StripeIdealBankComponent;
    }());
    StripeIdealBankComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-ideal-bank',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeIdealBankComponent.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripeIdealBankComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeIbanComponent = /** @class */ (function () {
        function StripeIbanComponent(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
            this.state = 'notready';
        }
        StripeIbanComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var options, updateElements, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            this.state = 'starting';
                            options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
                            updateElements = false;
                            if (!(changes.elementsOptions || changes.stripe || !this.elements)) return [3 /*break*/, 2];
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe, this.elementsOptions)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            updateElements = true;
                            _b.label = 2;
                        case 2:
                            if (changes.options ||
                                changes.containerClass ||
                                !this.element ||
                                updateElements) {
                                if (this.element && !updateElements) {
                                    this.update(options);
                                }
                                else if (this.elements && updateElements) {
                                    this.createElement(options);
                                }
                            }
                            this.state = 'ready';
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripeIbanComponent.prototype.ngOnInit = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(this.state === 'notready')) return [3 /*break*/, 2];
                            this.state = 'starting';
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            this.createElement();
                            this.state = 'ready';
                            _b.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        };
        StripeIbanComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
        };
        StripeIbanComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeIbanComponent.prototype.getIban = function () {
            return this.element;
        };
        StripeIbanComponent.prototype.createElement = function (options) {
            var _this = this;
            if (options === void 0) { options = {}; }
            this.element = this.elements.create('iban', options);
            this.element.on('change', function (ev) { return _this.change.emit(ev); });
            this.element.on('blur', function () { return _this.blur.emit(); });
            this.element.on('focus', function () { return _this.focus.emit(); });
            this.element.on('ready', function () { return _this.ready.emit(); });
            this.element.on('escape', function () { return _this.escape.emit(); });
            this.element.mount(this.stripeElementRef.nativeElement);
            this.load.emit(this.element);
        };
        return StripeIbanComponent;
    }());
    StripeIbanComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-iban',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeIbanComponent.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripeIbanComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripeAuBankAccountComponent = /** @class */ (function () {
        function StripeAuBankAccountComponent(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.load = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.escape = new core.EventEmitter();
            this.state = 'notready';
        }
        StripeAuBankAccountComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var options, updateElements, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            this.state = 'starting';
                            options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
                            updateElements = false;
                            if (!(changes.elementsOptions || changes.stripe || !this.elements)) return [3 /*break*/, 2];
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe, this.elementsOptions)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            updateElements = true;
                            _b.label = 2;
                        case 2:
                            if (changes.options ||
                                changes.containerClass ||
                                !this.element ||
                                updateElements) {
                                if (this.element && !updateElements) {
                                    this.update(options);
                                }
                                else if (this.elements && updateElements) {
                                    this.createElement(options);
                                }
                            }
                            this.state = 'ready';
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripeAuBankAccountComponent.prototype.ngOnInit = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(this.state === 'notready')) return [3 /*break*/, 2];
                            this.state = 'starting';
                            _a = this;
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(this.stripe)
                                    .toPromise()];
                        case 1:
                            _a.elements = _b.sent();
                            this.createElement();
                            this.state = 'ready';
                            _b.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        };
        StripeAuBankAccountComponent.prototype.ngOnDestroy = function () {
            if (this.element) {
                this.element.destroy();
            }
        };
        StripeAuBankAccountComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        /**
         * @deprecated
         */
        StripeAuBankAccountComponent.prototype.getAuBankAccount = function () {
            return this.element;
        };
        StripeAuBankAccountComponent.prototype.createElement = function (options) {
            var _this = this;
            if (options === void 0) { options = {}; }
            this.element = this.elements.create('auBankAccount', options);
            this.element.on('change', function (ev) { return _this.change.emit(ev); });
            this.element.on('blur', function () { return _this.blur.emit(); });
            this.element.on('focus', function () { return _this.focus.emit(); });
            this.element.on('ready', function () { return _this.ready.emit(); });
            this.element.on('escape', function () { return _this.escape.emit(); });
            this.element.mount(this.stripeElementRef.nativeElement);
            this.load.emit(this.element);
        };
        return StripeAuBankAccountComponent;
    }());
    StripeAuBankAccountComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-au-bank-account',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripeAuBankAccountComponent.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripeAuBankAccountComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        options: [{ type: core.Input }],
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        load: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        change: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        escape: [{ type: core.Output }]
    };

    var StripePaymentRequestButtonComponent = /** @class */ (function () {
        function StripePaymentRequestButtonComponent(stripeElementsService) {
            this.stripeElementsService = stripeElementsService;
            this.load = new core.EventEmitter();
            this.change = new core.EventEmitter();
            this.blur = new core.EventEmitter();
            this.focus = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.token = new core.EventEmitter();
            this.paymentMethod = new core.EventEmitter();
            this.source = new core.EventEmitter();
            this.cancel = new core.EventEmitter();
            this.shippingaddresschange = new core.EventEmitter();
            this.shippingoptionchange = new core.EventEmitter();
            this.notavailable = new core.EventEmitter();
        }
        StripePaymentRequestButtonComponent.prototype.ngOnChanges = function (changes) {
            return __awaiter(this, void 0, void 0, function () {
                var options, elementsOptions, stripe, updateElements, elements;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
                            elementsOptions = this.elementsOptions;
                            stripe = this.stripe;
                            updateElements = false;
                            if (!(changes.elementsOptions || changes.stripe || !this.elements)) return [3 /*break*/, 2];
                            return [4 /*yield*/, this.stripeElementsService
                                    .elements(stripe, elementsOptions)
                                    .toPromise()];
                        case 1:
                            elements = _a.sent();
                            this.elements = elements;
                            updateElements = true;
                            _a.label = 2;
                        case 2:
                            if (changes.paymentOptions && this.paymentRequest) {
                                this.updateRequest(this.paymentOptions);
                            }
                            if (changes.options ||
                                changes.containerClass ||
                                !this.element ||
                                updateElements) {
                                if (this.element && !updateElements) {
                                    this.update(options);
                                }
                                else if (this.elements && updateElements) {
                                    this.paymentRequest = this.stripeElementsService.paymentRequest(stripe, this.paymentOptions);
                                    this.paymentRequest.on('token', function (ev) { return _this.token.emit(ev); });
                                    this.paymentRequest.on('paymentmethod', function (ev) { return _this.paymentMethod.emit(ev); });
                                    this.paymentRequest.on('source', function (ev) { return _this.source.emit(ev); });
                                    this.paymentRequest.on('cancel', function () { return _this.cancel.emit(); });
                                    this.paymentRequest.on('shippingaddresschange', function (ev) { return _this.shippingaddresschange.emit(ev); });
                                    this.paymentRequest.on('shippingoptionchange', function (ev) { return _this.shippingoptionchange.emit(ev); });
                                    this.element = this.elements.create('paymentRequestButton', Object.assign({ paymentRequest: this.paymentRequest }, options));
                                    this.canMakePayment().subscribe(function (result) {
                                        if (result) {
                                            _this.element.on('click', function (ev) { return _this.change.emit(ev); });
                                            _this.element.on('blur', function () { return _this.blur.emit(); });
                                            _this.element.on('focus', function () { return _this.focus.emit(); });
                                            _this.element.on('ready', function () { return _this.ready.emit(); });
                                            _this.element.mount(_this.stripeElementRef.nativeElement);
                                            _this.load.emit({
                                                paymentRequestButton: _this.element,
                                                paymentRequest: _this.paymentRequest
                                            });
                                        }
                                        else {
                                            _this.notavailable.emit();
                                        }
                                    });
                                }
                            }
                            return [2 /*return*/];
                    }
                });
            });
        };
        StripePaymentRequestButtonComponent.prototype.canMakePayment = function () {
            return rxjs.from(this.paymentRequest.canMakePayment());
        };
        StripePaymentRequestButtonComponent.prototype.update = function (options) {
            this.element.update(options);
        };
        StripePaymentRequestButtonComponent.prototype.updateRequest = function (options) {
            var currency = options.currency, total = options.total, displayItems = options.displayItems, shippingOptions = options.shippingOptions;
            this.paymentRequest.update({
                currency: currency,
                total: total,
                displayItems: displayItems,
                shippingOptions: shippingOptions
            });
        };
        StripePaymentRequestButtonComponent.prototype.show = function () {
            this.paymentRequest.show();
        };
        /**
         * @deprecated
         */
        StripePaymentRequestButtonComponent.prototype.getButton = function () {
            return this.element;
        };
        return StripePaymentRequestButtonComponent;
    }());
    StripePaymentRequestButtonComponent.decorators = [
        { type: core.Component, args: [{
                    selector: 'ngx-stripe-payment-request-button',
                    template: "<div class=\"field\" #stripeElementRef></div>"
                },] }
    ];
    StripePaymentRequestButtonComponent.ctorParameters = function () { return [
        { type: StripeElementsService }
    ]; };
    StripePaymentRequestButtonComponent.propDecorators = {
        stripeElementRef: [{ type: core.ViewChild, args: ['stripeElementRef',] }],
        containerClass: [{ type: core.Input }],
        paymentOptions: [{ type: core.Input }],
        options: [{ type: core.Input }],
        elementsOptions: [{ type: core.Input }],
        stripe: [{ type: core.Input }],
        load: [{ type: core.Output }],
        change: [{ type: core.Output }],
        blur: [{ type: core.Output }],
        focus: [{ type: core.Output }],
        ready: [{ type: core.Output }],
        token: [{ type: core.Output }],
        paymentMethod: [{ type: core.Output }],
        source: [{ type: core.Output }],
        cancel: [{ type: core.Output }],
        shippingaddresschange: [{ type: core.Output }],
        shippingoptionchange: [{ type: core.Output }],
        notavailable: [{ type: core.Output }]
    };

    var StripeFactoryService = /** @class */ (function () {
        function StripeFactoryService(version, baseKey, baseOptions, loader, window) {
            this.version = version;
            this.baseKey = baseKey;
            this.baseOptions = baseOptions;
            this.loader = loader;
            this.window = window;
        }
        StripeFactoryService.prototype.create = function (key, options) {
            if (!key && !this.baseKey) {
                return null;
            }
            return new StripeInstance(this.version, this.loader, this.window, key || this.baseKey, options || this.baseOptions);
        };
        return StripeFactoryService;
    }());
    StripeFactoryService.decorators = [
        { type: core.Injectable }
    ];
    StripeFactoryService.ctorParameters = function () { return [
        { type: String, decorators: [{ type: core.Inject, args: [NGX_STRIPE_VERSION,] }] },
        { type: String, decorators: [{ type: core.Inject, args: [STRIPE_PUBLISHABLE_KEY,] }] },
        { type: undefined, decorators: [{ type: core.Inject, args: [STRIPE_OPTIONS,] }] },
        { type: LazyStripeAPILoader },
        { type: WindowRef }
    ]; };

    var components = [
        StripeCardComponent,
        StripeCardNumberComponent,
        StripeCardExpiryComponent,
        StripeCardCvcComponent,
        StripeFpxBankComponent,
        StripeIdealBankComponent,
        StripeIbanComponent,
        StripeAuBankAccountComponent,
        StripePaymentRequestButtonComponent
    ];
    var directives = [StripeCardGroupDirective];
    var currentVersion = '12.0.1';
    var NgxStripeModule = /** @class */ (function () {
        function NgxStripeModule() {
        }
        NgxStripeModule.forRoot = function (publishableKey, options) {
            return {
                ngModule: NgxStripeModule,
                providers: [
                    LazyStripeAPILoader,
                    StripeService,
                    StripeFactoryService,
                    StripeElementsService,
                    WindowRef,
                    DocumentRef,
                    {
                        provide: STRIPE_PUBLISHABLE_KEY,
                        useValue: publishableKey
                    },
                    {
                        provide: STRIPE_OPTIONS,
                        useValue: options
                    },
                    {
                        provide: NGX_STRIPE_VERSION,
                        useValue: currentVersion
                    }
                ]
            };
        };
        NgxStripeModule.forChild = function (publishableKey, options) {
            return {
                ngModule: NgxStripeModule,
                providers: [
                    LazyStripeAPILoader,
                    StripeService,
                    StripeFactoryService,
                    StripeElementsService,
                    WindowRef,
                    DocumentRef,
                    {
                        provide: STRIPE_PUBLISHABLE_KEY,
                        useValue: publishableKey
                    },
                    {
                        provide: STRIPE_OPTIONS,
                        useValue: options
                    },
                    {
                        provide: NGX_STRIPE_VERSION,
                        useValue: currentVersion
                    }
                ]
            };
        };
        return NgxStripeModule;
    }());
    NgxStripeModule.decorators = [
        { type: core.NgModule, args: [{
                    declarations: __spreadArray(__spreadArray([], __read(components)), __read(directives)),
                    exports: __spreadArray(__spreadArray([], __read(components)), __read(directives))
                },] }
    ];

    /*
     * Public API Surface of ngx-stripe
     */

    /**
     * Generated bundle index. Do not edit.
     */

    exports.DocumentRef = DocumentRef;
    exports.LazyStripeAPILoader = LazyStripeAPILoader;
    exports.NgxStripeModule = NgxStripeModule;
    exports.STRIPE_OPTIONS = STRIPE_OPTIONS;
    exports.STRIPE_PUBLISHABLE_KEY = STRIPE_PUBLISHABLE_KEY;
    exports.StripeAuBankAccountComponent = StripeAuBankAccountComponent;
    exports.StripeCardComponent = StripeCardComponent;
    exports.StripeCardCvcComponent = StripeCardCvcComponent;
    exports.StripeCardExpiryComponent = StripeCardExpiryComponent;
    exports.StripeCardGroupDirective = StripeCardGroupDirective;
    exports.StripeCardNumberComponent = StripeCardNumberComponent;
    exports.StripeElementsService = StripeElementsService;
    exports.StripeFactoryService = StripeFactoryService;
    exports.StripeFpxBankComponent = StripeFpxBankComponent;
    exports.StripeIbanComponent = StripeIbanComponent;
    exports.StripeIdealBankComponent = StripeIdealBankComponent;
    exports.StripeInstance = StripeInstance;
    exports.StripePaymentRequestButtonComponent = StripePaymentRequestButtonComponent;
    exports.StripeService = StripeService;
    exports.WindowRef = WindowRef;
    exports.ɵa = NGX_STRIPE_VERSION;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-stripe.umd.js.map
