import { __awaiter } from "tslib";
import { Component, Input, ViewChild, EventEmitter, Output } from '@angular/core';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripeAuBankAccountComponent {
    constructor(stripeElementsService) {
        this.stripeElementsService = stripeElementsService;
        this.load = new EventEmitter();
        this.blur = new EventEmitter();
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.ready = new EventEmitter();
        this.escape = new EventEmitter();
        this.state = 'notready';
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            this.state = 'starting';
            const options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            let updateElements = false;
            if (changes.elementsOptions || changes.stripe || !this.elements) {
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe, this.elementsOptions)
                    .toPromise();
                updateElements = true;
            }
            if (changes.options ||
                changes.containerClass ||
                !this.element ||
                updateElements) {
                if (this.element && !updateElements) {
                    this.update(options);
                }
                else if (this.elements && updateElements) {
                    this.createElement(options);
                }
            }
            this.state = 'ready';
        });
    }
    ngOnInit() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.state === 'notready') {
                this.state = 'starting';
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe)
                    .toPromise();
                this.createElement();
                this.state = 'ready';
            }
        });
    }
    ngOnDestroy() {
        if (this.element) {
            this.element.destroy();
        }
    }
    update(options) {
        this.element.update(options);
    }
    /**
     * @deprecated
     */
    getAuBankAccount() {
        return this.element;
    }
    createElement(options = {}) {
        this.element = this.elements.create('auBankAccount', options);
        this.element.on('change', (ev) => this.change.emit(ev));
        this.element.on('blur', () => this.blur.emit());
        this.element.on('focus', () => this.focus.emit());
        this.element.on('ready', () => this.ready.emit());
        this.element.on('escape', () => this.escape.emit());
        this.element.mount(this.stripeElementRef.nativeElement);
        this.load.emit(this.element);
    }
}
StripeAuBankAccountComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-stripe-au-bank-account',
                template: `<div class="field" #stripeElementRef></div>`
            },] }
];
StripeAuBankAccountComponent.ctorParameters = () => [
    { type: StripeElementsService }
];
StripeAuBankAccountComponent.propDecorators = {
    stripeElementRef: [{ type: ViewChild, args: ['stripeElementRef',] }],
    containerClass: [{ type: Input }],
    options: [{ type: Input }],
    elementsOptions: [{ type: Input }],
    stripe: [{ type: Input }],
    load: [{ type: Output }],
    blur: [{ type: Output }],
    change: [{ type: Output }],
    focus: [{ type: Output }],
    ready: [{ type: Output }],
    escape: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,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