import { __awaiter } from "tslib";
import { Component, Input, ViewChild, EventEmitter, Output, Optional } from '@angular/core';
import { StripeCardGroupDirective } from '../directives/card-group.directive';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripeCardExpiryComponent {
    constructor(stripeElementsService, cardGroup) {
        this.stripeElementsService = stripeElementsService;
        this.cardGroup = cardGroup;
        this.load = new EventEmitter();
        this.blur = new EventEmitter();
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.ready = new EventEmitter();
        this.escape = new EventEmitter();
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            if (changes.options || changes.containerClass) {
                this.setupElement('options');
            }
        });
    }
    ngOnInit() {
        if (this.cardGroup) {
            this.cardGroupSubscription = this.cardGroup.elements.subscribe((elements) => {
                this.elements = elements;
                this.setupElement('elements');
            });
        }
        else {
            throw new Error('StripeCardExpiryComponent must have StripeCardGroupDirective parent');
        }
    }
    ngOnDestroy() {
        if (this.element) {
            this.element.destroy();
        }
        if (this.cardGroupSubscription) {
            this.cardGroupSubscription.unsubscribe();
        }
    }
    update(options) {
        this.element.update(options);
    }
    /**
     * @deprecated
     */
    getCardExpiry() {
        return this.element;
    }
    setupElement(source) {
        const options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
        if (this.element && source === 'options') {
            this.update(options);
        }
        else if (this.elements && source === 'elements') {
            this.element = this.elements.create('cardExpiry', options);
            this.element.on('change', (ev) => this.change.emit(ev));
            this.element.on('blur', () => this.blur.emit());
            this.element.on('focus', () => this.focus.emit());
            this.element.on('ready', () => this.ready.emit());
            this.element.on('escape', () => this.escape.emit());
            this.element.mount(this.stripeElementRef.nativeElement);
            this.load.emit(this.element);
        }
    }
}
StripeCardExpiryComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-stripe-card-expiry',
                template: `<div class="field" #stripeElementRef></div>`
            },] }
];
StripeCardExpiryComponent.ctorParameters = () => [
    { type: StripeElementsService },
    { type: StripeCardGroupDirective, decorators: [{ type: Optional }] }
];
StripeCardExpiryComponent.propDecorators = {
    stripeElementRef: [{ type: ViewChild, args: ['stripeElementRef',] }],
    containerClass: [{ type: Input }],
    options: [{ type: Input }],
    load: [{ type: Output }],
    blur: [{ type: Output }],
    change: [{ type: Output }],
    focus: [{ type: Output }],
    ready: [{ type: Output }],
    escape: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,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