import { __awaiter } from "tslib";
import { Component, Input, ViewChild, EventEmitter, Output } from '@angular/core';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripeFpxBankComponent {
    constructor(stripeElementsService) {
        this.stripeElementsService = stripeElementsService;
        this.load = new EventEmitter();
        this.blur = new EventEmitter();
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.ready = new EventEmitter();
        this.escape = new EventEmitter();
        this.state = 'notready';
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            this.state = 'starting';
            const options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            let updateElements = false;
            if (changes.elementsOptions || changes.stripe || !this.elements) {
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe, this.elementsOptions)
                    .toPromise();
                updateElements = true;
            }
            if (changes.options ||
                changes.containerClass ||
                !this.element ||
                updateElements) {
                if (this.element && !updateElements) {
                    this.update(options);
                }
                else if (this.elements && updateElements) {
                    this.createElement(options);
                }
            }
            this.state = 'ready';
        });
    }
    ngOnInit() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.state === 'notready') {
                this.state = 'starting';
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe)
                    .toPromise();
                this.createElement();
                this.state = 'ready';
            }
        });
    }
    ngOnDestroy() {
        if (this.element) {
            this.element.destroy();
        }
    }
    update(options) {
        this.element.update(options);
    }
    /**
     * @deprecated
     */
    getFpxBank() {
        return this.element;
    }
    createElement(options = { accountHolderType: 'individual' }) {
        this.element = this.elements.create('fpxBank', options);
        this.element.on('change', (ev) => this.change.emit(ev));
        this.element.on('blur', () => this.blur.emit());
        this.element.on('focus', () => this.focus.emit());
        this.element.on('ready', () => this.ready.emit());
        this.element.on('escape', () => this.escape.emit());
        this.element.mount(this.stripeElementRef.nativeElement);
        this.load.emit(this.element);
    }
}
StripeFpxBankComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-stripe-fpx-bank',
                template: `<div class="field" #stripeElementRef></div>`
            },] }
];
StripeFpxBankComponent.ctorParameters = () => [
    { type: StripeElementsService }
];
StripeFpxBankComponent.propDecorators = {
    stripeElementRef: [{ type: ViewChild, args: ['stripeElementRef',] }],
    containerClass: [{ type: Input }],
    options: [{ type: Input }],
    elementsOptions: [{ type: Input }],
    stripe: [{ type: Input }],
    load: [{ type: Output }],
    blur: [{ type: Output }],
    change: [{ type: Output }],
    focus: [{ type: Output }],
    ready: [{ type: Output }],
    escape: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,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