import { __awaiter } from "tslib";
import { Component, Input, ViewChild, EventEmitter, Output } from '@angular/core';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripeIbanComponent {
    constructor(stripeElementsService) {
        this.stripeElementsService = stripeElementsService;
        this.load = new EventEmitter();
        this.blur = new EventEmitter();
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.ready = new EventEmitter();
        this.escape = new EventEmitter();
        this.state = 'notready';
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            this.state = 'starting';
            const options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            let updateElements = false;
            if (changes.elementsOptions || changes.stripe || !this.elements) {
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe, this.elementsOptions)
                    .toPromise();
                updateElements = true;
            }
            if (changes.options ||
                changes.containerClass ||
                !this.element ||
                updateElements) {
                if (this.element && !updateElements) {
                    this.update(options);
                }
                else if (this.elements && updateElements) {
                    this.createElement(options);
                }
            }
            this.state = 'ready';
        });
    }
    ngOnInit() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.state === 'notready') {
                this.state = 'starting';
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe)
                    .toPromise();
                this.createElement();
                this.state = 'ready';
            }
        });
    }
    ngOnDestroy() {
        if (this.element) {
            this.element.destroy();
        }
    }
    update(options) {
        this.element.update(options);
    }
    /**
     * @deprecated
     */
    getIban() {
        return this.element;
    }
    createElement(options = {}) {
        this.element = this.elements.create('iban', options);
        this.element.on('change', (ev) => this.change.emit(ev));
        this.element.on('blur', () => this.blur.emit());
        this.element.on('focus', () => this.focus.emit());
        this.element.on('ready', () => this.ready.emit());
        this.element.on('escape', () => this.escape.emit());
        this.element.mount(this.stripeElementRef.nativeElement);
        this.load.emit(this.element);
    }
}
StripeIbanComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-stripe-iban',
                template: `<div class="field" #stripeElementRef></div>`
            },] }
];
StripeIbanComponent.ctorParameters = () => [
    { type: StripeElementsService }
];
StripeIbanComponent.propDecorators = {
    stripeElementRef: [{ type: ViewChild, args: ['stripeElementRef',] }],
    containerClass: [{ type: Input }],
    options: [{ type: Input }],
    elementsOptions: [{ type: Input }],
    stripe: [{ type: Input }],
    load: [{ type: Output }],
    blur: [{ type: Output }],
    change: [{ type: Output }],
    focus: [{ type: Output }],
    ready: [{ type: Output }],
    escape: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,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