import { __awaiter } from "tslib";
import { Component, Input, ViewChild, EventEmitter, Output } from '@angular/core';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripeIdealBankComponent {
    constructor(stripeElementsService) {
        this.stripeElementsService = stripeElementsService;
        this.load = new EventEmitter();
        this.blur = new EventEmitter();
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.ready = new EventEmitter();
        this.escape = new EventEmitter();
        this.state = 'notready';
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            this.state = 'starting';
            const options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            let updateElements = false;
            if (changes.elementsOptions || changes.stripe || !this.elements) {
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe, this.elementsOptions)
                    .toPromise();
                updateElements = true;
            }
            if (changes.options ||
                changes.containerClass ||
                !this.element ||
                updateElements) {
                if (this.element && !updateElements) {
                    this.update(options);
                }
                else if (this.elements && updateElements) {
                    this.createElement(options);
                }
            }
            this.state = 'ready';
        });
    }
    ngOnInit() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.state === 'notready') {
                this.state = 'starting';
                this.elements = yield this.stripeElementsService
                    .elements(this.stripe)
                    .toPromise();
                this.createElement();
                this.state = 'ready';
            }
        });
    }
    ngOnDestroy() {
        if (this.element) {
            this.element.destroy();
        }
    }
    update(options) {
        this.element.update(options);
    }
    /**
     * @deprecated
     */
    getIdealBank() {
        return this.element;
    }
    createElement(options = {}) {
        this.element = this.elements.create('idealBank', options);
        this.element.on('change', (ev) => this.change.emit(ev));
        this.element.on('blur', () => this.blur.emit());
        this.element.on('focus', () => this.focus.emit());
        this.element.on('ready', () => this.ready.emit());
        this.element.on('escape', () => this.escape.emit());
        this.element.mount(this.stripeElementRef.nativeElement);
        this.load.emit(this.element);
    }
}
StripeIdealBankComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-stripe-ideal-bank',
                template: `<div class="field" #stripeElementRef></div>`
            },] }
];
StripeIdealBankComponent.ctorParameters = () => [
    { type: StripeElementsService }
];
StripeIdealBankComponent.propDecorators = {
    stripeElementRef: [{ type: ViewChild, args: ['stripeElementRef',] }],
    containerClass: [{ type: Input }],
    options: [{ type: Input }],
    elementsOptions: [{ type: Input }],
    stripe: [{ type: Input }],
    load: [{ type: Output }],
    blur: [{ type: Output }],
    change: [{ type: Output }],
    focus: [{ type: Output }],
    ready: [{ type: Output }],
    escape: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWRlYWwtYmFuay5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9uZ3gtc3RyaXBlL3NyYy9saWIvY29tcG9uZW50cy9pZGVhbC1iYW5rLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsT0FBTyxFQUNMLFNBQVMsRUFDVCxLQUFLLEVBQ0wsU0FBUyxFQUVULFlBQVksRUFDWixNQUFNLEVBS1AsTUFBTSxlQUFlLENBQUM7QUFXdkIsT0FBTyxFQUFFLHFCQUFxQixFQUFFLE1BQU0scUNBQXFDLENBQUM7QUFNNUUsTUFBTSxPQUFPLHdCQUF3QjtJQW9CbkMsWUFBbUIscUJBQTRDO1FBQTVDLDBCQUFxQixHQUFyQixxQkFBcUIsQ0FBdUI7UUFYckQsU0FBSSxHQUFHLElBQUksWUFBWSxFQUEwQixDQUFDO1FBRWxELFNBQUksR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO1FBQ2hDLFdBQU0sR0FBRyxJQUFJLFlBQVksRUFBcUMsQ0FBQztRQUMvRCxVQUFLLEdBQUcsSUFBSSxZQUFZLEVBQVEsQ0FBQztRQUNqQyxVQUFLLEdBQUcsSUFBSSxZQUFZLEVBQVEsQ0FBQztRQUNqQyxXQUFNLEdBQUcsSUFBSSxZQUFZLEVBQVEsQ0FBQztRQUc1QyxVQUFLLEdBQXNDLFVBQVUsQ0FBQztJQUVZLENBQUM7SUFFN0QsV0FBVyxDQUFDLE9BQXNCOztZQUN0QyxJQUFJLENBQUMsS0FBSyxHQUFHLFVBQVUsQ0FBQztZQUV4QixNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsWUFBWSxDQUNyRCxJQUFJLENBQUMsT0FBTyxFQUNaLElBQUksQ0FBQyxjQUFjLENBQ3BCLENBQUM7WUFDRixJQUFJLGNBQWMsR0FBRyxLQUFLLENBQUM7WUFFM0IsSUFBSSxPQUFPLENBQUMsZUFBZSxJQUFJLE9BQU8sQ0FBQyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFO2dCQUMvRCxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sSUFBSSxDQUFDLHFCQUFxQjtxQkFDN0MsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQztxQkFDM0MsU0FBUyxFQUFFLENBQUM7Z0JBQ2YsY0FBYyxHQUFHLElBQUksQ0FBQzthQUN2QjtZQUVELElBQ0UsT0FBTyxDQUFDLE9BQU87Z0JBQ2YsT0FBTyxDQUFDLGNBQWM7Z0JBQ3RCLENBQUMsSUFBSSxDQUFDLE9BQU87Z0JBQ2IsY0FBYyxFQUNkO2dCQUNBLElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLGNBQWMsRUFBRTtvQkFDbkMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztpQkFDdEI7cUJBQU0sSUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLGNBQWMsRUFBRTtvQkFDMUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztpQkFDN0I7YUFDRjtZQUVELElBQUksQ0FBQyxLQUFLLEdBQUcsT0FBTyxDQUFDO1FBQ3ZCLENBQUM7S0FBQTtJQUVLLFFBQVE7O1lBQ1osSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFVBQVUsRUFBRTtnQkFDN0IsSUFBSSxDQUFDLEtBQUssR0FBRyxVQUFVLENBQUM7Z0JBRXhCLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxJQUFJLENBQUMscUJBQXFCO3FCQUM3QyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztxQkFDckIsU0FBUyxFQUFFLENBQUM7Z0JBQ2YsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO2dCQUVyQixJQUFJLENBQUMsS0FBSyxHQUFHLE9BQU8sQ0FBQzthQUN0QjtRQUNILENBQUM7S0FBQTtJQUVELFdBQVc7UUFDVCxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDaEIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxNQUFNLENBQUMsT0FBK0M7UUFDcEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOztPQUVHO0lBQ0gsWUFBWTtRQUNWLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBRU8sYUFBYSxDQUFDLFVBQWtELEVBQUU7UUFDeEUsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDMUQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3hELElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7UUFDaEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztRQUNsRCxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQ2xELElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7UUFFcEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRXhELElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMvQixDQUFDOzs7WUFuR0YsU0FBUyxTQUFDO2dCQUNULFFBQVEsRUFBRSx1QkFBdUI7Z0JBQ2pDLFFBQVEsRUFBRSw2Q0FBNkM7YUFDeEQ7OztZQUxRLHFCQUFxQjs7OytCQU8zQixTQUFTLFNBQUMsa0JBQWtCOzZCQUc1QixLQUFLO3NCQUNMLEtBQUs7OEJBQ0wsS0FBSztxQkFDTCxLQUFLO21CQUVMLE1BQU07bUJBRU4sTUFBTTtxQkFDTixNQUFNO29CQUNOLE1BQU07b0JBQ04sTUFBTTtxQkFDTixNQUFNIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgQ29tcG9uZW50LFxuICBJbnB1dCxcbiAgVmlld0NoaWxkLFxuICBFbGVtZW50UmVmLFxuICBFdmVudEVtaXR0ZXIsXG4gIE91dHB1dCxcbiAgT25Jbml0LFxuICBPbkNoYW5nZXMsXG4gIFNpbXBsZUNoYW5nZXMsXG4gIE9uRGVzdHJveVxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuaW1wb3J0IHtcbiAgU3RyaXBlRWxlbWVudHNPcHRpb25zLFxuICBTdHJpcGVFbGVtZW50cyxcbiAgU3RyaXBlSWRlYWxCYW5rRWxlbWVudCxcbiAgU3RyaXBlSWRlYWxCYW5rRWxlbWVudE9wdGlvbnMsXG4gIFN0cmlwZUlkZWFsQmFua0VsZW1lbnRDaGFuZ2VFdmVudFxufSBmcm9tICdAc3RyaXBlL3N0cmlwZS1qcyc7XG5cbmltcG9ydCB7IFN0cmlwZUluc3RhbmNlIH0gZnJvbSAnLi4vc2VydmljZXMvc3RyaXBlLWluc3RhbmNlLmNsYXNzJztcbmltcG9ydCB7IFN0cmlwZUVsZW1lbnRzU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL3N0cmlwZS1lbGVtZW50cy5zZXJ2aWNlJztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnbmd4LXN0cmlwZS1pZGVhbC1iYW5rJyxcbiAgdGVtcGxhdGU6IGA8ZGl2IGNsYXNzPVwiZmllbGRcIiAjc3RyaXBlRWxlbWVudFJlZj48L2Rpdj5gXG59KVxuZXhwb3J0IGNsYXNzIFN0cmlwZUlkZWFsQmFua0NvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgT25DaGFuZ2VzLCBPbkRlc3Ryb3kge1xuICBAVmlld0NoaWxkKCdzdHJpcGVFbGVtZW50UmVmJykgcHVibGljIHN0cmlwZUVsZW1lbnRSZWYhOiBFbGVtZW50UmVmO1xuICBlbGVtZW50ITogU3RyaXBlSWRlYWxCYW5rRWxlbWVudDtcblxuICBASW5wdXQoKSBjb250YWluZXJDbGFzczogc3RyaW5nO1xuICBASW5wdXQoKSBvcHRpb25zOiBQYXJ0aWFsPFN0cmlwZUlkZWFsQmFua0VsZW1lbnRPcHRpb25zPjtcbiAgQElucHV0KCkgZWxlbWVudHNPcHRpb25zOiBQYXJ0aWFsPFN0cmlwZUVsZW1lbnRzT3B0aW9ucz47XG4gIEBJbnB1dCgpIHN0cmlwZTogU3RyaXBlSW5zdGFuY2U7XG5cbiAgQE91dHB1dCgpIGxvYWQgPSBuZXcgRXZlbnRFbWl0dGVyPFN0cmlwZUlkZWFsQmFua0VsZW1lbnQ+KCk7XG5cbiAgQE91dHB1dCgpIGJsdXIgPSBuZXcgRXZlbnRFbWl0dGVyPHZvaWQ+KCk7XG4gIEBPdXRwdXQoKSBjaGFuZ2UgPSBuZXcgRXZlbnRFbWl0dGVyPFN0cmlwZUlkZWFsQmFua0VsZW1lbnRDaGFuZ2VFdmVudD4oKTtcbiAgQE91dHB1dCgpIGZvY3VzID0gbmV3IEV2ZW50RW1pdHRlcjx2b2lkPigpO1xuICBAT3V0cHV0KCkgcmVhZHkgPSBuZXcgRXZlbnRFbWl0dGVyPHZvaWQ+KCk7XG4gIEBPdXRwdXQoKSBlc2NhcGUgPSBuZXcgRXZlbnRFbWl0dGVyPHZvaWQ+KCk7XG5cbiAgZWxlbWVudHM6IFN0cmlwZUVsZW1lbnRzO1xuICBzdGF0ZTogJ25vdHJlYWR5JyB8ICdzdGFydGluZycgfCAncmVhZHknID0gJ25vdHJlYWR5JztcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgc3RyaXBlRWxlbWVudHNTZXJ2aWNlOiBTdHJpcGVFbGVtZW50c1NlcnZpY2UpIHt9XG5cbiAgYXN5bmMgbmdPbkNoYW5nZXMoY2hhbmdlczogU2ltcGxlQ2hhbmdlcykge1xuICAgIHRoaXMuc3RhdGUgPSAnc3RhcnRpbmcnO1xuXG4gICAgY29uc3Qgb3B0aW9ucyA9IHRoaXMuc3RyaXBlRWxlbWVudHNTZXJ2aWNlLm1lcmdlT3B0aW9ucyhcbiAgICAgIHRoaXMub3B0aW9ucyxcbiAgICAgIHRoaXMuY29udGFpbmVyQ2xhc3NcbiAgICApO1xuICAgIGxldCB1cGRhdGVFbGVtZW50cyA9IGZhbHNlO1xuXG4gICAgaWYgKGNoYW5nZXMuZWxlbWVudHNPcHRpb25zIHx8IGNoYW5nZXMuc3RyaXBlIHx8ICF0aGlzLmVsZW1lbnRzKSB7XG4gICAgICB0aGlzLmVsZW1lbnRzID0gYXdhaXQgdGhpcy5zdHJpcGVFbGVtZW50c1NlcnZpY2VcbiAgICAgICAgLmVsZW1lbnRzKHRoaXMuc3RyaXBlLCB0aGlzLmVsZW1lbnRzT3B0aW9ucylcbiAgICAgICAgLnRvUHJvbWlzZSgpO1xuICAgICAgdXBkYXRlRWxlbWVudHMgPSB0cnVlO1xuICAgIH1cblxuICAgIGlmIChcbiAgICAgIGNoYW5nZXMub3B0aW9ucyB8fFxuICAgICAgY2hhbmdlcy5jb250YWluZXJDbGFzcyB8fFxuICAgICAgIXRoaXMuZWxlbWVudCB8fFxuICAgICAgdXBkYXRlRWxlbWVudHNcbiAgICApIHtcbiAgICAgIGlmICh0aGlzLmVsZW1lbnQgJiYgIXVwZGF0ZUVsZW1lbnRzKSB7XG4gICAgICAgIHRoaXMudXBkYXRlKG9wdGlvbnMpO1xuICAgICAgfSBlbHNlIGlmICh0aGlzLmVsZW1lbnRzICYmIHVwZGF0ZUVsZW1lbnRzKSB7XG4gICAgICAgIHRoaXMuY3JlYXRlRWxlbWVudChvcHRpb25zKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICB0aGlzLnN0YXRlID0gJ3JlYWR5JztcbiAgfVxuXG4gIGFzeW5jIG5nT25Jbml0KCkge1xuICAgIGlmICh0aGlzLnN0YXRlID09PSAnbm90cmVhZHknKSB7XG4gICAgICB0aGlzLnN0YXRlID0gJ3N0YXJ0aW5nJztcblxuICAgICAgdGhpcy5lbGVtZW50cyA9IGF3YWl0IHRoaXMuc3RyaXBlRWxlbWVudHNTZXJ2aWNlXG4gICAgICAgIC5lbGVtZW50cyh0aGlzLnN0cmlwZSlcbiAgICAgICAgLnRvUHJvbWlzZSgpO1xuICAgICAgdGhpcy5jcmVhdGVFbGVtZW50KCk7XG5cbiAgICAgIHRoaXMuc3RhdGUgPSAncmVhZHknO1xuICAgIH1cbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIGlmICh0aGlzLmVsZW1lbnQpIHtcbiAgICAgIHRoaXMuZWxlbWVudC5kZXN0cm95KCk7XG4gICAgfVxuICB9XG5cbiAgdXBkYXRlKG9wdGlvbnM6IFBhcnRpYWw8U3RyaXBlSWRlYWxCYW5rRWxlbWVudE9wdGlvbnM+KSB7XG4gICAgdGhpcy5lbGVtZW50LnVwZGF0ZShvcHRpb25zKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAZGVwcmVjYXRlZFxuICAgKi9cbiAgZ2V0SWRlYWxCYW5rKCkge1xuICAgIHJldHVybiB0aGlzLmVsZW1lbnQ7XG4gIH1cblxuICBwcml2YXRlIGNyZWF0ZUVsZW1lbnQob3B0aW9uczogUGFydGlhbDxTdHJpcGVJZGVhbEJhbmtFbGVtZW50T3B0aW9ucz4gPSB7fSkge1xuICAgIHRoaXMuZWxlbWVudCA9IHRoaXMuZWxlbWVudHMuY3JlYXRlKCdpZGVhbEJhbmsnLCBvcHRpb25zKTtcbiAgICB0aGlzLmVsZW1lbnQub24oJ2NoYW5nZScsIChldikgPT4gdGhpcy5jaGFuZ2UuZW1pdChldikpO1xuICAgIHRoaXMuZWxlbWVudC5vbignYmx1cicsICgpID0+IHRoaXMuYmx1ci5lbWl0KCkpO1xuICAgIHRoaXMuZWxlbWVudC5vbignZm9jdXMnLCAoKSA9PiB0aGlzLmZvY3VzLmVtaXQoKSk7XG4gICAgdGhpcy5lbGVtZW50Lm9uKCdyZWFkeScsICgpID0+IHRoaXMucmVhZHkuZW1pdCgpKTtcbiAgICB0aGlzLmVsZW1lbnQub24oJ2VzY2FwZScsICgpID0+IHRoaXMuZXNjYXBlLmVtaXQoKSk7XG5cbiAgICB0aGlzLmVsZW1lbnQubW91bnQodGhpcy5zdHJpcGVFbGVtZW50UmVmLm5hdGl2ZUVsZW1lbnQpO1xuXG4gICAgdGhpcy5sb2FkLmVtaXQodGhpcy5lbGVtZW50KTtcbiAgfVxufVxuIl19