import { __awaiter } from "tslib";
import { Component, Input, ViewChild, EventEmitter, Output } from '@angular/core';
import { from } from 'rxjs';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripePaymentRequestButtonComponent {
    constructor(stripeElementsService) {
        this.stripeElementsService = stripeElementsService;
        this.load = new EventEmitter();
        this.change = new EventEmitter();
        this.blur = new EventEmitter();
        this.focus = new EventEmitter();
        this.ready = new EventEmitter();
        this.token = new EventEmitter();
        this.paymentMethod = new EventEmitter();
        this.source = new EventEmitter();
        this.cancel = new EventEmitter();
        this.shippingaddresschange = new EventEmitter();
        this.shippingoptionchange = new EventEmitter();
        this.notavailable = new EventEmitter();
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            const options = this.stripeElementsService.mergeOptions(this.options, this.containerClass);
            const elementsOptions = this.elementsOptions;
            const stripe = this.stripe;
            let updateElements = false;
            if (changes.elementsOptions || changes.stripe || !this.elements) {
                const elements = yield this.stripeElementsService
                    .elements(stripe, elementsOptions)
                    .toPromise();
                this.elements = elements;
                updateElements = true;
            }
            if (changes.paymentOptions && this.paymentRequest) {
                this.updateRequest(this.paymentOptions);
            }
            if (changes.options ||
                changes.containerClass ||
                !this.element ||
                updateElements) {
                if (this.element && !updateElements) {
                    this.update(options);
                }
                else if (this.elements && updateElements) {
                    this.paymentRequest = this.stripeElementsService.paymentRequest(stripe, this.paymentOptions);
                    this.paymentRequest.on('token', (ev) => this.token.emit(ev));
                    this.paymentRequest.on('paymentmethod', (ev) => this.paymentMethod.emit(ev));
                    this.paymentRequest.on('source', (ev) => this.source.emit(ev));
                    this.paymentRequest.on('cancel', () => this.cancel.emit());
                    this.paymentRequest.on('shippingaddresschange', (ev) => this.shippingaddresschange.emit(ev));
                    this.paymentRequest.on('shippingoptionchange', (ev) => this.shippingoptionchange.emit(ev));
                    this.element = this.elements.create('paymentRequestButton', Object.assign({ paymentRequest: this.paymentRequest }, options));
                    this.canMakePayment().subscribe((result) => {
                        if (result) {
                            this.element.on('click', (ev) => this.change.emit(ev));
                            this.element.on('blur', () => this.blur.emit());
                            this.element.on('focus', () => this.focus.emit());
                            this.element.on('ready', () => this.ready.emit());
                            this.element.mount(this.stripeElementRef.nativeElement);
                            this.load.emit({
                                paymentRequestButton: this.element,
                                paymentRequest: this.paymentRequest
                            });
                        }
                        else {
                            this.notavailable.emit();
                        }
                    });
                }
            }
        });
    }
    canMakePayment() {
        return from(this.paymentRequest.canMakePayment());
    }
    update(options) {
        this.element.update(options);
    }
    updateRequest(options) {
        const { currency, total, displayItems, shippingOptions } = options;
        this.paymentRequest.update({
            currency,
            total,
            displayItems,
            shippingOptions
        });
    }
    show() {
        this.paymentRequest.show();
    }
    /**
     * @deprecated
     */
    getButton() {
        return this.element;
    }
}
StripePaymentRequestButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'ngx-stripe-payment-request-button',
                template: `<div class="field" #stripeElementRef></div>`
            },] }
];
StripePaymentRequestButtonComponent.ctorParameters = () => [
    { type: StripeElementsService }
];
StripePaymentRequestButtonComponent.propDecorators = {
    stripeElementRef: [{ type: ViewChild, args: ['stripeElementRef',] }],
    containerClass: [{ type: Input }],
    paymentOptions: [{ type: Input }],
    options: [{ type: Input }],
    elementsOptions: [{ type: Input }],
    stripe: [{ type: Input }],
    load: [{ type: Output }],
    change: [{ type: Output }],
    blur: [{ type: Output }],
    focus: [{ type: Output }],
    ready: [{ type: Output }],
    token: [{ type: Output }],
    paymentMethod: [{ type: Output }],
    source: [{ type: Output }],
    cancel: [{ type: Output }],
    shippingaddresschange: [{ type: Output }],
    shippingoptionchange: [{ type: Output }],
    notavailable: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGF5bWVudC1yZXF1ZXN0LWJ1dHRvbi5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9uZ3gtc3RyaXBlL3NyYy9saWIvY29tcG9uZW50cy9wYXltZW50LXJlcXVlc3QtYnV0dG9uLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsT0FBTyxFQUNMLFNBQVMsRUFDVCxLQUFLLEVBQ0wsU0FBUyxFQUVULFlBQVksRUFDWixNQUFNLEVBR1AsTUFBTSxlQUFlLENBQUM7QUFDdkIsT0FBTyxFQUFjLElBQUksRUFBRSxNQUFNLE1BQU0sQ0FBQztBQW9CeEMsT0FBTyxFQUFFLHFCQUFxQixFQUFFLE1BQU0scUNBQXFDLENBQUM7QUFNNUUsTUFBTSxPQUFPLG1DQUFtQztJQXVDOUMsWUFBbUIscUJBQTRDO1FBQTVDLDBCQUFxQixHQUFyQixxQkFBcUIsQ0FBdUI7UUE1QnJELFNBQUksR0FBRyxJQUFJLFlBQVksRUFHN0IsQ0FBQztRQUVLLFdBQU0sR0FBRyxJQUFJLFlBQVksRUFFaEMsQ0FBQztRQUNNLFNBQUksR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO1FBQ2hDLFVBQUssR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO1FBQ2pDLFVBQUssR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO1FBRWpDLFVBQUssR0FBRyxJQUFJLFlBQVksRUFBNEIsQ0FBQztRQUNyRCxrQkFBYSxHQUFHLElBQUksWUFBWSxFQUV2QyxDQUFDO1FBQ00sV0FBTSxHQUFHLElBQUksWUFBWSxFQUE2QixDQUFDO1FBQ3ZELFdBQU0sR0FBRyxJQUFJLFlBQVksRUFBUSxDQUFDO1FBQ2xDLDBCQUFxQixHQUFHLElBQUksWUFBWSxFQUUvQyxDQUFDO1FBQ00seUJBQW9CLEdBQUcsSUFBSSxZQUFZLEVBRTlDLENBQUM7UUFDTSxpQkFBWSxHQUFHLElBQUksWUFBWSxFQUFRLENBQUM7SUFJZ0IsQ0FBQztJQUU3RCxXQUFXLENBQUMsT0FBc0I7O1lBQ3RDLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxZQUFZLENBQ3JELElBQUksQ0FBQyxPQUFPLEVBQ1osSUFBSSxDQUFDLGNBQWMsQ0FDcEIsQ0FBQztZQUNGLE1BQU0sZUFBZSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDN0MsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUMzQixJQUFJLGNBQWMsR0FBRyxLQUFLLENBQUM7WUFFM0IsSUFBSSxPQUFPLENBQUMsZUFBZSxJQUFJLE9BQU8sQ0FBQyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFO2dCQUMvRCxNQUFNLFFBQVEsR0FBRyxNQUFNLElBQUksQ0FBQyxxQkFBcUI7cUJBQzlDLFFBQVEsQ0FBQyxNQUFNLEVBQUUsZUFBZSxDQUFDO3FCQUNqQyxTQUFTLEVBQUUsQ0FBQztnQkFDZixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztnQkFDekIsY0FBYyxHQUFHLElBQUksQ0FBQzthQUN2QjtZQUVELElBQUksT0FBTyxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsY0FBYyxFQUFFO2dCQUNqRCxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQzthQUN6QztZQUVELElBQ0UsT0FBTyxDQUFDLE9BQU87Z0JBQ2YsT0FBTyxDQUFDLGNBQWM7Z0JBQ3RCLENBQUMsSUFBSSxDQUFDLE9BQU87Z0JBQ2IsY0FBYyxFQUNkO2dCQUNBLElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLGNBQWMsRUFBRTtvQkFDbkMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztpQkFDdEI7cUJBQU0sSUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLGNBQWMsRUFBRTtvQkFDMUMsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsY0FBYyxDQUM3RCxNQUFNLEVBQ04sSUFBSSxDQUFDLGNBQWMsQ0FDcEIsQ0FBQztvQkFDRixJQUFJLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7b0JBQzdELElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLGVBQWUsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQzdDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUM1QixDQUFDO29CQUNGLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztvQkFDL0QsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztvQkFDM0QsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLENBQUMsdUJBQXVCLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUNyRCxJQUFJLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUNwQyxDQUFDO29CQUNGLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLHNCQUFzQixFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FDcEQsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FDbkMsQ0FBQztvQkFDRixJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLHNCQUFzQixrQkFDeEQsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjLElBQ2hDLE9BQU8sRUFDVixDQUFDO29CQUVILElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTt3QkFDekMsSUFBSSxNQUFNLEVBQUU7NEJBQ1YsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDOzRCQUN2RCxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDOzRCQUNoRCxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDOzRCQUNsRCxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDOzRCQUVsRCxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLENBQUM7NEJBRXhELElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dDQUNiLG9CQUFvQixFQUFFLElBQUksQ0FBQyxPQUFPO2dDQUNsQyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7NkJBQ3BDLENBQUMsQ0FBQzt5QkFDSjs2QkFBTTs0QkFDTCxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxDQUFDO3lCQUMxQjtvQkFDSCxDQUFDLENBQUMsQ0FBQztpQkFDSjthQUNGO1FBQ0gsQ0FBQztLQUFBO0lBRUQsY0FBYztRQUNaLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsY0FBYyxFQUFFLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQsTUFBTSxDQUFDLE9BQTBEO1FBQy9ELElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRCxhQUFhLENBQUMsT0FBb0M7UUFDaEQsTUFBTSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsWUFBWSxFQUFFLGVBQWUsRUFBRSxHQUFHLE9BQU8sQ0FBQztRQUVuRSxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU0sQ0FBQztZQUN6QixRQUFRO1lBQ1IsS0FBSztZQUNMLFlBQVk7WUFDWixlQUFlO1NBQ2hCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxJQUFJO1FBQ0YsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUM3QixDQUFDO0lBRUQ7O09BRUc7SUFDSCxTQUFTO1FBQ1AsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7OztZQWpKRixTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLG1DQUFtQztnQkFDN0MsUUFBUSxFQUFFLDZDQUE2QzthQUN4RDs7O1lBTFEscUJBQXFCOzs7K0JBTzNCLFNBQVMsU0FBQyxrQkFBa0I7NkJBSTVCLEtBQUs7NkJBQ0wsS0FBSztzQkFDTCxLQUFLOzhCQUNMLEtBQUs7cUJBQ0wsS0FBSzttQkFFTCxNQUFNO3FCQUtOLE1BQU07bUJBR04sTUFBTTtvQkFDTixNQUFNO29CQUNOLE1BQU07b0JBRU4sTUFBTTs0QkFDTixNQUFNO3FCQUdOLE1BQU07cUJBQ04sTUFBTTtvQ0FDTixNQUFNO21DQUdOLE1BQU07MkJBR04sTUFBTSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENvbXBvbmVudCxcbiAgSW5wdXQsXG4gIFZpZXdDaGlsZCxcbiAgRWxlbWVudFJlZixcbiAgRXZlbnRFbWl0dGVyLFxuICBPdXRwdXQsXG4gIE9uQ2hhbmdlcyxcbiAgU2ltcGxlQ2hhbmdlc1xufSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE9ic2VydmFibGUsIGZyb20gfSBmcm9tICdyeGpzJztcblxuaW1wb3J0IHtcbiAgU3RyaXBlRWxlbWVudHNPcHRpb25zLFxuICBTdHJpcGVFbGVtZW50cyxcbiAgUGF5bWVudFJlcXVlc3RPcHRpb25zLFxuICBQYXltZW50UmVxdWVzdCxcbiAgQ2FuTWFrZVBheW1lbnRSZXN1bHQsXG4gIFBheW1lbnRSZXF1ZXN0VXBkYXRlT3B0aW9ucyxcbiAgU3RyaXBlUGF5bWVudFJlcXVlc3RCdXR0b25FbGVtZW50LFxuICBTdHJpcGVQYXltZW50UmVxdWVzdEJ1dHRvbkVsZW1lbnRPcHRpb25zLFxuICBTdHJpcGVQYXltZW50UmVxdWVzdEJ1dHRvbkVsZW1lbnRDbGlja0V2ZW50LFxuICBQYXltZW50UmVxdWVzdFRva2VuRXZlbnQsXG4gIFBheW1lbnRSZXF1ZXN0UGF5bWVudE1ldGhvZEV2ZW50LFxuICBQYXltZW50UmVxdWVzdFNvdXJjZUV2ZW50LFxuICBQYXltZW50UmVxdWVzdFNoaXBwaW5nQWRkcmVzc0V2ZW50LFxuICBQYXltZW50UmVxdWVzdFNoaXBwaW5nT3B0aW9uRXZlbnRcbn0gZnJvbSAnQHN0cmlwZS9zdHJpcGUtanMnO1xuXG5pbXBvcnQgeyBTdHJpcGVJbnN0YW5jZSB9IGZyb20gJy4uL3NlcnZpY2VzL3N0cmlwZS1pbnN0YW5jZS5jbGFzcyc7XG5pbXBvcnQgeyBTdHJpcGVFbGVtZW50c1NlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9zdHJpcGUtZWxlbWVudHMuc2VydmljZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ25neC1zdHJpcGUtcGF5bWVudC1yZXF1ZXN0LWJ1dHRvbicsXG4gIHRlbXBsYXRlOiBgPGRpdiBjbGFzcz1cImZpZWxkXCIgI3N0cmlwZUVsZW1lbnRSZWY+PC9kaXY+YFxufSlcbmV4cG9ydCBjbGFzcyBTdHJpcGVQYXltZW50UmVxdWVzdEJ1dHRvbkNvbXBvbmVudCBpbXBsZW1lbnRzIE9uQ2hhbmdlcyB7XG4gIEBWaWV3Q2hpbGQoJ3N0cmlwZUVsZW1lbnRSZWYnKSBwdWJsaWMgc3RyaXBlRWxlbWVudFJlZiE6IEVsZW1lbnRSZWY7XG4gIGVsZW1lbnQhOiBTdHJpcGVQYXltZW50UmVxdWVzdEJ1dHRvbkVsZW1lbnQ7XG4gIHBheW1lbnRSZXF1ZXN0ITogUGF5bWVudFJlcXVlc3Q7XG5cbiAgQElucHV0KCkgY29udGFpbmVyQ2xhc3M6IHN0cmluZztcbiAgQElucHV0KCkgcGF5bWVudE9wdGlvbnM6IFBheW1lbnRSZXF1ZXN0T3B0aW9ucztcbiAgQElucHV0KCkgb3B0aW9uczogU3RyaXBlUGF5bWVudFJlcXVlc3RCdXR0b25FbGVtZW50T3B0aW9ucztcbiAgQElucHV0KCkgZWxlbWVudHNPcHRpb25zOiBQYXJ0aWFsPFN0cmlwZUVsZW1lbnRzT3B0aW9ucz47XG4gIEBJbnB1dCgpIHN0cmlwZTogU3RyaXBlSW5zdGFuY2U7XG5cbiAgQE91dHB1dCgpIGxvYWQgPSBuZXcgRXZlbnRFbWl0dGVyPHtcbiAgICBwYXltZW50UmVxdWVzdEJ1dHRvbjogU3RyaXBlUGF5bWVudFJlcXVlc3RCdXR0b25FbGVtZW50O1xuICAgIHBheW1lbnRSZXF1ZXN0OiBQYXltZW50UmVxdWVzdDtcbiAgfT4oKTtcblxuICBAT3V0cHV0KCkgY2hhbmdlID0gbmV3IEV2ZW50RW1pdHRlcjxcbiAgICBTdHJpcGVQYXltZW50UmVxdWVzdEJ1dHRvbkVsZW1lbnRDbGlja0V2ZW50XG4gID4oKTtcbiAgQE91dHB1dCgpIGJsdXIgPSBuZXcgRXZlbnRFbWl0dGVyPHZvaWQ+KCk7XG4gIEBPdXRwdXQoKSBmb2N1cyA9IG5ldyBFdmVudEVtaXR0ZXI8dm9pZD4oKTtcbiAgQE91dHB1dCgpIHJlYWR5ID0gbmV3IEV2ZW50RW1pdHRlcjx2b2lkPigpO1xuXG4gIEBPdXRwdXQoKSB0b2tlbiA9IG5ldyBFdmVudEVtaXR0ZXI8UGF5bWVudFJlcXVlc3RUb2tlbkV2ZW50PigpO1xuICBAT3V0cHV0KCkgcGF5bWVudE1ldGhvZCA9IG5ldyBFdmVudEVtaXR0ZXI8XG4gICAgUGF5bWVudFJlcXVlc3RQYXltZW50TWV0aG9kRXZlbnRcbiAgPigpO1xuICBAT3V0cHV0KCkgc291cmNlID0gbmV3IEV2ZW50RW1pdHRlcjxQYXltZW50UmVxdWVzdFNvdXJjZUV2ZW50PigpO1xuICBAT3V0cHV0KCkgY2FuY2VsID0gbmV3IEV2ZW50RW1pdHRlcjx2b2lkPigpO1xuICBAT3V0cHV0KCkgc2hpcHBpbmdhZGRyZXNzY2hhbmdlID0gbmV3IEV2ZW50RW1pdHRlcjxcbiAgICBQYXltZW50UmVxdWVzdFNoaXBwaW5nQWRkcmVzc0V2ZW50XG4gID4oKTtcbiAgQE91dHB1dCgpIHNoaXBwaW5nb3B0aW9uY2hhbmdlID0gbmV3IEV2ZW50RW1pdHRlcjxcbiAgICBQYXltZW50UmVxdWVzdFNoaXBwaW5nT3B0aW9uRXZlbnRcbiAgPigpO1xuICBAT3V0cHV0KCkgbm90YXZhaWxhYmxlID0gbmV3IEV2ZW50RW1pdHRlcjx2b2lkPigpO1xuXG4gIGVsZW1lbnRzOiBTdHJpcGVFbGVtZW50cztcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgc3RyaXBlRWxlbWVudHNTZXJ2aWNlOiBTdHJpcGVFbGVtZW50c1NlcnZpY2UpIHt9XG5cbiAgYXN5bmMgbmdPbkNoYW5nZXMoY2hhbmdlczogU2ltcGxlQ2hhbmdlcykge1xuICAgIGNvbnN0IG9wdGlvbnMgPSB0aGlzLnN0cmlwZUVsZW1lbnRzU2VydmljZS5tZXJnZU9wdGlvbnMoXG4gICAgICB0aGlzLm9wdGlvbnMsXG4gICAgICB0aGlzLmNvbnRhaW5lckNsYXNzXG4gICAgKTtcbiAgICBjb25zdCBlbGVtZW50c09wdGlvbnMgPSB0aGlzLmVsZW1lbnRzT3B0aW9ucztcbiAgICBjb25zdCBzdHJpcGUgPSB0aGlzLnN0cmlwZTtcbiAgICBsZXQgdXBkYXRlRWxlbWVudHMgPSBmYWxzZTtcblxuICAgIGlmIChjaGFuZ2VzLmVsZW1lbnRzT3B0aW9ucyB8fCBjaGFuZ2VzLnN0cmlwZSB8fCAhdGhpcy5lbGVtZW50cykge1xuICAgICAgY29uc3QgZWxlbWVudHMgPSBhd2FpdCB0aGlzLnN0cmlwZUVsZW1lbnRzU2VydmljZVxuICAgICAgICAuZWxlbWVudHMoc3RyaXBlLCBlbGVtZW50c09wdGlvbnMpXG4gICAgICAgIC50b1Byb21pc2UoKTtcbiAgICAgIHRoaXMuZWxlbWVudHMgPSBlbGVtZW50cztcbiAgICAgIHVwZGF0ZUVsZW1lbnRzID0gdHJ1ZTtcbiAgICB9XG5cbiAgICBpZiAoY2hhbmdlcy5wYXltZW50T3B0aW9ucyAmJiB0aGlzLnBheW1lbnRSZXF1ZXN0KSB7XG4gICAgICB0aGlzLnVwZGF0ZVJlcXVlc3QodGhpcy5wYXltZW50T3B0aW9ucyk7XG4gICAgfVxuXG4gICAgaWYgKFxuICAgICAgY2hhbmdlcy5vcHRpb25zIHx8XG4gICAgICBjaGFuZ2VzLmNvbnRhaW5lckNsYXNzIHx8XG4gICAgICAhdGhpcy5lbGVtZW50IHx8XG4gICAgICB1cGRhdGVFbGVtZW50c1xuICAgICkge1xuICAgICAgaWYgKHRoaXMuZWxlbWVudCAmJiAhdXBkYXRlRWxlbWVudHMpIHtcbiAgICAgICAgdGhpcy51cGRhdGUob3B0aW9ucyk7XG4gICAgICB9IGVsc2UgaWYgKHRoaXMuZWxlbWVudHMgJiYgdXBkYXRlRWxlbWVudHMpIHtcbiAgICAgICAgdGhpcy5wYXltZW50UmVxdWVzdCA9IHRoaXMuc3RyaXBlRWxlbWVudHNTZXJ2aWNlLnBheW1lbnRSZXF1ZXN0KFxuICAgICAgICAgIHN0cmlwZSxcbiAgICAgICAgICB0aGlzLnBheW1lbnRPcHRpb25zXG4gICAgICAgICk7XG4gICAgICAgIHRoaXMucGF5bWVudFJlcXVlc3Qub24oJ3Rva2VuJywgKGV2KSA9PiB0aGlzLnRva2VuLmVtaXQoZXYpKTtcbiAgICAgICAgdGhpcy5wYXltZW50UmVxdWVzdC5vbigncGF5bWVudG1ldGhvZCcsIChldikgPT5cbiAgICAgICAgICB0aGlzLnBheW1lbnRNZXRob2QuZW1pdChldilcbiAgICAgICAgKTtcbiAgICAgICAgdGhpcy5wYXltZW50UmVxdWVzdC5vbignc291cmNlJywgKGV2KSA9PiB0aGlzLnNvdXJjZS5lbWl0KGV2KSk7XG4gICAgICAgIHRoaXMucGF5bWVudFJlcXVlc3Qub24oJ2NhbmNlbCcsICgpID0+IHRoaXMuY2FuY2VsLmVtaXQoKSk7XG4gICAgICAgIHRoaXMucGF5bWVudFJlcXVlc3Qub24oJ3NoaXBwaW5nYWRkcmVzc2NoYW5nZScsIChldikgPT5cbiAgICAgICAgICB0aGlzLnNoaXBwaW5nYWRkcmVzc2NoYW5nZS5lbWl0KGV2KVxuICAgICAgICApO1xuICAgICAgICB0aGlzLnBheW1lbnRSZXF1ZXN0Lm9uKCdzaGlwcGluZ29wdGlvbmNoYW5nZScsIChldikgPT5cbiAgICAgICAgICB0aGlzLnNoaXBwaW5nb3B0aW9uY2hhbmdlLmVtaXQoZXYpXG4gICAgICAgICk7XG4gICAgICAgIHRoaXMuZWxlbWVudCA9IHRoaXMuZWxlbWVudHMuY3JlYXRlKCdwYXltZW50UmVxdWVzdEJ1dHRvbicsIHtcbiAgICAgICAgICBwYXltZW50UmVxdWVzdDogdGhpcy5wYXltZW50UmVxdWVzdCxcbiAgICAgICAgICAuLi5vcHRpb25zXG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMuY2FuTWFrZVBheW1lbnQoKS5zdWJzY3JpYmUoKHJlc3VsdCkgPT4ge1xuICAgICAgICAgIGlmIChyZXN1bHQpIHtcbiAgICAgICAgICAgIHRoaXMuZWxlbWVudC5vbignY2xpY2snLCAoZXYpID0+IHRoaXMuY2hhbmdlLmVtaXQoZXYpKTtcbiAgICAgICAgICAgIHRoaXMuZWxlbWVudC5vbignYmx1cicsICgpID0+IHRoaXMuYmx1ci5lbWl0KCkpO1xuICAgICAgICAgICAgdGhpcy5lbGVtZW50Lm9uKCdmb2N1cycsICgpID0+IHRoaXMuZm9jdXMuZW1pdCgpKTtcbiAgICAgICAgICAgIHRoaXMuZWxlbWVudC5vbigncmVhZHknLCAoKSA9PiB0aGlzLnJlYWR5LmVtaXQoKSk7XG5cbiAgICAgICAgICAgIHRoaXMuZWxlbWVudC5tb3VudCh0aGlzLnN0cmlwZUVsZW1lbnRSZWYubmF0aXZlRWxlbWVudCk7XG5cbiAgICAgICAgICAgIHRoaXMubG9hZC5lbWl0KHtcbiAgICAgICAgICAgICAgcGF5bWVudFJlcXVlc3RCdXR0b246IHRoaXMuZWxlbWVudCxcbiAgICAgICAgICAgICAgcGF5bWVudFJlcXVlc3Q6IHRoaXMucGF5bWVudFJlcXVlc3RcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB0aGlzLm5vdGF2YWlsYWJsZS5lbWl0KCk7XG4gICAgICAgICAgfVxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBjYW5NYWtlUGF5bWVudCgpOiBPYnNlcnZhYmxlPENhbk1ha2VQYXltZW50UmVzdWx0IHwgbnVsbD4ge1xuICAgIHJldHVybiBmcm9tKHRoaXMucGF5bWVudFJlcXVlc3QuY2FuTWFrZVBheW1lbnQoKSk7XG4gIH1cblxuICB1cGRhdGUob3B0aW9uczogUGFydGlhbDxTdHJpcGVQYXltZW50UmVxdWVzdEJ1dHRvbkVsZW1lbnRPcHRpb25zPikge1xuICAgIHRoaXMuZWxlbWVudC51cGRhdGUob3B0aW9ucyk7XG4gIH1cblxuICB1cGRhdGVSZXF1ZXN0KG9wdGlvbnM6IFBheW1lbnRSZXF1ZXN0VXBkYXRlT3B0aW9ucykge1xuICAgIGNvbnN0IHsgY3VycmVuY3ksIHRvdGFsLCBkaXNwbGF5SXRlbXMsIHNoaXBwaW5nT3B0aW9ucyB9ID0gb3B0aW9ucztcblxuICAgIHRoaXMucGF5bWVudFJlcXVlc3QudXBkYXRlKHtcbiAgICAgIGN1cnJlbmN5LFxuICAgICAgdG90YWwsXG4gICAgICBkaXNwbGF5SXRlbXMsXG4gICAgICBzaGlwcGluZ09wdGlvbnNcbiAgICB9KTtcbiAgfVxuXG4gIHNob3coKSB7XG4gICAgdGhpcy5wYXltZW50UmVxdWVzdC5zaG93KCk7XG4gIH1cblxuICAvKipcbiAgICogQGRlcHJlY2F0ZWRcbiAgICovXG4gIGdldEJ1dHRvbigpIHtcbiAgICByZXR1cm4gdGhpcy5lbGVtZW50O1xuICB9XG59XG4iXX0=