import { __awaiter } from "tslib";
import { Directive, Input, Output, EventEmitter } from '@angular/core';
import { StripeElementsService } from '../services/stripe-elements.service';
export class StripeCardGroupDirective {
    constructor(stripeElementsService) {
        this.stripeElementsService = stripeElementsService;
        this.elements = new EventEmitter();
        this.state = 'notready';
    }
    ngOnChanges(changes) {
        return __awaiter(this, void 0, void 0, function* () {
            this.state = 'starting';
            const elementsOptions = this.elementsOptions;
            const stripe = this.stripe;
            if (changes.elementsOptions || changes.stripe || !this._elements) {
                this._elements = yield this.stripeElementsService
                    .elements(stripe, elementsOptions)
                    .toPromise();
                this.elements.emit(this._elements);
            }
            this.state = 'ready';
        });
    }
    ngOnInit() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.state === 'notready') {
                this.state = 'starting';
                this._elements = yield this.stripeElementsService
                    .elements(this.stripe)
                    .toPromise();
                this.elements.emit(this._elements);
                this.state = 'ready';
            }
        });
    }
}
StripeCardGroupDirective.decorators = [
    { type: Directive, args: [{
                selector: 'ngx-stripe-card-group,[ngxStripeCardGroup]'
            },] }
];
StripeCardGroupDirective.ctorParameters = () => [
    { type: StripeElementsService }
];
StripeCardGroupDirective.propDecorators = {
    elementsOptions: [{ type: Input }],
    stripe: [{ type: Input }],
    elements: [{ type: Output }]
};
//# sourceMappingURL=data:application/json;base64,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