import { NgModule } from '@angular/core';
import { StripeCardComponent } from './components/card.component';
import { StripeCardNumberComponent } from './components/card-number.component';
import { StripeCardExpiryComponent } from './components/card-expiry.component';
import { StripeCardCvcComponent } from './components/card-cvc.component';
import { StripeFpxBankComponent } from './components/fpx-bank.component';
import { StripeIdealBankComponent } from './components/ideal-bank.component';
import { StripeIbanComponent } from './components/iban.component';
import { StripeAuBankAccountComponent } from './components/au-bank-account.component';
import { StripePaymentRequestButtonComponent } from './components/payment-request-button.component';
import { StripeCardGroupDirective } from './directives/card-group.directive';
import { NGX_STRIPE_VERSION, STRIPE_OPTIONS, STRIPE_PUBLISHABLE_KEY } from './interfaces/ngx-stripe.interface';
import { LazyStripeAPILoader } from './services/api-loader.service';
import { WindowRef } from './services/window-ref.service';
import { DocumentRef } from './services/document-ref.service';
import { StripeService } from './services/stripe.service';
import { StripeFactoryService } from './services/stripe-factory.service';
import { StripeElementsService } from './services/stripe-elements.service';
const components = [
    StripeCardComponent,
    StripeCardNumberComponent,
    StripeCardExpiryComponent,
    StripeCardCvcComponent,
    StripeFpxBankComponent,
    StripeIdealBankComponent,
    StripeIbanComponent,
    StripeAuBankAccountComponent,
    StripePaymentRequestButtonComponent
];
const directives = [StripeCardGroupDirective];
const currentVersion = '12.0.1';
export class NgxStripeModule {
    static forRoot(publishableKey, options) {
        return {
            ngModule: NgxStripeModule,
            providers: [
                LazyStripeAPILoader,
                StripeService,
                StripeFactoryService,
                StripeElementsService,
                WindowRef,
                DocumentRef,
                {
                    provide: STRIPE_PUBLISHABLE_KEY,
                    useValue: publishableKey
                },
                {
                    provide: STRIPE_OPTIONS,
                    useValue: options
                },
                {
                    provide: NGX_STRIPE_VERSION,
                    useValue: currentVersion
                }
            ]
        };
    }
    static forChild(publishableKey, options) {
        return {
            ngModule: NgxStripeModule,
            providers: [
                LazyStripeAPILoader,
                StripeService,
                StripeFactoryService,
                StripeElementsService,
                WindowRef,
                DocumentRef,
                {
                    provide: STRIPE_PUBLISHABLE_KEY,
                    useValue: publishableKey
                },
                {
                    provide: STRIPE_OPTIONS,
                    useValue: options
                },
                {
                    provide: NGX_STRIPE_VERSION,
                    useValue: currentVersion
                }
            ]
        };
    }
}
NgxStripeModule.decorators = [
    { type: NgModule, args: [{
                declarations: [...components, ...directives],
                exports: [...components, ...directives]
            },] }
];
//# sourceMappingURL=data:application/json;base64,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