import { Injectable } from '@angular/core';
import { StripeService } from './stripe.service';
export class StripeElementsService {
    constructor(stripeService) {
        this.stripeService = stripeService;
    }
    elements(stripe, options = {}) {
        if (stripe) {
            if (Object.keys(options).length > 0) {
                return stripe.elements(options);
            }
            return stripe.elements();
        }
        else {
            if (Object.keys(options).length > 0) {
                return this.stripeService.elements(options);
            }
            return this.stripeService.elements();
        }
    }
    paymentRequest(stripe, options) {
        return stripe
            ? stripe.paymentRequest(options)
            : this.stripeService.paymentRequest(options);
    }
    mergeOptions(options, containerClass) {
        if (!containerClass || (options && options.classes)) {
            return options || {};
        }
        if (!options || !options.classes) {
            return Object.assign(Object.assign({}, (options || {})), { classes: {
                    base: containerClass,
                    complete: `${containerClass}--complete`,
                    empty: `${containerClass}--empty`,
                    focus: `${containerClass}--focus`,
                    invalid: `${containerClass}--invalid`,
                    webkitAutoFill: `${containerClass}--webkit-autoFill`
                } });
        }
        return options || {};
    }
}
StripeElementsService.decorators = [
    { type: Injectable }
];
StripeElementsService.ctorParameters = () => [
    { type: StripeService }
];
//# sourceMappingURL=data:application/json;base64,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