import { Inject, Injectable } from '@angular/core';
import { NGX_STRIPE_VERSION, STRIPE_OPTIONS, STRIPE_PUBLISHABLE_KEY } from '../interfaces/ngx-stripe.interface';
import { LazyStripeAPILoader } from './api-loader.service';
import { WindowRef } from './window-ref.service';
import { StripeInstance } from './stripe-instance.class';
export class StripeFactoryService {
    constructor(version, baseKey, baseOptions, loader, window) {
        this.version = version;
        this.baseKey = baseKey;
        this.baseOptions = baseOptions;
        this.loader = loader;
        this.window = window;
    }
    create(key, options) {
        if (!key && !this.baseKey) {
            return null;
        }
        return new StripeInstance(this.version, this.loader, this.window, key || this.baseKey, options || this.baseOptions);
    }
}
StripeFactoryService.decorators = [
    { type: Injectable }
];
StripeFactoryService.ctorParameters = () => [
    { type: String, decorators: [{ type: Inject, args: [NGX_STRIPE_VERSION,] }] },
    { type: String, decorators: [{ type: Inject, args: [STRIPE_PUBLISHABLE_KEY,] }] },
    { type: undefined, decorators: [{ type: Inject, args: [STRIPE_OPTIONS,] }] },
    { type: LazyStripeAPILoader },
    { type: WindowRef }
];
//# sourceMappingURL=data:application/json;base64,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