import { ElementRef, EventEmitter, OnInit, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { StripeElementsOptions, StripeElements, StripeAuBankAccountElement, StripeAuBankAccountElementOptions, StripeAuBankAccountElementChangeEvent } from '@stripe/stripe-js';
import { StripeInstance } from '../services/stripe-instance.class';
import { StripeElementsService } from '../services/stripe-elements.service';
import * as ɵngcc0 from '@angular/core';
export declare class StripeAuBankAccountComponent implements OnInit, OnChanges, OnDestroy {
    stripeElementsService: StripeElementsService;
    stripeElementRef: ElementRef;
    element: StripeAuBankAccountElement;
    containerClass: string;
    options: Partial<StripeAuBankAccountElementOptions>;
    elementsOptions: Partial<StripeElementsOptions>;
    stripe: StripeInstance;
    load: EventEmitter<StripeAuBankAccountElement>;
    blur: EventEmitter<void>;
    change: EventEmitter<StripeAuBankAccountElementChangeEvent>;
    focus: EventEmitter<void>;
    ready: EventEmitter<void>;
    escape: EventEmitter<void>;
    elements: StripeElements;
    state: 'notready' | 'starting' | 'ready';
    constructor(stripeElementsService: StripeElementsService);
    ngOnChanges(changes: SimpleChanges): Promise<void>;
    ngOnInit(): Promise<void>;
    ngOnDestroy(): void;
    update(options: Partial<StripeAuBankAccountElementOptions>): void;
    /**
     * @deprecated
     */
    getAuBankAccount(): StripeAuBankAccountElement;
    private createElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeAuBankAccountComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripeAuBankAccountComponent, "ngx-stripe-au-bank-account", never, { "containerClass": "containerClass"; "options": "options"; "elementsOptions": "elementsOptions"; "stripe": "stripe"; }, { "load": "load"; "blur": "blur"; "change": "change"; "focus": "focus"; "ready": "ready"; "escape": "escape"; }, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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