import { ElementRef, EventEmitter, OnInit, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs';
import { StripeElements, StripeCardNumberElement, StripeCardNumberElementOptions, StripeCardNumberElementChangeEvent } from '@stripe/stripe-js';
import { StripeCardGroupDirective } from '../directives/card-group.directive';
import { StripeElementsService } from '../services/stripe-elements.service';
import * as ɵngcc0 from '@angular/core';
export declare class StripeCardNumberComponent implements OnInit, OnChanges, OnDestroy {
    stripeElementsService: StripeElementsService;
    private cardGroup;
    stripeElementRef: ElementRef;
    element: StripeCardNumberElement;
    containerClass: string;
    options: Partial<StripeCardNumberElementOptions>;
    load: EventEmitter<StripeCardNumberElement>;
    blur: EventEmitter<void>;
    change: EventEmitter<StripeCardNumberElementChangeEvent>;
    focus: EventEmitter<void>;
    ready: EventEmitter<void>;
    escape: EventEmitter<void>;
    elements: StripeElements;
    cardGroupSubscription: Subscription;
    constructor(stripeElementsService: StripeElementsService, cardGroup: StripeCardGroupDirective);
    ngOnChanges(changes: SimpleChanges): Promise<void>;
    ngOnInit(): void;
    ngOnDestroy(): void;
    update(options: Partial<StripeCardNumberElementOptions>): void;
    /**
     * @deprecated
     */
    getCardNumber(): StripeCardNumberElement;
    private setupElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeCardNumberComponent, [null, { optional: true; }]>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripeCardNumberComponent, "ngx-stripe-card-number", never, { "containerClass": "containerClass"; "options": "options"; }, { "load": "load"; "blur": "blur"; "change": "change"; "focus": "focus"; "ready": "ready"; "escape": "escape"; }, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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