import { ElementRef, EventEmitter, OnInit, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { StripeElementsOptions, StripeElements, StripeFpxBankElement, StripeFpxBankElementChangeEvent, StripeFpxBankElementOptions } from '@stripe/stripe-js';
import { StripeInstance } from '../services/stripe-instance.class';
import { StripeElementsService } from '../services/stripe-elements.service';
import * as ɵngcc0 from '@angular/core';
export declare class StripeFpxBankComponent implements OnInit, OnChanges, OnDestroy {
    stripeElementsService: StripeElementsService;
    stripeElementRef: ElementRef;
    element: StripeFpxBankElement;
    containerClass: string;
    options: StripeFpxBankElementOptions;
    elementsOptions: Partial<StripeElementsOptions>;
    stripe: StripeInstance;
    load: EventEmitter<StripeFpxBankElement>;
    blur: EventEmitter<void>;
    change: EventEmitter<StripeFpxBankElementChangeEvent>;
    focus: EventEmitter<void>;
    ready: EventEmitter<void>;
    escape: EventEmitter<void>;
    elements: StripeElements;
    state: 'notready' | 'starting' | 'ready';
    constructor(stripeElementsService: StripeElementsService);
    ngOnChanges(changes: SimpleChanges): Promise<void>;
    ngOnInit(): Promise<void>;
    ngOnDestroy(): void;
    update(options: Partial<StripeFpxBankElementOptions>): void;
    /**
     * @deprecated
     */
    getFpxBank(): StripeFpxBankElement;
    private createElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeFpxBankComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripeFpxBankComponent, "ngx-stripe-fpx-bank", never, { "containerClass": "containerClass"; "options": "options"; "elementsOptions": "elementsOptions"; "stripe": "stripe"; }, { "load": "load"; "blur": "blur"; "change": "change"; "focus": "focus"; "ready": "ready"; "escape": "escape"; }, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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