import { ElementRef, EventEmitter, OnInit, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { StripeElementsOptions, StripeElements, StripeIbanElement, StripeIbanElementOptions, StripeIbanElementChangeEvent } from '@stripe/stripe-js';
import { StripeInstance } from '../services/stripe-instance.class';
import { StripeElementsService } from '../services/stripe-elements.service';
import * as ɵngcc0 from '@angular/core';
export declare class StripeIbanComponent implements OnInit, OnChanges, OnDestroy {
    stripeElementsService: StripeElementsService;
    stripeElementRef: ElementRef;
    element: StripeIbanElement;
    containerClass: string;
    options: Partial<StripeIbanElementOptions>;
    elementsOptions: Partial<StripeElementsOptions>;
    stripe: StripeInstance;
    load: EventEmitter<StripeIbanElement>;
    blur: EventEmitter<void>;
    change: EventEmitter<StripeIbanElementChangeEvent>;
    focus: EventEmitter<void>;
    ready: EventEmitter<void>;
    escape: EventEmitter<void>;
    elements: StripeElements;
    state: 'notready' | 'starting' | 'ready';
    constructor(stripeElementsService: StripeElementsService);
    ngOnChanges(changes: SimpleChanges): Promise<void>;
    ngOnInit(): Promise<void>;
    ngOnDestroy(): void;
    update(options: Partial<StripeIbanElementOptions>): void;
    /**
     * @deprecated
     */
    getIban(): StripeIbanElement;
    private createElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeIbanComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripeIbanComponent, "ngx-stripe-iban", never, { "containerClass": "containerClass"; "options": "options"; "elementsOptions": "elementsOptions"; "stripe": "stripe"; }, { "load": "load"; "blur": "blur"; "change": "change"; "focus": "focus"; "ready": "ready"; "escape": "escape"; }, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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