import { ElementRef, EventEmitter, OnInit, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { StripeElementsOptions, StripeElements, StripeIdealBankElement, StripeIdealBankElementOptions, StripeIdealBankElementChangeEvent } from '@stripe/stripe-js';
import { StripeInstance } from '../services/stripe-instance.class';
import { StripeElementsService } from '../services/stripe-elements.service';
import * as ɵngcc0 from '@angular/core';
export declare class StripeIdealBankComponent implements OnInit, OnChanges, OnDestroy {
    stripeElementsService: StripeElementsService;
    stripeElementRef: ElementRef;
    element: StripeIdealBankElement;
    containerClass: string;
    options: Partial<StripeIdealBankElementOptions>;
    elementsOptions: Partial<StripeElementsOptions>;
    stripe: StripeInstance;
    load: EventEmitter<StripeIdealBankElement>;
    blur: EventEmitter<void>;
    change: EventEmitter<StripeIdealBankElementChangeEvent>;
    focus: EventEmitter<void>;
    ready: EventEmitter<void>;
    escape: EventEmitter<void>;
    elements: StripeElements;
    state: 'notready' | 'starting' | 'ready';
    constructor(stripeElementsService: StripeElementsService);
    ngOnChanges(changes: SimpleChanges): Promise<void>;
    ngOnInit(): Promise<void>;
    ngOnDestroy(): void;
    update(options: Partial<StripeIdealBankElementOptions>): void;
    /**
     * @deprecated
     */
    getIdealBank(): StripeIdealBankElement;
    private createElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeIdealBankComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripeIdealBankComponent, "ngx-stripe-ideal-bank", never, { "containerClass": "containerClass"; "options": "options"; "elementsOptions": "elementsOptions"; "stripe": "stripe"; }, { "load": "load"; "blur": "blur"; "change": "change"; "focus": "focus"; "ready": "ready"; "escape": "escape"; }, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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