import { ElementRef, EventEmitter, OnChanges, SimpleChanges } from '@angular/core';
import { Observable } from 'rxjs';
import { StripeElementsOptions, StripeElements, PaymentRequestOptions, PaymentRequest, CanMakePaymentResult, PaymentRequestUpdateOptions, StripePaymentRequestButtonElement, StripePaymentRequestButtonElementOptions, StripePaymentRequestButtonElementClickEvent, PaymentRequestTokenEvent, PaymentRequestPaymentMethodEvent, PaymentRequestSourceEvent, PaymentRequestShippingAddressEvent, PaymentRequestShippingOptionEvent } from '@stripe/stripe-js';
import { StripeInstance } from '../services/stripe-instance.class';
import { StripeElementsService } from '../services/stripe-elements.service';
import * as ɵngcc0 from '@angular/core';
export declare class StripePaymentRequestButtonComponent implements OnChanges {
    stripeElementsService: StripeElementsService;
    stripeElementRef: ElementRef;
    element: StripePaymentRequestButtonElement;
    paymentRequest: PaymentRequest;
    containerClass: string;
    paymentOptions: PaymentRequestOptions;
    options: StripePaymentRequestButtonElementOptions;
    elementsOptions: Partial<StripeElementsOptions>;
    stripe: StripeInstance;
    load: EventEmitter<{
        paymentRequestButton: StripePaymentRequestButtonElement;
        paymentRequest: PaymentRequest;
    }>;
    change: EventEmitter<StripePaymentRequestButtonElementClickEvent>;
    blur: EventEmitter<void>;
    focus: EventEmitter<void>;
    ready: EventEmitter<void>;
    token: EventEmitter<PaymentRequestTokenEvent>;
    paymentMethod: EventEmitter<PaymentRequestPaymentMethodEvent>;
    source: EventEmitter<PaymentRequestSourceEvent>;
    cancel: EventEmitter<void>;
    shippingaddresschange: EventEmitter<PaymentRequestShippingAddressEvent>;
    shippingoptionchange: EventEmitter<PaymentRequestShippingOptionEvent>;
    notavailable: EventEmitter<void>;
    elements: StripeElements;
    constructor(stripeElementsService: StripeElementsService);
    ngOnChanges(changes: SimpleChanges): Promise<void>;
    canMakePayment(): Observable<CanMakePaymentResult | null>;
    update(options: Partial<StripePaymentRequestButtonElementOptions>): void;
    updateRequest(options: PaymentRequestUpdateOptions): void;
    show(): void;
    /**
     * @deprecated
     */
    getButton(): StripePaymentRequestButtonElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripePaymentRequestButtonComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripePaymentRequestButtonComponent, "ngx-stripe-payment-request-button", never, { "containerClass": "containerClass"; "paymentOptions": "paymentOptions"; "options": "options"; "elementsOptions": "elementsOptions"; "stripe": "stripe"; }, { "load": "load"; "change": "change"; "blur": "blur"; "focus": "focus"; "ready": "ready"; "token": "token"; "paymentMethod": "paymentMethod"; "source": "source"; "cancel": "cancel"; "shippingaddresschange": "shippingaddresschange"; "shippingoptionchange": "shippingoptionchange"; "notavailable": "notavailable"; }, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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