import { Observable } from 'rxjs';
import { ConfirmAuBecsDebitPaymentData, ConfirmAuBecsDebitSetupData, ConfirmBancontactPaymentData, ConfirmBancontactPaymentOptions, ConfirmCardPaymentData, ConfirmCardPaymentOptions, ConfirmEpsPaymentData, ConfirmEpsPaymentOptions, ConfirmFpxPaymentData, ConfirmFpxPaymentOptions, ConfirmGiropayPaymentData, ConfirmGiropayPaymentOptions, ConfirmIdealPaymentData, ConfirmIdealPaymentOptions, ConfirmP24PaymentData, ConfirmP24PaymentOptions, ConfirmCardSetupData, ConfirmCardSetupOptions, ConfirmSepaDebitPaymentData, ConfirmSepaDebitSetupData, CreatePaymentMethodData, CreateSourceData, CreateTokenIbanData, CreateTokenCardData, CreateTokenPiiData, CreateTokenBankAccountData, PaymentIntent, PaymentMethod, PaymentRequest, PaymentRequestOptions, RedirectToCheckoutOptions, RetrieveSourceParam, SetupIntent, Stripe, StripeCardElement, StripeCardNumberElement, StripeCardCvcElement, StripeConstructorOptions, StripeElements, StripeElementsOptions, StripeElement, StripeError, StripeIbanElement, Source, Token, TokenCreateParams } from '@stripe/stripe-js';
import { StripeServiceInterface } from '../interfaces/stripe-instance.interface';
import { WindowRef } from './window-ref.service';
import { LazyStripeAPILoader } from './api-loader.service';
import { StripeInstance } from './stripe-instance.class';
import * as ɵngcc0 from '@angular/core';
export declare class StripeService implements StripeServiceInterface {
    version: string;
    key: string;
    options: StripeConstructorOptions;
    loader: LazyStripeAPILoader;
    window: WindowRef;
    stripe: StripeInstance;
    constructor(version: string, key: string, options: StripeConstructorOptions, loader: LazyStripeAPILoader, window: WindowRef);
    getStripeReference(): Observable<any>;
    getInstance(): Stripe | undefined;
    setKey(key: string, options?: StripeConstructorOptions): StripeInstance;
    changeKey(key: string, options?: StripeConstructorOptions): StripeInstance;
    elements(options?: StripeElementsOptions): Observable<StripeElements>;
    redirectToCheckout(options?: RedirectToCheckoutOptions): Observable<never | {
        error: StripeError;
    }>;
    confirmAuBecsDebitPayment(clientSecret: string, data?: ConfirmAuBecsDebitPaymentData): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmBancontactPayment(clientSecret: string, data?: ConfirmBancontactPaymentData, options?: ConfirmBancontactPaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmCardPayment(clientSecret: string, data?: ConfirmCardPaymentData, options?: ConfirmCardPaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmEpsPayment(clientSecret: string, data?: ConfirmEpsPaymentData, options?: ConfirmEpsPaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmFpxPayment(clientSecret: string, data?: ConfirmFpxPaymentData, options?: ConfirmFpxPaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmGiropayPayment(clientSecret: string, data?: ConfirmGiropayPaymentData, options?: ConfirmGiropayPaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmIdealPayment(clientSecret: string, data?: ConfirmIdealPaymentData, options?: ConfirmIdealPaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmP24Payment(clientSecret: string, data?: ConfirmP24PaymentData, options?: ConfirmP24PaymentOptions): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmSepaDebitPayment(clientSecret: string, data?: ConfirmSepaDebitPaymentData): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    handleCardAction(clientSecret: string): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    createPaymentMethod(paymentMethodData: CreatePaymentMethodData): Observable<{
        paymentMethod?: PaymentMethod;
        error?: StripeError;
    }>;
    retrievePaymentIntent(clientSecret: string): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    confirmAuBecsDebitSetup(clientSecret: string, data?: ConfirmAuBecsDebitSetupData): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    confirmCardSetup(clientSecret: string, data?: ConfirmCardSetupData, options?: ConfirmCardSetupOptions): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    confirmSepaDebitSetup(clientSecret: string, data?: ConfirmSepaDebitSetupData): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    retrieveSetupIntent(clientSecret: string): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    paymentRequest(options: PaymentRequestOptions): PaymentRequest | undefined;
    createToken(tokenType: StripeIbanElement, data: CreateTokenIbanData): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createToken(tokenType: StripeCardElement | StripeCardNumberElement, data?: CreateTokenCardData): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createToken(tokenType: 'pii', data: CreateTokenPiiData): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createToken(tokenType: 'bank_account', data: CreateTokenBankAccountData): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createToken(tokenType: 'cvc_update', element?: StripeCardCvcElement): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createToken(tokenType: 'account', data: TokenCreateParams.Account): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createToken(tokenType: 'person', data: TokenCreateParams.Person): Observable<{
        token?: Token;
        error?: StripeError;
    }>;
    createSource(element: StripeElement, sourceData: CreateSourceData): Observable<{
        source?: Source;
        error?: StripeError;
    }>;
    createSource(sourceData: CreateSourceData): Observable<{
        source?: Source;
        error?: StripeError;
    }>;
    retrieveSource(source: RetrieveSourceParam): Observable<{
        source?: Source;
        error?: StripeError;
    }>;
    /**
     * @deprecated
     */
    handleCardPayment(clientSecret: string, element?: any, data?: any): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    /**
     * @deprecated
     */
    confirmPaymentIntent(clientSecret: string, element?: any, data?: any): Observable<{
        paymentIntent?: PaymentIntent;
        error?: StripeError;
    }>;
    /**
     * @deprecated
     */
    handleCardSetup(clientSecret: string, element?: any, data?: any): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    /**
     * @deprecated
     */
    confirmSetupIntent(clientSecret: string, element?: any, data?: any): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    /**
     * @deprecated
     */
    handleFpxPayment(clientSecret: string, element?: any, data?: any): Observable<{
        setupIntent?: SetupIntent;
        error?: StripeError;
    }>;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeService, never>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<StripeService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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