describe('bootcode dependencies', function () {
    this.timeout(60 * 1000);

    var env = require('../../lib/environment'),
        Bundle = require('../../lib/bundle'),
        currentDependencies;

    before(function (done) {
        process && process.stdout.write('  -- building dependencies, please wait... ');
        Bundle.load(env).listDependencies(function (err, dependencies) {
            currentDependencies = dependencies;
            console.log(err ? 'failed' : 'done');
            return done(err);
        });
    });

    it('should not change', function () {
        expect(currentDependencies).to.eql([
            'ajv',
            'ansi-styles',
            'array-uniq',
            'assert',
            'assertion-error',
            'atob',
            'backbone',
            'base64-js',
            'boolbase',
            'browserify',
            'btoa',
            'buffer',
            'chai',
            'chai-postman',
            'chalk',
            'charset',
            'check-error',
            'cheerio',
            'color-convert',
            'color-name',
            'core-util-is',
            'crypto-js',
            'css-select',
            'css-what',
            'csv-parse',
            'deep-eql',
            'define-properties',
            'dom-serializer',
            'domelementtype',
            'domhandler',
            'domutils',
            'entities',
            'es6-object-assign',
            'escape-html',
            'escape-string-regexp',
            'events',
            'fast-deep-equal',
            'fast-json-stable-stringify',
            'file-type',
            'get-func-name',
            'has-flag',
            'htmlparser2',
            'http-reasons',
            'iconv-lite',
            'ieee754',
            'inherits',
            'ip-regex',
            'is-arguments',
            'is-generator-function',
            'is-nan',
            'isarray',
            'jquery',
            'json-schema-traverse',
            'liquid-json',
            'lodash',
            'lodash.assignin',
            'lodash.bind',
            'lodash.clonedeep',
            'lodash.defaults',
            'lodash.escaperegexp',
            'lodash.filter',
            'lodash.flatten',
            'lodash.foreach',
            'lodash.isplainobject',
            'lodash.isstring',
            'lodash.map',
            'lodash.merge',
            'lodash.mergewith',
            'lodash.pick',
            'lodash.reduce',
            'lodash.reject',
            'lodash.some',
            'lodash3',
            'marked',
            'mime-db',
            'mime-format',
            'mime-types',
            'moment',
            'nth-check',
            'number-is-nan',
            'object-is',
            'object-keys',
            'os-browserify',
            'path-browserify',
            'pathval',
            'postcss',
            'postman-collection',
            'postman-sandbox',
            'process',
            'process-nextick-args',
            'psl',
            'punycode',
            'querystring-es3',
            'readable-stream',
            'safe-buffer',
            'safer-buffer',
            'sanitize-html',
            'sax',
            'semver',
            'source-map',
            'srcset',
            'stream-browserify',
            'string_decoder',
            'supports-color',
            'teleport-javascript',
            'timers-browserify',
            'tough-cookie',
            'tv4',
            'type-detect',
            'underscore',
            'uniscope',
            'uri-js',
            'url',
            'util',
            'util-deprecate',
            'uuid',
            'xml2js',
            'xmlbuilder',
            'xtend'
        ]);
    });
});
