/// <reference types="stripe-v3" />
import { ElementRef, EventEmitter } from "@angular/core";
import { StripeScriptTag } from "../StripeScriptTag";
import { StripeSource } from "./StripeSource.component";
import * as ɵngcc0 from '@angular/core';
export declare class StripeCard extends StripeSource {
    ElementRef: ElementRef;
    StripeScriptTag: StripeScriptTag;
    createOptions: stripe.elements.ElementsCreateOptions;
    options: stripe.elements.ElementsOptions;
    token: stripe.Token;
    tokenChange: EventEmitter<stripe.Token>;
    cardMounted: EventEmitter<any>;
    complete: boolean;
    completeChange: EventEmitter<boolean>;
    changed: EventEmitter<ICardChangeEvent>;
    drawn: boolean;
    constructor(ElementRef: ElementRef, StripeScriptTag: StripeScriptTag);
    ngOnInit(): void;
    ngOnChanges(changes: any): void;
    redraw(): void;
    createToken(extraData?: any): Promise<stripe.Token>;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<StripeCard, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<StripeCard, "stripe-card", ["StripeCard"], { "complete": "complete"; "token": "token"; "createOptions": "createOptions"; "options": "options"; }, { "tokenChange": "tokenChange"; "cardMounted": "cardMounted"; "completeChange": "completeChange"; "changed": "changed"; }, never, never>;
}
interface ICardChangeEvent {
    "elementType": string;
    error?: {
        "code": string;
        "type": string;
        "message": string;
    };
    "value": {
        "postalCode": string;
    };
    "empty": boolean;
    "complete": boolean;
    "brand": string;
}
export {};

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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