import { Component, ElementRef, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
// import { group, addgroupForm } from '../agent.class';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { AgentserviceService } from '../agentservice.service';
declare var $: any;

@Component({
  selector: 'app-addgroup',
  templateUrl: './addgroup.component.html',
  styleUrls: ['./addgroup.component.css']
})

export class AddgroupComponent extends AppComponentClass<any, any> {
  @ViewChild('createmodal') createmodal: ElementRef;
  addgroupForm: FormGroup;
  submitted: boolean = false
  responseMessage = "";
  id: any;
  group: any;
  checked: boolean = false;
  strategy: IDropdownSettings = {};
  strategyOptions: any;
  selectedItems = [];
  // selected: any;
  errMessage = "";
  closeDropdownSelection = true;
  headerText: string = '';
  saveButton: any = 'Submit';

  constructor(public data: AgentserviceService, public router: Router, public fb: FormBuilder, private route: ActivatedRoute) {
    super(data, router, fb);
  }

  ngOnInit(): void {

    this.addgroupForm = this.fb.group({
      idgroup: [''],
      // GroupName: ['', [Validators.required, Validators.pattern("[a-zA-Z][a-zA-Z ]+")]],
      GroupName: ['', [Validators.required,Validators.maxLength(255),Validators.pattern(/^(?!\s*$).+$/)]],
      Strategy: ['', Validators.required],
      TierRulesApply: [this.checked],
      Description: ['', Validators.required],
    });

    this.strategy = {
      singleSelection: true,
      idField: 'item_text',
      textField: 'item_text',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.strategyOptions = [
      { item_id: 1, item_text: 'ring-all' },
      { item_id: 2, item_text: 'longest-idle-agent' },
      { item_id: 3, item_text: 'round-robin' },
      { item_id: 4, item_text: 'top-down' },
      { item_id: 5, item_text: 'agent-with-least-talk-time' },
      { item_id: 6, item_text: 'agent-with-fewest-calls' },
      { item_id: 7, item_text: 'sequentially-by-agent-order' },
      { item_id: 8, item_text: 'random' },
      { item_id: 9, item_text: 'ring-progressively' },
    ];

    this.headerText = 'Add Group',
      this.saveButton = 'Submit';

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id = params.get('id');
      if (this.id) {
        this.data.getSingleGroup(this.id).subscribe(result => {
          if (result.status == 200) {
            this.headerText = 'Edit Group',
              this.saveButton = 'Update';
            this.group = result.data[0];
            this.addgroupForm.patchValue({
              idgroup: this.group.id_group,
              GroupName: this.group.group_name,
              Description: this.group.description,
              TierRulesApply: this.group.tier_rules_apply === 'true' ? true : false
            });
            this.selectedItems = [this.group.strategy];
            if (this.group.tier_rules_apply == "true") {
              this.checked = true;
            }
            else {
              this.checked = false;
            }
          }
          else {
            this.errMessage = result.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
    });
  }

  getStretegy(event) {
    this.addgroupForm.patchValue({
      Strategy: event.item_text
    });
    this.selectedItems = [event.item_text];
  }

  onSubmit() {
    if (this.addgroupForm.invalid) {
      this.submitted = true;
      return;
    }
    else {
      this.addgroupForm.value.Strategy = Array.isArray(this.selectedItems) ? this.selectedItems[0] : this.selectedItems || '';
      if (this.addgroupForm.value.idgroup == undefined || this.addgroupForm.value.idgroup == '') {
        this.data.saveGroup(this.addgroupForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            this.onReset()
            const compModal = document.getElementById('createmodal');
            $(compModal).modal({ backdrop: 'static', keyboard: false });
            $(compModal).modal('show');
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
            // this.router.navigateByUrl('/agents/group-details');
            // this.router.navigate(['/agents/group-details'])
            //   .then(() => {
            //     location.reload();
            //   });
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          setTimeout(() => {
            this.responseMessage = "";
            this.responseMessage = err.message;
          }, 5000);
        })
      }
      else {
        this.data.updateGroup(this.addgroupForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigate(['/agents/group-details'])
              .then(() => {
                location.reload();
              });
            }, 3000);
            //  this.router.navigateByUrl('/agents/group-details');
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 3000)
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        })
      }
    }
  }
  reset() {
    this.submitted = false;
    this.addgroupForm.reset();
    Object.keys(this.addgroupForm.controls).forEach(key=>{
    this.addgroupForm.get(key).setValue('');
    })
    this.addgroupForm.patchValue({
      idgroup: this.id
    })
    // const currentIdGroup = this.addgroupForm.value.idgroup;
    // this.addgroupForm.get('idgroup').setValue(currentIdGroup);

  }
  onReset() {
    this.submitted = false;
    this.addgroupForm.reset();
    Object.keys(this.addgroupForm.controls).forEach(key=>{
      this.addgroupForm.get(key).setValue('');
      })
  }

  ModalOPen() {
    const modal = document.getElementById('createmodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
    // location.reload();
  }

  ngOnDestroy() {
    this.createmodal.nativeElement.click();
  }

}
