import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AddagentComponent } from './addagent/addagent.component';
import { AddgroupComponent } from './addgroup/addgroup.component';
import { AgentComponent } from './agent/agent.component';
import { GroupComponent } from './group/group.component';
import { AccountSettingComponent } from './account-setting/account-setting.component';
import { ChannelRequestsComponent } from './channel-requests/channel-requests.component';

const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: '',
                component: AgentComponent,
                data: {
                    title: 'Dashboard',
                    urls: [
                        {
                            title: 'Dashboard',
                            url: '/dashboards/dashboard'
                        },
                        {
                            title: 'Dashboard'
                        }
                    ]
                }
            },
            
            {
                path: 'agent-details/:id',
                component: AgentComponent,
                data: {
                    title: 'Agent Details',
                    urls: [
                        {
                            title: 'Agents',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Agent Details'
                        }
                    ]
                }
            },
            
            {
                path: 'group-details',
                component: GroupComponent,
                data: {
                    title: 'Group Details',
                    urls: [
                        {
                            title: 'Agents',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Group Details'
                        }
                    ]
                }
            },

            {
                path: 'add-agent/:id',
                component: AddagentComponent,
                data: {
                    title: 'Add Agent',
                    urls: [
                        {
                            title: 'Agents',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Add Agent'
                        }
                    ]
                }
            },

            {
                path: 'edit-agent/:id',
                component: AddagentComponent,
                data: {
                    title: 'edit Agent',
                    urls: [
                        {
                            title: 'Agents',
                            // url: 'user-profile'
                        },
                        {
                            title: 'edit Agent'
                        }
                    ]
                }
            },

            {
                path: 'add-group',
                component: AddgroupComponent,
                data: {
                    title: 'Add Group',
                    urls: [
                        {
                            title: 'Agents',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Add Group'
                        }
                    ]
                }
            },

            {
                path: 'edit-group/:id',
                component: AddgroupComponent,
                data: {
                    title: 'Edit Group',
                    urls: [
                        {
                            title: 'Agents',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Edit Group'
                        }
                    ]
                }
            },
            
            {
                path: 'account-setting',
                component: AccountSettingComponent,
                data: {
                    title: 'Account Setting',
                    urls: [
                        {
                            title: 'Account Setting',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Account Setting'
                        }
                    ]
                }
            },
            
            {
                path: 'channel-requests',
                component: ChannelRequestsComponent,
                data: {
                    title: 'Channel Requests',
                    urls: [
                        {
                            title: 'Channel Requests',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Channel Requests'
                        }
                    ]
                }
            },
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class AgentsRoutingModule { }
