import { CUSTOM_ELEMENTS_SCHEMA, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { AgentsRoutingModule } from './agents-routing.module';
import { AgentComponent } from './agent/agent.component';
import { GroupComponent } from './group/group.component';
import { NgxPaginationModule } from 'ngx-pagination';
import { Ng2SearchPipeModule } from 'ng2-search-filter';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { FormsModule } from '@angular/forms';
import { ReactiveFormsModule } from '@angular/forms';
import { SharedModule } from '../shared/shared.module';
import { AddagentComponent } from './addagent/addagent.component';
import { AddgroupComponent } from './addgroup/addgroup.component';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { MatTooltipModule } from '@angular/material/tooltip';
import { AccountSettingComponent } from './account-setting/account-setting.component';
import { ChannelRequestsComponent } from './channel-requests/channel-requests.component';
import { OrderPipe } from './orderPipe.pipe';
@NgModule({
  declarations: [AgentComponent, GroupComponent, AddagentComponent, AddgroupComponent, AccountSettingComponent, ChannelRequestsComponent,OrderPipe],
  imports: [
    CommonModule,
    Ng2SearchPipeModule,
    AgentsRoutingModule,
    NgxPaginationModule,
    NgbModule,
    FormsModule,
    ReactiveFormsModule,
    SharedModule,
    MatTooltipModule,
    NgMultiSelectDropDownModule.forRoot(),
  ],
  providers:[OrderPipe],
  schemas: [CUSTOM_ELEMENTS_SCHEMA]
})
  
export class AgentsModule { }
