import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormArray, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ApiService } from '../api.service';
import { TokensComponent } from '../tokens/tokens.component';
import { IDropdownSettings } from 'ng-multiselect-dropdown';

@Component({
  selector: 'app-addtoken',
  templateUrl: './addtoken.component.html',
  styleUrls: ['./addtoken.component.css'],
})
export class AddtokenComponent implements OnInit {
  tokenForm: FormGroup;
  public submitted: boolean = false;
  responseMessage = '';
  dangMessage = '';
  errMessage = '';
  users: any;
  userType: number;
  session: any;
  dropdownSettings: IDropdownSettings = {};
  usersnames: any = [];
  userlist: any = [];
  dropdownSetting: IDropdownSettings = {};
  dropdownSetting2: IDropdownSettings = {};
  closeDropdownSelection = true;
  userdata: any = [];
  ipOptions: any[] = [];
  selectedIP: any[] = [];
  selectedItems: any = [];
  submittedip = false;
  maxFields = 255;
  selectedRadio: string = '';
  isCustomSelecteds: boolean = false;
  private currentIPMode: 'all' | 'range' | 'individual' = 'all';

  constructor(
    private data: ApiService,
    public fb: FormBuilder,
    public dialog: MatDialogRef<TokensComponent>
  ) {}

  ngOnInit() {
    let session$ = sessionStorage.getItem('isLoggedIn');
    this.session = JSON.parse(session$);
    this.userType = this.session.type;

    this.data.subCustomers().subscribe(
      (result: any) => {
        this.users = result.data;
        // this.usersnames = this.users.map((user: any) => {
        //   return { id: user.iduser, username: user.username };
        // });
        // console.log("Usernames array:", this.users);

        // -----------------------new code change----------------------------------
        this.userdata = result.data.map((item) => ({
          iduser: item.iduser,
          userdata: `${item.customer_name}`,
        }));

        if (this.session.iduser) {
          const preSelectedUser = this.userdata.find(
            (user) => user.iduser == this.session.iduser
          );
          if (preSelectedUser) {
            this.tokenForm.patchValue({
              user: [preSelectedUser],
            });
          }
        }
      },
      (err) => {
        console.log(err.message);
      }
    );

    this.tokenForm = this.fb.group({
      name: ['', [Validators.required, Validators.maxLength(255)]],
      account: [''],
      user: ['', [Validators.required]],
      idtariff: [''],
      status: [''],
      ipdata: [this.selectedIP, [Validators.required]],
      ipdatas: ['', this.getIPRangeValidators()],
      rangeip: ['', this.getRangeValidators()],
      IPArr: this.fb.array([this.createIPGroup()]),
    });

    this.tokenForm.patchValue({
      account: this.session.idaccount,
      user: this.session.iduser,
      idtariff: this.session.idtariff,
      status: this.session.status,
    });

    this.dropdownSetting = {
      singleSelection: true,
      idField: 'iduser',
      textField: 'userdata',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true,
    };

    this.dropdownSetting2 = {
      singleSelection: true,
      idField: 'option',
      textField: 'lable',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true,
    };
    this.ipOptions = [
      { option: '0', lable: 'All IP' },
      { option: '1', lable: 'Custom IP' },
    ];
    this.selectedIP = [this.ipOptions[0]];
    this.tokenForm.get('ipdata')?.patchValue([this.ipOptions[0]]);
    this.currentIPMode = 'all';
    this.clearAllIPValidations();

    this.tokenForm.get('user').valueChanges.subscribe((value) => {
      if (!value || value.length == 0) {
        this.tokenForm.get('user').setErrors({ required: true });
        this.tokenForm.get('user').markAsTouched();
        this.tokenForm.get('user').markAsDirty();
      }
    });
  }

  get isCustomSelected(): boolean {
    const selected = this.tokenForm.get('ipdata')?.value;
    return selected && selected[0]?.option == '1';
  }

  onItemSelect(event: any) {
    this.submitted = false;
    if (event.option == '1') {
      this.isCustomSelecteds = true;
      this.selectedRadio = 'range';
      this.currentIPMode = 'range';
       this.clearIndividualIPFields();
       this.tokenForm.get('ipdatas')?.setValue('');
      this.tokenForm.get('rangeip')?.setValue('');
      this.applyRangeValidators();
      this.clearIndividualIPValidators();
      if (this.IPControls.length == 0) {
        this.addItem();
      }
    } else {
      this.isCustomSelecteds = false;
      this.selectedRadio = '';
      this.currentIPMode = 'all';
      this.clearAllIPValidations();
       this.clearIndividualIPFields();
      this.tokenForm.get('ipdatas')?.setValue('');
      this.tokenForm.get('rangeip')?.setValue('');
    }
  }

  onTokenSave() {
    this.submitted = true;
    if (this.tokenForm.value.user == '' && this.userType == 2) {
      return false;
    } else {
      this.validateIPFieldsBasedOnMode();
       // Additional validation for Individual IP mode
      if (this.currentIPMode === 'individual') {
        const ipArrCtrl = this.tokenForm.get('IPArr') as FormArray;
        let hasEmptyOrInvalidIP = false;
        
        ipArrCtrl.controls.forEach((ctrl, index) => {
          const ipCtrl = ctrl.get('ip');
          if (ipCtrl) {
            ipCtrl.markAsTouched();
            ipCtrl.markAsDirty();
            if (!ipCtrl.value || ipCtrl.value.trim() === '' || ipCtrl.invalid) {
              hasEmptyOrInvalidIP = true;
            }
          }
        });
        
        if (hasEmptyOrInvalidIP) {
          return; 
        }
      }
      if (this.tokenForm.invalid) {
        return;
      } else {
        this.tokenForm.value.user = this.tokenForm.value.user[0].iduser;
        this.tokenForm.value.ipdata = this.tokenForm.value.ipdata[0].option;
        this.data.saveToken(this.tokenForm.value).subscribe(
          (res) => {
            if (res.status == 201) {
              this.responseMessage = res.message;
              setTimeout(() => {
                this.responseMessage = '';
              }, 5000);
              this.dialog.close(res.message);
            } else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = '';
              }, 5000);
            }
          },
          (err) => {
            this.errMessage = 'Connection Lost!';
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        );
      }
    }
  }

  onSelectUser(e) {
    let iduser = e.target.value;
    let selectedUser = this.users.find((x) => x.iduser == iduser);
    this.tokenForm.patchValue({
      user: selectedUser.iduser,
      idtariff: selectedUser.idtariff,
      status: selectedUser.status,
      account: selectedUser.idaccount,
    });
  }

  onReset() {
    this.submitted = false;
    if (this.userType == 2) {
      this.tokenForm.reset({
        name: '',
        account: this.session.idaccount,
        user: this.session.iduser,
        idtariff: this.session.idtariff,
        status: this.session.status,
        ipdata: '',
        ipdatas: '',
        rangeip: '',
        IPArr: [this.createIPGroup()],
      });
      this.selectedRadio = '';
      this.currentIPMode = 'all';
      const ipArray = this.tokenForm.get('IPArr') as FormArray;
      ipArray.clear();
      ipArray.push(this.createIPGroup());
      this.tokenForm.get('ipdata')?.patchValue([this.ipOptions[0]]);
      this.clearAllIPValidations();
 
      this.tokenForm.markAsPristine();
      this.tokenForm.markAsUntouched();
    } else {
      this.tokenForm.reset({
        account: this.session.idaccount,
        user: this.session.iduser,
        idtariff: this.session.idtariff,
        status: this.session.status,
      });
    }
  }

  get IPControls(): FormArray {
    return this.tokenForm.get('IPArr') as FormArray;
  }

  createIPGroup(): FormGroup {
    return this.fb.group({
      ip: [
        '',
        this.currentIPMode == 'individual'
          ? [Validators.required, this.ipValidator]
          : [],
      ],
    });
  }


  addItem(): void {
    const lastIndex = this.IPControls.length - 1;
    if (this.currentIPMode == 'individual') {
      const lastIPControl = this.IPControls.at(lastIndex).get('ip');

      if (lastIPControl?.invalid || !lastIPControl?.value) {
        lastIPControl?.markAsTouched();
        return;
      }
    }

    if (this.IPControls.length < this.maxFields) {
      this.IPControls.push(this.createIPGroup());
    }else {
      alert('Maximum of 255 IP fields allowed.');
    }
  }

  deleteIPFormGroup1(index: number): void {
    if (this.IPControls.length > 1) {
      this.IPControls.removeAt(index);
    } else {
      // alert('At least one IP field is required.');
    }
  }

   ipValidator(control: any): { [key: string]: boolean } | null {
    if (!control.value || control.value.trim() === '') {
      return null;
    }

    const value = control.value.trim();
    // IPv4 validation
    const ipv4Regex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
    // IPv6 validation 
    const ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
    
    const isValidIPv4 = ipv4Regex.test(value);
    const isValidIPv6 = ipv6Regex.test(value);
    
    if (!isValidIPv4 && !isValidIPv6) {
      return { invalidIP: true };
    }
    return null;
  }

  private clearAllIPValidations(): void {
    const ipdatasCtrl = this.tokenForm.get('ipdatas');
    const rangeipCtrl = this.tokenForm.get('rangeip');

    ipdatasCtrl?.clearValidators();
    rangeipCtrl?.clearValidators();
    ipdatasCtrl?.updateValueAndValidity();
    rangeipCtrl?.updateValueAndValidity();

    this.clearIndividualIPValidators();
  }

  private clearIndividualIPValidators(): void {
    const ipArrCtrl = this.tokenForm.get('IPArr') as FormArray;
    ipArrCtrl.controls.forEach((ctrl) => {
      ctrl.get('ip')?.clearValidators();
      ctrl.get('ip')?.updateValueAndValidity();
    });
  }

  private applyRangeValidators(): void {
    const ipdatasCtrl = this.tokenForm.get('ipdatas');
    const rangeipCtrl = this.tokenForm.get('rangeip');

    ipdatasCtrl?.setValidators([
      Validators.required,
     this.ipValidator,
    ]);
    rangeipCtrl?.setValidators([
      Validators.required,
      Validators.min(1),
      Validators.max(255),
    ]);

    ipdatasCtrl?.updateValueAndValidity();
    rangeipCtrl?.updateValueAndValidity();
  }

  private applyIndividualIPValidators(): void {
    const ipArrCtrl = this.tokenForm.get('IPArr') as FormArray;
    ipArrCtrl.controls.forEach((ctrl) => {
      ctrl
        .get('ip')
        ?.setValidators([
          Validators.required,
          this.ipValidator,
        ]);
      ctrl.get('ip')?.updateValueAndValidity();
    });
  }

  private getIPRangeValidators() {
    return this.currentIPMode == 'range'
      ? [
          Validators.required,
         this.ipValidator,
        ]
      : [];
  }

  private getRangeValidators() {
    return this.currentIPMode == 'range'
      ? [Validators.required, Validators.min(1), Validators.max(255)]
      : [];
  }

  // private validateIPFieldsBasedOnMode(): void {
  //   if (this.currentIPMode == 'range') {
  //     const ipArrCtrl = this.tokenForm.get('IPArr') as FormArray;
  //     ipArrCtrl.controls.forEach((ctrl) => {
  //       if (ctrl.get('ip')?.valid) {
  //         ctrl.get('ip')?.setErrors(null);
  //       }
  //     });
  //   } else if (this.currentIPMode == 'individual') {
  //     this.tokenForm.get('ipdatas')?.setErrors(null);
  //     this.tokenForm.get('rangeip')?.setErrors(null);
  //   } else {
  //     this.clearAllIPValidations();
  //   }
  // }

    private validateIPFieldsBasedOnMode(): void {
    if (this.currentIPMode == 'range') {
      // For range mode, validate the range IP field
      const ipdatasCtrl = this.tokenForm.get('ipdatas');
      const rangeipCtrl = this.tokenForm.get('rangeip');
      
      if (ipdatasCtrl?.value && ipdatasCtrl.value.trim() !== '') {
        // Validate the IP field
        const validationResult = this.ipValidator(ipdatasCtrl);
        if (validationResult) {
          ipdatasCtrl.setErrors(validationResult);
        } else {
          ipdatasCtrl.setErrors(null);
        }
      }
      
      // Clear individual IP validators in range mode
      const ipArrCtrl = this.tokenForm.get('IPArr') as FormArray;
      ipArrCtrl.controls.forEach((ctrl) => {
        ctrl.get('ip')?.clearValidators();
        ctrl.get('ip')?.updateValueAndValidity();
      });
      
    } else if (this.currentIPMode == 'individual') {
      // For individual mode, ensure all IP fields have required validators
      const ipArrCtrl = this.tokenForm.get('IPArr') as FormArray;
      ipArrCtrl.controls.forEach((ctrl) => {
        const ipCtrl = ctrl.get('ip');
        if (ipCtrl) {
          // Apply required validator for individual IP mode
          ipCtrl.setValidators([Validators.required, this.ipValidator]);
          ipCtrl.updateValueAndValidity();
        }
      });
      
      // Clear range IP validators in individual mode
      this.tokenForm.get('ipdatas')?.clearValidators();
      this.tokenForm.get('rangeip')?.clearValidators();
      this.tokenForm.get('ipdatas')?.updateValueAndValidity();
      this.tokenForm.get('rangeip')?.updateValueAndValidity();
      
    } else {
      this.clearAllIPValidations();
    }
  }

  onRadioChange(value: string) {
    this.submitted = false;
    this.selectedRadio = value;
    this.currentIPMode = value as 'range' | 'individual';

    if (value == 'range') {
       this.clearIndividualIPFields();
      this.applyRangeValidators();
      this.clearIndividualIPValidators();
    } else if (value == 'individual') {
      this.tokenForm.get('ipdatas')?.setValue('');
      this.tokenForm.get('rangeip')?.setValue('');
      const ipdatasCtrl = this.tokenForm.get('ipdatas');
      const rangeipCtrl = this.tokenForm.get('rangeip');

      ipdatasCtrl?.clearValidators();
      rangeipCtrl?.clearValidators();
      ipdatasCtrl?.updateValueAndValidity();
      rangeipCtrl?.updateValueAndValidity();

      this.applyIndividualIPValidators();
    }
  }

   private clearIndividualIPFields(): void {
    const ipArray = this.tokenForm.get('IPArr') as FormArray;
    while (ipArray.length !== 0) {
      ipArray.removeAt(0);
    }
    ipArray.push(this.createIPGroup());
    this.tokenForm.markAsPristine();
    this.tokenForm.markAsUntouched();
  }

  get showIPError(): boolean {
    if (this.currentIPMode != 'individual') return false;
    if (this.IPControls.length == 0) return true;
    const hasValidIP = this.IPControls.controls.some(
      (ctrl: any) =>
        ctrl.get('ip')?.valid && ctrl.get('ip')?.value?.trim() !== ''
    );
    return !hasValidIP;
  }
}
