import { Component, ViewChild, ElementRef } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormArray} from '@angular/forms';
import { ApiService } from '../api.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AddtokenComponent } from '../addtoken/addtoken.component';
import { Router } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
import { IDropdownSettings } from 'ng-multiselect-dropdown';

declare var $: any;

@Component({
  selector: 'app-tokens',
  templateUrl: './tokens.component.html',
  styleUrls: ['./tokens.component.css'],
})
export class TokensComponent extends AppComponentClass<any, any> {
  @ViewChild('deleteaccountmodal') deleteaccountmodal: ElementRef;
  @ViewChild('viewmodal') viewmodal: ElementRef;
  @ViewChild('addipmodel') addipmodel: ElementRef;
  @ViewChild('deleteapi') deleteapi: ElementRef;
  @ViewChild('copyip') copyip: ElementRef;
  filterMetadata = { count: 0 };
  filtre: string;
  searchText = { count: 0 };
  pShow = false;

  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  filterTerm: string;
  responseMessage = '';
  msgHideAndShow: boolean = false;
  resData: any = [];
  password: any;
  userType: number;
  session: any;
  iptext: boolean = false;
  iselectAll: boolean = false;
  isChecked: boolean = false;
  ipOptions: any[] = [];
  selectedIP: any[] = [];
  selectedItems: any = [];
  IPForm: FormGroup;
  selectedRadio: string = '';
  dropdownSetting2: IDropdownSettings = {};
  closeDropdownSelection = true;
  submittedip = false;
  maxFields = 255;
  public submitted: boolean = false;
  ViewIp: any[] = [];
  errMessage: any;
  isCustomSelecteds: boolean = false;
  showIPErrors: boolean = false;
  delIp: any[] = [];
  selectedIps: string[] = [];
  idapi: any;

  private currentIPMode: 'all' | 'range' | 'individual' = 'all';
  api: any;
  copyid: any;
  deleteid: string;
  idacc: any;
  iduser: any;

  constructor(
    public data: ApiService,
    public dialog: MatDialog,
    public router: Router,
    public fb: FormBuilder
  ) {
    super(data, router, fb);
  }

  ngOnInit() {
    this.ipOptions = [
      { option: '0', lable: 'All IP' },
      { option: '1', lable: 'Custom IP' },
    ];

    let session$ = sessionStorage.getItem('isLoggedIn');
    this.session = JSON.parse(session$);
    this.userType = this.session.type;
    this.password = 'password';

    this.dropdownSetting2 = {
      singleSelection: true,
      idField: 'option',
      textField: 'lable',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true,
    };

    this.IPForm = this.fb.group({
      ipdata: [[this.ipOptions[0]],[Validators.required]],
      ipdatas: [''],
      rangeip: [''],
      IPArr: this.fb.array([this.createIPGroup()]),
    });
    this.updateValidators();

    this.getToken();
    this.selectedIP = [this.ipOptions[0]];
    this.IPForm.get('ipdata')?.patchValue([this.ipOptions[0]]);
    // this.IPForm.get('IPArr')?.setErrors(this.validateIPArray(this.IPControls));
  }

  getToken() {
    this.data.getApiToken().subscribe((res) => {
      $('#basic-datatabless06').dataTable().fnClearTable();
      $('#basic-datatabless06').dataTable().fnDraw();
      $('#basic-datatabless06').dataTable().fnDestroy();
      this.resData = res.data;
      $.getScript('./assets/table.js');
      this.resData.forEach((element) => {
        element.pShow = false;
        element.pswd = 'password';
      });
    });
  }

  keyToggle(id) {
    this.resData.forEach((element) => {
      if (element.idapi == id) {
        if (element.pswd == 'password') {
          element.pswd = 'text';
          element.pShow = true;
        } else {
          element.pswd = 'password';
          element.pShow = false;
        }
      }
    });
  }

  openDialog() {
    const dialogRef = this.dialog.open(AddtokenComponent, {
      disableClose: true,
    });

    dialogRef.afterClosed().subscribe((result) => {
      this.responseMessage = result;
      setTimeout(() => {
        this.responseMessage = '';
      }, 5000);
      // this.ngOnInit();
      this.getToken();
    });
  }

  onApiDelete() {
    if (confirm('Are you sure you want delete data!')) {
      this.data.onDeleteApiToken(this.deleteid).subscribe((res) => {
        this.responseMessage = res.message;
        this.deleteapi.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
        this.getToken();
      });
    } else {
      ('Cancel!');
    }
  }

  deleteToken(id: any, key: any) {
    this.deleteid = id + '@' + key;
  }

  textMessageFunc(msgText) {
    this.responseMessage = 'Copied to Clipboard';
    setTimeout(() => {
      this.responseMessage = '';
    }, 5000);
  }

  applyFilter(event: Event) {
    const filterValue = (event.target as HTMLInputElement).value;
    this.dataSource.filter = filterValue.trim().toLowerCase();

    if (this.dataSource.paginator) {
      this.dataSource.paginator.firstPage();
    }
  }
  toggleDescription(data, property) {
    data[property] = !data[property];
  }

  get isCustomSelected(): boolean {
    const selected = this.IPForm.get('ipdata')?.value;
    return selected && selected[0]?.option == '1';
  }

  get IPControls(): FormArray {
    return this.IPForm.get('IPArr') as FormArray;
  }

  createIPGroup(): FormGroup {
    return this.fb.group({
      ip: ['', [Validators.required, this.ipValidator.bind(this)]],
    });
  }

  addItem(): void {
    const lastIndex = this.IPControls.length - 1;
    const lastIPControl = this.IPControls.at(lastIndex).get('ip');

    if (lastIPControl?.invalid || !lastIPControl?.value) {
      lastIPControl?.markAsTouched();
      // alert('Please enter a valid IP before adding another.');
      return;
    }

    if (this.IPControls.length < this.maxFields) {
      this.IPControls.push(this.createIPGroup());
    } else {
      alert('Maximum of 25 IP fields allowed.');
    }
  }

  deleteIPFormGroup1(index: number): void {
    if (this.IPControls.length > 1) {
      this.IPControls.removeAt(index);
    } else {
      // alert('At least one IP field is required.');
    }
  }

  // ipValidator(control: any): { [key: string]: boolean } | null {
  //   const ipRegex =
  //     /^(25[0-5]|2[0-4]\d|1\d{2}|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]?\d)){3}$/;
  //   if (control.value && !ipRegex.test(control.value)) {
  //     return { invalidIP: true };
  //   }
  //   return null;
  // }
  ipValidator(control: any): { [key: string]: boolean } | null {

  const ipv4Regex = /^(25[0-5]|2[0-4]\d|1\d{2}|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]?\d)){3}$/;
  const ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
  
  if (control.value) {
    const isValidIPv4 = ipv4Regex.test(control.value);
    const isValidIPv6 = ipv6Regex.test(control.value);
    
    if (!isValidIPv4 && !isValidIPv6) {
      return { invalidIP: true };
    }
  }
  
  return null;
}

  private updateValidators(): void {
    const ipdatasCtrl = this.IPForm.get('ipdatas');
    const rangeipCtrl = this.IPForm.get('rangeip');
    const ipArrCtrl = this.IPForm.get('IPArr') as FormArray;

    // Clear all validators first
    ipdatasCtrl?.clearValidators();
    rangeipCtrl?.clearValidators();

    ipArrCtrl.controls.forEach((ctrl) => {
      ctrl.get('ip')?.clearValidators();
    });

    // Set validators based on current mode
    if (this.currentIPMode == 'range') {
      ipdatasCtrl?.setValidators([
        Validators.required,
        Validators.pattern(
          /^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}$/
        ),
      ]);
      rangeipCtrl?.setValidators([
        Validators.required,
        Validators.min(1),
        Validators.max(255),
      ]);
    } else if (this.currentIPMode == 'individual') {
      ipArrCtrl.controls.forEach((ctrl) => {
        ctrl.get('ip')?.setValidators([Validators.required, this.ipValidator.bind(this)]);
      });
    }

    // Update validity
    ipdatasCtrl?.updateValueAndValidity();
    rangeipCtrl?.updateValueAndValidity();
    ipArrCtrl.controls.forEach((ctrl) => {
      ctrl.get('ip')?.updateValueAndValidity();
    });
  }

  onItemSelect(event: any) {
     this.submitted = false;
    this.submittedip = false;
    if (event.option == '1') {
      this.isCustomSelecteds = true;
      this.selectedRadio = 'range';
      this.currentIPMode = 'range';
      this.clearIndividualIPFields()
      this.IPForm.get('ipdatas')?.setValue('');
      this.IPForm.get('rangeip')?.setValue('');
      this.updateValidators();

      if (this.IPControls.length == 0) {
        this.addItem();
      }
    } else {
      this.isCustomSelecteds = false;
      this.selectedRadio = '';
      this.currentIPMode = 'all';
      this.clearIndividualIPFields();
      this.IPForm.get('ipdatas')?.setValue('');
      this.IPForm.get('rangeip')?.setValue('');
      this.updateValidators();
    }
  }

  onRadioChange(value: string) {
    this.submitted = false;
    this.submittedip = false;
    this.selectedRadio = value;
    this.currentIPMode = value as 'range' | 'individual';
    if (value === 'range') {
      this.clearIndividualIPFields();
    } else if (value === 'individual') {
      this.IPForm.get('ipdatas')?.setValue('');
      this.IPForm.get('rangeip')?.setValue('');
    }
    
    this.updateValidators();
    
    if (value == 'individual' && this.IPControls.length == 0) {
      this.addItem();
    }
  }

  onIPSave() {
    this.submitted = true;
    this.submittedip = true;

    if (!this.validateForm()) {
      console.log('Form validation failed');
      return;
    } else {
      this.IPForm.value.ipdata = this.IPForm.value.ipdata[0].option ?? this.IPForm.value.ipdata;
      let payLoad: any = {
        idapi: this.api,
        data: this.IPForm.value,
        ...(this.userType == 1 && {
          idaccount: this.idacc,
          iduser: this.iduser,
        }),
      };

      this.data.AddIP(payLoad).subscribe((res) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          this.onReset();
          setTimeout(() => {
            this.responseMessage = '';
            this.addipmodel.nativeElement.click();
            this.getToken();
          }, 3000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 3000);
        }
      });
    }
  }

  validateForm(): boolean {
    this.markFormGroupTouched(this.IPForm);

    if (this.currentIPMode == 'all') {
      return this.IPForm.get('ipdata')
        ? this.IPForm.get('ipdata')!.valid
        : false;
    } else if (this.currentIPMode == 'range') {
      const ipdatasValid = this.IPForm.get('ipdatas')
        ? this.IPForm.get('ipdatas')!.valid
        : false;
      const rangeipValid = this.IPForm.get('rangeip')
        ? this.IPForm.get('rangeip')!.valid
        : false;
      return ipdatasValid && rangeipValid;
    } else if (this.currentIPMode == 'individual') {
       const allIPsValid = this.IPControls.controls.every(
        (ctrl: any) =>
          ctrl.get('ip')?.valid && ctrl.get('ip')?.value?.trim() !== ''
      );
      return allIPsValid;
    }

    return false;
  }

  markFormGroupTouched(formGroup: FormGroup | FormArray) {
    Object.keys(formGroup.controls).forEach((key) => {
      const control = formGroup.get(key);
      if (control instanceof FormGroup || control instanceof FormArray) {
        this.markFormGroupTouched(control);
      } else {
        control?.markAsTouched();
      }
    });
  }

  onReset() {
    this.submitted = false;
    this.submittedip = false;
    this.selectedRadio = '';
    this.currentIPMode = 'all';

    // Clear the form array
    const ipArray = this.IPForm.get('IPArr') as FormArray;
    while (ipArray.length !== 0) {
      ipArray.removeAt(0);
    }
    ipArray.push(this.createIPGroup());

    // Reset form values
    this.IPForm.reset();
    this.IPForm.get('ipdata')?.patchValue([this.ipOptions[0]]);

    // Reset validation state
    this.IPForm.markAsPristine();
    this.IPForm.markAsUntouched();

    this.updateValidators();
  }

  private clearIndividualIPFields(): void {
    const ipArray = this.IPForm.get('IPArr') as FormArray;
    while (ipArray.length !== 0) {
      ipArray.removeAt(0);
    }
    ipArray.push(this.createIPGroup());
    
    // Clear validation state
    this.IPForm.markAsPristine();
    this.IPForm.markAsUntouched();
  }

  getViewIp(id: any) {
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/table.js');
    this.ViewIp = [];
    this.data.getviewIp(id).subscribe((res) => {
      if (res.status == 200) {
        this.ViewIp = res.data;
        $('#basic-datatables').dataTable().fnClearTable();
        $('#basic-datatables').dataTable().fnDraw();
        $('#basic-datatables').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 3000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 3000);
      }
    });
  }

  getViewdeleteIp(id: any) {
    $('#basic-datatables1').dataTable().fnDestroy();
    $.getScript('./assets/table.js');
    this.delIp = [];
    this.data.getviewIp(id).subscribe((res) => {
      if (res.status == 200) {
        this.delIp = res.data;
        $('#basic-datatables1').dataTable().fnClearTable();
        $('#basic-datatables1').dataTable().fnDraw();
        $('#basic-datatables1').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
      }
      // else {
      //   this.errMessage = res.message;
      //   setTimeout(() => {
      //     this.errMessage = "";
      //   }, 3000);
      // }
    });
  }

 deletedip() {
    let payLoad: any = JSON.stringify({
      ips: this.selectedIps,
      idapi: this.idapi,
    });
    this.data.deleteselectedip(payLoad).subscribe((res) => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        this.getToken();
        // this.getViewdeleteIp(this.idapi);
        this.deleteaccountmodal.nativeElement.click();
        this.selectedIps =[]
        setTimeout(() => {
          this.responseMessage = '';
        }, 3000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 3000);
      }
    });
  }

  onCheckboxChange(item: any) {
    this.idapi = item.idapi;
    if (item.checked) {
      this.selectedIps.push(item.api_ip_id);
    } else {
      const index = this.selectedIps.indexOf(item.api_ip_id);
      if (index > -1) {
        this.selectedIps.splice(index, 1);
      }
    }
  }

  get showIPError(): boolean {
    if (this.IPControls.length == 0) return true;
    const hasValidIP = this.IPControls.controls.some(
      (ctrl: any) =>
        ctrl.get('ip')?.valid && ctrl.get('ip')?.value?.trim() !== ''
    );
    return !hasValidIP;
  }

  apitype(id: any) {
    // this.selectedRadio = id.api_type == 1 ? 'range' : '';
    const selected = this.ipOptions.find(
      (opt) => opt.option == String(id.api_type)
    );
    this.api = id.idapi;
    this.idacc = id.idaccount;
    this.iduser = id.iduser;
    if (selected) {
      this.IPForm.patchValue({ ipdata: [selected] });
      this.selectedIP = [selected];
    } else {
      this.IPForm.patchValue({ ipdata: [] });
      this.selectedIP = [];
    }
    if (id.api_type == 1) {
      this.isCustomSelecteds = true;
      this.selectedRadio = 'range';
      this.currentIPMode = 'range';
    } 
    this.updateValidators();

  }

  getcopyId(id: any) {
    this.copyid = id;
  }

  CopyToken() {
    this.data.copyToken(this.copyid).subscribe(
      (res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.getToken();
          this.copyip.nativeElement.click();

          setTimeout(() => {
            this.responseMessage = '';
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      },
      (err) => {
        this.errMessage = 'Connection Lost!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    );
  }

  ngOnDestroy() {
    this.deleteaccountmodal.nativeElement.click();
    this.viewmodal.nativeElement.click();
    this.addipmodel.nativeElement.click();
    this.deleteapi.nativeElement.click();
    this.copyip.nativeElement.click();
  }
}
