import { CUSTOM_ELEMENTS_SCHEMA, NgModule } from '@angular/core';
import { RouterModule } from '@angular/router';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { AuthenticationService } from './authentication.service';
import { AuthenticationRoutes } from './authentication.routing';
import { ErrorComponent } from './error/error.component';
import { LockscreenComponent } from './lockscreen/lockscreen.component';
import { LoginComponent } from './login/login.component';
import { AuthGuard } from './guard/auth.guard';
import { NotfoundComponent } from './404/not-found.component';
import { NgbModalModule } from '@ng-bootstrap/ng-bootstrap';
import { HttpErrorInterceptor } from './helper/error.interceptor';
import { SharedModule } from '../shared/shared.module';
import { SignupComponent } from './signup/signup.component';
import { DemoMaterialModule } from '../demo-material-module';
import { VerifyemailComponent } from './verifyemail/verifyemail.component';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import {MatExpansionModule} from '@angular/material/expansion';
import { GoogleLoginProvider, SocialAuthServiceConfig, SocialLoginModule } from 'angularx-social-login';
import { ForgotComponent } from './forgot/forgot.component';
import { DeleteUserComponent } from './delete-user/delete-user.component';
import { DeleteProcessComponent } from './delete-process/delete-process.component';
import { RestoreAccountComponent } from './restore-account/restore-account.component';
import { ResetPasswordComponent } from './reset-password/reset-password.component';
import { UserloginComponent } from './userlogin/userlogin.component';
import { SetpasswordComponent } from './setpassword/setpassword.component';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';

@NgModule({
  imports: [ 
    CommonModule,
    RouterModule.forChild(AuthenticationRoutes),
    ReactiveFormsModule,
    HttpClientModule,
    FormsModule,
    NgbModalModule,
    SharedModule,
    DemoMaterialModule,
    MatExpansionModule,
    SocialLoginModule ,
    NgMultiSelectDropDownModule.forRoot(),
    NgbModule,
  ],
  declarations: [
    ErrorComponent,
    LockscreenComponent,
    LoginComponent,
    NotfoundComponent,
    SignupComponent,
    VerifyemailComponent,
    ForgotComponent,
    DeleteUserComponent,
    DeleteProcessComponent,
    RestoreAccountComponent,
    ResetPasswordComponent,
    UserloginComponent,
    SetpasswordComponent,
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA],
  exports:[NotfoundComponent],
  providers: [
    AuthenticationService, AuthGuard,
    HttpErrorInterceptor
    // {
    //   provide: 'SocialAuthServiceConfig',
    //   useValue: {
    //     autoLogin: false,
    //     providers: [
    //       {
    //         id: GoogleLoginProvider.PROVIDER_ID,
    //         provider: new GoogleLoginProvider(
    //           '346894756193-77g7vakl06tbdm2julllpki0ib1d0rpt.apps.googleusercontent.com'
    //         )
    //       }
    //       {
    //         id: FacebookLoginProvider.PROVIDER_ID,
    //         provider: new FacebookLoginProvider('clientId')
    //       }
    //     ]
    //   } as SocialAuthServiceConfig,
    // }
    ],
})

export class AuthenticationModule {}
