import { Injectable } from '@angular/core';
import { AppService } from '../shared/service/AppService.class';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Router } from '@angular/router';
import { Authentication } from './model/model.class';
import { APIURL } from '../app-routing.module';
import { BehaviorSubject, Observable } from 'rxjs';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: "root"
})
export class AuthenticationService extends AppService<Authentication>{
  constructor(protected http: HttpClient, protected router: Router) {
    super(http);
    this.appmod = "login";
    this.currentUserSubject = new BehaviorSubject(JSON.parse(sessionStorage.getItem('isLoggedIn')));
    this.currentUser = this.currentUserSubject.asObservable();
  }

  private currentUserSubject: BehaviorSubject<any>;
  public currentUser: Observable<any>;

  public get currentUserValue() {
    return this.currentUserSubject.getValue();
  }

  logout() {
    this.http.get(APIURL + "login").subscribe(res => {
      console.log("User Logged Out Successfully");
      localStorage.clear();
      sessionStorage.clear();
      this.router.navigate(['/login']).then(()=>{
        location.reload();
      });
    }, err => {
      console.log("User Logged Out Successfully");
      localStorage.clear();
      sessionStorage.clear();
      this.router.navigate(['/login']).then(()=>{
        location.reload();
      });
    });
  }

  forgotpass(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/forgotpwd';
    let result = this.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  SessionLogin(type: string): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'login';
    let data = this.getService(type);
    this.appmod = tmp;
    return data;
  }

  @LoaderEnabled()
  Signup(data: any,url:any): Observable<any> {
    this.appmod = "signup";
    let result = super.saveService(data,url);
    this.appmod = "login";
    return result;
  }

  @LoaderEnabled()
  sendMailForgot(filter: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "forgot-mail";
    let result = super.saveService(filter);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  verifyToken(token: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "verify-token";
    let result = super.getService(token);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  verifyUrl(url: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "verify-url";
    let result = super.getService(url);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  updatePassword(password: any): Observable<any> {
    this.appmod = "update-password";
    let result = super.updateService(password);
    this.appmod = "login";
    return result;
  }

  googleLogin(): Observable<any> {
    const apiURL = environment.SERVER + 'auth/google';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders });
  }

  countryCodes(): Observable<any> {
    return this.http.get('./assets/country_codes.json');
  }

  /**
   * To setup the system Timezone
   */
  SetSystemTZ(data: any): Observable<any> {
    this.appmod = "update_sys_tz";
    let result = super.saveService(data);
    this.appmod = "login";
    return result;
  }

  @LoaderEnabled()
  setPassword(data: any): Observable<any> {
    this.appmod = "setpassworduser";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

}