import { Component, OnInit, Inject } from '@angular/core'
import { Router, ActivatedRoute } from '@angular/router'
import { DOCUMENT } from '@angular/common'
import { FormGroup, FormControl } from '@angular/forms'
import { AuthenticationService } from '../authentication.service'

import { from } from 'rxjs'
const url = require("url")
// const axios = require("axios")
const { URL } = url
// const jwt = require("jsonwebtoken")
// const fs = require("fs")
// const path = require("path")
// const { publicKey } = require(DOMAIN + "assets/sso_keys")
// const authURL = DOMAIN
// const validReferOrigin = APIURL
// const ssoServerJWTURL = APIURL + "verify_token"
const ISSUER = "ninja-dialer"

@Component({
  selector: 'app-authorization',
  templateUrl: './authorization.component.html',
  styleUrls: ['./authorization.component.css']
})
export class AuthorizationComponent implements OnInit {

  constructor(protected data: AuthenticationService, protected router: Router, private activatedRoute: ActivatedRoute, @Inject(DOCUMENT) private document: Document) { }

  form = new FormGroup({
    username: new FormControl(''),
    password: new FormControl('')
  })
  serviceURL: string = ""

  ngOnInit() {
    this.activatedRoute.queryParams.subscribe(params => {
      this.serviceURL = params['serviceURL']
    })

    if (this.isAuthenticated()) {
      if (this.serviceURL) {
        this.document.location.href = this.serviceURL
      } else {
        this.router.navigate(['/dashboards'])
      }
    }
  }

  isAuthenticated(): any {
    let userSess: any = null
    // if (req.session.user == null) {
    if (userSess == null) {
      return false
    }
    return true

    // const redirectURL = `${req.protocol}://${req.headers.host}${req.path}`
    // if (req.session.user == null) {
    //   return res.redirect(
    //     authURL + `login/authorize?serviceURL=${redirectURL}`
    //   )
    // }
  }

  ssoRedirect(): any {
    return async function (req, res, next) {
      // check if the req has the queryParameter as ssoToken
      // and who is the referer.
      const { ssoToken } = req.query
      if (ssoToken != null) {
        // to remove the ssoToken in query parameter redirect.
        const redirectURL = url.parse(req.url).pathname
        try {
          // const response = await axios.get(
          //   `${ssoServerJWTURL}?ssoToken=${ssoToken}`,
          //   {
          //     headers: {
          //       Authorization: "Bearer l1Q7zkOL59cRqWBkQ12ZiGVW2DBL"
          //     }
          //   }
          // )
          // const { token } = response.data
          // const decoded = await this.verifyJwtToken(token)

          // req.session.user = decoded
        } catch (err) {
          return next(err)
        }

        return res.redirect(`${redirectURL}`)
      }
    }
  }

  verifyJwtToken(token: any): any {
    new Promise((resolve, reject) => {
      // jwt.verify(
      //   token,
      //   publicKey,
      //   { issuer: ISSUER, algorithms: ["RS256"] },
      //   (err, decoded) => {
      //     if (err) return reject(err)
      //     return resolve(decoded)
      //   }
      // )
    })
  }

  onSubmit(): void {
    let form: any = this.form.value
    form['service_url'] = this.serviceURL
    form = JSON.stringify(form)
    // console.log(form)
    // this.data.authenticate(form).subscribe((r) => {
    //   console.log("r", r)
    //   if (!r.error) {
    //     this.document.location.href = r.data.serviceURL
    //   }
    // })
  }

}


// const publicKey: any = fs.readFileSync(DOMAIN + "assets/sso_keys")
// const publicKey: any = fetch(DOMAIN + "assets/sso_keys/jwtPublic.key")
// const jwtValidatityKey: any = "simple-sso-jwt-validatity"