import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})

export class ConnectionsService extends AppService<any> {
  constructor(public http:HttpClient) {
    super(http);

    this.appmod = "usermanagement";
  }


  @LoaderEnabled()
  deleteIP(id): Observable<any> {
    this.appmod = "deleteip";
    let result = super.deleteService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getConnection(): Observable<any> {
    this.appmod = 'getconnection';
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getRoutingConnection(): Observable<any> {
    this.appmod = 'get_routing';
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getUrl(data): Observable<any> {
    this.appmod = 'get_url';
    let result = super.getService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getUrls(data): Observable<any> {
    this.appmod = 'get_urls';
    let result = super.getService(data);
    this.appmod = "usermanagement";
    return result;
  }
  @LoaderEnabled()
  setUrl(data): Observable<any> {
    this.appmod = 'set_url';
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }
  
  updatePassword(data): Observable<any> {
    this.appmod = 'set_pass';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  get_expertSetting(data): Observable<any> {
    this.appmod = 'get_setting';
    let result = super.getService(data);
    this.appmod = "usermanagement";
    return result;
  }


  @LoaderEnabled()
  saveConnection(data: any): Observable<any> {
    this.appmod = 'saveconnectionIP';
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateConnectionName(data: any): Observable<any> {
    this.appmod = 'updateconnectionname';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateStatus(data: any,id:any): Observable<any> {
    console.log("service",id);
    this.appmod = 'updatestatus';
    let result = super.updateService(data,id);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateConnTechPre(data: any): Observable<any> {
    this.appmod = 'updateconntechpre';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }
  
  @LoaderEnabled()
  updateConnUserPass(data: any): Observable<any> {
    this.appmod = 'updateconnuserpass';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }
  @LoaderEnabled()
  updateConnInboundCall(data: any): Observable<any> {
    this.appmod = 'updateconninboundcall';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateConnection(data: any): Observable<any> {
    this.appmod = 'update_connection';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  saveIp(data: any):Observable<any> {
    this.appmod = 'saveip';
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getIP(data: any) :Observable<any> {
    this.appmod = "getIP";
    let result = super.getService(data);
    this.appmod="";
    return result;
  }

  @LoaderEnabled()
  updateIP(data: any):Observable<any> {   
    this.appmod = 'updateip';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  saveUrls(data: any){
    this.appmod = 'saveurls';
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateUrls(data: any):Observable<any> {
    this.appmod = 'update_urls';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updatefqdn(data: any):Observable<any> {
    this.appmod = 'update_fqdn';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  update_expertSetting(data: any):Observable<any> {
    this.appmod = 'update_expertsetting';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  save_forword(data: any) :Observable<any> {
    this.appmod = "save_forword";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  save_smsinbound(data: any) :Observable<any> {
    this.appmod = "save_smsinbound";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  save_smsoutbound(data: any) :Observable<any> {
    this.appmod = "save_smsoutbound";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getInbound(data): Observable<any> {
    this.appmod = 'get_inbound';
    let result = super.getService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getOutbound(data): Observable<any> {
    this.appmod = 'get_outbound';
    let result = super.getService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateInbound(data: any):Observable<any> {
    this.appmod = 'update_inbound';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateOutbound(data: any):Observable<any> {
    this.appmod = 'update_outbound';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  delete_connection(key: any):Observable<any> {
    this.appmod = 'delete_connection';
    let result = super.deleteService(key);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getAssociatedDID(id: any) :Observable<any> {
    this.appmod = "getAssociatedDID";
    let result = super.getService(id);
    this.appmod="";
    return result;
  }

  @LoaderEnabled()
  setDefault(data): Observable<any>{
      let apiUrl = environment.SERVER + "default-connection";
      let httpHeaders = new HttpHeaders({
        // "Content-Type": "application/json",
      });
      return this.http.put(apiUrl, {data: data}, {headers: httpHeaders});
  }

  @LoaderEnabled()
  deleteForward(data: any): Observable<any> {
    this.appmod = 'deleteForward';
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  public getconnectiondetails():Observable<any>{
    return this.http.get('./assets/connections.json');
  }
  public connectionhelp():Observable<any>{
    return this.http.get('./assets/connectionhelp.json');
  }
}
