import { Component, ElementRef, HostListener, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { FederalService } from '../federal.service';

@Component({
  selector: 'app-federal',
  templateUrl: './federal.component.html',
  styleUrls: ['./federal.component.css']
})
export class FederalComponent implements OnInit {
  submitted2: boolean = false;
  @ViewChild('canvas') canvas: ElementRef;
  @ViewChild('canvas', { static: true }) canvasRef!: ElementRef<HTMLCanvasElement>;
  // @ViewChild('esignmodal') esignmodal: ElementRef;
  app: any;
  // canvas: any;
  urlData: any;
  showImage: any;
  FedrlQuestion: any = [];
  errMessage: any = "";
  responseMessage: any = "";
  FederalForm: FormGroup;
  hideQus: boolean = true;
  Errqus: string = '';
  FederalPDF: any = [];
  iduser: any;
  idaccount: any;
  sesiduser: any;
  checked1: number = 0;
  checked2: number = 0;
  sessionType: any;
  newUserStatus: any;
  disabled: boolean = false;
  kyc_status: any = '';
  kyc_color: any;
  federal_status: any = "";
  federal_color: any = "";
  counter: number = 5;
  countDownInterval: any = 0;
  private ctx: CanvasRenderingContext2D;
  private isDrawing: boolean = false;
  private lastX: number = 0;
  private lastY: number = 0;
  errorMessageDisplayed : boolean = false;
  constructor(public data: FederalService, public User: UsermanagementService, public fb: FormBuilder, public router: Router) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.sessionType = this.sesiduser.type;
    this.newUserStatus = this.sesiduser.newUser_status;
    if (this.sesiduser.newUser_status == 0) {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    if (this.sesiduser.newUser_status == 1) {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true" && this.sesiduser.isCard == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    this.getUserDetail();
    this.FederalForm = this.fb.group({
      federal_question_1: ['', [Validators.required]],
      sub_federal_question_2: [''],
      fullname: ['', [Validators.required,Validators.pattern(/^(?! )[ -~]+(?: [ -~]+)*(?<! )$/),Validators.maxLength(99)]],
      kyc_signature: ['', [Validators.required]],
    });

    this.data.getFedrlQuestion().subscribe(res => {
      if (res.status == 200) {
        this.FedrlQuestion = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }


  async init() {
    const canvasEl = this.canvas.nativeElement;
    const parent = canvasEl.parentElement;
    const devicePixelRatio = window.devicePixelRatio || 1;
    const width = parent?.clientWidth || window.innerWidth;
    // const height = parent?.clientHeight || window.innerHeight;
    canvasEl.width = width * devicePixelRatio;
    // canvasEl.height = height * devicePixelRatio;
    canvasEl.style.width = `${width}px`;
    // canvasEl.style.height = `${height}px`;
    this.ctx = canvasEl.getContext('2d');
    this.ctx.scale(devicePixelRatio, devicePixelRatio);
    this.ctx.strokeStyle = '#222';
    this.ctx.lineCap = 'round';
    this.ctx.lineJoin = 'round';
    this.ctx.lineWidth = 4;
    this.isDrawing = false;

    canvasEl.addEventListener('mousedown', (e) => {
      this.isDrawing = true;
      this.lastX = e.offsetX;
      this.lastY = e.offsetY;
    });
  
    canvasEl.addEventListener('mousemove', (e) => {
      if (!this.isDrawing) return;
      this.draw(e.offsetX, e.offsetY);
      this.lastX = e.offsetX;
      this.lastY = e.offsetY;
    });
  
    canvasEl.addEventListener('mouseup', () => this.isDrawing = false);
    canvasEl.addEventListener('mouseleave', () => this.isDrawing = false);
  
    // Touch Events
    canvasEl.addEventListener('touchstart', (e: TouchEvent) => {
      e.preventDefault();
      this.isDrawing = true;
      const rect = canvasEl.getBoundingClientRect();
      const touch = e.touches[0];
      this.lastX = (touch.clientX - rect.left);
      this.lastY = (touch.clientY - rect.top);
    });
  
    canvasEl.addEventListener('touchmove', (e: TouchEvent) => {
      if (!this.isDrawing) return;
      e.preventDefault();
      const rect = canvasEl.getBoundingClientRect();
      const touch = e.touches[0];
      const x = (touch.clientX - rect.left);
      const y = (touch.clientY - rect.top);
      this.draw(x, y);
      this.lastX = x;
      this.lastY = y;
    });
  
    canvasEl.addEventListener('touchend', () => this.isDrawing = false);
    canvasEl.addEventListener('touchcancel', () => this.isDrawing = false);
    const element: HTMLElement = document.getElementById('auto_trigger') as HTMLElement;
    element?.click();
  }

  draw(x: number, y: number) {
    this.ctx.beginPath();
    this.ctx.moveTo(this.lastX, this.lastY);
    this.ctx.lineTo(x, y);
    this.ctx.stroke();
  }


  clearCanvas() {
    this.ctx.clearRect(0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.height);
    this.errorMessageDisplayed = false;
  }

  async saveSignature() {
    if (this.isCanvasEmpty()) {
      this.errorMessageDisplayed = true; 
     return;
    }
    const a = document.createElement('a');
    a.href = await this.canvas.nativeElement.toDataURL();
    this.urlData = a.href;
    await this.FederalForm.patchValue({ 'kyc_signature': this.urlData });
    document.getElementById("myModal").click();
  }
  isCanvasEmpty() {
    const canvasData = this.ctx.getImageData(0, 0, this.canvas.nativeElement.width, this.canvas.nativeElement.height).data;
    for (let i = 0; i < canvasData.length; i += 4) {
      if (canvasData[i + 3] !== 0) {
        return false; 
      }
    }
    return true; 
  }
  showModel() {
    setTimeout(() => {
      this.init();
      this.errorMessageDisplayed = false;
    }, 500);
  }

  changeStatus(check, Id, Qus) {
    this.FedrlQuestion.forEach(element => {
      if (Qus == 'QusOut') {
        if (check == 'Yes') {
          this.FederalForm.get(Id).setValue('1');
          this.FederalForm.get('sub_federal_question_2').setValue('');
          this.hideQus = false;
          this.Errqus = "Question is required";
          element['checked'] = 1;
        }
        else {
          this.FederalForm.get(Id).setValue('0');
          this.hideQus = true;
          this.Errqus = '';
          element['checked'] = 2;
          element['checked2'] = 0;
        }
      }
      if (Qus == 'QusIn') {
        this.Errqus = '';
        if (check == 'Yes') {
          this.FederalForm.get(Id).setValue('1');
          element['checked2'] = 1;
        }
        else {
          this.FederalForm.get(Id).setValue('0');
          element['checked2'] = 2;
        }
      }
    });
  }

  saveFederal() {
    if (this.FederalForm.invalid || this.Errqus !== '') {
      this.submitted2 = true;
      return;
    }
    else {
      if(this.FederalForm.value.federal_question_1 == '0'){
        this.FederalForm.get('sub_federal_question_2').setValue('')
      }
      this.data.saveFederal(this.FederalForm.value).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.router.navigate(['/account-message'])
            .then(() => {
              location.reload();
            });
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  getUserDetail() {
    this.User.getSingleUsers().subscribe(res => {
      // To KYC Status
      this.kyc_status = res.data1[0].kyc_verify_status;
      switch (this.kyc_status) {
        case 0: this.kyc_status = "Unverified"; this.kyc_color = "rgb(236 41 52)"; break;
        case 1: this.kyc_status = "Verified"; this.kyc_color = "#2aab5b"; break;
        case 2: this.kyc_status = "Verification Pending"; this.kyc_color = "#e6b125"; break;
        case 3: this.kyc_status = "Reject"; this.kyc_color = "rgb(236 41 52)"; break;
        case 4: this.kyc_status = "Cancel"; this.kyc_color = "rgb(236 41 52)"; break;
      }
      if (this.kyc_status == 'Verified') {
        this.getFederalPdf();
      }
      else {
        this.countDownInterval = setInterval(() => {
          this.counter = this.counter - 1;
            if (this.counter === 0) {
              this.counter = 5;
              clearTimeout(this.countDownInterval);
              this.router.navigate(['/kyc/kyc']);
            }
        }, 1000);
      }
    })
  }

  getFederalPdf() {
    this.data.getFederalPdf({ iduser: this.iduser, idaccount: this.idaccount }).subscribe(res => {
      if (res.status == 200) {
        this.FederalPDF = res.data[0];
        this.FederalForm.patchValue({
          federal_question_1: this.FederalPDF.answer1,
          sub_federal_question_2: this.FederalPDF.answer2,
          fullname: this.FederalPDF.fullname,
          kyc_signature: this.FederalPDF.signature,
        });
        this.urlData = this.FederalPDF.signature;
        if (this.FederalPDF.answer1 == '1') {
          // this.checked1==1;
          this.FederalForm.get('federal_question_1').setValue('1');
          this.hideQus = false;
        } else if(this.FederalPDF.answer1 == '0'){
          // this.checked1==0;
          this.FederalForm.get('federal_question_1').setValue('0')
          this.hideQus = true;
        } else{
          this.FederalForm.get('federal_question_1').setValue('')
          this.hideQus = true;
        }



        if (this.FederalPDF.answer2 == '1') {
          this.FederalForm.get('sub_federal_question_2').setValue('1')
          // this.checked2==1;
        } else if(this.FederalPDF.answer2 == '0') {
          this.FederalForm.get('sub_federal_question_2').setValue('0')
          // this.checked2==0;
        } else {
          this.FederalForm.get('sub_federal_question_2').setValue('')
        }
        if (this.FederalPDF.federal_status !== 3 && this.FederalPDF.federal_status !== 4) {
          if (res.data.length > 0) {
            this.router.navigate(['/federal/federal-details'])
              .then(() => {
                location.reload();
              });
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    });
  }
  // ngOnDestroy(){
  //   this.esignmodal.nativeElement.click();
  // }
}
