import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { GroupService } from '../group.service';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
declare var $: any;
@Component({
  selector: 'app-create-group',
  templateUrl: './create-group.component.html',
  styleUrls: ['./create-group.component.css']
})
export class CreateGroupComponent implements OnInit {
  @ViewChild('createmodal') createmodal: ElementRef;
  userInfo: any;
  headingdata: any;
  formfield: any;
  public creategroupForm: FormGroup;
  formfield1: any;
  formfield2: any;
  dropdownSettings: IDropdownSettings = {};
  statusList: any = [];
  submitted = false;
  submitted1 = false;
  public mappingForm: FormGroup;
  dropdownSettings1: IDropdownSettings = {};
  enableDropdowns: boolean = false;
  slaveDropdown: boolean = false;
  userlist: any = [];
  responseMessage: any;
  cgid: any;
  cgID: string;
  Group: any;
  masterID: any;
  Slaves: any = [];
  errMessage: any;
  groupSaved: boolean = false;
  mappingValue: any;
  SlaveIDs: any = [];
  modifiedMaster: any;
  masterUser: any;
  masterUser2: any;
  masterIDAcc: any;
  slavelist: any = [];
  notReset: boolean = false;
  slaveWithUser: any = [];
  masterUserNameAppended: boolean = false;
  valueSlave: any = [];
  previousmaster: any;
  deselectedItem: boolean = false;
  masterDeselected: boolean = false;
  slaveCalled: boolean = false;

  constructor(public data: GroupService, public fb: FormBuilder, public userService: UsermanagementService, public router: Router, private route: ActivatedRoute) { }

  ngOnInit(): void {

    this.getUserList();
    // creatgroup
    this.data.get_group().subscribe((result) => {
      this.userInfo = result[1].creatgroup;
      this.headingdata = this.userInfo[0].heading;
      this.formfield1 = this.userInfo[0].subheading2;
      this.formfield2 = this.userInfo[0].subheading3;
    });

    this.creategroupForm = this.fb.group({
      group_name: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m), Validators.maxLength(255)]],
      description: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m), Validators.minLength(10)]],
    });
    this.mappingForm = this.fb.group({
      masteraccount: ['', [Validators.required]],
      slaveaccount: ['', [Validators.required]]
    })
    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'idField',
      textField: 'combinedData',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
    this.dropdownSettings = {
      singleSelection: false,
      idField: 'idField2',
      textField: 'combinedData',
      itemsShowLimit: 2,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
    this.route.paramMap.subscribe((params: ParamMap) => {
      this.cgID = params.get('id');
      if (this.cgID) {
        this.groupSaved = true;
      }
      this.data.getCustomerGroup(this.cgID).subscribe(res => {
        this.Group = res.data[0];
        this.creategroupForm.patchValue({
          group_name: this.Group.group_name,
          description: this.Group.description,
        });
        this.masterID = this.Group.master_idaccount;
        if (!this.masterID) {
          this.modifiedMaster = '';
          this.enableDropdowns = true;
          this.slaveDropdown = false;
          this.getUserList();
        }
        else if (this.masterID) {
          this.modifiedMaster = 100000000 + this.masterID;
          this.enableDropdowns = true;
          this.slaveDropdown = true;
          this.getUserList();
        }
        this.data.getSlaveAccount(this.masterID, this.cgID).subscribe(res => {
          let Slave = res.data;
          Slave.forEach((slave) => {
            if (slave) {
              this.Slaves.push(100000000 + slave.slave_idaccount);
            }
          })
          // this.mappingForm.patchValue({
          //   masteraccount: this.modifiedMaster ? [this.modifiedMaster] : null,
          //   slaveaccount: this.Slaves? this.Slaves : null
          // });        
        }, err => {
          this.responseMessage = "Something Went Wrong!";
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        })

      }, err => {
        this.responseMessage = "Something Went Wrong!";
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      })
    });
  }


  getUserList(): void {
    this.userService.getUsers("main").subscribe(
      (res: any) => {
        // this.userlist = res.data[0].filter(item => item.type === 2 && item.is_deleted === 0 && item.san !== null && item.first_name !== null && item.last_name !== null);
        // this.slavelist = res.data[0].filter(item => item.type === 2 && item.is_deleted === 0 && item.san !== null && item.first_name !== null && item.last_name !== null);
        const seenAccounts = new Set();
        this.userlist = res.data[0].filter(item => item.type === 2 && item.is_deleted === 0 && item.san && item.first_name && item.last_name && !seenAccounts.has(item.idaccount) && seenAccounts.add(item.idaccount));
        seenAccounts.clear();
        this.slavelist = res.data[0].filter(item => item.type === 2 && item.is_deleted === 0 && item.san && item.first_name && item.last_name && !seenAccounts.has(item.idaccount) && seenAccounts.add(item.idaccount));
        if (this.masterID && !this.notReset && !this.masterDeselected) {
          let samplemasterUser = this.slavelist.filter(item => item.idaccount === this.masterID);
          this.masterUser = samplemasterUser[0].iduser;
          this.slavelist = this.slavelist.filter(item => item.idaccount !== this.masterID);
        }
        this.userlist.forEach(item => {
          if (!this.cgID) {
            item.idField = { idaccount: item.idaccount, iduser: item.iduser };
          }
          else {
            item.idField = `${item.san} - ${item.first_name} ${item.last_name}`;
          }
          item.combinedData = `${item.san} - ${item.first_name} ${item.last_name}`;
        });
        this.slavelist.forEach(item => {
          if (!this.cgID) {
            item.idField2 = { idaccount: item.idaccount, iduser: item.iduser };
          }
          else {
            item.idField2 = `${item.san} - ${item.first_name} ${item.last_name}`;
          }
          item.combinedData = `${item.san} - ${item.first_name} ${item.last_name}`;
        });
        if (!this.notReset && this.cgID) {
          if (!this.masterUserNameAppended) {
            let masterUser = this.userlist.find(user => user.idaccount === this.masterID);
            let masterUserName = `${masterUser.first_name} ${masterUser.last_name}`;
            this.modifiedMaster += ` - ${masterUserName}`;
            this.masterUserNameAppended = true;
          }
          this.slaveWithUser = [];
          this.slavelist.forEach(slave => {
            this.Slaves.forEach(slaves => {
              if (slave.san === slaves) {
                this.slaveWithUser.push(`${slave.san} - ${slave.first_name} ${slave.last_name}`)
              }
            })
          })
          if (!this.masterDeselected) {
            this.mappingForm.patchValue({
              masteraccount: this.modifiedMaster ? [this.modifiedMaster] : null,
              slaveaccount: this.slaveWithUser ? this.slaveWithUser : null
            });
          }
          else {
            let slavesRemained = this.mappingForm.value.slaveaccount
            this.mappingForm.patchValue({
              masteraccount: null,
              slaveaccount: slavesRemained ? slavesRemained : null
            });
          }
        }
      },
      (error: any) => {
        console.error('Error fetching user list:', error);
      }
    );
  }
  saveGroup() {
    this.submitted = true;
    if (this.creategroupForm.invalid) {
      return;
    } else {
      if (!this.cgID && !this.cgid) {
        this.data.saveCustomerGroup(this.creategroupForm.value).subscribe(res => {
          if (res.status == 200) {
            this.cgid = res.data;
            this.responseMessage = res.message;
            this.enableDropdowns = true;
            this.groupSaved = true;
            this.getUserList();
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000)
          } else if (res.status == 400) {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000)
          }
        })
      }
      else {
        let payLoad = {
          data: this.creategroupForm.value,
          cgID: this.cgID ? this.cgID : this.cgid
        }
        this.data.updateCustomerGroup(payLoad).subscribe((res) => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.enableDropdowns = true;
            setTimeout(() => {
              this.responseMessage = ""
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = ""
            }, 5000);
          }
        })
      }
    }
  }

  resetGroup() {
    this.submitted = false;
    let formvalue = this.mappingForm.value;
    this.creategroupForm.reset();
    if ((formvalue.masteraccount === null || formvalue.masteraccount == '') && (formvalue.slaveaccount === null || formvalue.slaveaccount == '')) {
      this.enableDropdowns = false;
      this.slaveDropdown = false;
    }
  }

  saveMapping() {
    this.submitted1 = true;
    if (this.mappingForm.invalid) {
      return;
    }
    else {
      if (!this.cgID) {
        const masterIds = this.mappingForm.value.masteraccount.map(item => item.idField.idaccount);
        const slaveIds = this.mappingForm.value.slaveaccount.map(item => item.idField2.idaccount);
        const masterUser = this.mappingForm.value.masteraccount.map(item => item.idField.iduser);
        const slaveUser = this.mappingForm.value.slaveaccount.map(item => item.idField2.iduser);
        const mappingValue = {
          masteraccount: masterIds,
          slaveaccount: slaveIds,
          cgid: this.cgid,
          master_iduser: masterUser,
          slave_iduser: slaveUser
        };
        this.data.saveCustomerMapping(mappingValue).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.submitted = false;
            this.submitted1 = false;
            this.mappingForm.reset();
            this.enableDropdowns = false;
            this.slaveDropdown = false;
            this.ngOnInit();
            const compModal = document.getElementById('createmodal');
            $(compModal).modal({ backdrop: 'static', keyboard: false });
            $(compModal).modal('show');
            setTimeout(() => {
              this.responseMessage = "";
              // this.router.navigate(['/group']).then(() => {
              //   location.reload();
              // });
            }, 5000)
          }
        })
      }
      else {
        if (this.modifiedMaster == this.mappingForm.value.masteraccount) {
          const slaveAccounts = this.mappingForm.value.slaveaccount;
          let slaveIds = [];
          let slaveUsers = [];
          let slaveIDAcc = [];
          if (Array.isArray(slaveAccounts) && slaveAccounts.length > 0) {
            if (typeof slaveAccounts[0] === 'object' && 'idField2' in slaveAccounts[0]) {
              slaveIds = slaveAccounts.map(item => item.idField2.idField ? item.idField2.idField : item.idField2);
            } else {
              slaveIds = slaveAccounts;
            }
          }
          slaveIds.forEach(slave => {
            const user = this.userlist.find(element => `${element.san} - ${element.first_name} ${element.last_name}` == slave);
            if (user) {
              slaveUsers.push(user.iduser);
              slaveIDAcc.push(user.idaccount);
            }
          });
          // slaveIds.forEach(slave => {
          //   const user = this.userlist.find(element => `${element.san} - ${element.first_name} ${element.last_name}` == slave);
          //   if (user) {
          //       slaveIDAcc.push(user.idaccount);
          //   }
          // });
          this.mappingValue = {
            masterId: this.masterID,
            masterIdUser: this.masterUser,
            slaveIds: slaveIDAcc,
            slaveUsers: slaveUsers,
            cgID: this.cgID,
          };
        }
        else {
          const slaveAccounts = this.mappingForm.value.slaveaccount;
          let slaveIds = [];
          let slaveUsers = [];
          let slaveIDAcc = [];
          if (Array.isArray(slaveAccounts) && slaveAccounts.length > 0) {
            if (typeof slaveAccounts[0] === 'object' && 'idField2' in slaveAccounts[0]) {
              slaveIds = slaveAccounts.map(item => item.idField2.idField ? item.idField2.idField : item.idField2);
            } else {
              slaveIds = slaveAccounts;
            }
          }
          slaveIds.forEach(slave => {
            const user = this.userlist.find(element => `${element.san} - ${element.first_name} ${element.last_name}` == slave);
            if (user) {
              slaveUsers.push(user.iduser);
              slaveIDAcc.push(user.idaccount);
            }
          });
          // slaveIds.forEach(slave => {
          //   const user = this.userlist.find(element => `${element.san} - ${element.first_name} ${element.last_name}` == slave);
          //   if (user) {
          //       slaveIDAcc.push(user.idaccount);
          //   }
          // });
          this.mappingValue = {
            masterId: this.masterIDAcc,
            slaveIds: slaveIDAcc,
            slaveUsers: slaveUsers,
            masterIdUser: this.masterUser2,
            cgID: this.cgID,
          };
        }
        this.data.updateCustomerMapping(this.mappingValue).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigate(['/group']).then(() => {
                location.reload();
              });
            }, 5000)
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000)
          }
        });
      }
    }
  }
  resetMapping() {
    this.submitted1 = false;
    this.notReset = true;
    this.slaveDropdown = false;
    let groupform = this.creategroupForm.value;
    if ((groupform.group_name === null || groupform.group_name == '') && groupform.description === null || groupform.description == '') {
      this.enableDropdowns = false;
    }
    this.mappingForm.reset();
    this.valueSlave = [];
    this.getUserList();
  }
  toggleSlaveDropdown(value: any, isDeselect: boolean): void {
    this.slaveDropdown = !!value;
    if (!isDeselect) {
      if (this.cgID) {
        let masterUsers = this.userlist.filter(item => `${item.san} - ${item.first_name} ${item.last_name}` == value.idField);
        this.masterUser2 = masterUsers[0].iduser;
        this.masterIDAcc = masterUsers[0].idaccount;
        this.slavelist = this.slavelist.filter(item => `${item.san} - ${item.first_name} ${item.last_name}` !== value.idField);
        this.slaveWithUser = this.slaveWithUser.filter((slave) => slave !== value.idField)
        // let extraMaster = this.mappingForm.value.slaveaccount.filter((slave)=> slave.idField2 !== value.idField);
        if (!this.notReset) {
          if (this.mappingForm.value.slaveaccount.length < this.slaveWithUser.length) {
            if (!this.deselectedItem) {
              this.mappingForm.patchValue({
                slaveaccount: this.slaveWithUser ? this.slaveWithUser : null
              })
            }
          }
          else {
            if (this.mappingForm.value.slaveaccount !== '') {
              this.slaveWithUser = this.mappingForm.value.slaveaccount.filter((slave) => typeof slave === 'string' ? slave !== value.idField : (slave.idField2.idField ? slave.idField2.idField : slave.idField2) !== value.idField)
              this.mappingForm.patchValue({
                slaveaccount: this.slaveWithUser ? this.slaveWithUser : null
              })
            }
          }
        }
        else {
          this.mappingForm.value.slaveaccount = '';
          // this.valueSlave = this.valueSlave.filter((slave)=> slave.idField2 !== value.idField)
          this.valueSlave = this.valueSlave.filter((slave) => {
            // Check if idField2 is an object and has an idField property
            if (slave.idField2 && typeof slave.idField2 === 'object' && 'idField' in slave.idField2) {
              return slave.idField2.idField !== value.idField;
            } else {
              // Check if idField2 itself is not equal to value.idField
              return slave.idField2 !== value.idField;
            }
          });
          this.mappingForm.patchValue({
            slaveaccount: this.valueSlave ? this.valueSlave : null
          })
        }
        if (this.previousmaster !== value.idField) {
          const previousMasterId = typeof this.previousmaster === 'string' ? this.previousmaster : this.previousmaster.idField;
          // let changedMaster2 = this.userlist.filter(item => `${item.san} - ${item.first_name} ${item.last_name}` === this.previousmaster ? this.previousmaster : this.previousmaster.idField )
          let changedMaster2 = this.userlist.find(item => {
            return item.idField === previousMasterId || item.idField === this.previousmaster;
          });
          if (changedMaster2) {
            changedMaster2.idField2 = this.previousmaster;
            this.slavelist = this.slavelist.filter(slaveItem => slaveItem.idField !== changedMaster2.idField);
          }
          this.slavelist.push(changedMaster2);
          this.slavelist.sort((a, b) => {
            return a.san - b.san;
          })
          this.getSlaves(this.mappingForm.value.masteraccount)
        }
      } else {
        this.slavelist = this.slavelist.filter(item => item.idaccount !== value.idField.idaccount);
        let slaveAccount = this.mappingForm.value.slaveaccount.filter(item => item.idField2.idaccount !== value.idField.idaccount);
        if (this.mappingForm.value.slaveaccount !== null) {
          this.mappingForm.patchValue({
            slaveaccount: slaveAccount
          })
        }
        if (this.previousmaster !== value.idField.idaccount) {
          let changedMaster = this.userlist.filter(item => item.idaccount === this.previousmaster);
          this.slavelist.push(changedMaster[0])
          this.slavelist.sort((a, b) => {
            return a.san - b.san;
          })
          this.getSlaves(this.mappingForm.value.masteraccount)
        }
      }
    }
  }
  onDeselectMaster(deselectedMaster: any) {
    this.masterDeselected = true;
    if (this.cgID) {
      let deselectedUser = this.userlist.find(item => item.idField === deselectedMaster.idField)
      this.slavelist.push(deselectedUser)
      this.slavelist.sort((a, b) => {
        return a.san - b.san
      })
      const index = this.slaveWithUser.findIndex(item => item.idField === deselectedMaster.idField);
      if (index > -1) {
        this.slaveWithUser.splice(index, 1);
      }
      this.getUserList();
    }
    else {
      let userDeselected = this.userlist.find(item => item.idaccount === deselectedMaster.idField.idaccount)
      this.slavelist.push(userDeselected);
      this.getUserList();
    }
  }
  masterClicked() {
    if (this.cgID && !this.masterDeselected) {
      if (this.mappingForm.value.masteraccount !== '' || this.mappingForm.value.slaveaccount !== '') {
        this.previousmaster = Array.isArray(this.mappingForm.value.masteraccount) && this.mappingForm.value.masteraccount.length > 0 ? this.mappingForm.value.masteraccount[0] : null;
      }
    }
  }
  onDeSelect(value: any) {
    this.deselectedItem = true;
  }
  onDeSelectAll(value: any) {
    this.slaveWithUser = [];
  }
  navigateToGroup() {
    this.router.navigate(['/group']).then(() => {
      location.reload();
    });
  }
  onSelect(value: any) {
    this.getSlaves(value);
  }
  onSelectAll(values: any) {
    this.valueSlave = [];
    values.forEach(value => this.getSlaves(value));
  }
  getSlaves(value) {
    this.slaveCalled = true
    if (this.notReset) {
      this.valueSlave.push(value);
      if (this.mappingForm.value.masteraccount === value) {
        this.valueSlave = this.valueSlave.filter(item => item.idField2 !== value.idField);
      }
    }
    if (!this.cgID) {
      this.previousmaster = this.mappingForm.value.masteraccount[0].idField.idaccount;
    }
    else {
      this.previousmaster = this.mappingForm.value.masteraccount[0] !== undefined ? this.mappingForm.value.masteraccount[0] : this.mappingForm.value.masteraccount;
    }
  }

  ModalClose() {
    this.cgid = ''
    this.groupSaved = false;
    const modal = document.getElementById('createmodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
  }

  ngOnDestroy() {
    this.createmodal.nativeElement.click();
  }
}
