import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { GroupService } from '../group.service';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;
@Component({
  selector: 'app-group',
  templateUrl: './group.component.html',
  styleUrls: ['./group.component.css']
})
export class GroupComponent implements OnInit {
  @ViewChild('deleteCampaign') deleteCampaign: ElementRef;
  @ViewChild('viewmodal') viewmodal: ElementRef;
  show_filter: boolean = false;
  userInfo: any;
  public filterUser: FormGroup;
  Groups: any = [];
  responseMessage: any;
  errMessage: any;
  GroupID: any;
  Slaves: any;
  masterID: any;
  public submitted: boolean = false;
  userlist: any = [];
  FilterMaster: any = [];
  cgID: any;
  userList: any;
  SlavesLength: any;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  selectedItem: any = [];
  name_with_san: any = [];
  userss: any = [];
  constructor(public data: GroupService, public fb: FormBuilder, public userService: UsermanagementService) { }

  ngOnInit(): void {
    this.data.get_group().subscribe((result) => {
      this.userInfo = result[0].grouheaders;
    });
    this.filterUser = this.fb.group({
      from_date: [''],
      to_date: [''],
      groupid: [''],
      groupname: [''],
      master: [''],
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'idaccount',
      textField: 'Name_san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    // this.userService.getUsers("main").subscribe((res: any) => {
    //     this.userlist = res.data[0].filter(item => item.type === 2 && item.san !== null && item.first_name !== null && item.last_name !== null);
    //     this.userlist.sort((a, b) => {
    //       return a.san - b.san;
    //     });
    //     this.userlist.forEach(element => {
    //       const fullName = `${element.first_name} ${element.last_name}`
    //       this.name_with_san.push({ idaccount: element.idaccount, Name_san: element.san + ' - ' +  fullName});
    //     })
    //     this.userss = this.name_with_san
    //   },(error: any) => {
    //     console.error('Error fetching user list:', error);
    //   });

    // this.data.getCustomerGroups().subscribe((res) => {
    //   this.FilterMaster = []
    //   this.filterUser.get('master').setValue('');
    //   if (res.status == 200) {
    //     $('#basic-datatablessgroup').DataTable().clear();
    //     $('#basic-datatablessgroup').DataTable().destroy();
    //     this.Groups = res.data;
    //     $.getScript('./assets/table.js');
    //   }
    // });
    this.getUserList();
    this.getdetails();
  }

  getdetails(){
    this.data.getCustomerGroups().subscribe((res) => {
      this.FilterMaster = []
      this.filterUser.get('master').setValue('');
      if (res.status == 200) {
        $('#basic-datatablessgroup').DataTable().clear();
        $('#basic-datatablessgroup').DataTable().destroy();
        this.Groups = res.data;
        $.getScript('./assets/table.js');
      }
    });
  }

  getUserList(){
    this.userService.getidAccount().subscribe((res: any) => {
      this.userlist = res.data.filter(item => item.type === 2 && item.san !== null && item.first_name !== null && item.last_name !== null);
      this.userlist.sort((a, b) => {
        return a.san - b.san;
      });
      this.userlist.forEach(element => {
        const fullName = `${element.first_name} ${element.last_name}`
        this.name_with_san.push({ idaccount: element.idaccount, Name_san: element.san + ' - ' +  fullName});
      })
      this.userss = this.name_with_san
    },(error: any) => {
      console.error('Error fetching user list:', error);
    });
  }

  onItemSelect(item: any) {
    console.log(item);
  }

  // getUserList(): void {
  //   this.userService.getUsers("main").subscribe(
  //     (res: any) => {
  //       this.userList = [];
  //       this.userList = res.data[0].filter(item => item.type === 2 && item.idaccount !== null);
  //       this.Groups.forEach((group) => {
  //         this.userList.forEach((user) => {
  //           if (user.idaccount) {
  //             let san = 100000000 + user.idaccount
  //             if (user.idaccount == group.master_idaccount) {
  //               let master_account = san + '-' + user.first_name + '' + user.last_name;
  //               let idaccount = user.idaccount
  //               let payload = {
  //                 idaccount: idaccount,
  //                 masteraccount: master_account
  //               }
  //               let exists = this.FilterMaster.some(item => item.idaccount === idaccount);
  //               if (!exists) {
  //                 this.FilterMaster.push(payload);
  //               }
  //             }
  //           }
  //         })
  //       })
  //     },
  //     (error: any) => {
  //       console.error('Error fetching user list:', error);
  //     }
  //   );
  // }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }
  openview(masterid, cgID) {
    this.masterID = masterid;
    this.data.getSlaveAccount(this.masterID, cgID).subscribe(res => {
      $('#basic-datatables2').DataTable().clear();
      $('#basic-datatables2').DataTable().destroy();
      this.Slaves = res.data;
      this.SlavesLength = res.data.length;
      this.Slaves.forEach((slave) => {
        if (slave) {
          this.userlist.forEach(element => {
            if (element.idaccount == slave.slave_idaccount) {
              slave.slave_firstname = element.first_name;
              slave.slave_lastname = element.last_name;
            }
          });
        }
      })

      $.getScript('./assets/table.js');
    })
  }
  openDeleteModel(groupid, cgid) {
    this.GroupID = groupid;
    this.cgID = cgid;
  }

  deleteCustomerGroup() {
    let payload = {
      groupid: this.GroupID,
      cgID: this.cgID
    }
    this.data.deleteCustomerGroup(payload).subscribe(res => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          this.ngOnInit()
          this.deleteCampaign.nativeElement.click();
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000)
    })

  }

  Submitfilter() {
    this.submitted = true;
    if(this.filterUser.invalid){
      return;
    }
    else {
      this.data.applyGroupFilter(this.filterUser.value).subscribe(res => {
        if (res.status == 200) {
          this.Groups = [];
          this.Groups = res.data;
          $('#basic-datatablessgroup').DataTable().clear();
          $('#basic-datatablessgroup').DataTable().destroy();
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset();
    Object.keys(this.filterUser.controls).forEach(key => {
      this.filterUser.get(key).setValue('');
    });
    // this.ngOnInit();
    this.name_with_san = [];
    this.selectedItem = [];
    this.getUserList();
    this.getdetails();
  }
  messageshow() {
    const from_date = this.filterUser.get('from_date').value;
    const to_date = this.filterUser.get('to_date').value;
    const currentDate = new Date();
  
    // Reset previous errors
    this.filterUser.get('from_date').setErrors(null);
    this.filterUser.get('to_date').setErrors(null);
  
    if (!to_date && !from_date) {
      // Both dates are not selected, no need to set any errors
      return;
    }
  
    if (to_date) {
      if (new Date(to_date) > currentDate) {
        this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
        return;
      }
    }
  
    if (from_date) {
      if (new Date(from_date) > currentDate) {
        this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
        return;
      }
    }
  
    if (!from_date && to_date) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please Select From Date' });
      return;
    }
  
    if (from_date && !to_date) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please Select To Date' });
      return;
    }
  
    if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    }
  }

  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
  }
  ngOnDestroy() {
    this.viewmodal.nativeElement.click();
    this.deleteCampaign.nativeElement.click();
  }
}
