import { Component, OnInit } from '@angular/core';
import { InboundService } from '../inbound.service';
import { HttpClient } from '@angular/common/http';
declare var $: any;
@Component({
  selector: 'app-bulkaction-log',
  templateUrl: './bulkaction-log.component.html',
  styleUrls: ['./bulkaction-log.component.css']
})
export class BulkactionLogComponent implements OnInit {

  responseMessage: any = "";
  errMessage: any = "";
  bulkdata: any = []; 
  isLoggedin: any;
  type:any;
  idaccount:any;
  constructor(public data: InboundService, private _http: HttpClient) { }

  ngOnInit(): void {
    this.isLoggedin = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.type = this.isLoggedin.type;
    this.idaccount = this.isLoggedin.idaccount;
    this.actionLog()
  }

  actionLog() {
    this.data.getDIDActionLog().subscribe(res => {
      console.log(res);
      
      $('#basic-datatables13').DataTable().clear();
      $('#basic-datatables13').DataTable().destroy();
      if (res.status == 200) {          
          this.bulkdata = res.data          
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
      $.getScript('./assets/table.js');
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  downloadCSVFile(data: any) {
    if (data) {
      const a = document.createElement('a');
      a.href = data;
      a.download = data.split('_').pop();
      a.click();
    }
  }
  
  extractFileName(url: string): string {
    return url.substring(url.lastIndexOf('/') + 1);
  }

}