import { Component, ElementRef, ViewChild, ViewEncapsulation } from '@angular/core';
import { InboundService } from '../inbound.service'
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { BehaviorSubject } from 'rxjs';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { trigger, transition, style, animate, state } from '@angular/animations';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { ConnectionsService } from 'src/app/connections/connections.service';
import { formatDate } from '@angular/common';
import { IDropdownSettings } from 'ng-multiselect-dropdown';

declare var $: any;

@Component({
	selector: 'app-did',
	templateUrl: './did.component.html',
	styleUrls: ['./did.component.css'],
	animations: [
		trigger('widthGrow', [
			state(
				'closed',
				style({
					border: "0px",
					height: "0px",
					margin: "0px 0px 20px 0px",
				})
			),
			state(
				'open',
				style({

					margin: "0px 0px 20px 0px",
				})
			),
			transition('* => *', animate(500)),
		]),
		trigger('widthGrow1', [
			state(
				'closed',
				style({
					border: "0px",
					height: "0px",
					// margin: "0px 0px 20px 0px",
				})
			),
			state(
				'open',
				style({

					// margin: "0px 0px 20px 0px",
				})
			),
			transition('* => *', animate(500)),
		]),
	],
})

export class DidComponent extends AppComponentClass<any, any> {
	@ViewChild('closeModal') private closeModal: ElementRef;
	@ViewChild('uploadd') uploadd: ElementRef;
	@ViewChild('connectionmodal') connectionmodal: ElementRef;
	@ViewChild('enabledisablesms') enabledisablesms: ElementRef;
	@ViewChild('didActionLog') didActionLog: ElementRef;
    @ViewChild('modalcampaign') modalcampaign: ElementRef;
	// p : number = 1;
	filtre: string;
	searchText = { count: 0 };
	page: number = 1;
	field: any;
	header: any;
	count: number = 0;
	tableSize: number = 10;
	tableSizes: any = [10, 20, 50, 100];
	filterTerm: string
	responseMessage: any = "";
	errMessage: any = "";
	dids: any = [];
	didCount: any = [];
	tab1$ = new BehaviorSubject<any>("");
	tab1 = this.tab1$.asObservable();
	tab1Value = "";
	tab2$ = new BehaviorSubject<any>("");
	tab2 = this.tab1$.asObservable();
	tab2Value = "";
	tab3$ = new BehaviorSubject<any>("");
	tab3 = this.tab1$.asObservable();
	tab3Value = "";
	connectionLists: any;
	iddid: any;
	connectionKey$ = new BehaviorSubject<any>("");
	connection: any = this.connectionKey$.asObservable();
	connectionValue = "";
	inboundKey$ = new BehaviorSubject<any>("");
	inbound = this.inboundKey$.asObservable();
	inboundValue = "";
	outboundKey$ = new BehaviorSubject("");
	outbound = this.outboundKey$.asObservable();
	outboundValue = "";
	campaigns: any = [];
	campaign = "";
	didBackup: any = [];
	did: string = "";
	selectedDid: any = [];
	isChecked: Boolean = false;
	isSelected: Boolean = false;
	users: any = [];
	brandId: any = null;
	isCampaign: boolean = false;
	camp: any;
	uploadDid: FormGroup;
	file: File | any;
	fileView: any;
	upload: any;
	public submitted: boolean = false;
	isAdmin: boolean = false;
	username: any;
	filterForm: FormGroup;
	monthNameList: any = [];
	/* didList: any = []; */
	public show: boolean = false;
	EXCEL_TYPE = 'application/csv';
	EXCEL_EXTENSION = '.csv';
	isButton: any;
	iselectAll: boolean;
	selectedDIDCount: any;
	exportButton: any;
	tooltp: String;
	state: any;
	state1: any;
	isClass: any;
	campaignCount: any;
	isEnable: Boolean = false;
	searchFilter: FormGroup;
	Paste_number: boolean = true;
	selectedOption: string = '';
	sortField: string = '';
	sortOrder: string = 'asc';
	// DidProviders: any = [
	// 	{ name: "thinQ", value: "ThinQ" },
	// 	{ name: "inteliQ", value: "InteliQ" },
	// 	{ name: "teleapi", value: "Teleapi" },
	// 	{ name: "Peerless", value: "Peerless" },
	// 	{ name: "coreTel", value: "CoreTel" }
	// ]
	// NumberType: any = [
	// 	{ type: "Local Number", value: "NN" },
	// 	{ type: "Toll-Free Number", value: "TF" }
	// ]
	CurrentUConn: any = []
	currid: any = []

	dIFlag: boolean = false
	dIFBtn: string = "Import DID"
	stateList: any = [];
	didDisInfo: any;
	didNotDisInfo: any;
	getDID: any;
	conn_key: any;
	AllKeyData: any;
	disButton: any;
	didDisInfolen: any;
	didNotDisInfolen: any;
	responseDIDMessage: Boolean;
	slctDIDTotal: any;
	toDate: any;
	lastDay: Date;
	getVal: any;
	sms_provider: any;
	filterIconVal: any;
	filterIconVal1: any;
	iduser: any;
	campaignCountDID: any;
	mess: any;
	campaignsAdmin: any = [];
	listedDid: any = [];
	sInfo: string;
	allUserDIDLen: any;
	shwoingEntry: number;
	connectionList: any[] = [];
	connectiondatas: any[] = [];
	SIZE: number = 10;
	tableSizeN: number;
	dismiss: boolean = false;
	increse_stop: boolean = false;
	Oldcampaign: any;
	OLDcampid: any;
	btnType: string = '';
	subUsers: any = [];
	Ciduser: any;
	btnTypeHide: boolean;
	campDid: any = [];
	public submittedMF: boolean = false;
	connectionDrop: boolean = false;
	user_id: any;
	connectiondata: any = [];
	account_id: any;
	tryingStep: any;
	sinchStatus: any;
	idaccount: any;
	roughData: any = [];
	findDID: any = [];
	notFindDID: any = [];
	campaignsUser: any = [];
	type: any;
	did2: any;
	did1: any;
	savedPage: number = 1;
	did_import: any = [];
	did_provider: any = [];
	did_provider1: any = [];
	NumberType: any = [];
	isConnectionDisabled: boolean = false;
	labeldidProvider: any;
	labeldidProvider1: any;
	myvalue: string;
	user: any;
	rates: any[];
	showrates: any;
	PortPin: any;
	providertype: any;
	isDropdownOpen = false;
	selectedConnection: string;
	dropdownSettings: IDropdownSettings = {};
	dropdownSettingsportout: IDropdownSettings = {};
	dropdownSettingscamp: IDropdownSettings = {};
	dropdownSettingsconection: IDropdownSettings = {};
	dropdownSettingsuser: IDropdownSettings = {};
	dropdownSettingsconnection: IDropdownSettings = {};
	closeDropdownSelection = true;
	manageDID = [];
	dropdownList = [];
	dropdownSettingscustomer: IDropdownSettings = {};
	dropdownSettingsautoRenew: IDropdownSettings = {};
	dropdownSettingscampaign: IDropdownSettings = {};
	dropdownSettingscamp1: IDropdownSettings = {};
	dropdownSettingsSMSType: IDropdownSettings = {};
	dropdownSettingsType: IDropdownSettings = {};
	dropdownSettingsConnection: IDropdownSettings = {};
	dropdownSettingscampaig: IDropdownSettings = {};
	SMSType: any = [];
	autoRenewOptions: any = [];
	dropdownData: any;
	MatchingDID: string[];
	NonDuplicateDID: string[];
	NonDuplicateDIDFLag: boolean = false;
	matchingDIDCsvBlob: Blob | null = null;
    actionList: any = [];
	selectedAction: any = null;
	connectionValues: any = [];
	campaignsdata: any = [];
	selectedCampaignId: string = "";
	selectedCampaign: any[] = [];
 

	constructor(
		public data: InboundService,
		public router: Router,
		public fb: FormBuilder,
		private userService: UsermanagementService,
		public ConnectionService: ConnectionsService,
		private campService: CapmaignserviceService) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		this.isEnable = true;
		this.state = 'closed';
		this.state1 = 'closed';
		this.selectThisMonth();
		this.slctDIDTotal = '';
		this.exportButton = 'Export All DID';
		this.iselectAll = false;
		this.selectedDIDCount = '';
		this.didDisInfo = '';
		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.username = user.username;
		this.user_id = user.iduser;
		this.account_id = user.idaccount;
		this.disButton = '';
		this.didCount = '';
		this.filterIconVal = "1";
		if (user.type == '1') {
			this.isAdmin = true;
			this.isClass = "col-md-4";
		}
		else {
			this.isAdmin = false;
			this.isClass = "col-md-8";
		}

		this.filterIconVal1 = "1";
		if (user.type == '1') {
			this.isAdmin = true;
			this.isClass = "col-md-4";
		}
		else {
			this.isAdmin = false;
			this.isClass = "col-md-8";
		}


		this.searchFilter = this.fb.group({
			numbers: new FormControl(''),
			selectAction: new FormControl(''),
			connVal: new FormControl(''),
			uploadfile: new FormControl('')
		})

		this.filterForm = this.fb.group({
			fromDate: new FormControl(''),
			toDate: new FormControl(''),
			selectedUser: new FormControl(''),
			didnumber: new FormControl('', [Validators.minLength(3), Validators.maxLength(10)]),
			didnpa: new FormControl('', [Validators.minLength(3)]),
			selectState: new FormControl(''),
			connectionKey: new FormControl(''),
			campaignKey: new FormControl(''),
			selectSMS: new FormControl(''),
			autoRenew: new FormControl(''),
			portout: new FormControl(''),
		}
		);

		this.uploadDid = this.fb.group({
			upload: new FormControl('', [Validators.required]),
			user: new FormControl('', [Validators.required]),
			campaign: new FormControl(''),
			connection: new FormControl(''),
			inbound: new FormControl(''),
			outbound: new FormControl(''),
			provider: new FormControl('', [Validators.required]),
			sms_provider: new FormControl(''),
			idtariff: new FormControl(''),
			numbertype: new FormControl('', [Validators.required]),
			description: new FormControl(''),
			Rates: new FormControl('')
		});

		this.data.getdid().subscribe((result) => {
			this.header = result[0].headers_details;
			if (!this.isAdmin) {
				this.header = this.header.filter(header => header !== 'SAN' && header !== 'Port-out PIN');
			}
		});
		//To  get All DIDs
		this.getDIDs(this.filterForm.value);

		this.getnumbertype();

		// this.campService.onGetCampaign().subscribe(response => {
		// 	if (response.status == 200) {
		// 		this.campaigns = response.data;
		// 	}
		// 	else {
		// 		this.errMessage = response.message;
		// 		setTimeout(() => {
		// 			this.errMessage = "";
		// 		}, 5000);
		// 	}
		// });
		// this.optionVal();
		this.getConnection();

		this.userService.getidAccount().subscribe(res => {
			if (res.status == 200) {
				this.users = res.data;
				this.users = res.data.map(item => ({
					userdata: `${item.iduser}-${item.idaccount}`,
					users: `${item.san} - ${item.first_name} ${item.last_name}`
				}));
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Something went wrong with get Users!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.data.getStates().subscribe(res => {
			this.stateList = res.data;

			// ------new code to get statelist-----
			this.stateList = res.data.map(item => ({
				idaccount: `${item.id}-${item.abbrev}`,
				newArray: `${item.name}  ${(item.abbrev)}`
			}));
		});


		this.data.getDisconnectedDid().subscribe((res) => {
			this.getDID = res.data;
			if (this.getDID.length > 1) {
				this.isButton = '1';
			} else {
				this.isButton = '2';
			}
		})

		this.mess = '';


		this.ConnectionService.getConnection().subscribe(response => {
			if (response.status == 200) {
				if (response.data.length > 0) {
					this.connectionList = response.data;

					// ----------------new change------------------
					this.connectiondatas = response.data.map(item => ({
						conne: item.connection_key,
						connectiondatas: item.name
					}));

				}
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Something went wrong with get Connection!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});



		this.campService.GetCampaignsList().subscribe(result => {
			if (result.status == 200) {
				// if (result.data.length > 0) {
				// 	this.campaignsUser = result.data.filter((item) => item.provisioning_status == 3 && item.status == 0 && item.deleted == 0);
				// }

				if (result.data.length > 0) {
					this.campaignsUser = result.data.filter((item) =>
						item.provisioning_status == 3 &&
						item.status == 0 &&
						item.deleted == 0
					);

					// Preparing data for the dropdown
					this.dropdownData = this.campaignsUser.map((item) => ({
						id: item.campaign_key,  // Replace with actual ID field
						name: item.campaign_key  // Replace with actual campaign key field
					}));
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		this.campService.GetCampaignsListForAdmin("main").subscribe(result => {
			if (result.status == 200) {
				// ------------camp dropdown---------------------------
				this.campaignsAdmin = result.data;
				this.campaignsAdmin = result.data.filter((item: any) => item.campaign_key !== null).map((item: any, index: number) => ({
					campid: index,
					campaignsadmin: item.campaign_key
				}));
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
		this.getAllUsers();
		$('#didActionLog').on('show.bs.modal', function (event) {
			$(this).find('.nav button:first').tab('show');
		})

		if (user.type == '1') {
			this.data.GetPortPIn().subscribe((res) => {
				if (res.status == 201) {
					this.PortPin = res.data;
					// -----------port out pin new code ------------
					this.PortPin = res.data.map(item => ({
						portout: item.portoutpin,
						portpin: `${item.san} - ${item.portoutpin}`
					}));
				} else {
					this.errMessage = res.message
					setTimeout(() => {
						this.errMessage = ''

					}, 5000);
				}
			})
		}
		this.dropdownSettingsconnection = {
			singleSelection: true,
			idField: 'currid',
			textField: 'CurrentUConn',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};
		this.dropdownSettingscustomer = {
			singleSelection: true,
			idField: 'iduser',
			textField: 'displayName',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: true
		};

		// ------------------- filter-----------------
		this.dropdownSettingsconection = {
			singleSelection: true,
			idField: 'conne',
			textField: 'connectiondatas',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettingscamp = {
			singleSelection: true,
			idField: 'campid',
			textField: 'campaignsadmin',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};
		this.dropdownSettingscamp1 = {
			singleSelection: true,
			idField: 'id',
			textField: 'name',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettings = {
			singleSelection: true,
			idField: 'idaccount',
			textField: 'newArray',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettingsuser = {
			singleSelection: true,
			idField: 'userdata',
			textField: 'users',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettingsportout = {
			singleSelection: true,
			idField: 'portout',
			textField: 'portpin',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettingsSMSType = {
			singleSelection: true,
			idField: 'id',
			textField: 'name',
			allowSearchFilter: false,
			closeDropDownOnSelection: true
		};
		this.SMSType = [
			{ id: 'enabled', name: 'SMS Enabled' },
			{ id: 'disabled', name: 'SMS Not Enabled' }
		];

		this.dropdownSettingsautoRenew = {
			singleSelection: true,
			idField: 'id',
			textField: 'name',
			allowSearchFilter: false,
			closeDropDownOnSelection: true
		};
		this.autoRenewOptions = [
			{ id: '', name: 'ALL' },
			{ id: 'Enabled', name: 'Enable' },
			{ id: 'Disabled', name: 'Disable' }
		];


		this.dropdownSettingsType = {
			singleSelection: true,
			idField: 'id',
			textField: 'itemName',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: true
		};

		this.actionList = [
			{ id: 'search', itemName: 'Search DID' },
			{ id: 'connection', itemName: 'Remove Connection' },
			{ id: 'set_connection', itemName: 'Update Connection' },
			{ id: 'auto_enable', itemName: 'Auto Renewal Enable' },
			{ id: 'auto_disable', itemName: 'Auto Renewal Disable' },
			{ id: 'disconnect', itemName: 'Disconnect DID' }
		];

		this.dropdownSettingsConnection = {
			singleSelection: true,
			idField: 'conn_key',
			textField: 'connectiondata',
			allowSearchFilter: true,
			closeDropDownOnSelection: true
		};

		this.dropdownSettingscampaig = {
			singleSelection: true,
			idField: 'id',
			textField: 'itemName',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: true
		};

	}

	getnumbertype() {
		if (this.user || this.camp) {
			this.data.get_didImport().subscribe((res) => {
				this.did_import = res;
				// this.labeldidProvider = this.did_import[0].heading;
				// this.labeldidProvider1 = this.did_import[1].heading1;
				this.did_provider = this.did_import[0].subheading1.options;
				this.did_provider1 = this.did_import[0].subheading2.options;
				this.NumberType = this.did_import[1].subheading1.options;
			})
		}
	}

	// To Get DIDs
	getDIDs(formData) {
		this.dids = [];
		this.data.onGetBuyDids(formData).subscribe(
			(res) => {
				$('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
				this.SIZE = 10;
				if (res.status == 200) {
					this.dids = res.data;
					this.didBackup = this.dids;
					this.data.exportDID(this.filterForm.value).subscribe((ress) => {
						if (ress.status == 200) {
							this.allUserDIDLen = ress.data.length;
							this.onTableSizeChange(10);
							// this.didCount = '(of ' + ress.data.length + ' total)';
							this.didCount = '(of ' + this.allUserDIDLen + ' total)';
							$.getScript('./assets/managetable.js');
						}
					});
				} else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = '';
					}, 5000);
				}
			},
			(err) => {
				this.responseMessage = 'Something went wrong with get DIDs!';
				setTimeout(() => {
					this.responseMessage = '';
				}, 5000);
			}
		);
	}

	changeState(val): void {
		this.state == 'closed' ? (this.state = 'open') : (this.state = 'closed');
		val == '1' ? (this.filterIconVal = '2') : (this.filterIconVal = '1');
	}
	changeStatebulk(val): void {
		this.state1 == 'closed' ? (this.state1 = 'open') : (this.state1 = 'closed');
		val == '1' ? (this.filterIconVal1 = '2') : (this.filterIconVal1 = '1');
	}

	/**
	 * To load the selected customer's campaign
	 */
	/* onCampaign(e) {
		this.camp = [];
		this.showrates = [];
		this.uploadDid.get('connection').setValue('');
		this.uploadDid.get('numbertype').setValue('');
		this.uploadDid.get('provider').setValue('');
		this.user = e.target.value.split('-')[0];
		let iduser = e.target.value.split('-')[0];
		this.getnumbertype();
		this.data.getCampaigns(iduser).subscribe(result => {
			if (result.status == 200) {
				if (result.data.length > 0) {
					this.camp = result.data;
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	} */
	onCampaign(event) {
		this.camp = [];
		this.showrates = [];
		this.uploadDid.get('connection').setValue('');
		this.uploadDid.get('numbertype').setValue('');
		this.uploadDid.get('provider').setValue('');
		this.user = event.iduser;
		let iduser = event.iduser;
		this.getnumbertype();
		/* let payLoad = {
			iduser: iduser.split('-')[0],
			idaccount: iduser.split('-')[1]
		}		
		this.data.getCampaigns(JSON.stringify(payLoad)).subscribe(result => {
			if (result.status == 200) {
				if (result.data.length > 0) {
					this.camp = result.data;
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}); */
	}
	onSmsProvider(event) {
		this.camp = [];
		let iduser = event.iduser;
		let idtariff = event.iduser.split('-')[2];
		let idtariffval: any = '';

		if (idtariff == '0') {
			idtariffval = 0;
		} else if (idtariff == '') {
			idtariffval = -1;
		} else {
			idtariffval = idtariff;
		}
		this.uploadDid.patchValue({
			sms_provider: '',
			idtariff: idtariffval
		});
	}
	onItemSelect(event) {
		this.CurrentUConn = [];
		let iduser = event.iduser.split('-')[0];
		this.data.GetConnections(iduser).subscribe(result => {
			if (result.status == 200) {
				if (result.data.length > 0) {
					this.CurrentUConn = result.data;
					this.CurrentUConn = result.data.map(item => ({
						currid: item.connection_key,
						CurrentUConn: `${item.connection}`
					}));

				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	/**
	 * To get the selected customer's sms_provider
	 */
	/* onSmsProvider(e) {
		this.camp = [];
		let iduser = e.target.value.split('-')[0];
		let idtariff = e.target.value.split('-')[2];
		let idtariffval: any = '';

		if (idtariff == '0') {
			idtariffval = 0;
		} else if (idtariff == '') {
			idtariffval = -1;
		} else {
			idtariffval = idtariff;
		}
		this.uploadDid.patchValue({
			sms_provider: '',
			idtariff: idtariffval
		});
	} */


	/**
	 * To load the selected customer's connection
	 */
	// onConnection(e:any ,type:any) {
	// 	this.CurrentUConn = [];
	// 	if(type == 'user' || type == 'subuser'){
	// 		this.Ciduser = e.target.value.split('-')[0];
	// 	}
	// 	if(type == 'reset'){
	// 		this.Ciduser = e.split('-')[0];
	// 	}

	// 	this.data.GetConnections(this.Ciduser).subscribe(result => {
	// 		if (result.status == 200) {
	// 			if (result.data.length > 0) {
	// 				this.CurrentUConn = result.data;
	// 				this.uploadDid.get("connection").setValue('');
	// 			}
	// 		}
	// 		else {
	// 			this.errMessage = result.message;
	// 			setTimeout(() => {
	// 				this.errMessage = "";
	// 			}, 5000);
	// 		}
	// 	});
	// }

	onConnection(e) {
		this.CurrentUConn = [];
		let iduser = e.target.value.split('-')[0];
		this.data.GetConnections(iduser).subscribe(result => {
			if (result.status == 200) {
				if (result.data.length > 0) {
					this.CurrentUConn = result.data;

					// --------------------new changes-------------------------------------------
					// this.CurrentUConn = result.data.map(item => ({
					// 	currid: item.connection_key,
					// 	CurrentUConn: `${item.connection}`,
					// }));

				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	multiSubmit() {
		this.submitted = true;
		// this.iselectAll = false;
		if (!this.searchFilter.value.selectAction || this.searchFilter.value.selectAction == 'no') {
			this.errMessage = 'Please select Action Type';
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
			return true;
		}
		else {
			let payload = {
				num: this.searchFilter.value.numbers ? this.searchFilter.value.numbers.split(/[ ,\t\n]+/) : '',
				option: this.searchFilter.value.selectAction[0]?.id,
				file: this.file != undefined ? this.file : '',
				inboundValue: this.inboundValue,
				outboundValue: this.outboundValue,
				connectionValue: this.connectionValue
			}
			// console.log("payload", payload);
			
			// this.selectedDIDCount = 0;
			// this.selectedDid = []
			this.data.onGetMultiSearch(payload).subscribe(res => {
				$('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
				if (res.status == 200) {
					this.dids = res.data;
					this.manageDID = res.data
					this.roughData = res.roughDID;
					this.findDID = res.findDID;
					this.notFindDID = res.notFindDID;
					this.selectedDid = [];
					this.selectedDIDCount = 0;
					this.iselectAll = false;
					this.onTableSizeChange(this.tableSize);
					this.didCount = '(of ' + res.data.length + ' total)';
					$.getScript('./assets/managetable.js');
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.searchFilter.reset();
					// this.clearFilter(1);
					this.resetBulk();
					this.roughData = res.roughDID;
					this.findDID = res.findDID;
					this.notFindDID = res.notFindDID;

					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.resetBulk();
				// this.clearFilter(1);
				this.errMessage = "Something went wrong with Bulk Option or number formate is not correct!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000)
			});
		}

	}

	resetBulk(){
		this.submitted = false;
		this.searchFilter.reset();
		this.getDIDs(this.filterForm.value);
	}
	

	// getAllUsers() {
	// 	this.userService.getAllUsers().subscribe(res => {
	// 		if (res.status == 201) {
	// 			//this.subUsers = res.data[1];
	// 			this.subUsers = res.data;
	// 			console.log("Users ::",this.subUsers);				
	// 			this.subUsers.forEach((ele: any) => {
	// 				ele.customer_data = JSON.parse(ele.customer_data);
	// 			});
	// 		}
	// 		else {
	// 			this.errMessage = res.message;
	// 			setTimeout(() => {
	// 				this.errMessage = "";
	// 			}, 5000);
	// 		}
	// 	});
	// }

	/* getAllUsers() {
		this.userService.getAllUsers().subscribe(res => {
			if (res.status === 201) {
				const customers = res.customers;
				const subCustomers = res.subCustomers;

				// Map sub-customers to their corresponding customers
				customers.forEach(customer => {
					customer.subCustomers = subCustomers.filter(sub => sub.idaccount === customer.idaccount);
				});

				this.subUsers = customers;
				console.log("Mapped Sub-Users:", this.subUsers);
			} else {
				this.errMessage = res.message;
				setTimeout(() => { this.errMessage = ""; }, 5000);
			}
		});
	} */
	getAllUsers() {
		this.userService.getAllUsers().subscribe(res => {
			if (res.status === 201) {
				this.userService.getidAccount().subscribe(res => {
					this.dropdownList = res.data.map(item => ({
						iduser: `${item.iduser}-${item.idaccount}-${item.idtariff}`,
						displayName: `${item.first_name} ${item.last_name} - (${item.san})`,
						idaccount: item.idaccount,
						idtariff: item.idtariff,
					}));
				}, err => {
				});
			} else {
				this.errMessage = res.message;
				setTimeout(() => { this.errMessage = ""; }, 5000);
			}
		});
	}

	setConnectionFromBulk(e) {
		
		if (e.id == "set_connection") {
			this.connectionDrop = true;
			this.connectiondata = [];
			let idaccount : any = this.isAdmin ? this.account_id : ''
			this.data.GetConnectionsByAccount(idaccount).subscribe(result => {
				if (result.status == 200) {
					if (result.data.length > 0) {
						// this.connectiondata = result.data;
						this.connectiondata = result.data.map(item => ({
							conn_key: item.connection_key,
							connectiondata: `${item.connection}`
						}));
					}
				}
				else {
					this.errMessage = result.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
		else {
			this.connectionDrop = false;
		}
	}
	
	getInOutKeyForSetConnection(e) {
		// console.log("Connection Key Event ::", e);
		// this.conn_key = e.target.value;
		this.conn_key = e.conn_key;
		// console.log("Connection Key 231232454::", this.conn_key);
		this.disButton = '';
		this.data.onGetAllKeyByConnKey(this.conn_key).subscribe(res => {
			if (res.status == 200) {
				this.AllKeyData = res.data[0];
				this.inboundValue = this.AllKeyData.inbound_key;
				this.outboundValue = this.AllKeyData.outbound_key;
				this.connectionValue = this.AllKeyData.connection_key;
				// console.log("All Key Data ::", this.AllKeyData);
				// console.log("Inbound Key ::", this.inboundValue);
				// console.log("Outbound Key ::", this.outboundValue);
				// console.log("this.connectionValue ::", this.connectionValue);
				
				
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				this.disButton = '';
			}
		}, err => {
			this.responseMessage = "Something went wrong with get connection key for set connection!";
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});

	}
	/**
	 * To reset the import DID form
	 */
	rSetForm(): void {
		this.submitted = false;
		this.uploadDid.reset();
		this.dIFBtn = "Import DID"
		$('#exampleModal1').hide();
		this.closeModal.nativeElement.click();
		this.uploadDid.get('connection').enable();
		this.myvalue = '';
		this.CurrentUConn = [];
		this.NumberType = [];
		this.did_provider = [];
		this.did_provider1 = [];
		this.uploadDid.get('provider').setValue('');
		this.uploadDid.get('numbertype').setValue('');
		this.uploadDid.get('connection').setValue('');
		this.uploadDid.get('user').setValue('');
		this.uploadDid.get('Rates').setValue('');
		this.NonDuplicateDIDFLag = false
		this.MatchingDID = [];
		this.matchingDIDCsvBlob = null;
 
	}

	reSet() {
		this.submitted = false;
		this.dIFBtn = "Import DID"
		this.uploadDid.get('connection').enable();
		this.myvalue = '';
		this.manageDID = [];
		this.CurrentUConn = []
		this.NumberType = [];
		this.did_provider = [];
		this.did_provider1 = [];
		this.uploadDid.get('numbertype').setValue('');
		this.uploadDid.get('provider').setValue('');
		this.NonDuplicateDIDFLag = false
		this.MatchingDID = []; 
		this.matchingDIDCsvBlob = null;

	}

	/**
	 * Get All Connection List
	 */
	getConnection() {
		this.data.listConnections().subscribe(res => {
			this.connectionLists = res.data;
			this.connectionKey$.next(this.connectionLists[0]);
			this.inboundKey$.next(this.connectionLists[1]);
			this.outboundKey$.next(this.connectionLists[2]);
		});
	}

	/* onSelectAll(e) {
		if (e.target.checked) {
			this.listedDid.forEach((ele: any) => {
				if (!ele.isChecked) {
					ele.isChecked = true;
					this.selectedDid.push(ele);
				};
			});
		}
		else {
			this.selectedDid = this.selectedDid.filter((ele: any) => !this.listedDid.includes(ele));
			this.listedDid.forEach((ele: any) => {
				if (ele.isChecked) {
					ele.isChecked = false;
				};
			});
		}
		if (this.listedDid.length > 0 && this.listedDid.every((ele: any) => ele.isChecked)) {
			this.iselectAll = true;
		}
		else {
			this.iselectAll = false;
		}

		if (this.selectedDid.length > 0) {
			this.isSelected = true;
		}
		else {
			this.isSelected = false;
		}
		this.selectedDIDCount = this.selectedDid.filter((ele: any) => ele.isChecked).length;
	} */
	onSelectAll(e) {
		if (e.target.checked) {
			this.listedDid.forEach((ele: any) => {
				if (!ele.isChecked) {
					ele.isChecked = true;
					this.selectedDid.push(ele);
				};
			});
		}
		else {
			this.selectedDid = this.selectedDid.filter((ele: any) => !this.listedDid.includes(ele));
			this.listedDid.forEach((ele: any) => {
				if (ele.isChecked) {
					ele.isChecked = false;
				};
			});
		}
		if (this.listedDid.length > 0 && this.listedDid.every((ele: any) => ele.isChecked)) {
			this.iselectAll = true;
		}
		else {
			this.iselectAll = false;
		}

		if (this.selectedDid.length > 0) {
			this.isSelected = true;
		}
		else {
			this.isSelected = false;
		}
		this.selectedDIDCount = this.selectedDid.filter((ele: any) => ele.isChecked).length;
	}


	onSelectDid(e, did, idx) {
		if (e.target.checked) {
			this.selectedDid.push(did);
		}
		else {
			this.selectedDid.forEach((value, index) => {
				if (value.iddid == did.iddid)
					this.selectedDid.splice(index, 1);
			});
		}
		if (this.listedDid.length > 0 && this.listedDid.every((ele: any) => ele.isChecked)) {
			this.iselectAll = true;
		}
		else {
			this.iselectAll = false;
		}

		if (this.selectedDid.length > 0) {
			this.isSelected = true;
		}
		else {
			this.isSelected = false;
		}
		this.selectedDIDCount = this.selectedDid.length;
	}


	onConnectionKeyNew(e:any) {
		this.conn_key = e.conne;
		// this.conn_key = e.target.value;
		this.disButton = '';
		this.data.onGetAllKeyByConnKey(this.conn_key).subscribe(res => {
			if (res.status == 200) {
				this.AllKeyData = res.data[0];
				this.inboundValue = this.AllKeyData.inbound_key;
				this.outboundValue = this.AllKeyData.outbound_key;
				this.connectionValue = this.AllKeyData.connection_key;
				// console.log("Selected Connection Key Data ::",this.AllKeyData);
				
				// this.connectionValues = [selectedConn];
				this.disButton = 'true';

			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				this.disButton = '';
			}

		}, err => {
			this.responseMessage = "Something went wrong with Connection Key!";
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});

	}
	getInOutKeys(e) {
		this.conn_key = e.target.value;
		// this.conn_key = e.currid;
		this.disButton = '';
		this.data.onGetAllKeyByConnKey(this.conn_key).subscribe(res => {
			if (res.status == 200) {
				this.AllKeyData = res.data[0];
				this.inboundValue = this.AllKeyData.inbound_key;
				this.outboundValue = this.AllKeyData.outbound_key;
				this.connectionValue = this.AllKeyData.connection_key;
				this.uploadDid.patchValue({
					inbound: this.inboundValue,
					outbound: this.outboundValue,
				});
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				this.disButton = '';
			}
		}, err => {
			this.responseMessage = "Something went wrong with Inbound and Outbound Key!";
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});

	}
	onConnectionKey(e) {
		this.inboundValue = "";
		this.outboundValue = "";
		this.connectionValue = "";
		this.connectionValue = e.target.value;
	}
	onInboundKey(e) {
		this.inboundValue = "";
		this.outboundValue = "";
		this.connectionValue = "";
		this.inboundValue = e.target.value;
	}
	onOutboundKey(e) {
		this.inboundValue = "";
		this.outboundValue = "";
		this.connectionValue = "";
		this.outboundValue = e.target.value;
	}

	onSelectCampagin(e) {
		this.inboundValue = "";
		this.outboundValue = "";
		this.connectionValue = "";
		this.iduser = this.iduser;
		this.idaccount = this.isAdmin ? this.idaccount :'';
		this.campaign = e.id;
		this.data.getCampaignDIDCount(this.campaign, this.idaccount).subscribe((camp) => {
			if (camp.status == 200) {
				this.isEnable = false;

				if (camp.data[0].did_count >= camp.data[0].did_limit) {
					this.isEnable = true;
					this.mess = `You can enable only ${camp.data[0].did_limit} DID's in this Campaign.`

				} else if (camp.data[0].did_limit <= 0) {
					this.isEnable = true;
					this.mess = 'You can not Enable any DID with this campaign.';
				} else {
					this.isEnable = false;
					this.mess = '';
				}
				if (this.campaign == this.OLDcampid) {
					this.btnTypeHide = false
					this.isEnable = true;
				}
				else {
					this.btnTypeHide = true
					this.isEnable = false;
				}
			} else {
				this.isEnable = false;
				this.mess = '';
			}
		});
		let campInfo = this.campaigns.find(el => el.campaign_key === this.campaign);
		if (campInfo.campaign_key == this.OLDcampid) {
			if (this.type == 1)
				this.tryingStep = '1'
			if (this.type == 2)
				this.tryingStep = '2'
			if (this.type == 3)
				this.tryingStep = '3'
			/* if(campInfo.upstreamCnpId.toLowerCase() == "sinch"){
				if(this.type == 1)
					this.tryingStep = '1'
				if(this.type == 2)
					this.tryingStep = '2'
				if(this.type == 3)
					this.tryingStep = '3'
			}
			else{
				if(this.type == 1)
					this.tryingStep = '1'
				if(this.type == 2)
					this.tryingStep = '2'
				if(this.type == 3)
					this.tryingStep = '3'
			} */
		}
		else {
			this.tryingStep = '1'
			/* if(campInfo.upstreamCnpId.toLowerCase() == "sinch"){
				this.tryingStep = '1'
			}
			else{
				this.tryingStep = '1'
			} */
		}

	}
	getCampRegDID() {
		this.campDid = [];
		let idaccount = this.isAdmin ? this.idaccount : ''
		this.data.getCampaignDID(this.campaign, idaccount).subscribe((res) => {
			if (res.status == 200) {
				this.campDid = res.data;
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	onUpdateConnection() {
		let updateDID: any = {};
		updateDID = {
			iddid: this.iddid, connection_key: this.connectionValues[0]?.conne, did: this.did,
			inboundKey: this.inboundValue, outboundKey: this.outboundValue, campaign: this.campaign
		};
		this.data.updateDID(updateDID).subscribe(res => {

			if (res.status == 201) {
				this.iselectAll = false;
				this.selectedDIDCount = '';
				this.selectedDid = [];
				this.responseMessage = res.message;
				window.location.reload();
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, error => {
			this.responseMessage = "Something went wrong with update connection!";
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}
	enableDIDSMS() {
		let updateDID: any = {};
		/* updateDID = {
			iddid: this.iddid, DID: this.did, CampaignId: this.campaign, iduser: this.iduser, idaccount: this.idaccount, sinchStatus: this.sinchStatus
		}; */
		updateDID = {
			iddid: this.iddid, DID: this.did, CampaignId: this.campaign, sinchStatus: this.sinchStatus
		};
		
		// let disableDID: any = {};
		// disableDID ={
		// 	iddid: this.iddid, DID: this.did, CampaignId: this.OLDcampid, iduser: this.iduser
		// };		
		if (this.OLDcampid !== '') {
			if (confirm("This DID will be Disable from previous campaign after that it will be Enable with new campaign!")) {
				if (confirm("Are you sure you want to Disable SMS service from old Campaign and Enable with New Campaign!")) {
					console.log("enable did=>");
					this.data.disableSMS(this.did).subscribe(disres => {
						if (disres.status == 200 || disres.status == 201 || disres.status == 202) {
							this.enableSMS(updateDID);
						}
						else {
							this.errMessage = disres.message;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
					})
				}
			}
		}
		else {
			if (confirm("Are you sure you want to Enable SMS service from this Campaign!")) {
				this.enableSMS(updateDID);
			}
		}
	}
	enableSMS(updateDID) {
		this.data.enableSMS(updateDID).subscribe(res => {
			this.iselectAll = false;
			this.selectedDIDCount = '';
			this.selectedDid = [];
			if (res.status == 200) {
				this.getDIDs(this.filterForm.value);
				this.responseMessage = res.message;
				//window.location.reload();
				this.btnType = 'disable';
				this.isEnable = true;
				this.btnTypeHide = false;
				this.OLDcampid = updateDID.CampaignId;
				setTimeout(() => {
					this.responseMessage = "";
					document.getElementById("campaignModalClose").click();
				}, 5000);
			}
			else {
				//this.btnType='enable';
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, error => {
			//this.btnType='enable';
			this.errMessage = "Something went wrong with Enable SMS!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	reEnableDIDSMS() {
		let updateDID: any = {};
		/* updateDID = {
			iddid: this.iddid, DID: this.did, CampaignId: this.campaign, iduser: this.iduser, idaccount: this.idaccount, sinchStatus: this.sinchStatus
		}; */
		updateDID = {
			iddid: this.iddid, DID: this.did, CampaignId: this.campaign, sinchStatus: this.sinchStatus
		};
		this.reProvisioningSMS(updateDID);

	}
	reProvisioningSMS(updateDID) {
		this.data.reProvisioningSMS(updateDID).subscribe(res => {
			this.iselectAll = false;
			this.selectedDIDCount = '';
			this.selectedDid = [];
			if (res.status == 200) {
				this.getDIDs(this.filterForm.value);
				this.responseMessage = res.message;
				//window.location.reload();
				this.btnType = 'disable';
				this.isEnable = true;
				this.btnTypeHide = false;
				this.OLDcampid = updateDID.CampaignId;
				setTimeout(() => {
					this.responseMessage = "";
					document.getElementById("campaignModalClose").click();
				}, 5000);
			}
			else {
				//this.btnType='enable';
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, error => {
			//this.btnType='enable';
			this.errMessage = "Something went wrong with Re-Provisioning!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}


	disableDIDSMS() {
		if (confirm("Are you sure you want to Disable SMS service from this Campaign!")) {
			this.data.disableSMS(this.did).subscribe(disres => {
				if (disres.status == 200 || disres.status == 201 || disres.status == 202) {
					this.getDIDs(this.filterForm.value);
					this.responseMessage = disres.message;
					this.campaign = "";
					this.isEnable = true;
					setTimeout(() => {
						this.responseMessage = "";
						document.getElementById("campaignModalClose").click();
					}, 5000);
				}
				else {
					this.btnType = 'disable';
					this.errMessage = disres.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, error => {
				this.btnType = 'disable';
				this.errMessage = "Something went wrong with Disable SMS service!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	onUpdateSelectedDids() {
		let updateDID: any = [];
		this.selectedDid.forEach((el: any) => {
			updateDID.push({
				iddid: el.iddid, connection_key: this.connectionValues[0]?.conne, did: el.did,
				inboundKey: this.inboundValue, outboundKey: this.outboundValue, campaign: this.campaign
			});
		});
		this.data.updateSelectedDids(updateDID).subscribe(res => {
			if (res.status == 201) {
				this.iselectAll = false;
				this.selectedDIDCount = '';
				this.selectedDid = [];
				this.responseMessage = res.message;
				window.location.reload();
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, error => {
			this.responseMessage = "Something went wrong with update selected DIDs!";
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}


	disconnectDids() {
		if (confirm("Please Confirm You Want To Disconnect Selected DID's")) {
			if (confirm("Are you sure you want to Disconnect Selected DID's")) {
				this.data.disconnectSelectedDids(this.selectedDid).subscribe(res => {
					$('#basic-datatables').DataTable().clear();
					$('#basic-datatables').DataTable().destroy();
					this.iselectAll = false;
					this.selectedDid = [];
					this.selectedDIDCount = '';
					if (res.status == 201) {
						this.selectedDid = [];
						this.selectedDIDCount = '';

						this.didDisInfo = res.disdata;
						this.didDisInfolen = res.disdata.length;
						this.didNotDisInfo = res.notdisDID;
						this.didNotDisInfolen = res.notdisDID.length;
						this.slctDIDTotal = this.didDisInfolen + this.didNotDisInfolen;
						this.responseDIDMessage = true;
						setTimeout(() => {
							this.responseDIDMessage = false;
						}, 5000);
						this.responseMessage = res.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					} else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
					this.ngOnInit();
					$('#basic-datatables').DataTable().clear();
					$('#basic-datatables').DataTable().destroy();
					this.data.onGetBuyDids(this.filterForm.value).subscribe(res => {
						this.didCount = '';
						this.iselectAll = false;
						this.selectedDid = [];
						this.selectedDIDCount = '';
						if (res.status == 200) {
							//this.exportButton='Export Filtered DID';
							this.dids = res.data;
							$.getScript('./assets/managetable.js');
							this.data.exportDID(this.filterForm.value).subscribe(res => {
								if (res.status == 200) {
									this.didCount = '(of ' + res.data.length + ' total)';
								}
							});
						}
						else {
							this.errMessage = res.message;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}

					}, err => {
						this.errMessage = "Something went wrong with get DIDs!";
						setTimeout(() => {
							this.errMessage = "";
						}, 5000)
					});
				}, err => {
					this.responseMessage = "Something went wrong with Disconnect Selected DIDs!";
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				});;
			}
			else {
				return
			}
		}
		else {
			return
		}
	}

	disconnectDid(did, iduser, idaccount) {
		if (confirm("Please Confirm You Want To Disconnect Selected Dids")) {
			let iduser1 :any = this.isAdmin ? iduser : ''
			let idaccount1 : any = this.isAdmin ? idaccount: ''
			this.data.onDisconnectDid(did, iduser1, idaccount1).subscribe(res => {
				this.iselectAll = false;
				this.selectedDid = [];
				this.selectedDIDCount = '';
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.ngOnInit();
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.responseMessage = "Something went wrong with Disconnect DID!";
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			});
		}
		else {
			return
		}
	}

	onSMSStatus(iddid, type, sinchStatus) {

		this.type = type;
		//this.tryingStep = this.type == 1 ? '1' : '2';
		this.sinchStatus = sinchStatus;
		this.did = "";
		this.iddid = iddid;
		this.campaign = "";
		let did = this.dids.find(el => el.iddid == iddid);
		this.campaign = (did.camp_registry !== '' && did.camp_registry !== null && did.camp_registry !== undefined && did.camp_registry !== 'null' && did.camp_registry !== 'undefined') ? did.camp_registry : '';

		this.OLDcampid = this.campaign;
		this.did = did.did;
		this.iduser = did.iduser;
		this.idaccount = did.account_id - 100000000;
		this.OLDcampid = this.campaign;
		if (this.OLDcampid !== '') {
			this.btnType = 'disable';
			this.isEnable = true;
		}
		else {
			this.btnType = 'enable';
			this.isEnable = true;
		}
		let payLoad = this.isAdmin ? {
			iduser: this.isAdmin ? this.iduser : '',
			idaccount: this.isAdmin ? this.idaccount : ''
		} : {}
		this.data.getCampaigns(JSON.stringify(payLoad)).subscribe(result => {
			if (result.status == 200) {
				if (result.data.length > 0) {
					this.campaigns = result.data;

					// let campInfo = this.campaigns.find(el => el.campaign_key === this.campaign);
					// if (this.type == 1)
					// 	this.tryingStep = '1'
					// if (this.type == 2)
					// 	this.tryingStep = '2'
					// if (this.type == 3)
					// 	this.tryingStep = '3'

					this.campaignsdata = this.campaigns.map(item => ({
          id: item.campaign_key,
          itemName: `${item.campaign_key} - [${item.did_count}/${item.did_limit}]`,
        }));

        // Preselect if OLDcampid exists
        if (this.OLDcampid) {
          const campInfo = this.campaigns.find(el => el.campaign_key === this.OLDcampid);
          if (campInfo) {
            this.selectedCampaign = [{
              id: campInfo.campaign_key,
              itemName: `${campInfo.campaign_key} - [${campInfo.did_count}/${campInfo.did_limit}]`
            }];
            this.campaign = campInfo.campaign_key; // keep key as string
          }
        } else {
          this.selectedCampaign = [];
          this.campaign = '';
        }

        // Set tryingStep
        if (this.type == 1) this.tryingStep = '1';
        if (this.type == 2) this.tryingStep = '2';
        if (this.type == 3) this.tryingStep = '3';
      }


					/* if(campInfo && campInfo.upstreamCnpId.toLowerCase() == "sinch"){
						if(this.type == 1)
							this.tryingStep = '1'
						if(this.type == 2)
							this.tryingStep = '2'
						if(this.type == 3)
							this.tryingStep = '3'
					}
					else{
						if(this.type == 1)
							this.tryingStep = '1'
						if(this.type == 2)
							this.tryingStep = '2'
						if(this.type == 3)
							this.tryingStep = '3'
					} */
				// }
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

	}

	tabSetting(data: any, tabs: any) {
		if (data != "data") {
			
			this.did = "";
			// this.connectionValue = "";
			this.connectionValues = [];
			this.inboundValue = "";
			this.outboundValue = "";
			this.iddid = data.iddid;
			let did = this.dids.find(el => el.iddid == data.iddid);
			this.did = did.did;

			// this.connectionValue = did.connection_key;
			let selectedConnection = this.connectiondatas.find(x => x.conne === did.connection_key);
			// console.log("Selected Connection ::",selectedConnection);
			
			if (selectedConnection) {
				this.connectionValues = [selectedConnection];   
			} else {
				this.connectionValues = [];
			}
			// ----------change for multiselect-------
			this.inboundValue = did.inbound_key;
			this.outboundValue = did.outbound_key;
			if ((this.connectionValue) && (this.inboundValue) && (this.outboundValue)) {
				this.disButton = 'true';
			} else {
				this.disButton = '';
			}
		}

		switch (tabs) {
			case 1: {
				this.tab1Value = "active";
				this.tab2Value = "";
				this.tab3Value = "";
				break;
			}
			case 2: {
				this.tab1Value = "";
				this.tab2Value = "active";
				this.tab3Value = "";
				break;
			}
			case 3: {
				this.tab1Value = "";
				this.tab2Value = "";
				this.tab3Value = "active";
				break;
			}
		}
	}
	onTableSize(e) {
		if (e) {
			this.tableSizeN = e
		} else {
			this.tableSizeN = this.tableSize
		}
	}
	minus() {
		this.tableSize = Math.floor(Math.floor(this.tableSize) - Math.floor(1));
		this.onTableSizeChange(this.tableSize);
		if (this.tableSize == 1) {
			this.dismiss = true;
		}
		else {
			this.dismiss = false;
		}
		if (this.tableSize < 1000) {
			this.increse_stop = false;
		}
		else {
			this.increse_stop = true;
		}
	}
	plus() {
		this.tableSize = Math.floor(Math.floor(this.tableSize) + Math.floor(1));
		this.onTableSizeChange(this.tableSize);
		if (this.tableSize > 1) {
			this.dismiss = false;
			if (this.tableSize > 999) {
				this.increse_stop = true;
			}
			else {
				this.increse_stop = false;
			}
		}
		else {
			this.dismiss = true;
		}

	}

	onTableSizeChange(event: number): void {
		if (event[1] !== ":") {
			this.tableSize = event;
			if (this.tableSize > 0) {
				this.tableSize = this.tableSize;
			} else {
				if (this.tableSizeN) {
					this.tableSize = this.tableSizeN;
				} else {
					this.tableSize = this.SIZE;
				}
			}
		} else {
			this.tableSize = this.SIZE;
			this.dismiss = false;
		}

		// this.selectedDIDCount = 0;
		// this.selectedDid.splice(0);
		// this.iselectAll = false;

		this.page;
		this.dids;
		this.listedDid = [];
		if (this.tableSize == 1000) {
			this.listedDid = this.dids;
		} else {
			let c: any = this.tableSize * this.page == 10 ? 0 : this.tableSize * (this.page - 1);
			let C: any = Math.floor(Math.floor(c) + Math.floor(this.tableSize));
			for (let i = 0; i < this.dids.length; i++) {
				if (i >= c && i < C) {
					this.listedDid.push(this.dids[i]);
				}
			}
		}

		let count: any;
		if (this.dids.length === 0) {
			count = 0;
		} else if (this.page <= 1) {
			count = 1;
		} else {
			count = Math.min(((this.page - 1) * this.tableSize) + 1, this.dids.length);
		}

		let tblEntry = 0;
		if (this.tableSize * this.page < this.dids.length) {
			tblEntry = this.tableSize * this.page;
		} else {
			tblEntry = this.dids.length;
		}

		this.shwoingEntry = count;
		this.sInfo = "Showing " + count + " to " + tblEntry + " of " + this.dids.length + " entries (of " + this.allUserDIDLen + " total)";

		// this.listedDid.forEach((ele: any) => {
		// 	ele.isChecked = false;
		// });
	}

	onTableDataChange(event) {
		this.page = event;
		this.savedPage = event;
		this.dids;
		this.onTableSizeChange(this.tableSize);
		this.iselectAll = this.listedDid.length > 0 && this.listedDid.every((ele: any) => ele.isChecked)
	}

	reload() {
		this.tab1Value = "";
		this.tab2Value = "";
		this.tab3Value = "";
	}

	uploadListener($event: any): void { }

	onFilePicked(event: Event) {
		const file: File = (event.target as HTMLInputElement).files[0];
		this.file = file;
		const reader = new FileReader();
		reader.readAsDataURL(file)
	}

onFilePickeddata(event: Event) {
	this.NonDuplicateDIDFLag = false;

	const file: File = (event.target as HTMLInputElement).files?.[0];
	if (!file) return;

	this.file = file;
	const reader = new FileReader();

	reader.onload = () => {
		const result = reader.result as string;

		// Extract base64 content from the Data URL
		const base64Index = result.indexOf(',') + 1;
		const base64 = result.slice(base64Index);

		// Decode base64 to string
		const decodedText = atob(base64);

		const lines = decodedText.trim().split(/\r?\n/);
		const header = lines[0].replace(/[()]/g, "").trim().toLowerCase();

		if (header == "npanxxyyyy") {
			const numbers = lines.slice(1)
				.map(line => line.trim())
				.filter(line => line !== "");

			this.data.checkDIDduplicacy(numbers).subscribe((resp) => {
				const duplicates = (resp.data || []).map((item: any) => item.did);
				const matchingDIDs = numbers.filter(num => duplicates.includes(num));
				const nonMatchingDIDs = numbers.filter(num => !duplicates.includes(num));

				this.MatchingDID = matchingDIDs;
				this.NonDuplicateDID = nonMatchingDIDs;

				if (this.NonDuplicateDID.length === 0) {
					this.NonDuplicateDIDFLag = true;
				}

				// ✅ Prepare CSV Blob if there are matching DIDs
				if (matchingDIDs.length > 0) {
					const csvContent = ["(NPANXXYYYY)", ...matchingDIDs].join("\n");
					this.matchingDIDCsvBlob = new Blob([csvContent], { type: 'text/csv' });
				} else {
					this.matchingDIDCsvBlob = null;
				}
			});
		} else {
			console.warn("Header NPANXXYYYY not found!");
		}
	};

	reader.readAsDataURL(file);
}

downloadMatchingDIDCsv() {
	if (!this.matchingDIDCsvBlob) return;
	const url = window.URL.createObjectURL(this.matchingDIDCsvBlob);
	const a = document.createElement('a');
	a.href = url;
	a.download = 'matching_dids.csv';
	document.body.appendChild(a);
	a.click();
	document.body.removeChild(a);
	window.URL.revokeObjectURL(url);
}


 

	onUpload() {
		this.submitted = false;
		if (this.uploadDid.invalid) {
			// alert("Mandatory fields are required!");
			this.submitted = true;
			return;
		}
		else {
			let payload = {
				user: this.uploadDid.value.user[0].iduser,
				connection: this.uploadDid.value.connection[0].currid,
				description: this.uploadDid.value.description,
				numbertype: this.uploadDid.value.numbertype,
				provider: this.uploadDid.value.provider,
				upload: this.uploadDid.value.upload,
				Rates: this.uploadDid.value.Rates,
				idtariff: this.uploadDid.value.idtariff
			}
			// console.log("payload",payload);
			this.dIFlag = true
			this.dIFBtn = "Uploading..."
			this.data.uploadDid(payload, this.file).subscribe(response => {
				this.dIFlag = false
				if (response.status == 201) {
					this.uploadDid.reset();
					this.closeModal.nativeElement.click();
					//this.ngOnInit();
					window.location.reload();
					this.dIFBtn = "Imported"
					this.upload = response.data;
					this.responseMessage = response.message;
					setTimeout(() => {
						this.dIFBtn = "Import DID"
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.dIFBtn = "Import DID"
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.dIFlag = false
				this.dIFBtn = "Import DID";
				this.errMessage = "Something went wrong with upload DIDs!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	selectedFromDate(e) {
		this.submitted = true;
		if (e.target.value) {
			this.filterForm.get("toDate").setValidators(Validators.required);
			this.filterForm.get("toDate").updateValueAndValidity();
		}
	}

	selectedToDate(e) {
		this.submitted = true;
		if (e.target.value) {
			this.filterForm.get("fromDate").setValidators(Validators.required);
			this.filterForm.get("fromDate").updateValueAndValidity();
		}
	}

	filterByUser(e) {
		this.filterForm.patchValue({
			selectedUser: e.target.value
		});
	}
	filterByConnection(e) {
		this.filterForm.patchValue({
			connectionKey: e.target.value
		});
	}
	filterByCampaign(e) {
		this.filterForm.patchValue({
			campaignKey: e.target.value
		});
	}

	filterSubmit() {
		this.submitted = true;
		if (this.filterForm.invalid) {
			return false;
		}
		if (this.filterForm.value.portout == 'N/A' && this.isAdmin) {
			this.errMessage = "Port Out Pin unavailable";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000)
			return false;

		}
		else {
			const payloads = {
				// 	autoRenew:this.filterForm.value.autoRenew = this.filterForm.value.autoRenew?.[0]?.id || '',
				// 	campaignKey :this.filterForm.value.campaignKey = this.filterForm.value.campaignKey?.[0]?.campaignsadmin || '',
				// 	connectionKey:this.filterForm.value.connectionKey = this.filterForm.value.connectionKey?.[0]?.conne || '',
				// 	didnpa:this.filterForm.value.didnpa || '',
				// 	didnumber:this.filterForm.value.didnumber || '', 
				// 	fromDate:this.filterForm.value.fromDate || '',
				// 	portout: this.filterForm.value.portout = this.filterForm.value.portout?.[0]?.portout || '',
				// 	selectSMS: this.filterForm.value.selectSMS = this.filterForm.value.selectSMS?.[0]?.id || '',
				// 	selectState:this.filterForm.value.selectState = this.filterForm.value.selectState?.[0]?.idaccount?.split("-")[1] || '',
				// 	selectedUser: this.filterForm.value.selectedUser = this.filterForm.value.selectedUser?.[0]?.userdata || '',
				// 	toDate: this.filterForm.value.toDate || ''
				autoRenew: this.filterForm.value.autoRenew?.[0]?.id || '',
				campaignKey: this.filterForm.value.campaignKey?.[0]?.campaignsadmin || '',
				connectionKey: this.filterForm.value.connectionKey?.[0]?.conne || '',
				didnpa: this.filterForm.value.didnpa || '',
				didnumber: this.filterForm.value.didnumber || '',
				fromDate: this.filterForm.value.fromDate || '',
				portout: this.filterForm.value.portout?.[0]?.portout || '',
				selectSMS: this.filterForm.value.selectSMS?.[0]?.id || '',
				selectState: this.filterForm.value.selectState?.[0]?.idaccount?.split("-")[1] || '',
				// selectedUser: this.filterForm.value.selectedUser?.[0]?.userdata || '',
				selectedUser: this.filterForm.value.selectedUser?.[0]?.userdata?.split("-")[1] || '',

				toDate: this.filterForm.value.toDate || ''
			}

			this.data.onGetBuyDids(payloads).subscribe(res => {
				this.didCount = '';
				this.iselectAll = false;
				this.selectedDid = [];
				this.selectedDIDCount = '';
				$('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
				if (res.status == 200) {
					this.exportButton = 'Export Filtered DID';
					this.dids = res.data;

					this.data.exportDID(payloads).subscribe(res => {
						if (res.status == 200) {
							this.page = 1;
							// this.allUserDIDLen = res.data.length;
							this.onTableSizeChange(this.tableSize);
							// this.didCount = '(of ' + res.data.length + ' total)';
							this.didCount = '(of ' + this.allUserDIDLen + ' total)';
							$.getScript('./assets/managetable.js');
						}
					});
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}

			}, err => {
				this.errMessage = "Something went wrong with DID Filter!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000)
			});
		}

		this.show = true;
	}

	autoRenew(iddid, did) {
		this.iselectAll = false;
		this.selectedDid.forEach((ele: any) => {
			ele.isChecked = false;
		});
		this.selectedDid = [];
		this.selectedDIDCount = '';
		const variVal = document.getElementById("isEnable-" + iddid);
		if (variVal.innerHTML == 'Enabled') { this.getVal = "Disabled"; } else { this.getVal = "Enabled"; }
		var data = { iddid: iddid, isEnable: this.getVal, did: did }
		this.data.enableDisable(data).subscribe(response => {
			if (response.status == 201) {
				if (variVal.innerHTML == "Enabled") {
					variVal.innerHTML = "Disabled";
					variVal.className = "btn-red btn-xs btn-style";
					this.errMessage = '(' + did + ') ' + response.message;
					setTimeout(() => {
						this.errMessage = "";
						// this.getDIDs(this.filterForm.value);
					}, 5000);
				}
				else {
					variVal.innerHTML = "Enabled";
					variVal.className = "btn-green btn-xs btn-style";
					this.responseMessage = '(' + did + ') ' + response.message;
					setTimeout(() => {
						this.responseMessage = "";
						// this.getDIDs(this.filterForm.value);
					}, 5000);
				}
			}
			else {
				this.errMessage = response.message
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

// resetFilter() {
// 		this.searchFilter.reset({
// 			numbers: '',
// 			selectAction: [],
// 			connVal: [],
// 			uploadfile: ''
// 		});

// 		this.Paste_number = true;   
// 		this.connectionDrop = false;
// 		this.getDIDs(this.filterForm.value);
// 	}

	clearFilters() {
		this.submitted = false;
		this.filterForm.reset();
	}

	clearFilter(e) {
		this.submitted = false;
		this.page = this.savedPage;
		this.roughData = [];
		this.findDID = [];
		this.notFindDID = [];
		this.connectionDrop = false;
		this.iselectAll = false;
		this.selectedDid = [];
		this.selectedDIDCount = '';
		this.manageDID = [];
		this.resetDt();
		this.searchFilter.reset();
		this.filterForm.reset();
		this.filterForm.get('portout').setValue('')
		this.filterForm.get('campaignKey').setValue('')
		this.filterForm.get('selectState').setValue('')
		this.filterForm.get('selectSMS').setValue('')
		this.filterForm.get('selectedUser').setValue('')
		this.filterForm.get('autoRenew').setValue('')
		// if (e == 1 || e == 2)
		if (e == 1 || e == 2 || e == 4)
			this.ngOnInit();
	}


	// optionVal() {
	// 	this.searchFilter.patchValue({
	// 		selectAction: 'no',
	// 		connVal: 'no'
	// 	});
	// }

	resetDt(): void {
		this.manageDID = [];
		this.iselectAll = false;
		this.selectedDid = [];
		this.selectedDIDCount = '';
		// this.optionVal();
		// $('#basic-datatables').DataTable().clear().destroy();
	}

	downloadCSVFile() {
  const payloads = {
    autoRenew: this.filterForm.value.autoRenew?.[0]?.id || '',
    campaignKey: this.filterForm.value.campaignKey?.[0]?.campaignsadmin || '',
    connectionKey: this.filterForm.value.connectionKey?.[0]?.conne || '',
    didnpa: this.filterForm.value.didnpa || '',
    didnumber: this.filterForm.value.didnumber || '',
    fromDate: this.filterForm.value.fromDate || '',
    portout: this.filterForm.value.portout?.[0]?.portout || '',
    selectSMS: this.filterForm.value.selectSMS?.[0]?.id || '',
    selectState: this.filterForm.value.selectState?.[0]?.idaccount?.split("-")[1] || '',
    selectedUser: this.filterForm.value.selectedUser?.[0]?.userdata?.split("-")[1] || '',
    toDate: this.filterForm.value.toDate || ''
  };

  this.iselectAll = false;
  this.selectedDid.forEach((ele: any) => ele.isChecked = false);
  this.selectedDid = [];
  this.selectedDIDCount = '';

//   console.log("payloads", payloads);

  this.data.exportDID(payloads).subscribe(res => {
    if (res.status === 200 && res.data.length > 0) {
      this.manageDID = res.data; // update with fresh data
    //   console.log("Fetched manageDID:", this.manageDID);

      const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.manageDID);
      const workbook: XLSX.WorkBook = { Sheets: { 'did': worksheet }, SheetNames: ['did'] };
      const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
      this.saveAsExcelFile(excelBuffer, "did_" + res.username + "_");
    } else {
      this.errMessage = "DID Not Available";
      setTimeout(() => { this.errMessage = ""; }, 5000);
    }
  }, err => {
    this.errMessage = "Something went wrong while exporting CSV!";
    setTimeout(() => { this.errMessage = ""; }, 5000);
  });
}

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		//let dateObj = new Date();
		let date = new Date().toLocaleDateString('en-US').replace('_', '/');
		saveAs(data, fileName + date + this.EXCEL_EXTENSION);
	}

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}

	monthsList() {
		this.monthNameList = [
			{ name: "Jan", value: "1" },
			{ name: "Feb", value: "2" },
			{ name: "Mar", value: "3" },
			{ name: "Apr", value: "4" },
			{ name: "May", value: "5" },
			{ name: "Jun", value: "6" },
			{ name: "Jul", value: "7" },
			{ name: "Aug", value: "8" },
			{ name: "Sep", value: "9" },
			{ name: "Oct", value: "10" },
			{ name: "Nov", value: "11" },
			{ name: "Dec", value: "12" }
		];
	}

	selectThisMonth() {
		let now = new Date();
		let year = now.getFullYear();
		let month = now.getMonth() + 1;
		let day = new Date(year, month, 0).getDate();
		this.toDate = year + '-' + month + '-' + day;
	}


	static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
		return (c: AbstractControl): { [key: string]: boolean } | null => {
			const date1 = c.get(fromDate).value;
			const date2 = c.get(toDate).value;
			if ((date1 !== null && date2 !== null) && date1 > date2) {
				return validatorField;
			}
			return null;
		};
	}

	reset() {
		// this.connectionValue = '';
		this.connectionValues = [];
		this.disButton = ''
	}

	// checkbox1
	displayfield(evt: any) {
		if (this.Paste_number) {
			this.Paste_number = false
			this.selectedOption = '';
		}
		else {
			this.Paste_number = true
			this.selectedOption = '';
			this.searchFilter.get('numbers').setValue('');
		}
		this.roughData = [];
		this.findDID = [];
		this.notFindDID = [];
		this.file = '';
		this.searchFilter.patchValue({
			numbers: '',
			uploadfile: ''
		})
	}

	showDiv = {
		current: false,
		next: false
	}
	didtab: any = 'filters';
	filter: any
	bulk: any
	Clicked: boolean

	onClick(check) {
		if (check == 1) {
			this.didtab = 'filter';
		} else if (check == 2) {
			this.didtab = 'bulk';
		}
	}

	onSwitch(check) {
		switch (check) {
			case 1:
				return 'filter';
			case 2:
				return 'bulk';
		}

	}

	onSearch(data: any): void {
		if (data) {
			let searchText: any = '';
			searchText = data.toLowerCase();
			this.dids = this.didBackup.filter(it => {
				return Object.keys(it).some(key => {
					if (data.includes('/') && (key === 'subscription_end_date' || key === 'created_at')) {
						it[key] = formatDate(it[key], 'MM/dd/yyyy', 'en-US');
						return String(it[key]).toLowerCase().includes(searchText);
					} else {
						return String(it[key]).toLowerCase().includes(searchText);
					}
				});
			});
			this.page = 1;
			this.onTableSizeChange(this.tableSize);
		} else {
			this.dids = this.didBackup;
			this.page = this.savedPage;
			this.onTableSizeChange(this.tableSize);
		}
	}

	sort_did(data: string) {
		const getField = (data: string) => {
			switch (data) {
				case 'SAN':
					return 'account_id';
				case 'DID':
					return 'did';
				case 'Port-out PIN':
					return 'portoutpin';
				case 'NPA':
					return 'npa';
				case 'NXX':
					return 'nxx';
				case 'State':
					return 'state';
				case 'Rate Center':
					return 'ratecenter';
				case 'Connection':
					return 'connectionName';
				case 'Start Subscription':
					return 'created_at';
				case 'End Subscription':
					return 'subscription_end_date';
				case 'Auto Renewal':
					return 'sub_auto_renew';
				case 'Disconnect Days':
					return 'did_disconnect_days';
				default:
					return '';
			}
		};

		const field = getField(data);

		if (field) {
			this.sortOrder = this.sortField === field ? (this.sortOrder === 'asc' ? 'desc' : 'asc') : 'asc';

			let startIndex = (this.page - 1) * this.tableSize;
			let endIndex = startIndex + this.tableSize;
			const entriesToSort = this.dids.slice(startIndex, endIndex);

			entriesToSort.sort((a: any, b: any) => {
				const comparison = this.sortOrder === 'asc' ? 1 : -1;
				return a[field] < b[field] ? -comparison : a[field] > b[field] ? comparison : 0;
			});

			for (let i = startIndex, j = 0; i < endIndex && j < entriesToSort.length; i++, j++) {
				this.dids[i] = entriesToSort[j];
			}

			this.sortField = field;
		}

	}
	ondidprovider(e: any) {
		this.providertype = e;
	}
	onNumberTypeChange(selectedType: string) {
		this.myvalue = selectedType;
		/* if (this.myvalue === 'TF') {
			this.did_provider = this.did_import[0].subheading1.options.filter(option => option.value !== 'OTT_MASH');
		} else {
			this.did_provider = this.did_import[0].subheading1.options;
		} */
		if (selectedType === 'SC') {
			this.uploadDid.get('connection').setValue('');
			this.uploadDid.get('connection').enable();
			this.uploadDid.get('provider').setValue('shortcode');
			this.uploadDid.get('Rates').setValue('');
			this.uploadDid.get('outbound').setValue('');
			this.uploadDid.get('inbound').setValue('');
		}
		else if (selectedType === 'NN') {
			this.uploadDid.get('Rates').setValue('');
			this.uploadDid.get('provider').setValue('');
			this.uploadDid.get('connection').enable();
		}
		else if (selectedType === 'TF') {
			this.uploadDid.get('Rates').setValue('');
			this.uploadDid.get('provider').setValue('');
			this.uploadDid.get('connection').enable();
		}
		else {
			this.uploadDid.get('connection').enable();
			this.uploadDid.get('provider').setValue('');
			this.uploadDid.get('Rates').setValue('');
		}
	}

	function1(e) {
		if (this.user && this.myvalue) {
			this.showrates = [];
			if (this.myvalue === 'NN') {
				this.showrates = this.rates.filter(rate => rate.category === 'local_number');
			}
			if (this.myvalue === 'NN' && this.providertype == 'OTT_MASH') {
				this.showrates = this.rates.filter(rate => rate.category === 'imported_ott_mash');
			}
			if (this.myvalue === 'TF') {
				this.showrates = this.rates.filter(rate => rate.category === 'toll_free_number' || rate.category === 'vanity_number' || rate.category === 'imported_ott_mash');
			}
			if (this.myvalue === 'SC') {
				this.showrates = this.rates.filter(rate => rate.category === 'short_code_lease' || rate.category === 'vanity_short_code' || rate.category === 'migrated_short_code');
			}
		}
	}


	GetRatesID(event) {
		let idtariff = event.iduser.split('-')[2];
		this.data.Getrates(idtariff).subscribe(result => {
			if (result.status == 200) {
				if (result.data.length > 0) {
					this.rates = result.data;
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

	messageshow() {
		const fromDate = this.filterForm.get('fromDate').value;
		const toDate = this.filterForm.get('toDate').value;
		const currentDate = new Date();
		if ((!fromDate && !toDate)) {
		} else if ((fromDate == null || !fromDate) && (toDate != null)) {
			this.filterForm.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((fromDate != null) && (toDate == null || !toDate)) {
			this.filterForm.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
			this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (toDate && new Date(toDate) > currentDate) {
			this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (fromDate && new Date(fromDate) > currentDate) {
			this.filterForm.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		} else {
			this.filterForm.get('fromDate').setErrors(null);
			this.filterForm.get('toDate').setErrors(null);
		}

	}


	toggleDropdown() {
		this.isDropdownOpen = !this.isDropdownOpen;
	}
	selectConnection(key: string, connection: string) {
		this.selectedConnection = connection;
		this.isDropdownOpen = false;

	}

	deselect(event: any) {
		// console.log("Deselect event:", event);
		// this.clearFilters()
		// this.filterForm.get(formControl).setValue([]);
	}


onActionTypeDeSelect(item: any) {
		// console.log("Action type deselected:", item);
		this.searchFilter.get('selectAction')?.setValue(null);
	}
	onConnectionDeSelect(item: any) {
		// console.log("Connection deselected:", item);
		this.searchFilter.get('connVal')?.setValue(null);
	}


	ngOnDestroy() {
		this.connectionmodal.nativeElement.click()
		this.enabledisablesms.nativeElement.click()
		this.didActionLog.nativeElement.click()
		 this.modalcampaign.nativeElement.click()
 
	}
}
