
import { ChangeDetectorRef, Component, ElementRef, ViewChild, } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl, } from '@angular/forms';
import { InboundService } from '../inbound.service';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Cart, getnumbersForm } from '../inbound.class';
import { BehaviorSubject, Observable, Subscription } from 'rxjs';
import * as fromInbound from '../inbound.reducer';
import * as inboundAction from '../inbound.action';
import { Store } from '@ngrx/store';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { TariffService } from 'src/app/tariff/tariff.service';
declare var $: any;

@Component({
  selector: 'app-getnumbers',
  templateUrl: './getnumbers.component.html',
  styleUrls: ['./getnumbers.component.css']
})

export class GetnumbersComponent extends AppComponentClass<any, any> {
  @ViewChild('createmodal') createmodal: ElementRef;
  @ViewChild('stateDropdown') stateDropdown: any;
  @ViewChild('rateCenterDropdown') rateCenterDropdown: any;
  public maskTeleUS = ['(', /\d/, /\d/, /\d/, ')', ' ', /\d/, /\d/, /\d/, '-', /\d/, /\d/, /\d/, /\d/];

  searchText = { count: 0 };
  filtre: string;
  _filter: any;
  viewMode: any;
  rowdata: any;
  label: any;
  label1: any;
  listdata: any[];
  list1: any;
  p: number = 1;
  value: any;
  page = 1;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  filterTerm: string
  public inbound: any[];
  label2: any;
  public value1: any;
  public getnumbersForm: FormGroup;
  public vanityForm: FormGroup;
  public tollfreeForm: FormGroup;
  public submitted: boolean = false;
  public show: boolean = false;
  public show1: boolean = true;
  hide: string;
  block: string;
  resDID: any = [];
  responseMessage = "";
  didLocations: any = [];
  didLength: any;
  errMessage: any = "";
  cartItems$ = new BehaviorSubject<any>([]);
  cartItems = this.cartItems$.asObservable();
  counter$: Observable<Cart[]>;
  isTollFree: Boolean = false;
  isLoaded: Boolean = false;
  selectedDid: any = [];
  isSelected$ = new BehaviorSubject<Boolean>(false);
  isSelected = this.isSelected$.asObservable();
  isSelect$ = new BehaviorSubject<Boolean>(false);
  isSelect = this.isSelect$.asObservable();
  subscription: Subscription;
  name: any;
  dropdownSettings: IDropdownSettings = {};
  dropdownSetting: IDropdownSettings = {};
  stateList: any = [];
  rateCenterList: any = [];
  dataTable: any;
  list: string;
  showTab: string;
  isDisabled: boolean = true;
  iselectAll: boolean;
  isCartText: string;
  isDisabledSingle: boolean;
  cartDid: any = [];
  selectedDIDCount: any;
  withoutcartDid: any = [];
  closeDropdownSelection = true;
  displayinput: boolean = false;
  isChecked: boolean = false;
  sequential: boolean = false;
  postVanity: any;
  idtariff: any;
  vanityRate: any;
  // tollFreeDids: any;

  constructor(public data: InboundService, public router: Router, private tariffService: TariffService,public cd:ChangeDetectorRef,
    public fb: FormBuilder, private store: Store<fromInbound.inboundState>) {
      
    super(data, router, fb);
    this.data.solution.subscribe(res => {
      if (res != null) {
        this.cdata = new getnumbersForm(res);
        this.keyfield = res.id;
        this.getnumbersForm = this.cdata.makeform(this.fb);
      } else {
        this.cdata = new getnumbersForm(null);
        this.keyfield = -1;
        this.getnumbersForm = this.cdata.makeform(this.fb);
      }
    });
  }

  ngOnInit(): void {
    this.cartDid = [];
    this.selectedDIDCount = '';
    this.withoutcartDid = [];
    $('#basic-datatables2').DataTable().clear();
    $('#basic-datatables2').DataTable().destroy();
    $.getScript('./assets/table.js');
    this.showTab = '1';
    this.iselectAll = false;
    this.isDisabled = true;
    this.isDisabledSingle = false;

    this.isCartText = '';
    this.counter$ = this.store.select(fromInbound.getCartItems);

    this.data.getnumber().subscribe((result) => {
      this.label = result[1];
      this.list1 = result[0].list;
      this.inbound = result[0].headers_details;
      this.rowdata = result[0].product_details;
      this.label2 = result[2];
    });

    this.vanityForm = this.fb.group({
      wildcard: new FormControl(''),
      sequential: new FormControl(),
      quantity: new FormControl('', [Validators.required]),
      tnMask1: new FormControl(''),
      tnMask2: new FormControl(''),
      tnMask3: new FormControl('')
    })

    this.data.getStates().subscribe(res => {
      this.stateList = res.data;
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'id',
      textField: 'abbrev',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.dropdownSetting = {
      singleSelection: true,
      idField: 'id',
      textField: 'rc_abbre',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    let session: any = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.tariffService.getSingleUsers().subscribe(res => {
      this.userData = res.data1[0];
      this.idtariff = this.userData.idtariff;
      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "message", subtype: "message_activation" }).subscribe(res => {
        res.data.forEach(element => {
          if (element.category == 'vanity_number') {
            this.vanityRate = element.rate;
          }
        });
      })
    })

    $('#basic-datatables2').DataTable().clear().destroy();
    $.getScript('./assets/table.js');
  }
  tabChange(e) {
    this.cartItems$.next([]);
    $('#basic-datatables2').DataTable().clear();
    $('#basic-datatables2').DataTable().destroy();
    $('#basic-datatables').DataTable().clear();
    $('#basic-datatables').DataTable().destroy();
    $.getScript('./assets/table.js');
    this.selectedDIDCount = "";
    this.resDID = [];
    this.isSelected$.next(false);
    if (e == '1') {
      this.showTab = '1';
      this.iselectAll = false;
      this.isDisabled = true;
    } else if (e == '2') {
      this.showTab = '2';
      this.iselectAll = false;
      this.isDisabled = true;
    } else {
      this.showTab = '3';
      this.iselectAll = false;
      this.isDisabled = true;
    }
  }
  setState(event) {
    this.getnumbersForm.patchValue({
      State: event.abbrev,
    });
    this.data.getnumber().subscribe((result) => {
      this.label[2] = result[1][2];
    });
    this.data.GetRateCenter(event.abbrev).subscribe((res) => {
      res.data.forEach((ele: any, idx: number) => {
        ele.id = idx;
      });
      this.rateCenterList = res.data;
    });
  }

  deselectState(event) {
    this.rateCenterList = [];
    this.getnumbersForm.patchValue({
      RateCenter: '',
    });
    this.setState(event)
    this.getnumbersForm.get('State').setValue('');
  }
   

  setRateCenter(event) {
    this.getnumbersForm.patchValue({
      RateCenter: event.rc_abbre,
    });
  }

  onchanged(e) {
    this.getnumbersForm.patchValue({
      State: '',
    });
    this.getnumbersForm.patchValue({
      RateCenter: '',
    });
    this.getnumbersForm.get('Qty').setValue('1');
    this.getnumbersForm.get('states')?.setValue([]);
    this.getnumbersForm.get('rateCenters')?.setValue([]);
    if (this.stateDropdown && Array.isArray(this.stateDropdown.selectedItems)) {
      this.stateDropdown.selectedItems.length = 0;
      if (this.stateDropdown.dropdown) {
        this.stateDropdown.dropdown.selectedItems.length = 0;
      }
    }
    if (this.rateCenterDropdown && Array.isArray(this.rateCenterDropdown.selectedItems)) {
      this.rateCenterDropdown.selectedItems.length = 0;
      if (this.rateCenterDropdown.dropdown) {
        this.rateCenterDropdown.dropdown.selectedItems.length = 0;
      }
    }
    this.cd.detectChanges();
    switch (e.target.value) {
      case '1':
        this.show1 = true;
        break;
      case '2':
        this.show1 = false;
        break;
      case '3':
        this.show1 = false;
        break;
      default:
        this.show1 = false;
        break;
    }
  }
 

  get f() { return this.getnumbersForm.controls; };



  onResetDID() {
    this.submitted = false;
    this.iselectAll = false;
    this.selectedDIDCount = '';
    this.isDisabled = true;
    this.data.getnumber().subscribe((result) => {
      this.label = result[1];
      this.list1 = result[0].list;
      this.inbound = result[0].headers_details;
      this.rowdata = result[0].product_details;
      this.label2 = result[2];
    });
    this.resDID = [];
    this.selectedDid = [];
    this.cartItems$.next([]);
    this.isSelected$.next(false);
    this.show1 = true;
    $('#basic-datatables').DataTable().clear();
    $('#basic-datatables').DataTable().destroy();
    $('#basic-datatables2').DataTable().clear();
    $('#basic-datatables2').DataTable().destroy();
    $.getScript('./assets/table.js');
  }
  // @to save/update form data
  onSearchDID() {
    this.isSelected$.next(false);
    this.iselectAll = false;
    this.submitted = true;
    this.selectedDid = [];
    this.counter$ = this.store.select(fromInbound.getCartItems);
   
    if (this.getnumbersForm.invalid) {
      return false;
    } else {
      this.cartDid = [];
      this.withoutcartDid = [];
      this.selectedDIDCount = "";
   
      if (this.cdata.saveForm(this.getnumbersForm)) {
        if (this.show1) {
          // 🔹 NPA/NXX search
          this.subscription = this.data.searchDIDByNpx(this.cdata).subscribe(
            (res) => {
              if (res.status == 200) {
                this.isDisabled = false;
                this.showTab = '1';
                this.resDID = res.data;
   
                $('#basic-datatables').DataTable().clear();
                $('#basic-datatables').DataTable().destroy();
                $.getScript('./assets/table.js');
   
                this.cartItems$.next(res.data);
   
                this.subscription = this.counter$.subscribe((res: any) => {
                  this.resDID.forEach((element) => {
                    if (res.length > 0) {
                      var dids = res.map((item) => item.did);
                      var isDuplicate = dids.some(
                        (item) => item == element.phone_number
                      );
                      if (isDuplicate) {
                        element.isCartText = 'Already in Cart';
                        element.isCart = false;
                        element.isDisabledSingle = true;
                        this.cartDid.push({ did: element.phone_number });
                      } else {
                        this.isCartText = '';
                        element.isCart = false;
                        element.isDisabledSingle = false;
                        this.withoutcartDid.push({
                          phone_number: element.phone_number,
                          disable: 'false',
                          provider: element.provider,
                        });
                      }
                    } else {
                      this.isCartText = '';
                      element.isCart = false;
                      element.isDisabledSingle = false;
                    }
                  });
                });
   
                this.responseMessage = res.message;
                setTimeout(() => (this.responseMessage = ''), 5000);
              } else {
                this.errMessage = res.message;
                setTimeout(() => (this.errMessage = ''), 5000);
                this.iselectAll = this.resDID.every((did) => did.isCart);
              }
            },
            (error) => {
              this.errMessage = error.message;
              setTimeout(() => (this.errMessage = ''), 5000);
            }
          );
        } else {
          // 🔹 Check filter type to determine search type
          if (this.cdata.filter_type === '3') {
            // 🔹 State-only search
            this.subscription = this.data.searchDIDByState(this.cdata).subscribe(
              (res) => {
                if (res.status == 200) {
                  this.isDisabled = false;
                  this.resDID = res.data;
   
                  $('#basic-datatables').DataTable().clear();
                  $('#basic-datatables').DataTable().destroy();
                  $.getScript('./assets/table.js');
   
                  this.cartItems$.next(res.data);
   
                  this.subscription = this.counter$.subscribe((res: any) => {
                    this.resDID.forEach((element) => {
                      if (res.length > 0) {
                        var dids = res.map((item) => item.did);
                        var isDuplicate = dids.some(
                          (item) => item == element.phone_number
                        );
                        if (isDuplicate) {
                          element.isCartText = 'Already in Cart';
                          element.isCart = false;
                          element.isDisabledSingle = true;
                          this.cartDid.push({ did: element.phone_number });
                        } else {
                          this.isCartText = '';
                          element.isCart = false;
                          element.isDisabledSingle = false;
                          this.withoutcartDid.push({
                            phone_number: element.phone_number,
                            disable: 'false',
                            provider: element.provider,
                          });
                        }
                      } else {
                        this.isCartText = '';
                        element.isCart = false;
                        element.isDisabledSingle = false;
                      }
                    });
                  });
   
                  this.responseMessage = res.message;
                  setTimeout(() => (this.responseMessage = ''), 5000);
                } else {
                  this.errMessage = res.message;
                  setTimeout(() => (this.errMessage = ''), 5000);
                }
              },
              (error) => {
                this.errMessage = error.message;
                setTimeout(() => (this.errMessage = ''), 5000);
              }
            );
          } else {
            // 🔹 Rate Center search
            this.subscription = this.data.searchDIDByRate(this.cdata).subscribe(
              (res) => {
                if (res.status == 200) {
                  this.isDisabled = false;
                  this.resDID = res.data;
   
                  $('#basic-datatables').DataTable().clear();
                  $('#basic-datatables').DataTable().destroy();
                  $.getScript('./assets/table.js');
   
                  this.cartItems$.next(res.data);
   
                  this.subscription = this.counter$.subscribe((res: any) => {
                    this.resDID.forEach((element) => {
                      if (res.length > 0) {
                        var dids = res.map((item) => item.did);
                        var isDuplicate = dids.some(
                          (item) => item == element.phone_number
                        );
                        if (isDuplicate) {
                          element.isCartText = 'Already in Cart';
                          element.isCart = false;
                          element.isDisabledSingle = true;
                          this.cartDid.push({ did: element.phone_number });
                        } else {
                          this.isCartText = '';
                          element.isCart = false;
                          element.isDisabledSingle = false;
                          this.withoutcartDid.push({
                            phone_number: element.phone_number,
                            disable: 'false',
                            provider: element.provider,
                          });
                        }
                      } else {
                        this.isCartText = '';
                        element.isCart = false;
                        element.isDisabledSingle = false;
                      }
                    });
                  });
   
                  this.responseMessage = res.message;
                  setTimeout(() => (this.responseMessage = ''), 5000);
                } else {
                  this.errMessage = res.message;
                  setTimeout(() => (this.errMessage = ''), 5000);
                }
              },
              (error) => {
                this.errMessage = error.message;
                setTimeout(() => (this.errMessage = ''), 5000);
              }
            );
          }
        }
      }
    }
  }
   
  /* onSearchDID() {
    this.isSelected$.next(false);
    // this.isDisabled = false;
    this.iselectAll = false;
    this.submitted = true;
    this.selectedDid = [];
    this.counter$ = this.store.select(fromInbound.getCartItems);
    if (this.getnumbersForm.invalid) {
      return false;
    } else {
      // this.resDID = [];
      this.cartDid = [];
      this.withoutcartDid = [];
      this.selectedDIDCount = "";
      // $('#basic-datatables').DataTable().clear();
      // $('#basic-datatables').DataTable().destroy();
      if (this.cdata.saveForm(this.getnumbersForm)) {
        if (this.show1) {
          this.subscription = this.data.searchDIDByNpx(this.cdata).subscribe(res => {
          if (res.status == 200) {
              this.isDisabled = false;
              this.showTab = '1';
              this.resDID = res.data;
              $('#basic-datatables').DataTable().clear();
              $('#basic-datatables').DataTable().destroy();
              $.getScript('./assets/table.js');
              this.cartItems$.next(res.data);
              // this.resDID.forEach(element => {
              // 	element.isCart = false;
              // });
              this.subscription = this.counter$.subscribe((res: any) => {
                this.resDID.forEach((element, idx) => {
                  if (res.length > 0) {
                    var dids = res.map((item) => {
                      return item.did
                    });
                    var isDuplicate = dids.some(function (item, idx) {
                      return item == element.phone_number
                    });
                    if (isDuplicate) {
                      element.isCartText = 'Already in Cart';
                      element.isCart = false;
                      element.isDisabledSingle = true;
                      this.cartDid.push({ did: element.phone_number });
                    }
                    else {
                      this.isCartText = '';
                      element.isCart = false;
                      element.isDisabledSingle = false;
                      this.withoutcartDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
                    }
                  }
                  else {
                    this.isCartText = '';
                    element.isCart = false;
                    element.isDisabledSingle = false;
                  }

                  // element.isCart = false;
                  // element.isCartText = '';
                  // element.isDisabledSingle = false;
                  // this.withoutcartDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
                });
              });
              this.responseMessage = res.message;
              setTimeout(() => {
                this.responseMessage = "";
              }, 5000);
            }
            else {
              // this.isDisabled = true;
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
              this.iselectAll = this.resDID.every(did => did.isCart);
            }
          }, error => {
            this.errMessage = error.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          });
        }
        else {
          this.subscription = this.data.searchDIDByRate(this.cdata).subscribe(res => {
            if (res.status == 200) {
              this.isDisabled = false;
              this.resDID = res.data;
              $('#basic-datatables').DataTable().clear();
              $('#basic-datatables').DataTable().destroy();
              $.getScript('./assets/table.js');
              this.cartItems$.next(res.data);

              // this.resDID.forEach(element => {
              // 	element.isCart = false;
              // });
              this.subscription = this.counter$.subscribe((res: any) => {
                this.resDID.forEach((element, idx) => {
                  if (res.length > 0) {
                    var dids = res.map((item) => {
                      return item.did
                    });
                    var isDuplicate = dids.some(function (item, idx) {
                      return item == element.phone_number
                    });
                    if (isDuplicate) {
                      element.isCartText = 'Already in Cart';
                      element.isCart = false;
                      element.isDisabledSingle = true;
                      this.cartDid.push({ did: element.phone_number });
                    }
                    else {
                      this.isCartText = '';
                      element.isCart = false;
                      element.isDisabledSingle = false;
                      this.withoutcartDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
                    }
                  }
                  else {
                    this.isCartText = '';
                    element.isCart = false;
                    element.isDisabledSingle = false;
                  }
                  // element.isCart = false;
                  // element.isCartText = '';
                  // element.isDisabledSingle = false;
                  // this.withoutcartDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
                });
              });
              this.responseMessage = res.message;
              setTimeout(() => {
                this.responseMessage = "";
              }, 5000);
            }
            else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          }, error => {
            this.errMessage = error.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          });
        }
      }
    }
  } */

  ele(data) {
    this.sequential = data.target.checked
  }

  onSubmit() {
    // this.isDisabled = false;
    this.iselectAll = false;
    this.vanityForm.patchValue({
      sequential: this.sequential
    })
    // this.tollFreeDids = [];
    this.resDID = [];
    this.cartDid = [];
    this.withoutcartDid = [];
    $('#basic-datatables2').DataTable().clear();
    $('#basic-datatables2').DataTable().destroy();
    $.getScript('./assets/table.js');
    if (this.vanityForm.invalid) {
      this.submitted = true;
      return
    } else {
      this.data.onTollFreeNumber(this.vanityForm.value).subscribe(response => {
        if (response.status == 200) {
          this.isDisabled = false;
          $('#basic-datatables2').DataTable().clear();
          $('#basic-datatables2').DataTable().destroy();
          this.resDID = response.data;
          $.getScript('./assets/table.js');
          this.subscription = this.counter$.subscribe((res: any) => {
            this.resDID.forEach((element, idx) => {
              if (res.length > 0) {
                var dids = res.map((item) => {
                  return item.did
                });
                var isDuplicate = dids.some(function (item, idx) {
                  return item == element.phone_number
                });
                if (isDuplicate) {
                  element.isCartText = 'Already in Cart';
                  element.isCart = false;
                  element.isDisabledSingle = true;
                  this.cartDid.push({ did: element.phone_number });
                }
                else {
                  this.isCartText = '';
                  element.isCart = false;
                  element.isDisabledSingle = false;
                  this.withoutcartDid.push({ phone_number: element.phone_number, disable: element.disable, provider: element.provider });
                }
              }
              else {
                this.isCartText = '';
                element.isCart = false;
                element.isDisabledSingle = false;
              }
            });
          });
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.isDisabled = true;
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onSelectDid(event, did, idx) {    
    this.isDisabled = false;
    if (event.target.checked) {
      this.subscription = this.counter$.subscribe((res: any) => {
        if (res.length > 0) {
          var dids = res.map((item) => {
            return item.did
          });
          var isDuplicate = dids.some(function (item, idx) {
            return item == did.phone_number
          });
          if (isDuplicate) {
            return this.Exist(event);
          }
          else {
            return this.selectedDid.push({ phone_number: did.phone_number, disable: "false", provider: did.provider,portout_pin:did.portout_pin_supported, rates:did.rates });
          }
        }
        else {
          return this.selectedDid.push({ phone_number: did.phone_number, disable: "false", provider: did.provider,portout_pin:did.portout_pin_supported, rates:did.rates});
        }
      });
      this.selectedDIDCount = this.selectedDid.length;
    }
    else {
      if (this.selectedDid.length > 0) {
        // let index = this.selectedDid.indexOf(did.phone_number);
        // this.selectedDid.splice(index, 1);
        const index = this.selectedDid.findIndex(
          (value) => value.phone_number === did.phone_number
        );
        
        if (index !== -1) {
          this.selectedDid.splice(index, 1);
        }
        
        this.selectedDIDCount = this.selectedDid.length;
      }
    }
    if (Array.isArray(this.selectedDid) && this.selectedDid.length > 0) {
      this.isSelected$.next(true);
      this.iselectAll = true;
    }
    else {
      this.isSelected$.next(false);
      this.iselectAll = false;
      this.selectedDIDCount = '';
    }
    if (this.selectedDid.length == this.withoutcartDid.length || this.selectedDid.length === this.resDID.length) {
      this.isSelect$.next(true);
      // this.iselectAll = true;
    }
    else {
      // if(this.selectedDid.length == this.resDID.length){
      // 	this.isSelect$.next(true);
      // 	this.iselectAll = true;
      // }else{
      this.isSelect$.next(false);
      this.iselectAll = false;
      // }
    }
  }

  onSelectAll(event: any) {
    this.isDisabled = false;
    this.subscription = this.counter$.subscribe((res: any) => {
      if (event.target.checked) {
        this.selectedDid = [];
        this.resDID.forEach((element, idx) => {
          if (res.length > 0) {
            var dids = res.map((item) => {
              return item.did
            });
            var isDuplicate = dids.some(function (item, idx) {
              return item == element.phone_number
            });
            if (isDuplicate) {
              element.isCart = false;
              element.isCartText = 'Already in Cart';
              element.isDisabledSingle = true;
            }
            else {
              this.isCartText = '';
              element.isCart = true;
              element.isDisabledSingle = false;
              this.selectedDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider, rates:element.rates });
            }
          }
          else {
            this.isCartText = '';
            element.isCart = true;
            element.isDisabledSingle = false;
            this.selectedDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider, rates:element.rates });
          }
          this.selectedDIDCount = this.selectedDid.length;
        });
        this.selectedDIDCount = this.selectedDid.length;
      }
      else {
        this.selectedDid = [];
        this.resDID.map((item: any) => {
          item.isCart = false;
          return item;
        });
      }
    });
    if (this.selectedDid.length == this.withoutcartDid.length) {
      this.isSelect$.next(true);
      this.iselectAll = true;
    }
    else {
      this.isSelect$.next(false);
      this.iselectAll = false;
    }

    if (Array.isArray(this.selectedDid) && this.selectedDid.length > 0) {
      this.isSelected$.next(true);
      this.iselectAll = true;
    }
    else {
      this.isSelected$.next(false);
      this.iselectAll = false;
      this.selectedDIDCount = '';
    }
  }

  onReset(checkBox1: HTMLInputElement, checkBox2: HTMLInputElement) {
    this.submitted = false;
    checkBox1.checked = false;
    checkBox2.checked = false;
    this.vanityForm.reset();
  }

  addToCart() {
    this.showTab = '1';
    if (this.selectedDid.length > 0) {
      this.subscription = this.data.onAddAllToCart(this.selectedDid).subscribe(res => {
        if (res.status == 201) {
          this.iselectAll = false;
          this.isDisabled = true;
          this.store.dispatch(new inboundAction.Add(this.selectedDid));
          this.selectedDid.forEach((el, idx1) => {
            this.resDID.filter((ele, idx2) => {
              if (el.phone_number == ele.phone_number) {
                this.resDID.splice(idx2, 1);
              }
            });
          });

          if (this.selectedDid.length == this.resDID.length) {
            this.isSelect$.next(true);
            this.iselectAll = true;
          }
          else {
            this.isSelect$.next(false);
            this.iselectAll = false;
          }
          if (Array.isArray(this.selectedDid) && this.selectedDid.length > 0) {
            this.isSelected$.next(true);
          }
          else if (this.selectedDid.length == 0) {
            this.isSelected$.next(false);
          }
          this.isSelected$.next(false);
          this.isSelect$.next(false);
          this.cartItems$.next([]);
          this.cartItems$.next(this.resDID);
          this.selectedDid = [];
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          window.location.reload();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
    else {
      alert("You must select atleast one or more DID to add into cart!")
    }
  }

  changeTab(e) {
    if (e == 'localNumber') {
      this.isLoaded = false;
      this.isTollFree = false;
    }
    else {
      this.isTollFree = true;
      this.isTollFree = true;
    }
  }

  changed(i) {
  }

  Exist(event) {
    event.target.checked = false;
    this.errMessage = "This DID already in cart";
    setTimeout(() => {
      this.errMessage = "";
    }, 3000);
  }
  ExistAll(event) {
    event.target.checked = false;
    this.errMessage = "Some DID already in cart";
    setTimeout(() => {
      this.errMessage = "";
    }, 3000);
  }
  onDestroy(): void {
    this.subscription.unsubscribe();
  }

  vanitychange(event: any) {
    this.vanityForm.patchValue({
      quantity: '',
      wildcard: '',
      tnMask1: '',
      tnMask2: '',
      tnMask3: '',
    })

    if (event.currentTarget.checked == true) {
      this.displayinput = true;

    }
    else {
      this.displayinput = false;

    }
  }
  deselectedRate(event) {
    this.getnumbersForm.get('RateCenter').setValue('');
  }

  ngOnDestroy() {
    this.createmodal.nativeElement.click();
  }
}
