import { FormBuilder, FormGroup, Validators } from "@angular/forms";

// inbound : getnumbers 
export interface getnumbers
{
    latter_authorization: string;
    billing_copy: string;
    comment: string;
    csv_number: string;
   
    State: any,
    Qty:string,
    filter_type:string,
    NPA:number,
    NXX:number ,
    RateCenter:string,  
}

export interface HTTPgetnumbers
{
   
    State:any,
    Qty:string,
    filter_type:string,
    NPA:number,
    NXX:number,
    RateCenter:string,      
}

export class getnumbersForm implements HTTPgetnumbers
{
    
    State:any;
    Qty:string;
    filter_type:string;
    NPA:number;
    NXX:number;
    RateCenter:string;
  
    constructor(data : getnumbers) 
    {
        if(data==null)
        {        
           
            this.Qty="1";
            this.filter_type="";
            this.NPA = null;
            this.NXX = null;
            this.State="";
            this.RateCenter="";
        }
        else
        {         
            this.Qty = data.Qty;
            this.filter_type = data.filter_type;
            this.NPA = data.NPA;
            this.NXX = data.NXX;
            this.State = data.State;
            this.RateCenter = data.RateCenter;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            Qty:[this.Qty, [Validators.required]],
            filter_type:[this.filter_type],
            NPA:[this.NPA],
            NXX:[this.NXX],
            State:[this.State] ,  
            RateCenter:[this.RateCenter]        
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
           
            this.Qty = fg.get("Qty").value;
            this.filter_type = fg.get("filter_type").value;
            this.NPA = fg.get("NPA").value;            
            this.NXX = fg.get("NXX").value;  
            this.State = fg.get("State").value;
            this.RateCenter = fg.get("RateCenter").value;               
            return true;
        }
        else
        {
            return false;
        }
    }
  }

// Toll free Numbers Form
 
export interface gettollfreenumbers
{
    Qty: string,
    due_date: string;
}

export interface HTTPgettollfreenumbers
{
    Qty:string,   
    due_date: string,
}

export class gettollfreenumbersForm implements HTTPgettollfreenumbers
{
    Qty:string;
    due_date: string;
  
    constructor(data : gettollfreenumbers) 
    {
        if(data==null)
        {        
            this.Qty="1";
            //this.due_date = "";
        }
        else
        {         
            this.Qty = data.Qty;
            //this.due_date = data.due_date;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({     
            Qty:[this.Qty, [Validators.required]],
            //due_date: [this.due_date, [Validators.required]],
          });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.Qty = fg.get("Qty").value;
           // this.due_date = fg.get("due_date").value;
            return true;
        }
        else
        {
            return false;
        }
    }
  }

// inbound : confignumber 
export interface confignumber
{
    phone:string,
    feature:string,
    sites:string,
    cnamout:string,
    network:string,     
    routing_prf:string   
}

export interface HTTPgetconfignumber
{
    phone:string,
    feature:string,
    sites:string,
    cnamout:string,
    network:string,     
    routing_prf:string      
}

export class confignumberForm implements HTTPgetconfignumber
{
    phone:string;
    feature:string;
    sites:string;
    cnamout:string;
    network:string;     
    routing_prf:string  
  
    constructor(data : confignumber) 
    {
        if(data==null)
        {        
            this.phone="";
            this.feature="";
            this.sites="";
            this.cnamout="";
            this.network="";
            this.routing_prf="";
        }
        else
        {         
            this.phone = data.phone;
            this.feature = data.feature;
            this.sites = data.sites;
            this.cnamout = data.cnamout;
            this.network = data.network;
            this.routing_prf = data.routing_prf;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            phone: [this.phone, [Validators.required, Validators.pattern("[0-9 ]{10}")]],
            feature:[this.feature, [Validators.required]],
            sites:[this.sites, [Validators.required]],
            cnamout:[this.cnamout, [Validators.required]],
            network:[this.network, [Validators.required]],
            routing_prf:[this.routing_prf, [Validators.required]]     
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.phone = fg.get("phone").value;
            this.feature = fg.get("feature").value;
            this.sites = fg.get("sites").value;
            this.cnamout = fg.get("cnamout").value;            
            this.network = fg.get("network").value;            
            this.routing_prf = fg.get("routing_prf").value;            
            return true;
        }
        else
        {
            return false;
        }
    }
  }

// inbound : inboundprofileForm  
export interface ipf
{
    // existing_profile:string,
    // settings:string,  
    name:String,
    type:string,
    address:string
}

export interface HTTPipf
{
    // existing_profile:string,
    // settings:string,  
    name:String,
    type:string,
    address:string
      
}

export class inboundprofileForm implements HTTPipf
{
    name:String;
    type:string;
    address:string;
  
    constructor(data : ipf) 
    {
        if(data==null)
        {        
            this.name="";
            this.type="";
            this.address="";
        }
        else
        {         
            this.name = data.name;
            this.type = data.type;
            this.address = data.address;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            name:[this.name, [Validators.required]],
            type:[this.type, [Validators.required]],   
            address:[this.address, [Validators.required]],   
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.name = fg.get("name").value;
            this.type = fg.get("type").value;           
            this.address = fg.get("address").value;           
            return true;
        }
        else
        {
            return false;
        }
    }
  }

// inbound : ip_address
export interface ip
{
    ip_address:string,
    last_octet: string,
}

export interface HTTPip
{
    ip_address:string,
    last_octet: string,

}

export class ipForm implements HTTPip
{
   public ip_address:string;
   public last_octet:string;
   
    constructor(data : ipForm) 
    {
        if(data==null)
        {        
           this.ip_address="";
           this.last_octet="";
        }
        else
        {         
            this.ip_address = data.ip_address;
            this.last_octet = data.last_octet;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            ip_address:[this.ip_address, [Validators.required]],
            last_octet:[this.last_octet, [Validators.required]],
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.ip_address=  fg.get("ip_address").value;
            this.last_octet=  fg.get("last_octet").value;
            return true;
        }
        else
        {
            return false;
        }
    }
  }

// inbound : managesite   
export interface managesite
{
    nickname:string,
    type:string,
    address:string,
    location:string,
    country:string,
    state:string,
    city:string,
    zip:string,
}

export interface HTTPmanagesite
{
    nickname:string,
    type:string,
    address:string,
    location:string,
    country:string,
    state:string,
    city:string,
    zip:string,
}

export class managesiteForm implements HTTPmanagesite
{
    nickname:string;
    type:string;
    address:string;
    location:string;
    country:string;
    state:string;
    city:string;
    zip:string;
   
    constructor(data : managesite) 
    {
        if(data==null)
        {        
           this.nickname="";
           this.type="";
           this.address="";
           this.location="";
           this.country="";
           this.state="";
           this.city="";
           this.zip="";
        }
        else
        {         
            this.nickname = data.nickname;
            this.type = data.type;
            this.address = data.address;
            this.location = data.location;
            this.country = data.country;
            this.state = data.state;
            this.city = data.city;
            this.zip = data.zip;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            nick_name:[this.nickname, [Validators.required]],
            type:[this.type, [Validators.required]],
            address:[this.address, [Validators.required]],
            location:[this.location, [Validators.required]],
            country:[this.country, [Validators.required]],
            state:[this.state, [Validators.required]],
            city:[this.city, [Validators.required]],
            zip:[this.zip, [Validators.required]],
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.nickname=  fg.get("nick_name").value;
            this.type=  fg.get("type").value;
            this.address=  fg.get("address").value;
            this.location=  fg.get("location").value;
            this.country=  fg.get("country").value;
            this.state=  fg.get("state").value;
            this.city=  fg.get("city").value;
            this.zip=  fg.get("zip").value;
            return true;
        }
        else
        {
            return false;
        }
    }
  }




  // inbound : call Details Record 

  export interface calldetails {
    status: string,
    call_id: string,
    from_number: string,
    to_number: string
}

export interface HTTPcalldetails {
    status: string,
    call_id: string,
    from_number: string,
    to_number: string
}

export class calldetailsForm implements HTTPcalldetails {
    status: string;
    call_id: string;
    from_number: string;
    to_number: string

    constructor(data: calldetails) {
        if (data == null) {
            this.status = "";
            this.call_id = "";
            this.from_number = "";
            this.to_number = "";
        }
        else {
            this.status = data.status;
            this.call_id = data.call_id;
            this.from_number = data.from_number;
            this.to_number = data.to_number;
        }
    }

    public makeform(fb: FormBuilder): FormGroup {
        return fb.group({
            status: [this.status, [Validators.required]],
            call_id: [this.call_id, [Validators.required]],
            from_number: [this.from_number, [Validators.required]],
            to_number: [this.to_number, [Validators.required]]
        });
    }

    public saveForm(fg: FormGroup): boolean {
        if (fg.valid) {
            this.status = fg.get("status").value;
            this.call_id = fg.get("call_id").value;
            this.from_number = fg.get("from_number").value;
            this.to_number = fg.get("to_number").value;
            return true;
        }
        else {
            return false;
        }
    }
}





// inbound : LoadNumber 
export interface loadnumber
{
   
    csv_number:string,
    latter_authorization:string,
    billing_copy:string,
    comment:string,
   
}

export interface HTTPloadnumber
{
   
    csv_number:string,
    latter_authorization:string,
    billing_copy:string,
    comment:string,
    
}

export class LoadnumberForm implements HTTPloadnumber
{
    
    csv_number:string;
    latter_authorization:string;
    billing_copy:string;
    comment:string;
   
  
    constructor(data : getnumbers) 
    {
        if(data==null)
        {        
           
            this.latter_authorization="1";
            this.billing_copy="";
            this.comment="";
            this.csv_number="";
        }
        else
        {         
           
            this.latter_authorization = data.latter_authorization;
            this.billing_copy = data.billing_copy;
            this.comment = data.comment;
            this.csv_number = data.csv_number;
           
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
           
            latter_authorization:[this.latter_authorization],
            billing_copy:[this.billing_copy],
            comment:[this.comment],
            csv_number:[this.csv_number] ,     
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
           
            this.latter_authorization = fg.get("latter_authorization").value;
            this.billing_copy = fg.get("billing_copy").value;
            this.comment = fg.get("comment").value;            
            this.csv_number = fg.get("csv_number").value;
            
            return true;
        }
        else
        {
            return false;
        }
    }
  }

export interface Cart {
    did: string;
}

