import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { NewCamapignService } from '../new-camapign.service';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';

declare var $: any;

@Component({
  selector: 'app-managereseller',
  templateUrl: './managereseller.component.html',
  styleUrls: ['./managereseller.component.css']
})
export class ManageresellerComponent implements OnInit {
  @ViewChild('resallerdetails') resallerdetails: ElementRef;

  public addreseller: FormGroup;
  submitted = false;

  resellercampign: any[] = [];
  responseMessage: string = '';
  errMessage: string = '';
  camp_reseller_id: any;
  resellerdata: any;
  reseller_id: any;
  singleData: any;

  constructor(private fb: FormBuilder, private data: NewCamapignService, private modalService: NgbModal
  ) {}
 
  ngOnInit(): void {   
    
    this.addreseller = this.fb.group({
      camp_reseller_id: [''],
      reseller_id: [''],
      LegalCompanyName: ['', [Validators.required, Validators.minLength(2), Validators.maxLength(100), Validators.pattern(/^(?!\s*$)(?:[^\s][^\s]*?(?: [^\s]+)*)$/)
      ]],
     emailaddress: ['', [Validators.required, Validators.minLength(5), Validators.maxLength(100), Validators.pattern("^(?!.*\\.\\.)(?!\\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,10}(?<!\\.)$")]],
      
      phonenumber: ['', [ Validators.required, Validators.minLength(10), Validators.maxLength(15)]]
    });

    this.getreseller();
  }

  getreseller(){
    $('#basic-datatablesFA').dataTable().fnClearTable();
    $('#basic-datatablesFA').dataTable().fnDraw();
    $('#basic-datatablesFA').dataTable().fnDestroy(); 
    this.data.getresellercampign().subscribe((res: any) => {
      if (res.status === 201) {
        this.resellercampign = res.data;
      }
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
      $.getScript('./assets/table.js');   
    });
  }

  getsingleReseller(data: any): void {
    this.singleData = data;
    this.camp_reseller_id = data.camp_reseller_id;
    this.reseller_id = data.camp_reseller_unique_id;
    this.resellerdata = this.resellercampign.find(
      elm => elm.camp_reseller_id === this.camp_reseller_id
    );
    if(this.resellerdata){
      this.addreseller.patchValue({
        camp_reseller_id: this.resellerdata.camp_reseller_id,
        reseller_id: this.resellerdata.camp_reseller_unique_id,
        LegalCompanyName: this.resellerdata.legal_campany_name,
        emailaddress: this.resellerdata.camp_reseller_email,
        phonenumber: this.resellerdata.camp_reseller_contact
      });      
    }
    else{
      this.errMessage = "Something went wrong to get detail";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }

  onSubmit() {
    this.submitted = true;
    if (this.addreseller.invalid) {
      return false;
    }
    const payload = {
      ...this.addreseller.value,
      resellerId: this.reseller_id, 
    };  
    if (this.camp_reseller_id) {
      this.updateReseller(payload);
    } else {
      this.saveReseller(payload)
    }
  }

  saveReseller(payload){
    this.data.resellerdata(payload).subscribe((res: any) => {
      if (res.status === 200) {
        document.getElementById('closeReseller')?.click();
        this.getreseller();
        this.responseMessage = res.message
        setTimeout(() => {
          this.responseMessage = ''
        }, 5000);
        this.resetForm();
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ''
        }, 5000);
      }
    });
  }
  
  updateReseller(payload){
    this.data.resellerdataupdate(payload).subscribe((res: any) => {
      if (res.status === 201) {
        document.getElementById("closeReseller")?.click();
        this.getreseller();
        this.responseMessage = res.message
        setTimeout(() => {
          this.responseMessage = ''
        }, 5000);
        this.resetForm();
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ''
        }, 5000);
      }
    });
  }

  deleteReseller(data: any): void {{
      this.data.deletereseller(data.camp_reseller_unique_id).subscribe((res: any) => {
        if (res.status === 201) {
          document.getElementById('closeReseller')?.click();
          this.getreseller();
          this.responseMessage = res.message
          setTimeout(() => {
            this.responseMessage = ''
          }, 5000);
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ''
          }, 5000);
        }
      });
    }
  }

  resetForm(){
    if(this.camp_reseller_id){
      this.addreseller.reset();
      this.addreseller.patchValue({
        camp_reseller_id: this.singleData.camp_reseller_id,
        reseller_id: this.singleData.camp_reseller_unique_id,
      }); 
      this.submitted = false;
    }
    else{
      this.addreseller.reset();
      this.submitted = false;
    }    
  }

  onCancel(){
    this.camp_reseller_id ='';
    this.reseller_id = '';
    this.resetForm();
    document.getElementById("closeReseller").click();
  }

  ngOnDestroy() {
		this.resallerdetails.nativeElement.click();
  }
  
}
