import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NotificationRoutingModule } from './notification-routing.module';
import { SystemNotificationComponent } from './system-notification/system-notification.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { AngularEditorModule } from '@kolkov/angular-editor';
import { HttpClientModule } from '@angular/common/http'
import { MatTooltipModule } from '@angular/material/tooltip';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { SharedModule } from "../shared/shared.module";
import { ComposemailComponent } from './composemail/composemail.component';
import { EmailNotificationComponent } from './email-notification/email-notification.component';
import { NotificationEmailComponent } from './notification-email/notification-email.component';
import { EmailSubscriptionSettingComponent } from './email-subscription-setting/email-subscription-setting.component';
import { MatMenuModule } from '@angular/material/menu';

@NgModule({
    declarations: [SystemNotificationComponent, ComposemailComponent, EmailNotificationComponent, NotificationEmailComponent, EmailSubscriptionSettingComponent],
    imports: [
        CommonModule,
        NotificationRoutingModule,
        FormsModule,
        ReactiveFormsModule,
        NgMultiSelectDropDownModule,
        AngularEditorModule,
        HttpClientModule,
        MatTooltipModule,
        NgbModule,
        SharedModule,
        MatMenuModule,
    ]
})
export class NotificationModule { }