import { Component,ElementRef, HostListener, OnInit, Renderer2, ViewChild,  } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { HttpClient, HttpRequest } from '@angular/common/http'
import { NotificationService } from '../notification.service';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';

declare var $: any;

@Component({
  selector: 'app-system-notification',
  templateUrl: './system-notification.component.html',
  styleUrls: ['./system-notification.component.css'],
})
export class SystemNotificationComponent implements OnInit {
  @ViewChild('close') close: ElementRef;
  @ViewChild('systemNoticeModal') systemNoticeModal: any;
  @ViewChild('notifyclose') notifyclose : ElementRef;
  @ViewChild('myTextarea') myTextarea: ElementRef;


  public systemtable: any;
  systemheading: any;
  btndata: any;
  datatable1: any;
  datatable2: any;
  submitted: boolean;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  modaldata1: any;
  heading: any;
  heading1: any;
  heading2: any;
  userType: any;
  selectedAwaitCount: any;
  notifyListData: any = [];
  selectedEmailTitle: string;
  signalmashIcon: any = 'ST';
  signalmashHeader: any = 'Signalmash Team';
  selectedStatus: string;
  customerDetails: any = [];
  errMessage: any;
  responseMessage: any;
  customerLength: any = '';
  notifyCount: any = '';
  customerList: any = [];
  allCustomerList: any =[];
  // selectedItems: any = [];
  // selectedStatusItems: any;
  dropdownSettings1: IDropdownSettings = {};
  statusList: any = [];
  systemNoticeForm: FormGroup;
  notifyUsers: any = [];
  userlist: any;
  backupNotify: any = [];
  selectedDescription: string;
  idaccount: any =[];
  notifyCustomerListData: any = [];
  notificationCount: any;
  notification_color: string;
  keys: any = "";
  menushow: boolean = false;
  suspendedUserList: any = [];
  message = ''; 
  public settings = {};

constructor( private el: ElementRef,public route:ActivatedRoute,public router: Router, private http: HttpClient, public data: NotificationService,private fb: FormBuilder,private renderer: Renderer2) { 
  this.renderer.listen('window', 'click', (e: Event) => {
    if(this.menushow == true) {
      this.menushow = false;
      $('#' + this.keys).css('border', '');
      $('#' + this.keys).css('backgroundColor', '');
      this.router.navigate(['/system-notification'])
    }
  });
}
  ngOnInit(): void {
    this.selectedAwaitCount = '';
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.systemNoticeForm = this.fb.group({
      title: ['', [Validators.required, this.noWhitespaceValidator]],
      status: ['', [Validators.required,]],
      customers:['', [Validators.required]],
      body: ['', [Validators.required, this.noWhitespaceValidator]]
    });
    
  
    this.dropdownSettings = {
      singleSelection: false,
      idField: 'combinedId',
      textField: 'combinedText',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'combinedData',
      textField: 'title',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.data.get_system_notification().subscribe((result) =>{
    this.systemtable = result[0].systemheader
    this.systemheading = this.systemtable[0].heading
    this.btndata = this.systemtable[0].button
    this.datatable1 = this.systemtable[0].tableheaders
    this.modaldata1 = result[0].customersmodel
    this.heading = this.modaldata1[0].heading
    this.heading1 = this.modaldata1[0].heading1
    this.heading2 = this.modaldata1[0].heading2
    this.datatable2 = this.modaldata1[0].tableheaders
    });

    this.data.getSuspendedService().subscribe((res) => {
      this.suspendedUserList = res.data;
    });
    
    this.route.queryParams.subscribe(params => {
      this.keys = params['key'];
      if (!this.keys) {
        setTimeout(() => {
          this.data.displayNotificationForCustomer().subscribe((resUnseenNotify) => {
            const unreadNotifications = resUnseenNotify.data;
            for (let i = 0; i < unreadNotifications.length; i++) {
              const notification = unreadNotifications[i];
              if (notification.view_status !== 1) {
                const selectedElement = document.getElementById(notification.ns_key);
                if (selectedElement) {
                  const headerHeight = 160;
                  const topOffset = selectedElement.getBoundingClientRect().top + window.scrollY - headerHeight;
                  window.scrollTo({
                    top: topOffset,
                    behavior: 'smooth'
                  });
                }
                break;
              }
            }
          });
        }, 3000);
      }
    });

    this.alldata();
    this.getUsers();
    this.getStatus();
    this.displayNotificationForCustomer();
    this.notificationScrollIntoView();
    this.systemNoticeForm.get('body').setValue('');
    this.settings = {
      maxHeight: 100,
    };
  
  }

  noWhitespaceValidator(control: any) {
    const isWhitespace = (control.value || '').trim().length === 0;
    const isValid = !isWhitespace;
    return isValid ? null : { 'whitespace': true };
  }

  // Inside your component class
  onTitleBlur() {
    const titleControl = this.systemNoticeForm.get('title');
    if (titleControl.value) {
      titleControl.setValue(titleControl.value.trim());
    }
  }
  

// Inside your component class
onBodyBlur() {
  const bodyControl = this.systemNoticeForm.get('body');
  if (bodyControl.value) {
    bodyControl.setValue(bodyControl.value.trim());
  }
}



  getUsers(){
    this.data.getUsers("main").subscribe(res => {
      this.allCustomerList = res.data[0];
      // this.customerList = this.allCustomerList;
      this.allCustomerList.forEach(item => {
        item.combinedId = `${item.idaccount}-${item.iduser}`;
        item.combinedText = `${item.first_name}-${item.last_name}-${item.san}`;
      });
    });
  }

  displayNotificationForCustomer(){
      this.data.displayNotificationForCustomer().subscribe((res) => {
        if(res.status == 200){
          this.notifyCustomerListData = res.data;
          
          this.notificationCount=this.notifyCustomerListData.length;
          this.markNotificationsInView();
          // this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
  }
  formatDescription(description: string): string {
    return description.split('\n').join('<br>');
  }
  @HostListener('window:scroll', ['$event'])
  onScroll(event: any): void {
    this.markNotificationsInView();
  }
  markNotificationsInView(): void {
    this.notifyCustomerListData.forEach((notification) => {
      const notificationElement = document.getElementById(notification.ns_key);      
      if (this.isElementInViewport(notificationElement) && notification.view_status !== 1) {
        this.markNotificationAsRead(notification);
      }
    });
  }
  isElementInViewport(element: any): boolean {
    const rect = element.getBoundingClientRect();
    return (
      rect.top < (window.innerHeight || document.documentElement.clientHeight) &&
      rect.bottom > 0 &&
      rect.left < (window.innerWidth || document.documentElement.clientWidth) &&
      rect.right > 0
    );
  }
  markNotificationAsRead(notification: any): void {
    notification.view_status = 1;
    this.data.UpdateViewNotificationStatus(notification.ns_key).subscribe((res)=>{
      this.data.NotificationCountForCustomer().subscribe((resCount)=>{
        this.data.updateNotificationCount(resCount.data.length , resCount.data);
      });
    });
  }

  notificationScrollIntoView(){ 
    this.route.queryParams.subscribe(params => {
      this.keys = params['key'];
      if(this.keys){
        this.menushow = !this.menushow;
      setTimeout(() => { 
        const sectionElement = document.getElementById(this.keys);
        if (sectionElement) {
          const headerHeight = 115;
            const topOffset = sectionElement.getBoundingClientRect().top + window.scrollY - headerHeight;
            window.scrollTo({
              top: topOffset,
              behavior: "smooth"
            });
        }else {
          console.error(`Section with id ${this.keys} not found.`);
        }
        }, 3000);
      }
    });
  }

  getDate(dateString: string): string {
    return new Date(dateString).toLocaleDateString();
  }

  getStatus(){
    this.data.getStatus().subscribe(res => {
      if(res.status == 201){
        this.statusList = res.data;
        this.statusList.forEach(item => {
          item.combinedData = `${item.cs_id}-${item.show_status}`;
        });
      }
    });
  }

  alldata(){
    $('#basic-datatables3').dataTable().fnClearTable();
    $('#basic-datatables3').dataTable().fnDraw();
    $('#basic-datatables3').dataTable().fnDestroy();
    this.data.viewNotification().subscribe((res)=>{
      if(res.status == 200){ 
        this.notifyListData = res.data;
        this.notifyCount = this.notifyListData.length;
        $.getScript('./assets/tollfree.js');
        // this.responseMessage = res.message;
        // setTimeout(() => {
        //   this.responseMessage = "";
        // }, 5000);
      }
      else{
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  openSystemNoticeModal(title: string , description: string): void {
    this.selectedEmailTitle = title;
    this.selectedDescription = description.split('\n').join('<br>');
    $(this.systemNoticeModal.nativeElement).modal({ backdrop: 'static', keyboard: false });
    $(this.systemNoticeModal.nativeElement).modal('show');
  }
  closeSystemModal(){
    $(this.systemNoticeModal.nativeElement).modal('hide');
    $('.modal-backdrop').remove();
  }

  viewCustomer(idaccount : any):void{
    this.notifyUsers = [];
    this.data.getUsers('main').subscribe((res) => {
    $('#basic-datatables').dataTable().fnClearTable();
    $('#basic-datatables').dataTable().fnDraw();
    $('#basic-datatables').dataTable().fnDestroy();
      this.userlist = res.data[0];
      let allUser=idaccount.split(",");
      allUser.forEach((notifyUser) => {
      const notifySame = this.userlist.find((user) => user.idaccount == notifyUser);
        this.notifyUsers.push(notifySame);
      });
        this.customerLength = this.notifyUsers.length;
        $.getScript('./assets/tollfree.js');
    });
  }

  addStatus(e){
    const getField = (data: string) => {
		  switch (data) {
      case 'All':
      return 'user.is_deleted == 0 || user.is_deleted == 1 || user.is_deleted == 2';
			case 'Active Customer':
			  return 'user.is_deleted == 0';
			case 'Non-Active Customer':
			  return 'user.is_deleted == 1';
			case 'KYC Completed':
			  return 'user.kyc_verify_status == 1 && user.newUser_status ==1';
			case 'KYC Pending':
			  return 'user.kyc_verify_status == 2 && user.newUser_status ==1';
			case 'KYC Rejected':
			  return '(user.kyc_verify_status == 3 || user.kyc_verify_status == 4) && user.newUser_status ==1';
      case 'KYC Not Completed':
        return 'user.kyc_verify_status == 0 && user.newUser_status ==1'; 
      case 'Federal DNC Not Completed':
        return 'user.federal_status == 0 && user.newUser_status ==1';   
			case 'Federal DNC Completed':
			  return 'user.federal_status == 1 && user.newUser_status ==1';
			case 'Federal DNC Pending':
			  return 'user.federal_status == 2 && user.newUser_status ==1';
			case 'Federal DNC Rejected':
			  return '(user.federal_status == 3 || user.federal_status == 4) && user.newUser_status ==1';
      case 'Service Suspended':
        return 'Service Suspended';  
			default:
			  return '';
		  }
		};
	  if(this.systemNoticeForm.value.status.length >0){
      const field = getField(this.systemNoticeForm.value.status[0].title);
      if(field){
        this.customerList = [];
        this.systemNoticeForm.patchValue({
          customers:''
        });
        if(field == 'Service Suspended'){
          this.suspendedUserList.forEach((suspendedUser) => {
            const suspendSame = this.allCustomerList.find((user) => user.idaccount == suspendedUser.idaccount);
            if (suspendSame) {
              this.customerList.push(suspendSame);
            }
          });
        }
        else{
          let condition = eval(`(user) => ${field}`);
          this.customerList = this.allCustomerList.filter(condition); 
        }
      }
      else{
        return
      }
    }
    else{
      this.customerList = [];
      this.systemNoticeForm.patchValue({
        customers:''
      });
    }
  }

  onSubmit() {
      if(this.systemNoticeForm.invalid){
        this.submitted = true;
        return
      }
      else{
        this.data.sendNotification(this.systemNoticeForm.value).subscribe(res => {
          if(res.status == 201){
            this.responseMessage = res.message;
            this.close.nativeElement.click();
            this.systemNoticeForm.reset({
              body: ''
            });
            this.submitted = false;
            this.alldata();
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else{
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
  }

  clearform(){
    this.submitted = false;
    this.customerList = [];
    this.systemNoticeForm.reset({
      body:''
    });
  }

  truncatedescription(description: string, maxLength: number): string {
    return description.length > maxLength ? description.substring(0, maxLength) + '...' : description;
  }
  truncatetitle(ns_title: string, maxLength: number): string {
    return ns_title.length > maxLength ? ns_title.substring(0, maxLength) + '...' : ns_title;
  }
  buttonClick(event: any) {
    const textarea = this.myTextarea.nativeElement;
    const cursorPosition = textarea.selectionStart; 
    const currentValue = textarea.value; 
    let charToInsert = '';
    if (event.key === 'Enter') {
      charToInsert = '\n'; 
    } else if (event.key === ' ') {
      charToInsert = ' '; 
    } else {
      charToInsert = event.target.value; 
    }
    const newValue =
      currentValue.substring(0, cursorPosition) + 
      charToInsert +
      currentValue.substring(cursorPosition); 
    this.systemNoticeForm.get('body').setValue(newValue);
    const newCursorPosition = cursorPosition + charToInsert.length;
    const maxLength = textarea.value.length;
    const finalCursorPosition = Math.min(newCursorPosition, maxLength);
    textarea.setSelectionRange(finalCursorPosition, finalCursorPosition);
    textarea.focus();
  }
  toggleDescription(data: any) {
		data.moreShown = !data.moreShown;
	}
  ngOnDestroy()
  {
    this.notifyclose.nativeElement.click()
    this.close.nativeElement.click()
    this.closeSystemModal()
  }

}
