import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ObsiptrunkingService } from '../obsiptrunking.service';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
declare var $: any;
@Component({
  selector: 'app-bcid-did-add',
  templateUrl: './bcid-did-add.component.html',
  styleUrls: ['./bcid-did-add.component.css']
})
export class BcidDidAddComponent implements OnInit {
  @ViewChild('addBcidDid') addBcidDid: ElementRef;
  @ViewChild('sweetalert') sweetalert: ElementRef;
  tableheader: any;
  errMessage: any;
  responseMessage: any;
  public bcidDidForm: FormGroup;
  submitted: boolean = false;
  id: any;
  BcidEiddata: any;
  closeDropdownSelection = true;
  dropdownSettings: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  dropdownSettings2: IDropdownSettings = {};
  dropdownSettings3: IDropdownSettings = {};
  dropdownSettings4: IDropdownSettings = {};
  dropdownSettings5: IDropdownSettings = {};
  dropdownSettings6: IDropdownSettings = {};
  dropdownSettings7: IDropdownSettings = {};
  Bciddata: any;
  users: any = [];
  sipname: any;
  DID: any[];
  idaccount: any;
  iduser: any;
  type: any;
  numbertype: any = [];
  selectedItems = [];
  BCIDEid = [];
  numType = [];
  SipName = [];
  san = [];
  ID: any;
  show_filter: boolean = false;
  public filterUser: FormGroup;
  accountID = [];
  BCIDname = [];
  sipName = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  users1:any=[]

  constructor(public data: ObsiptrunkingService, private fb: FormBuilder, private userService: UsermanagementService) { }

  ngOnInit(): void {

    this.data.get_obsiptrunking().subscribe((res) => {
      this.tableheader = res[2].bcidDidAddTable
    });

    this.bcidDidForm = this.fb.group({
      san: ['', Validators.required],
      sipName: ['', Validators.required],
      bcidEid: ['', Validators.required],
      numberType: ['', Validators.required],
      did: ['', Validators.required]
    })

    this.filterUser = this.fb.group({
      from_date: [''],
      to_date: [''],
      sipname: [''],
      bcidEid: ['',],
      idaccount: [''],
      did: ['']
    });

    this.GetBCIDAddData()

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'userdata',
      textField: 'Users',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
    
    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'idsipts',
      textField: 'sip_name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings2 = {
      singleSelection: true,
      idField: 'name',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings3 = {
      singleSelection: false,
      idField: 'did',
      textField: 'did',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings4 = {
      singleSelection: true,
      idField: 'idbcideid',
      textField: 'eid_name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings5 = {
      singleSelection: true,
      idField: 'idsipts',
      textField: 'sip_name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings6 = {
      singleSelection: true,
      idField: 'idbcideid',
      textField: 'eid_name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings7 = {
      singleSelection: true,
      idField: 'userdata',
      textField: 'Users',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.getSan()
    this.getsipnamelist()
    this.GetBCIDEID()

    this.numbertype = [
      { name: 'NN' },
      { name: 'TF' }
    ];

  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
      this.filterUser.reset();
      Object.keys(this.filterUser.controls).forEach(key => {
        this.filterUser.get(key).setValue('');
      })
    }
  }

  checknumbertype(did: any) {
    let len = did.length - 10;
    let npa = did.slice(len, len + 3);
    let type: any = ''
    if ((npa == "800" || npa == "822" || npa == "833" || npa == "844" || npa == "855" || npa == "866" || npa == "877" || npa == "888")) {
      console.log("Number Type is Toll-free ", did);
      type = 'TF'
      return type;
    }
    else if (did.length == 10) {
      console.log("Number Type is Local Number ", did);
      type = 'NN'
      return type;
    }
  }

  getsipnamelist() {
    this.data.getsiptrunkingdetails().subscribe((res) => {
      if (res.status == 201) {
        this.sipname = res.data1;
        // this.sipname = res.data.map(item => ({
        //   userdata: `${item.iduser}-${item.idaccount}`,
        //   users: `${item.san} - ${item.first_name} ${item.last_name}`
        // }));
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    })
  }

  getSan() {
    this.userService.getidAccount().subscribe(res => {
      if (res.status == 200) {
        this.users1=res.data
        this.users = res.data;
        this.users = res.data.map(item => ({
          userdata: `${item.iduser}-${item.idaccount}`,
          Users: `${item.first_name} ${item.last_name}- (${item.san})`
        }));
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Users!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getNumber() {
    this.DID = []
    this.selectedItems = [];
    if (this.idaccount && this.type) {

      let payLoad: any = JSON.stringify({
        idaccount: this.idaccount,
        iduser: this.iduser,
        type: this.type
      })
      this.data.getNumber(payLoad).subscribe(res => {
        if (res.status == 201) {
          this.DID = res.data;
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = "Something went wrong with get Users!";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });

    }

  }

  GetBCIDEID() {
    this.data.BcidEidData('').subscribe((res) => {
      if (res.status == 201) {
        this.BcidEiddata = res.data
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  getIdBcid(data: any) {
    this.ID = data.idbcidoverride
  }

  GetBCIDAddData() {
    this.data.BcidAddData(JSON.stringify(this.filterUser.value)).subscribe((res) => {
      if (res.status == 201) {
        this.Bciddata = res.data
        $('#basic-datatables2').DataTable().clear();
        $('#basic-datatables2').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  selectsan(e: any) {
    this.iduser = e.userdata.split('-')[0]
    this.idaccount = e.userdata.split('-')[1]
  }

  selecttype(e: any) {
    this.type = e.name
  }

  onItemRemoved(event: any) {
    this.bcidDidForm.get('san')?.reset();
    this.bcidDidForm.get('sipName')?.reset();
    this.bcidDidForm.get('numberType')?.reset();
    this.bcidDidForm.get('did')?.reset();
    this.bcidDidForm.get('bcidEid')?.reset();
  }

  SaveBcidDID() {
    this.submitted = true;
    if (this.bcidDidForm.invalid) {
      return false
    } else {
      this.data.AddBcid(this.bcidDidForm.value).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.addBcidDid.nativeElement.click();
          this.GetBCIDAddData();
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  EditBcidDid(data: any) {
    this.DID = [];
    this.id = data.idbcidoverride;
    let didType = this.checknumbertype(data.did);
    // this.idaccount = data.idaccount
    // this.type = didType
    let payLoad: any = JSON.stringify({
      idaccount: data.idaccount,
      iduser: this.iduser,
      type: didType
    })
    this.data.getNumber(payLoad).subscribe(res => {
      if (res.status == 201) {
        this.DID = res.data;
        this.selectedItems = [{ did: data.did }];
        this.BCIDEid = [{ idbcideid: data.idbcideid, eid_name: data.eid_name }];
        this.numType = [{ name: didType }];
        this.SipName = [{ idsipts: data.idsipts, sip_name: data.sip_name }];
       this.san = this.users1.filter(user => user.idaccount == data.idaccount).map(user => ({
    userdata: this.iduser + '-' + user.idaccount,
    Users: `${user.first_name} ${user.last_name}- (${user.san})`
  }));
        this.DID.push({ did: data.did });
      }
    });
  }

  UpdateBcidAdd() {
    this.submitted = true;
    if (this.bcidDidForm.invalid) {
      return false
    } else {
      
      this.bcidDidForm.value.san = this.san?.[0]?.userdata.split("-")[1] || '';
      this.bcidDidForm.value.sipName = this.SipName?.[0]?.idsipts || '';
      this.bcidDidForm.value.bcidEid = this.BCIDEid?.[0]?.idbcideid || '';
      this.bcidDidForm.value.numberType = this.numType?.[0]?.name || '';
      let payLoad: any = ({
        data: this.bcidDidForm.value,
        id: this.id,
        Number: this.bcidDidForm.value.did
      });
      
      this.data.EditBCIDAdd(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.addBcidDid.nativeElement.click();
          this.GetBCIDAddData();
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  resetAdd() {
    this.submitted = false;
    this.bcidDidForm.reset();
    this.id = '';
    this.DID = [];
  }

  resetEdit() {
    this.submitted = false
    this.bcidDidForm.reset()
  }

  deleteBcidDid() {
    this.data.deleteBCIDAdd(this.ID).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message
        this.GetBCIDAddData();
        this.sweetalert.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = ""
        }, 5000);
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  Submitfilter() {
    this.submitted = false;
    if (this.filterUser.invalid) {
      return;
    } else {
      this.filterUser.value.idaccount = this.accountID?.[0]?.userdata.split("-")[1] || '';
      this.filterUser.value.bcidEid = this.BCIDname?.[0]?.idbcideid || '';
      this.filterUser.value.sipname = this.sipName?.[0]?.idsipts || '';
      this.data.BcidAddData(JSON.stringify(this.filterUser.value)).subscribe((res) => {
        if (res.status == 201) {
          this.Bciddata = res.data;
          $('#basic-datatables2').DataTable().clear();
          $('#basic-datatables2').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset();
    Object.keys(this.filterUser.controls).forEach(key => {
      this.filterUser.get(key).setValue('');
    })
    this.GetBCIDAddData();
  }

  messageshow() {
    const fromDate = this.filterUser.get('from_date').value;
    const toDate = this.filterUser.get('to_date').value;
    const currentDate = new Date();

    function checkForMidnight() {
      const now = new Date();

      if (now.getHours() === 0 && now.getMinutes() === 0) {
        currentDate.setDate(now.getDate());
        currentDate.setMonth(now.getMonth());
        currentDate.setFullYear(now.getFullYear());
      }
    }

    setInterval(checkForMidnight, 60 * 1000);
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterUser.get('from_date').setErrors(null);
      this.filterUser.get('to_date').setErrors(null);
    }
  }

  onSubmit() {
    this.Submitfilter();
  }

  downloadCSV() {
    setTimeout(() => {
      this.filterUser.value.idaccount = this.accountID?.[0]?.userdata?.split('-')[1] ?? '';
      this.data.BcidAddData(JSON.stringify(this.filterUser.value)).subscribe((res) => {
        if (res.status == 201) {
          let bciddideid = res.data
          if (bciddideid.length > 0) {
            let NewFilteredRes = bciddideid.map((item) => {
              const { san, did, eid_name, sip_name, created_at } = item;
              const formattedDate = created_at ? new Date(created_at).toLocaleDateString('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).split(/[-\/]/).join(created_at.includes('-') ? '-' : '/') : 'N/A';
              return {
                "SAN": san,
                "SIP Name": sip_name,
                "EID Name": eid_name,
                "DID": did,
                'Created Date': formattedDate
              };
            });
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
            const workbook: XLSX.WorkBook = { Sheets: { 'Bcid Did': worksheet }, SheetNames: ['Bcid Did'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer, 'Bcid Did');
          } else {
            this.errMessage = 'No Record Available'
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }, 1000);
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  ngOnDestroy() {
    this.addBcidDid.nativeElement.click();
    this.sweetalert.nativeElement.click();
  }
}
