import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ObsiptrunkingService } from '../obsiptrunking.service';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-bcid-eid-setting',
  templateUrl: './bcid-eid-setting.component.html',
  styleUrls: ['./bcid-eid-setting.component.css']
})
export class BcidEidSettingComponent implements OnInit {
  @ViewChild('addsetting') addsetting: ElementRef;
  @ViewChild('sweetalert') sweetalert: ElementRef;
  tableheader: any;
  errMessage: any;
  responseMessage: any;
  public bcideidForm: FormGroup;
  submitted: boolean = false;
  id: any;
  BcidEiddata: any;
  BcidEiddata1: any;
  BcidEiddata2: any;
  ID: any;
  show_filter: boolean = false;
  public filterUser: FormGroup;
  dropdownSettings: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  BCIDEid = [];
  BCIDname = [];
  constructor(public data: ObsiptrunkingService, private fb: FormBuilder) { }

  ngOnInit(): void {

    this.data.get_obsiptrunking().subscribe((res) => {
      this.tableheader = res[1].bcideidTable
    });

    this.filterUser = this.fb.group({
      from_date: [''],
      to_date: [''],
      EIDName: [''],
      bcidEid: ['',],
    });

    this.bcideidForm = this.fb.group({
      eidName: ['', [Validators.required, Validators.pattern(/^(?!\s*$).+$/), Validators.maxLength(255)]],
      eid: ['', [Validators.required, Validators.pattern(/^(?!\s*$).+$/), Validators.maxLength(255)]]
    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'eid_name',
      textField: 'eid_name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'eid',
      textField: 'eid',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.GetBCIDEIDData()

  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
      this.filterUser.reset();
      Object.keys(this.filterUser.controls).forEach(key => {
        this.filterUser.get(key).setValue('');
      })
    }
  }

  getdeleteID(data: any) {
    this.ID = data.idbcideid
  }

  GetBCIDEIDData() {
    this.data.BcidEidData(JSON.stringify(this.filterUser.value)).subscribe((res) => {
      if (res.status == 201) {
        this.BcidEiddata = res.data
        this.BcidEiddata1 = res.data
        this.BcidEiddata2 = res.data
        $('#basic-datatables7').DataTable().clear();
        $('#basic-datatables7').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  AddBcidEid() {
    this.submitted = true
    if (this.bcideidForm.invalid) {
      return false
    } else {
      this.data.AddBcidEid(this.bcideidForm.value).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message
          this.addsetting.nativeElement.click()
          this.GetBCIDEIDData()
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }
  }

  editSipBCID(data: any) {
    this.id = data.idbcideid
    this.bcideidForm.patchValue({
      eidName: data.eid_name,
      eid: data.eid,
    })
  }

  UpdateBcidEid() {
    this.submitted = true
    if (this.bcideidForm.invalid) {
      return false
    } else {
      let payLoad: any = ({
        data: this.bcideidForm.value,
        id: this.id,
      });
      this.data.EditBCIDEID(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message
          this.addsetting.nativeElement.click()
          this.GetBCIDEIDData()
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }
  }

  resetAdd() {
    this.submitted = false
    this.bcideidForm.reset();
    this.id = '';
  }

  resetEdit() {
    this.submitted = false
    this.bcideidForm.reset();
  }

  deleteData() {
    this.data.deleteBCIDEID(this.ID).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message
        this.GetBCIDEIDData();
        this.sweetalert.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = ""
        }, 5000);
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  Submitfilter() {
    this.submitted = false;
    if (this.filterUser.invalid) {
      return;
    } else {
      this.filterUser.value.bcidEid = this.BCIDEid?.[0]?.eid || '';
      this.filterUser.value.EIDName = this.BCIDname?.[0]?.eid_name || '';
      this.data.BcidEidData(JSON.stringify(this.filterUser.value)).subscribe((res) => {
        if (res.status == 201) {
          this.BcidEiddata = res.data;
          $('#basic-datatables7').DataTable().clear();
          $('#basic-datatables7').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset();
    Object.keys(this.filterUser.controls).forEach(key => {
      this.filterUser.get(key).setValue('');
    })
    this.GetBCIDEIDData();
  }

  messageshow() {
    const fromDate = this.filterUser.get('from_date').value;
    const toDate = this.filterUser.get('to_date').value;
    const currentDate = new Date();

    function checkForMidnight() {
      const now = new Date();

      if (now.getHours() === 0 && now.getMinutes() === 0) {
        currentDate.setDate(now.getDate());
        currentDate.setMonth(now.getMonth());
        currentDate.setFullYear(now.getFullYear());
      }
    }

    setInterval(checkForMidnight, 60 * 1000);
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterUser.get('from_date').setErrors(null);
      this.filterUser.get('to_date').setErrors(null);
    }
  }

  onSubmit() {
    this.Submitfilter();
  }

  ngOnDestroy() {
    this.addsetting.nativeElement.click();
    this.sweetalert.nativeElement.click();
  }

}
