import { Component, OnInit } from '@angular/core';
import { ObsiptrunkingService } from '../obsiptrunking.service';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';


declare var $: any;

@Component({
  selector: 'app-cpsconfiguration',
  templateUrl: './cpsconfiguration.component.html',
  styleUrls: ['./cpsconfiguration.component.css']
})
export class CpsconfigurationComponent implements OnInit {
  userInfo: any;
  public cpsForm: FormGroup;
  CSP: any=[];
  dropdownSettings: IDropdownSettings = {};
  public submitted:boolean = false
  selectedItem: any = [];
  errMessage: any;
  responseMessage: any;
  CPS: any = [];
  accountID:any=[];
  
  
  constructor(public data: ObsiptrunkingService, public fb: FormBuilder) { }

  ngOnInit(): void {
    
    this.data. get_obsiptrunking().subscribe((result) => {
      this.userInfo = result[0].tableheaders;
    });

    this.cpsForm = this.fb.group({
      san:['',Validators.required],
      // cps:['',Validators.required]
      cps: ['', [ Validators.required,Validators.maxLength(5),]]
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'userdata',
      textField: 'Users',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
    this. CSPData()
  }

  CSPData(){
    this.data.getCPSData().subscribe((res)=>{
      if(res.status == 201){
        this.CSP = res.data.map(item => ({
          ...item,
          cps: item.cps == null || item.cps === '' ? 0 : item.cps
        }));
         this.accountID = res.data.sort((a, b) => a.san - b.san).map(item => ({
          userdata: `${item.idaccount}`,
          Users: `${item.firstname} ${item.lastname}- (${item.san})`
        }));
        $('#basic-datatables').DataTable().clear();
        $('#basic-datatables').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        // this.responseMessage = res.message
        // setTimeout(() => {
        //   this.responseMessage = ""
        // }, 5000);
      }else{
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })

  }

  SetValue(){
    if (this.selectedItem.length !== 0) {
      let idaccount = this.selectedItem[0].userdata;
      let matched = this.CSP.find(item => item.idaccount == idaccount);
      if (matched) {
        let cps = matched.cps
        this.cpsForm.patchValue({
          cps : cps
        }) 
      } else {
        this.cpsForm.patchValue({
          cps : 0
        })     
      }
    }
  }
  
  editCsp(san:any,idaccount:any,csp:any){
    this.selectedItem = []
    // this.selectedItem = [{ san: san, idaccount: idaccount }];
     this.selectedItem =  this.accountID.filter(user => user.userdata == idaccount).map(user => ({
    userdata: user.userdata,
    Users: `${user.Users} `
  }));
    this.cpsForm.patchValue({
      cps:csp
    })
    
  }

  UpdateCPS(){
    this.submitted = true
    if(this.cpsForm.invalid){
      return false
    }else{
      this.cpsForm.value.san = this.selectedItem[0].userdata
      this.data.UpdateCPSdata(this.cpsForm.value).subscribe((res)=>{
        if(res.status == 201){
          this.Reset()
          this.CSPData()
          this.responseMessage = res.message
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
          }else{
             this.errMessage = res.message
             setTimeout(() => {
               this.errMessage = ""
             }, 5000);
          }
      })
    }
  }

  Reset(){
    this.submitted = false
    this.cpsForm.reset()
    this.selectedItem = []
  }

  validateQuantity(event: any) {
    let input = event.target.value;
    input = input.replace(/[^0-9]/g, '');
    event.target.value = input;
    this.cpsForm.get('cps')?.setValue(input, { emitEvent: false });
  }

}