import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CpsconfigurationComponent } from './cpsconfiguration/cpsconfiguration.component';
import { SiptrunkingsettingComponent } from './siptrunkingsetting/siptrunkingsetting.component';
import { SiptrunkingprofileComponent } from './siptrunkingprofile/siptrunkingprofile.component';
import { BcidDidAddComponent } from './bcid-did-add/bcid-did-add.component';
import { BcidEidSettingComponent } from './bcid-eid-setting/bcid-eid-setting.component';


const routes: Routes = [
  {
    path: '',
    children: [
        {
            path: 'cps-configuration',
            component: CpsconfigurationComponent,
            data: {
                title: 'OB SIP Trunking',
                urls: [
                    {
                        title: 'OB SIP Trunking',
                    },
                    {
                        title: 'CPS Configuration'
                    }
                ]
            }
        },
        {
          path: 'siptrunking-setting',
          component: SiptrunkingsettingComponent,
          data: {
              title: 'OB SIP Trunking',
              urls: [
                  {
                      title: 'OB SIP Trunking',
                  },
                  {
                      title: 'SIP Trunking Setting'
                  }
              ]
          }
      },
      {
        path: 'siptrunking-profile',
        component: SiptrunkingprofileComponent,
        data: {
            title: 'OB SIP Trunking',
            urls: [
                {
                    title: 'OB SIP Trunking',
                },
                {
                    title: 'SIP Trunking Profile'
                }
            ]
        }
    },
     {
                path: 'bcid-did-add',
                component: BcidDidAddComponent,
                data: {
                    title: 'OB SIP Trunking',
                    urls: [
                        {
                            title: 'OB SIP Trunking',
                        },
                        {
                            title: 'BCID DID Add'
                        }
                    ]
                }
            },
            {
                path: 'bcid-eid-setting',
                component: BcidEidSettingComponent,
                data: {
                    title: 'OB SIP Trunking',
                    urls: [
                        {
                            title: 'OB SIP Trunking',
                        },
                        {
                            title: 'BCID EID Setting'
                        }
                    ]
                }
            },
        
    ]
}
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class ObsiptrunkingRoutingModule { }
