import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';



@Injectable({
  providedIn: 'root'
})
export class ObsiptrunkingService extends AppService<any> {

  constructor(public http: HttpClient) {
    super(http)
  }

  get_obsiptrunking(): Observable<any> {
    return this.http.get('./assets/obsip-trunking.json')
  }

  @LoaderEnabled()
  getCPSData(): Observable<any> {
    this.appmod = "getcps";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  UpdateCPSdata(data: any): Observable<any> {
    this.appmod = "updatecps";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  SIPTrunkingData(): Observable<any> {
    this.appmod = "getSipTrunking";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  AddSip(data: any): Observable<any> {
    this.appmod = "addsip";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  EditSIPTrunking(data: any): Observable<any> {
    this.appmod = "editSip";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deleteSIP(id: any): Observable<any> {
    let apiUrl = environment.SERVER + 'deletesip';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { ID: id } });
  }

  @LoaderEnabled()
  getsiptrunkingdetails(): Observable<any> {
    this.appmod = "get_sipdetails";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  submitsipprofile(data: any): Observable<any> {
    this.appmod = "saveSipProfile";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateSipprofile(data: any): Observable<any> {
    this.appmod = "updateSip";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deleteSipprofile(idSIP): Observable<any> {
    let apiUrl = environment.SERVER + 'deleteSipprofile';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { ID: idSIP } });
  }

  @LoaderEnabled()
  applyFilter(data?: any): Observable<any> {
    this.appmod = "getsiptrunkingfilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getcount(id?: any): Observable<any> {
    this.appmod = "get_totalcount";
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  BcidEidData(data?:any): Observable<any> {
    this.appmod = "getBcidEid";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  BcidEid(): Observable<any> {
    this.appmod = "getBcidEid";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  AddBcidEid(data: any): Observable<any> {
    this.appmod = "addBcidEid";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  EditBCIDEID(data: any): Observable<any> {
    this.appmod = "editBcidEid";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deleteBCIDEID(id: any): Observable<any> {
    let apiUrl = environment.SERVER + 'deleteBcidEid';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { ID: id } });
  }

  @LoaderEnabled()
  BcidAddData(data?:any): Observable<any> {
    this.appmod = "getBcidDID";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  AddBcid(data: any): Observable<any> {
    this.appmod = "addBcidDID";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  EditBCIDAdd(data: any): Observable<any> {
    this.appmod = "editBcidDID";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deleteBCIDAdd(id: any): Observable<any> {
    let apiUrl = environment.SERVER + 'deleteBcidDid';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { ID: id } });
  }

  @LoaderEnabled()
  getNumber(data?: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'getnumber';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }


}





