import { I } from '@angular/cdk/keycodes';
import { Component, OnInit  } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { ResellerService } from '../reseller.service';

declare var $: any;

@Component({
  selector: 'app-commission-tier',
  templateUrl: './commission-tier.component.html',
  styleUrls: ['./commission-tier.component.css'],
  
})
export class CommissionTierComponent implements OnInit {
  responseMessage: any = "";
  errMessage: any = "";
  submitted: boolean = false;

  tierData: string;
  idPlan: string;
  planId: string;
  planName: any;
  planName1: any;
  planNameOnly: any;
  getPlan: any;
  tierRec: any;
  tierRec1: any;
  idtier: any;
  getTier: any = [];
  noTier = 1
  from_amount = "from_amount"
  to_amount = 'to_amount'
  commission = 'commission'
  tier = 'tier'
  tier1 = 'tier1'
  disable: any = true;

  newItem: any = { from_amount: '', to_amount: '', commission: '', tier: this.noTier > 1 ? this.noTier : "" };
  tiers: Array<any> = [
    { from_amount1: '', to_amount1: '', commission1: '', tier: 'tier1' },
  ];

  formGroup: {
    from_amount1: FormControl; to_amount1: FormControl; commission1: FormControl; tier1: FormControl;
  };
  x: any = 1;
  current_id: any[] = [];
  obj_format = { from_amount: 0, to_amount: 0, commission: 0, id_plan: '', tier: '', insert: 1 }
  planNamef: string;
  errmessage: string = "";
  addTier: boolean =false;
  TiedForm: any;
  formData: any = [];
  UpdateNow: boolean = false;
  adTierBtn: boolean = false;

  constructor(public data: ResellerService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router) { }
  public TierForm: FormGroup;

  ngOnInit(): void {
    this.addTier = false;
    this.UpdateNow = false;
    this.disable = false;
    this.adTierBtn = false;
    this.current_id = [];
    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idPlan = params.get('id');
      this.planName = this.idPlan.split('-').join(' ');
      this.planName1 = this.planName.split(" ");
      this.planName1.shift();
      this.planNameOnly = this.planName1.join(" ");
      this.planId = this.idPlan.split('-')[0]
    });

    this.getPlanTier();
  }

  addTiers() {
    this.addTier = true;
    this.disable = true;
    let crr_index = this.getTier.length + 1; 
    let new_Obj: any = {}
    new_Obj['id_plan'] = this.getTier.length == 0 ? '' : this.getTier[0].id_plan,
      new_Obj['from_amount' + crr_index] = '',
      new_Obj['to_amount' + crr_index] = '',
      new_Obj['commission' + crr_index] = '',
      new_Obj['tier'] = 'tier' + crr_index,
      this.getTier.push(new_Obj);
      this.TierForm = this.fb.group(this.getTier);
    this.addTierdisable()  
  }

  addTierdisable(){
    Object.keys(this.getTier).forEach((name:any) => {
      Object.keys(this.getTier[name]).forEach(value => {
        let val = this.getTier[name][value];
        if(!val){
         this.adTierBtn = true;
        }
      });    
    });
  }

  // get commission tier details
  getPlanTier() {
    this.data.getCommissionTier(this.planId).subscribe(res => {
      if (res.status == 200) {
        this.getTier = res.data;
        $.getScript('./assets/table.js');
        this.ptvalue();
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  ptvalue() {
    const newData = {}
    const newKey = {}
    if (this.getTier.length == 0) {
      this.addTiers();
    }
    else {
      Object.keys(this.getTier).forEach(name => {
        this.idtier = name;
        Object.keys(this.getTier[name]).forEach(value => {
          let newValue = value + (parseInt(name) + 1);
          newKey[newValue] = ['', Validators.required];
          newData[newValue] = this.getTier[name][value];
        });
      });
      this.TierForm = this.fb.group(newKey);
      this.TierForm.patchValue(newData);
      setTimeout(() => {
        this.setValidators();
      }, 2000);
    }
  }

  
  setValidators(){
    Object.keys(this.getTier).forEach((name:any) => {
      let FromValue= Number((<HTMLInputElement>document.getElementById('from' + name)).value);
      let toVal = Number((<HTMLInputElement>document.getElementById('to' + name)).value);
      let commVal = Number((<HTMLInputElement>document.getElementById('comm' + name)).value);
      if(name > 0){
        let toptoValue= Number((<HTMLInputElement>document.getElementById('to' + (name-1))).value);
        if(FromValue >= toVal){
          $('#to' + name).css('border', '1px solid red');
          this.disable = true;
          this.errmessage="To Amount should be greater than From Amount";
        }
        if(FromValue <= toptoValue){
          $('#from' + name).css('border', '1px solid red');
          this.disable = true;
          this.errmessage="From Amount should be greater than top To Amount !";
        }
      }
      if(name == 0 && FromValue >= toVal){
        $('#from' + name).css('border', '1px solid red');
        this.disable = true;
        this.errmessage="From Amount should be greater than To Amount";
      }     
      if(commVal < 0 || commVal > 100) {
        $('#comm' + name).css('border', '1px solid red');
        this.disable = true;
        this.errmessage="Commission% should be less than 100 And greater than 0";
      }
    });

    Object.keys(this.getTier).forEach((name:any) => { 
      let sname = Number(name);
      sname = sname+1;
      this.getTier[name].tier = "tier"+sname;
      if(this.getTier.length == sname){
        this.TierForm = this.fb.group(this.getTier);
      }
    });
  }

  // save tier1 records....
  onsaveTier(data) {
    if (data.invalid) {
      this.submitted = true;
      return;
    }
    else {
      Object.keys(this.getTier).forEach((name:any) => {
        let FromValue= Number((<HTMLInputElement>document.getElementById('from' + name)).value);
        let toVal = Number((<HTMLInputElement>document.getElementById('to' + name)).value);
        let commVal = Number((<HTMLInputElement>document.getElementById('comm' + name)).value);
      
        if(!FromValue || !toVal || commVal < 0 || commVal > 100){
          
          if(commVal < 0 || commVal > 100){
            $('#comm' + name).css('border', '1px solid red');
            this.errmessage ="Commission% should be less than 100 And greater than 0"
            this.UpdateNow = false;
          }
          if(!FromValue){
            $('#from' + name).css('border', '1px solid red');
            this.UpdateNow = false;
          }
          if(!toVal){
            $('#to' + name).css('border', '1px solid red');
            this.UpdateNow = false;
          }
          this.errmessage ="All Field Are Required !"
  
          if(name == 0 && toVal!==0){
            if(FromValue == 0){
              $('#from' + name).css('border', '');
              this.UpdateNow = false;
              this.errmessage =""
            }
          }
          else{
            this.disable = true;
            return;
          }
        } 

        if(FromValue >= toVal){
          $('#from' + name).css('border', '1px solid red');
          this.disable = true;
          this.errmessage ="From amount should be less than their To amount !"
          return;
        }
        if(name > 0){
          let ToptoVal = Number((<HTMLInputElement>document.getElementById('to' + (name-1))).value);
          if(FromValue <= ToptoVal){
            $('#from' + name).css('border', '1px solid red');
            this.disable = true;
            this.errmessage ="From amount should be greater than top To amount !"
            return;
          }
        }

        let sname = Number(name);
        sname = sname+1;
        if(this.getTier.length == sname && this.disable == false){
          this.UpdateNow = true;
        }
      });
     
      if(this.UpdateNow == true){
        this.tierRec = JSON.stringify({
          tierData: data.value,
          idPlan: this.planId,
        })
      
        this.data.saveCommissionTier(this.tierRec).subscribe(res => {
          if (res.status == 200) {
            this.ngOnInit();
            this.responseMessage = res.message;
            data.reset();
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 3000);
          }
        })
      }
    }
  }

  // onupdate tiers....
  onupdateTier(data) {
    if (data.invalid) {
      this.submitted = true;
      return;
    }
    else {
      Object.keys(this.getTier).forEach((name:any) => {
        let FromValue= Number((<HTMLInputElement>document.getElementById('from' + name)).value);
        let toVal = Number((<HTMLInputElement>document.getElementById('to' + name)).value);
        let commVal = Number((<HTMLInputElement>document.getElementById('comm' + name)).value);
       
        if(!FromValue || !toVal || commVal < 0 || commVal > 100){
          
          if(commVal < 0 || commVal > 100){
            $('#comm' + name).css('border', '1px solid red');
            this.errmessage ="Commission% should be less than 100 And greater than 0"
            this.UpdateNow = false;
          }
          if(!FromValue){
            $('#from' + name).css('border', '1px solid red');
            this.UpdateNow = false;
          }
          if(!toVal){
            $('#to' + name).css('border', '1px solid red');
            this.UpdateNow = false;
          }
          this.errmessage ="All Field Are Required !"
         
          if(name == 0 && toVal!==0){
            if(FromValue == 0){
              $('#from' + name).css('border', '');
              this.UpdateNow = false;
              this.errmessage =""
            }
          }
          else{
            this.disable = true;
            return;
          }
        } 

        if(FromValue >= toVal){
          $('#from' + name).css('border', '1px solid red');
          this.disable = true;
          this.errmessage ="From Amount should be less than their To Amount !"
          return;
        }
        if(name > 0){
          let ToptoVal = Number((<HTMLInputElement>document.getElementById('to' + (name-1))).value);
          if(FromValue <= ToptoVal){
            $('#from' + name).css('border', '1px solid red');
            this.disable = true;
            this.errmessage ="From Amount should be greater than top To Amount !"
            return;
          }
        }

        let sname = Number(name);
        sname = sname+1;
        if(this.getTier.length == sname && this.disable == false){
          this.UpdateNow = true;
        }
      });
      // loop end
      if(this.UpdateNow == true){
        this.TiedForm = "";
        if(this.addTier == true){
          this.tierRec1 = JSON.stringify({
            tierData: data.value,
            idPlan: this.planId,
          })
          this.TiedForm = this.tierRec1;
        }
        else{
          this.TiedForm = JSON.stringify({
            tierData: this.current_id
          });   
        
         if(this.current_id.length == 0){
          this.disable = true;
          this.UpdateNow = false;
          this.errmessage ="Please Change Any Record !"
          return;
         }
        }
          this.data.updateCommPTier(this.TiedForm).subscribe(res => {
            if (res.status == 200) {
              this.ngOnInit();
              this.responseMessage = res.message;
              setTimeout(() => {
                this.responseMessage = "";
              }, 3000);
            }
            else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 3000);
            }
          })
      }
    }
  }

  deleteTier(id: any, index: number) {
    if (confirm("Are you sure you want delete tier!")) {
      if (id) {
        this.data.ondeleteTier(id).subscribe(res => {
          if (res.status == 201) {
            this.ngOnInit();
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            });
          }
        })
      }
      else{
        this.getTier.splice(index, 1);
        this.TierForm = this.fb.group(this.getTier);
        Object.keys(this.getTier).forEach((name:any) => {
          let hasKey1 = this.getTier[name].hasOwnProperty('from_amount');
          let hasKey2 = this.getTier[name].hasOwnProperty('to_amount');
          let hasKey3 = this.getTier[name].hasOwnProperty('commission');
          if(hasKey1 == false || hasKey2 == false || hasKey3 == false){
            this.adTierBtn = true;
            this.disable = true;
          }
          else{
            this.adTierBtn = false;
            this.disable = false;
          }
        });

        Object.keys(this.getTier).forEach((name:any) => { 
          let sname = Number(name);
          sname = sname+1;
          this.getTier[name].tier = "tier"+sname;
          if(this.getTier.length == sname){
            this.TierForm = this.fb.group(this.getTier);   
          }
        });
      }
    }
    else {
      return
    }
  }

  validateNumber(e: any) {
    let digit = e.target.id.match(/[\d\.]+/g);
    let cid = digit[0];
    let commVal= $('#comm' + cid).val();
    
    let data = e.target.value;
    const key = e.key;
   
   let indx= data.indexOf('.');
    if(indx !== -1){
      if(key == "Backspace" || key == "Delete") {
        return true;
      }
      if(data.length >= (indx+3)){
        // e.preventDefault();
        return false;
      }
    }

    if(commVal > 100 || commVal < 0){
      $('#comm' + cid).css('border', '1px solid red');
      this.disable = true;
      this.adTierBtn = true;
      this.errmessage="Commission% should be less than 100 And greater than 0";
    }
    else{
      $('#comm' + cid).css('border', '');
      this.disable = false;
      this.adTierBtn = false;
      this.errmessage="";
      if(cid > 0){
        let FromValue = Number($('#from' + cid).val());
        let toVal = Number($('#to' + cid).val());
        let toptoVal = Number($('#to' + (cid-1)).val());

        if(FromValue >= toVal){
          $('#to' + cid).css('border', '1px solid red');
          this.disable = true;
          this.adTierBtn = true;
          this.errmessage="To Amount should be greater than From Amount";
          $('#from' + cid).css('border', '');
        }

        if(toVal > 0 && FromValue <= toptoVal){
          $('#from' + cid).css('border', '1px solid red');
          this.disable = true;
          this.adTierBtn = true;
          this.errmessage="From Amount should be greater than previous To Amount";
          $('#to' + cid).css('border', '');
        }
      }
    }
   
    Object.keys(this.getTier).forEach((name:any) => {
      let FromValue= $('#from' + name).val();
      let toVal= $('#to' + name).val();
      let commVal= $('#comm' + name).val();      
    
      if(!FromValue || !toVal || !commVal || (toVal < 0) || (commVal < 0) || (commVal > 100)){
        this.disable = true;
        this.adTierBtn = true; 
      }
    });

  }

  checkValue(e: any, index: any) {
    let eId= e.target.id;
    let digit = e.target.id.match(/[\d\.]+/g);
    let cid = digit[0];

    let findToVal = eId.search("to");
    if(findToVal!== -1){
      let FromValue = Number($('#from' + cid).val());
      let toVal = Number($('#to' + cid).val());
      if(FromValue >= toVal){
        $('#to' + cid).css('border', '1px solid red');
        this.disable = true;
        this.adTierBtn = true;
        this.errmessage="To Amount should be greater than From Amount";
        $('#from' + cid).css('border', '');
      }
      if(cid > 0){
        let toptoVal = Number($('#to' + (cid-1)).val());  
        if(toVal > 0 && FromValue <= toptoVal){
          $('#from' + cid).css('border', '1px solid red');
          this.disable = true;
          this.adTierBtn = true;
          this.errmessage="From Amount should be greater than previous To Amount";
          $('#to' + cid).css('border', '');
        }
        if(toVal > FromValue && FromValue > toptoVal){
          $('#to' + cid).css('border', '');
          this.disable = false;
          this.adTierBtn = false;
          this.errmessage ="";
        }
      }
    }

    let findFromVal = eId.search("from");
    if(findFromVal!== -1 && cid > 0){
      let toptoValue = Number($('#to' + (cid-1)).val());
      let toValue = Number($('#to' + cid).val());
      let currentV = Number($('#from' + cid).val());
      if(currentV <= toptoValue){
        $('#from'+ cid).css('border', '1px solid red');
        $('#to'+ cid).css('border', '');
        this.disable = true;
        this.adTierBtn = true;
        this.errmessage="From Amount should be greater than previous To Amount";
      }
      else{
        $('#from'+ cid).css('border','');
        this.disable = false;
        this.adTierBtn = false;
        this.errmessage="";
      }
      if(toValue && currentV >= toValue){
        this.disable = true;
        this.adTierBtn = true;
        $('#to'+ cid).css('border', '1px solid red');
        $('#from'+ cid).css('border', '');
        this.errmessage="To Amount should be greater than From Amount";
      }
      
      if(currentV < toValue && currentV > toptoValue){
        $('#to'+ cid).css('border', '');
        $('#from'+ cid).css('border', '');
        this.errmessage="";
        this.disable = false;
        this.adTierBtn = false;
      }
    }
    if(cid == 0){
      let currentV = Number($('#from' + cid).val());
      let toValue = Number($('#to' + cid).val());

      if(currentV >= toValue){
        $('#from'+ cid).css('border', '1px solid red');
        $('#to' + cid).css('border', '');
        this.disable = true;
        this.adTierBtn = true;
        this.errmessage="From Amount should be less than To Amount";
      }
      else{
        $('#from'+ cid).css('border', '');
        $('#to'+ cid).css('border', '');
        this.disable = false;
        this.adTierBtn = false;
        this.errmessage="";
      }
    }

    Object.keys(this.getTier).forEach((name:any) => {
      let FromValue = $('#from' + name).val();
      let toVal = $('#to' + name).val();
      let commVal = $('#comm' + name).val();
     
      if(!FromValue || !toVal || !commVal || (toVal < 0) || (commVal < 0) || (commVal > 100)){
        this.disable = true;
        this.adTierBtn = true; 
      }
    });
  }

  get_Id_tier(i: any, value: any, type: number) {
    if (this.getTier[i]) {
      if (this.current_id.length >= 1) {
        const found = this.current_id.find(element => element.id_tier == this.getTier[i].id_tier);
        if (!found) {
          if (type == 0) {
            this.getTier[i].from_amount = parseInt(value)
          }
          else if (type == 1) {
            this.getTier[i].to_amount = parseInt(value)
          }
          else if (type == 2) {
            this.getTier[i].commission = parseFloat(value)
          }
          this.current_id.push(this.getTier[i])
        }
        else {
          if (type == 0) {
            this.getTier[i].from_amount = parseInt(value)
          }
          else if (type == 1) {

            this.getTier[i].to_amount = parseInt(value)
          }
          else if (type == 2) {

            this.getTier[i].commission = parseFloat(value)
          }
        }

      } else {
        if (type == 0) {
          this.getTier[i].from_amount = parseInt(value)
        }
        else if (type == 1) {

          this.getTier[i].to_amount = parseInt(value)
        }
        else if (type == 2) {
          this.getTier[i].commission = parseFloat(value)
        }
        this.current_id.push(this.getTier[i])
      }
    } else {

      if (type == 0) {
        this.obj_format.from_amount = parseInt(value)
      } else if (type == 1) {
        this.obj_format.to_amount = parseInt(value)
      } else if (type == 2) {
        this.obj_format.commission = parseFloat(value)
      }
      this.obj_format.id_plan = this.planId
      this.obj_format.tier = "tier" + (i + 1)

      if (this.obj_format.to_amount > 0 && this.obj_format.from_amount > 0 && this.obj_format.commission > 0)
        this.current_id.push(this.obj_format)
        
    }
  }

  Rreset(){ 
    this.disable = true;
    this.adTierBtn = true;
    this.errmessage="";
    Object.keys(this.getTier).forEach((name:any) => {
    (<HTMLInputElement>document.getElementById('from' + name)).value = "";
    (<HTMLInputElement>document.getElementById('to' + name)).value = "";
    (<HTMLInputElement>document.getElementById('comm' + name)).value = "";
    $('#from'+ name).css('border','');
    $('#to'+ name).css('border','');
    $('#comm'+ name).css('border','');
    });
  }
}
