import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { AbstractControl, FormArray, FormBuilder, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { ResellerService } from '../reseller.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
declare var $: any;

@Component({
  selector: 'app-resellerlink',
  templateUrl: './resellerlink.component.html',
  styleUrls: ['./resellerlink.component.css']
})

export class ResellerlinkComponent implements OnInit {
  @ViewChild('tariffordering') tariffordering: ElementRef;
  Resellerlink: any = [];
  errMessage: any = "";
  responseMessage: any = "";
  show_filter: boolean = false;
  public filterUser: FormGroup;
  submitted: boolean = false;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  Urltariff: any = []
  terriforder: any = []
  linkid: any;
  iduser: any;
  defaultOrder = [];
  selectedorder: any = []
  tariffForm: FormGroup;

  constructor(public data: ResellerService, public fb: FormBuilder, public userservice: UsermanagementService,) { }

  ngOnInit(): void {

    for (let i = 0; i < 10; i++) {
      this.defaultOrder.push({ id: i, item: i + 1 });
    }

    this.filterUser = this.fb.group({
      from_date: [''],
      to_date: [''],
      resellerID: ['']
    });

    $('#basic-datatablesreseller').DataTable().clear();
    $('#basic-datatablesreseller').DataTable().destroy();
    $.getScript('./assets/tollfree.js');
    this.getlinkdata();

    this.data.getordderjson().subscribe((res) => {
    })
    this.dropdownSettings = {
      singleSelection: true,
      idField: 'id',
      textField: 'item',
      itemsShowLimit: 1,
      allowSearchFilter: true
    };

    this.tariffForm = this.fb.group({
      tariffs: this.fb.array([], this.uniqueOrderValidator)
    });
    this.initForm();
  }

  initForm() {
    const control = <FormArray>this.tariffForm.get('tariffs');
    this.Urltariff.forEach(() => {
      control.push(this.fb.group({
        selectedOrder: [null]
      }));
    });
  }

  get tariffsFormArray() {
    return this.tariffForm.get('tariffs') as FormArray;
  }

  // onSubmitTariff() {
  // if (this.tariffForm.invalid) {
  //   this.tariffForm.get('tariffs').markAsTouched();
  //   return;
  // }
  // const formValue = this.tariffForm.value;
  // const selectedTariffs = formValue.tariffs.map((t: any, index: number) => {
  //   return {
  //     idtariff: this.Urltariff[index]?.idtariff, 
  //     selectedOrderId: t.selectedOrder && t.selectedOrder[0]?.id 
  //   };
  // });
  // let payload={
  //   linkid:this.linkid,
  //   order:selectedTariffs,
  //   iduser:this.iduser
  // }
  // this.userservice.updateTariffOrder(payload).subscribe((res=>{
  //   if(res.status==201){
  //     this.tariffordering.nativeElement.click();
  //     this.iduser='';
  //     this.responseMessage=res.message
  //       setTimeout(() => {
  //         this.responseMessage = '';
  //       }, 3000);
  //   }else{
  //     this.errMessage=res.message
  //       setTimeout(() => {
  //         this.errMessage = '';
  //       }, 3000);
  //   }
  // }))

  // }
  onSubmitTariff() {
    const formValue = this.tariffForm.value;


    const validationResult = this.validateOrder(formValue);
    if (validationResult === false) {
      return;
    }

    if (this.tariffForm.invalid) {
      this.tariffForm.get('tariffs').markAsTouched();
      return;
    }

    const selectedTariffs = formValue.tariffs.map((t: any, index: number) => {
      return {
        idtariff: this.Urltariff[index]?.idtariff,
        selectedOrderId: t.selectedOrder && t.selectedOrder[0]?.item,
      };
    });

    let payload = {
      linkid: this.linkid,
      order: selectedTariffs,
      iduser: this.iduser
    };

    this.userservice.updateTariffOrder(payload).subscribe((res => {
      if (res.status == 201) {
        this.tariffordering.nativeElement.click();
        this.iduser = '';
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = '';
        }, 3000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 3000);
      }
    }));
  }

  validateOrder(formValue: any): any[] | false {
    let hasDuplicates = false;
    const orderSet = new Set();
    const tariffOrderData: any[] = [];
    let selectedCount = 0;
    const totalTariffs = formValue.tariffs.length;
    formValue.tariffs.forEach((tariff: any, index: number) => {
      let orderValue = 0;
      let selectedOrder = null;

      if (tariff.selectedOrder && tariff.selectedOrder.length > 0) {
        selectedOrder = tariff.selectedOrder[0];
        let rawValue = selectedOrder?.item;
        orderValue = Number(rawValue);
      }
      if (!isNaN(orderValue) && orderValue > 0) {
        selectedCount++;
        if (orderSet.has(orderValue)) {
          hasDuplicates = true;
        } else {
          orderSet.add(orderValue);
        }
      }
    });
    if (hasDuplicates) {
      this.errMessage = "Please select the correct order. Each order must be unique.";
      setTimeout(() => (this.errMessage = ""), 3000);
      return false;
    }
    if (selectedCount > 0 && selectedCount < totalTariffs) {
      this.errMessage = "Please select order for every tariff!";
      setTimeout(() => (this.errMessage = ""), 3000);
      return false;
    }
    return tariffOrderData;
  }


  orderTariff(data: any) {
    this.linkid = data.link_id;
    this.iduser = data.iduser;
    this.data.getUrlTariff(data.link_id).subscribe((res) => {
      if (res.status == 200) {
        this.Urltariff = res.data.map((tariff: any) => {
          const preSelectedOrder = this.defaultOrder.find(order => order.item === tariff.order_by);
          return {
            ...tariff,
            selectedOrder: preSelectedOrder ? [preSelectedOrder] : []
          };
        });
        this.rebuildTariffFormArray();
        // this.responseMessage = res.message;
      } 
    });
  }

  rebuildTariffFormArray() {
    const tariffsArray = this.fb.array([], this.uniqueOrderValidator);
    this.Urltariff.forEach(tariff => {
      tariffsArray.push(this.fb.group({
        selectedOrder: [tariff.selectedOrder || []]
      }));
    });
    this.tariffForm.setControl('tariffs', tariffsArray);
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  getlinkdata() {
    this.data.getresellerlinkdetails().subscribe((res) => {
      if (res.status == 201) {
        this.Resellerlink = res.data;
        //this.responseMessage = res.message
        $('#basic-datatablesreseller').DataTable().clear();
        $('#basic-datatablesreseller').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        setTimeout(() => {
          this.responseMessage = '';
        }, 3000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  textMessageFunc(msgText) {
    this.responseMessage = "URL Copied!";
    setTimeout(() => {
      this.responseMessage = "";
    }, 5000);
  }

  Submitfilter() {
    this.submitted = false;
    if (this.filterUser.invalid) {
      return;
    } else {
      this.data.applyFilter(this.filterUser.value).subscribe((res) => {
        if (res.status == 201) {
          this.Resellerlink = res.data;
          $('#basic-datatablesreseller').DataTable().clear();
          $('#basic-datatablesreseller').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset();
    Object.keys(this.filterUser.controls).forEach(key => {
      this.filterUser.get(key).setValue('');
    })
    this.getlinkdata();
  }

  messageshow() {
    const fromDate = this.filterUser.get('from_date').value;
    const toDate = this.filterUser.get('to_date').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterUser.get('from_date').setErrors(null);
      this.filterUser.get('to_date').setErrors(null);
    }
  }

  onSubmit() {
    this.Submitfilter();
  }

  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength ? subject.substring(0, maxLength) + '..' : subject;
  }

  // Custom validator for unique order selection
  uniqueOrderValidator: ValidatorFn = (formArray: AbstractControl) => {
    const selectedOrders = (formArray as FormArray).controls
      .map(group => group.get('selectedOrder')?.value)
      .filter(val => val && val.length > 0)
      .map(val => val[0]?.id); // single selection, so first item
    const hasDuplicates = selectedOrders.some((id, idx) => selectedOrders.indexOf(id) !== idx);
    return hasDuplicates ? { notUnique: true } : null;
  };

  ngOnDestroy() {
    this.tariffordering.nativeElement.click();
  }
}
