import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { ShortcodesmsComponent } from './shortcodesms/shortcodesms.component';
import { CreateProfileComponent } from './create-profile/create-profile.component';
import { ViewprofileComponent } from './viewprofile/viewprofile.component';
import { ShortcodeNumberComponent } from './shortcode-number/shortcode-number.component';
import { ShortcodeRequestComponent } from './shortcode-request/shortcode-request.component';

const routes: Routes = [

  {
    path: '',
        children: [
            {
                path: 'shortcode-campaign',
                component: ShortcodesmsComponent,
                data: {
                    title: 'Shortcode Campaign',
                    urls: [
                        {
                            title: 'Shortcode Number',
                        },
                        {
                            title: 'Shortcode Campaign'
                        }
                    ]
                }
            },
            {
              path: 'create-profile',
              component: CreateProfileComponent,
              data: {
                  title: 'Shortcode Number',
                  urls: [
                      {
                          title: 'Create Profile',
                          //   url: 'user'
                      },
                      {
                          title: 'Create Profile'
                      }
                  ]
              }
            },
            {
                path: 'create-profile/copy/:selected_id',
                component: CreateProfileComponent,
                data: {
                    title: 'Shortcode Number',
                    urls: [
                        {
                            title: 'Shortcode Number',
                        },
                        {
                            title: 'Shortcode SMS'
                        }
                    ]
                }
            },
            {
              path: 'create-profile/:id_profile',
              component: CreateProfileComponent,
              data: {
                  title: 'Shortcode Number',
                  urls: [
                      {
                          title: 'Edit Profile',
                          //   url: 'user'
                      },
                      {
                          title: 'Edit Profile'
                      }
                  ]
              }
            },
            {
              path: 'view-profile/:id_profile',
              component: ViewprofileComponent,
              data: {
                  title: 'Shortcode Number',
                  urls: [
                      {
                          title: 'Shortcode Number',
                          //   url: 'user'
                      },
                      {
                          title: 'View Profile'
                      }
                  ]
              }
            },
            {
                path: 'shortcode-request',
                component: ShortcodeRequestComponent,
                data: {
                    title: 'Shortcode Request',
                    urls: [
                        {
                            title: 'Shortcode Number',
                        },
                        {
                            title: 'Shortcode Request'
                        }
                    ]
                }
            },
            {
                path: 'shortcode-number',
                component: ShortcodeNumberComponent,
                data: {
                    title: 'Shortcode Number',
                    urls: [
                        {
                            title: 'Shortcode Number',
                            // url: '/toll-free-sms'
                        },
                        {
                            title: 'Shortcode Number'
                        }
                    ]
                }
            },
        ],
        
  }

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class ShortcodesmsRoutingModule { }
