import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { AngularEditorConfig } from '@kolkov/angular-editor';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { SignuptemplateService } from '../signuptemplate.service';

@Component({
  selector: 'app-smstemplate',
  templateUrl: './smstemplate.component.html',
  styleUrls: ['./smstemplate.component.css']
})
export class SmstemplateComponent extends AppComponentClass<any, any> {
  @ViewChild('myTextarea') myTextarea: ElementRef;
  htmlContent = '';
  message = '';
  idSMSTemplate: any;
  errMessage: any = '';
  smsTemplate: any = {};
  responseMessage: any = '';
  smsTemplateForm: FormGroup;
  submitted: boolean = false;
  sms_type: any;

  config: AngularEditorConfig = {
    editable: true,
    spellcheck: true,
    height: '15rem',
    minHeight: '5rem',
    placeholder: 'Enter text here...',
    translate: 'no',
    defaultParagraphSeparator: 'p',
    defaultFontName: 'Arial',
    toolbarHiddenButtons: [
      ['bold']
    ],
    customClasses: [
      {
        name: "quote",
        class: "quote",
      },
      {
        name: 'redText',
        class: 'redText'
      },
      {
        name: "titleText",
        class: "titleText",
        tag: "h1",
      },
    ]
  };
  constructor(public data: SignuptemplateService,

    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {

    super(data, router, fb);

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idSMSTemplate = params.get('id');
      if (this.idSMSTemplate) {
        this.data.getSmsTemplate(this.idSMSTemplate).subscribe(res => {
          if (res.status == 200) {
            if (res.data.length > 0) {
              this.smsTemplate = res.data[0];
              this.sms_type = this.smsTemplate.type;
              this.smsTemplateForm.patchValue({
                idsms_template: this.smsTemplate.idsms_template,
                name: this.smsTemplate.name,
                type: this.smsTemplate.type,
                body: this.smsTemplate.body
              });
            }
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        })
      }
    })

  }
  ngOnInit(): void {

    this.smsTemplateForm = this.fb.group({
      idsms_template: [''],
      type: ['', [Validators.required]],
      name: ['', [Validators.required]],
      body: ['', [Validators.required]],
    });
  }
  buttonClick(event: any) {
    const textarea = this.myTextarea.nativeElement;
    const cursorPosition = textarea.selectionStart;
    const currentValue = textarea.value;
    let charToInsert = '';
    if (event.key === 'Enter') {
      charToInsert = '\n';
    } else if (event.key === ' ') {
      charToInsert = ' ';
    } else {
      charToInsert = event.target.value;
    }
    const newValue =
      currentValue.substring(0, cursorPosition) +
      charToInsert +
      currentValue.substring(cursorPosition);
    this.smsTemplateForm.get('body').setValue(newValue);
    const newCursorPosition = cursorPosition + charToInsert.length;
    const maxLength = textarea.value.length;
    const finalCursorPosition = Math.min(newCursorPosition, maxLength);
    textarea.setSelectionRange(finalCursorPosition, finalCursorPosition);
    textarea.focus();
  }
  
  onSubmit(): void {
    if (this.smsTemplateForm.invalid) {
      this.submitted = true;
      return
    } else {
      console.log(this.smsTemplateForm.value);
      this.data.updateSmsTemplate(this.smsTemplateForm.value).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;          
          setTimeout(() => {
            this.router.navigateByUrl('/signup-template/sms-template-details');
            this.responseMessage = "";
          }, 3000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }
  onEdit(data: any) { }

  resetForm() {
    this.submitted = false;
    this.smsTemplateForm.reset();
    this.smsTemplateForm.patchValue({
      idsms_template: this.idSMSTemplate,
      type: this.sms_type
    })
  }

}
