import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { Validators, FormBuilder, FormGroup, AbstractControl, ValidatorFn } from '@angular/forms';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { DatePipe, formatDate } from '@angular/common';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
	selector: 'app-mdrs',
	templateUrl: './mdrs.component.html',
	styleUrls: ['./mdrs.component.css']
})

export class MdrsComponent extends AppComponentClass<any, any> {
	@ViewChild('downloadreportmodal') downloadreportmodal: ElementRef;
	@ViewChild('viewdetails') viewdetails: ElementRef;
	show_filter: boolean = false;
	show_daily: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public mdrsForm: FormGroup;
	public summerymdrsForm: FormGroup;
	public submitted: boolean = false;
	filterMDR: any = [];
	singleMDR: any = [];
	isOutbound$ = new BehaviorSubject<Boolean>(false);
	isOutbound = this.isOutbound$.asObservable();
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	monthNameList: any = [];
	filterSummarySms: any = [];
	currentDate: any;
	startdate: any;
	lastdate: any;
	sel: boolean;
	exportfile: any = [];
	userType: any;
	public downloadreport: FormGroup;
	submitteddownload: boolean;
	responseMessage: any = "";
	dropdownSettings: IDropdownSettings = {};
	dropdownSetting: IDropdownSettings = {};
	closeDropdownSelection = true;
	directionOptions: any[] = [];
	directionOptions1: any[] = [];
	dropdownSettingsd: IDropdownSettings = {};
	dropdownSettingsd1: IDropdownSettings = {};

	constructor(public data: SmsService, public router: Router,
		public fb: FormBuilder, msg: MatSnackBar,
		private userService: UsermanagementService,
		private datePipe: DatePipe) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getidAccount().subscribe(res => {
			// this.userlist = res.data[0];
			this.userlist = res.data.map((user) => ({
				iduser: `${user.iduser}-${user.idaccount}`,
				userlist: `${user.san} - ${user.first_name} ${user.last_name}`,
			}))
			// $.getScript('./assets/table.js');
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.userType = user.type;
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}
		this.mdrsForm = this.fb.group({
			from_date: [this.startDate()],
			to_date: [this.current_datetime()],
			from_number: [''],
			to_number: [''],
			direction: [''],
			iduser: [''],
			fType: ['']
		});
		this.summerymdrsForm = this.fb.group({
			from_date: ['', [Validators.required]],
			to_date: ['', [Validators.required]],
			directionSummery: [''],
			fType: [''],
			iduser: ['']
		});

		this.summerymdrsForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		});

		this.data.get_mdrs().subscribe((result) => {
			this.label = result[1];
			// if (this.userType === 1) {
			this.header = result[0].headers_details;
			// } else {
			// this.header = result[0].headers_details.filter(column => column !== 'SAN');
			// }
			this.rowdata = result[0].product_details;
		});
		this.mdrsForm.patchValue({
			fType: ""
		})
		this.data.getMDRFilter(JSON.stringify(this.mdrsForm.value)).subscribe(response => {
			if (response.status == 200) {
				this.filterMDR = response.data;
				$('#basic-datatablesMess').DataTable().clear();
				$('#basic-datatablesMess').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
		});
		this.summerySmsmdrsForm();

		this.downloadreport = this.fb.group({
			from_date: [[this.startDate()]],
			to_date: [[this.current_datetime()]],
			directions: [''],
			// status: [''],
			fromnumber: [''],
			tonumber: [''],
			type: [1]
		})


		this.dropdownSettings = {
			singleSelection: true,
			idField: 'iduser',
			textField: 'userlist',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};
		this.dropdownSetting = {
			singleSelection: true,
			idField: 'iduser',
			textField: 'userlist',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSettingsd = {
			singleSelection: true,
			idField: 'id',
			textField: 'name',
			allowSearchFilter: false,
			closeDropDownOnSelection: true
		};
		this.directionOptions = [
			{ id: 'Inbound', name: 'Inbound' },
			{ id: 'Outbound', name: 'Outbound' },
			{ id: 'Both', name: 'Both' }
		];

		this.dropdownSettingsd1 = {
			singleSelection: true,
			idField: 'id',
			textField: 'option',
			allowSearchFilter: false,
			closeDropDownOnSelection: true
		};
		this.directionOptions1 = [
			{ id: 'Inbound', option: 'Inbound' },
			{ id: 'Outbound', option: 'Outbound' }
		];
	}

	// @to save/update form data
	onMdrsGet() {
		this.submitted = true;
		this.mdrsForm.patchValue({
			fType: ""
		})
		if (this.mdrsForm.invalid) {
			// $('#basic-datatablesMess').DataTable().destroy();
			return
		}
		else {
			this.mdrsForm.value.direction = this.mdrsForm.value.direction[0]?.id || ''
			this.mdrsForm.value.iduser = this.mdrsForm.value.iduser[0]?.iduser || ''
			this.filterMDR = [];
			this.data.getMDRFilter(JSON.stringify(this.mdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterMDR = response.data
					$('#basic-datatablesMess').DataTable().clear();
					$('#basic-datatablesMess').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	getFullMdr(data) {
		this.singleMDR = data
		if (this.singleMDR.Direction == "outbound") {
			this.isOutbound$.next(true);
		}
		else {
			this.isOutbound$.next(false);
		}
	}

	// exportFile(e: any) {
	// 	let fType = "filter";
	// 	this.mdrsForm.patchValue({
	// 		fType: fType
	// 	})
	// 	this.summerymdrsForm.patchValue({
	// 		fType: fType
	// 	})
	// 	if (e == 'message') {
	// 		const exportFormValues = { ...this.mdrsForm.value };
	// 		exportFormValues.direction = exportFormValues.direction[0]?.id || '';
	// 		exportFormValues.iduser = exportFormValues.iduser[0]?.iduser || '';
	// 		this.exportfile = [];
	// 		this.data.getMDRFilter(JSON.stringify(exportFormValues)).subscribe(response => {
	// 			if (response.status == 200) {
	// 				if (response.data.length > 0) {
	// 					this.exportfile = response.data.map(item => {
	// 						delete item.idmdr;
	// 						let transformedItem = {}
	// 						if (this.userType == 1) {
	// 							transformedItem = {
	// 								"SAN": item.san,
	// 								"Direction": item.direction,
	// 								"Msg Count": item.msg_count,
	// 								"From Number": item.from_number,
	// 								"To Number": item.to_number,
	// 								"MT rates": item.MT_rates,
	// 								"MO rates": item.MO_rates,
	// 								"MT Surcharge": item.MT_surcharge,
	// 								"MO Surcharge": item.MO_surcharge,
	// 								// "Status": item.status ,
	// 								"Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
	// 								"Message Delivered To Operator": new Date(item.message_delivered_to_operator).toLocaleDateString('en-US'),
	// 								"Message Accepted By Signalmash": new Date(item.message_accepted_by_signalmash).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Received By Signalmash": new Date(item.delivery_receipt_received_by_singnalmash).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Delivered": new Date(item.delivery_receipt_delivered).toLocaleDateString('en-US'),
	// 								"Mobility": item.mobility,
	// 								"Messsage Body": item.messsage_body,
	// 								"Ocn": item.ocn,
	// 								"Lata": item.lata,
	// 								"Created At": new Date(item.created_at).toLocaleDateString('en-US'),
	// 								"Cost": item.cost,
	// 							};
	// 						} else {
	// 							transformedItem = {
	// 								"Direction": item.direction,
	// 								"Msg Count": item.msg_count,
	// 								"From Number": item.from_number,
	// 								"To Number": item.to_number,
	// 								"MT rates": item.MT_rates,
	// 								"MO rates": item.MO_rates,
	// 								"MT Surcharge": item.MT_surcharge,
	// 								"MO Surcharge": item.MO_surcharge,
	// 								// "Status": item.status ,
	// 								"Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
	// 								"Message Delivered To Operator": new Date(item.message_delivered_to_operator).toLocaleDateString('en-US'),
	// 								"Message Accepted By Signalmash": new Date(item.message_accepted_by_signalmash).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Received By Signalmash": new Date(item.delivery_receipt_received_by_singnalmash).toLocaleDateString('en-US'),
	// 								"Delivery Receipt Delivered": new Date(item.delivery_receipt_delivered).toLocaleDateString('en-US'),
	// 								"Mobility": item.mobility,
	// 								"Messsage Body": item.messsage_body,
	// 								"Ocn": item.ocn,
	// 								"Lata": item.lata,
	// 								"Created At": new Date(item.created_at).toLocaleDateString('en-US'),
	// 								"Cost": item.cost,
	// 							};
	// 						}
	// 						return transformedItem;
	// 					});

	// 					const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
	// 					const workbook: XLSX.WorkBook = { Sheets: { 'SMS-MDR': worksheet }, SheetNames: ['SMS-MDR'] };
	// 					const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
	// 					this.saveAsExcelFile(excelBuffer, "SMS-MDR");
	// 				}
	// 				else {
	// 					this.errMessage = "Record Not Found !";
	// 					setTimeout(() => {
	// 						this.errMessage = ""
	// 					}, 5000);
	// 				}
	// 			}
	// 			else {
	// 				this.errMessage = response.message;
	// 				setTimeout(() => {
	// 					this.errMessage = "";
	// 				}, 5000);
	// 			}
	// 		});

	// 	}
	// 	if (e == 'summery') {
	// 		const exportSummaryValues = { ...this.summerymdrsForm.value };
	// 		exportSummaryValues.directionSummery = exportSummaryValues.directionSummery[0]?.id || '';
	// 		exportSummaryValues.iduser = exportSummaryValues.iduser[0]?.iduser || '';
	// 		this.exportfile = [];
	// 		this.data.summerySmsmdrForm(JSON.stringify(exportSummaryValues)).subscribe(response => {
	// 			if (response.status == 200) {
	// 				if (response.data.length > 0) {
	// 					this.exportfile = response.data.map(item => {
	// 						delete item.idmdr;
	// 						let transformedItem = {}
	// 						if (this.userType == 1) {
	// 							transformedItem = {
	// 								"SAN": 100000000 + item.idaccount,
	// 								"Date": new Date(item.date).toLocaleDateString('en-US'),
	// 								"Direction": item.direction,
	// 								"Total Message": item.total_message,
	// 								"Total Cost": item.total_cost,
	// 								// "Status": item.status,
	// 								"Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
	// 							};
	// 						} else {
	// 							transformedItem = {
	// 								"Date": new Date(item.date).toLocaleDateString('en-US'),
	// 								"Direction": item.direction,
	// 								"Total Message": item.total_message,
	// 								"Total Cost": item.total_cost,
	// 								// "Status": item.status,
	// 								"Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
	// 							};
	// 						}
	// 						return transformedItem;
	// 					});
	// 					const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
	// 					const workbook: XLSX.WorkBook = { Sheets: { 'SMS-MDR': worksheet }, SheetNames: ['SMS-MDR'] };
	// 					const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
	// 					this.saveAsExcelFile(excelBuffer, "SMS-MDR");
	// 				}
	// 				else {
	// 					this.errMessage = "Record Not Found !";
	// 					setTimeout(() => {
	// 						this.errMessage = ""
	// 					}, 5000);
	// 				}
	// 			}
	// 			else {
	// 				this.errMessage = response.message;
	// 				setTimeout(() => {
	// 					this.errMessage = "";
	// 				}, 5000);
	// 			}
	// 		});
	// 	}

	// }


	exportFile(e: any) {
		let fType = "filter";
		this.mdrsForm.patchValue({
			fType: fType
		});
		this.summerymdrsForm.patchValue({
			fType: fType
		});
		if (e == 'message') {
			const exportFormValues = { ...this.mdrsForm.value };
			exportFormValues.direction = exportFormValues.direction[0]?.id || '';
			exportFormValues.iduser = exportFormValues.iduser[0]?.iduser || '';
			this.exportfile = [];
			this.data.getMDRFilter(JSON.stringify(exportFormValues)).subscribe(response => {
				if (response.status == 200) {
					if (response.data.length > 0) {
						this.exportfile = response.data.map(item => {
							delete item.idmdr;
							let transformedItem = {}
							if (this.userType == 1) {
								transformedItem = {
									"SAN": item.san,
									"Direction": item.direction,
									"Msg Count": item.msg_count,
									"From Number": item.from_number,
									"To Number": item.to_number,
									"MT rates": item.MT_rates,
									"MO rates": item.MO_rates,
									"MT Surcharge": item.MT_surcharge,
									"MO Surcharge": item.MO_surcharge,
									"Status": item.status,
									// "Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
									"Message Delivered To Operator": new Date(item.message_delivered_to_operator).toLocaleDateString('en-US'),
									"Message Accepted By Signalmash": new Date(item.message_accepted_by_signalmash).toLocaleDateString('en-US'),
									"Delivery Receipt Received By Signalmash": new Date(item.delivery_receipt_received_by_singnalmash).toLocaleDateString('en-US'),
									"Delivery Receipt Delivered": new Date(item.delivery_receipt_delivered).toLocaleDateString('en-US'),
									"Mobility": item.mobility,
									"Messsage Body": item.messsage_body,
									"Ocn": item.ocn,
									"Lata": item.lata,
									"Created At": new Date(item.created_at).toLocaleDateString('en-US'),
									"Cost": item.cost,
								};
							} else {
								transformedItem = {
									"Direction": item.direction,
									"Msg Count": item.msg_count,
									"From Number": item.from_number,
									"To Number": item.to_number,
									"MT rates": item.MT_rates,
									"MO rates": item.MO_rates,
									"MT Surcharge": item.MT_surcharge,
									"MO Surcharge": item.MO_surcharge,
									"Status": item.status,
									// "Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
									"Message Delivered To Operator": new Date(item.message_delivered_to_operator).toLocaleDateString('en-US'),
									"Message Accepted By Signalmash": new Date(item.message_accepted_by_signalmash).toLocaleDateString('en-US'),
									"Delivery Receipt Received By Signalmash": new Date(item.delivery_receipt_received_by_singnalmash).toLocaleDateString('en-US'),
									"Delivery Receipt Delivered": new Date(item.delivery_receipt_delivered).toLocaleDateString('en-US'),
									"Mobility": item.mobility,
									"Messsage Body": item.messsage_body,
									"Ocn": item.ocn,
									"Lata": item.lata,
									"Created At": new Date(item.created_at).toLocaleDateString('en-US'),
									"Cost": item.cost,
								};
							}
							return transformedItem;
						});

						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'SMS-MDR': worksheet }, SheetNames: ['SMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "SMS-MDR");
					}
					else {
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage = ""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});

		}

		if (e == 'summery') {
			this.exportfile = [];

			let exportSummaryForm = { ...this.summerymdrsForm.value };
			if (this.summerymdrsForm.value.directionSummery &&
				Array.isArray(this.summerymdrsForm.value.directionSummery) &&
				this.summerymdrsForm.value.directionSummery.length > 0) {
				exportSummaryForm.directionSummery = this.summerymdrsForm.value.directionSummery[0]?.id || '';
			}
			if (this.summerymdrsForm.value.iduser &&
				Array.isArray(this.summerymdrsForm.value.iduser) &&
				this.summerymdrsForm.value.iduser.length > 0) {
				exportSummaryForm.iduser = this.summerymdrsForm.value.iduser[0]?.iduser || '';
			}
			this.data.summerySmsmdrForm(JSON.stringify(exportSummaryForm)).subscribe(response => {
				if (response.status == 200) {
					if (response.data.length > 0) {
						this.exportfile = response.data.map(item => {
							delete item.idmdr;
							let transformedItem = {}
							if (this.userType == 1) {
								transformedItem = {
									"SAN": 100000000 + item.idaccount,
									"Date": new Date(item.date).toLocaleDateString('en-US'),
									"Direction": item.direction,
									"Total Message": item.total_message,
									"Failed Message": item.failed_msg,
									"Total Cost": item.total_cost,
									// "Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
								};
							} else {
								transformedItem = {
									"Date": new Date(item.date).toLocaleDateString('en-US'),
									"Direction": item.direction,
									"Total Message": item.total_message,
									"Failed Message": item.failed_msg,
									"Total Cost": item.total_cost,
									// "Status": item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 34 ? 'Expired' : item.status == 16 ? 'No Acknowledge From SMSC' : item.status == 64 ? 'Internal Expired' : item.status == 'dispatched' ? 'Dispatched' : '',
								};
							}
							return transformedItem;
						});
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'SMS-MDR': worksheet }, SheetNames: ['SMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "SMS-MDR");
					}
					else {
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage = ""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}
	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}



	// startDate() {
	// 	let now = new Date();
	// 	let year = "" + now.getFullYear();
	// 	let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
	// 	let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
	// 	let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
	// 	let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
	// 	let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
	// 	return year + '-' + month + "-" + "01";
	// }


	// startDate() {
	// 	let now = new Date();
	// 	now.setDate(now.getDate() - 90);
	// 	let year = "" + now.getFullYear();
	// 	let month = "" + (now.getMonth() + 1);
	// 	if (month.length == 1) {
	// 		month = "0" + month;
	// 	}

	// 	let day = "" + now.getDate();
	// 	if (day.length == 1) {
	// 		day = "0" + day;
	// 	}

	// 	return year + '-' + month + "-" + day;
	// }

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1);
		if (month.length == 1) {
			month = "0" + month;
		}
		let day = "01";
		return year + '-' + month + "-" + day;
	}
	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}

	monthsList() {
		this.monthNameList = [
			{ name: "Jan", value: "1" },
			{ name: "Feb", value: "2" },
			{ name: "Mar", value: "3" },
			{ name: "Apr", value: "4" },
			{ name: "May", value: "5" },
			{ name: "Jun", value: "6" },
			{ name: "Jul", value: "7" },
			{ name: "Aug", value: "8" },
			{ name: "Sep", value: "9" },
			{ name: "Oct", value: "10" },
			{ name: "Nov", value: "11" },
			{ name: "Dec", value: "12" }
		];
	}


	// static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
	// 	return (c: AbstractControl): { [key: string]: boolean } | null => {
	// 		const date1 = c.get(from_date).value;
	// 		const date2 = c.get(to_date).value;
	// 		if ((date1 !== null && date2 !== null) && date1 > date2) {
	// 			return validatorField;
	// 		}
	// 		return null;
	// 	};
	// }

	messageshow() {
		this.validateDateRange(this.mdrsForm, 1);
		this.validateDateRange(this.summerymdrsForm, 2);
		this.validateDateRange(this.downloadreport, 3);

	}

	validateDateRange(form: FormGroup, type: any) {
		const fromDate = form.get('from_date').value;
		const toDate = form.get('to_date').value;
		const currentDate = new Date();
		const threeMonthsAgo = new Date();
		threeMonthsAgo.setMonth(currentDate.getMonth() - 3);
		const oneAndHalfYearsAgo = new Date();
		oneAndHalfYearsAgo.setMonth(currentDate.getMonth() - 18);


		if ((!fromDate && !toDate)) {
			// No date range selected, do nothing
		} else if ((fromDate == null || !fromDate) && (toDate != null)) {
			form.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((fromDate != null) && (toDate == null || !toDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (toDate && new Date(toDate) > currentDate) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (fromDate && new Date(fromDate) > currentDate) {
			form.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		}
		else if (new Date(fromDate) < threeMonthsAgo && type == 1) {
			form.get('from_date').setErrors({ 'dateRange': 'We can only provide data for the last three months' });
			return;
		}
		else if (new Date(fromDate) < oneAndHalfYearsAgo && type == 3) {
			form.get('from_date').setErrors({ 'dateRange': 'We can only provide data for the last 1.5 years' });
			return;
		}
		else {
			form.get('from_date').setErrors(null);
			form.get('to_date').setErrors(null);
		}
	}

	summerySmsmdrsForm() {
		this.summerymdrsForm.patchValue({
			fType: ""
		})
		if (this.summerymdrsForm.invalid) {
			return false
		}
		else {
			this.summerymdrsForm.value.directionSummery = this.summerymdrsForm.value.directionSummery[0]?.id || '',
				this.summerymdrsForm.value.iduser = this.summerymdrsForm.value.iduser[0]?.iduser || ''
			this.filterSummarySms = [];
			this.data.summerySmsmdrForm(JSON.stringify(this.summerymdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummarySms = response.data;
					$('#basic-datatablesSum').DataTable().clear();
					$('#basic-datatablesSum').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetMdr() {
		this.submitted = false;
		this.mdrsForm.reset();
		this.mdrsForm.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
			direction: [],
			iduser: [],
			fType: ""
		});
		this.onMdrsGet();
	}


	OnRequest() {
		this.submitteddownload = true;
		if (this.downloadreport.invalid) {
			return false;
		} else {
			// this.downloadreport.value.type = 1
			this.data.SMSrequest(this.downloadreport.value).subscribe((res => {
				console.log("resresresresresres:::", res);

				if (res.status == 201) {
					this.responseMessage = res.message;
					this.downloadreportmodal.nativeElement.click();
					setTimeout(() => {
						this.responseMessage = '';
						this.router.navigate(['./downloadreport/sms']);
					}, 5000);
				} else {
					this.errMessage = res.message;
					this.downloadreportmodal.nativeElement.click();
					setTimeout(() => {
						this.errMessage = '';
						this.router.navigate(['./downloadreport/sms']);
					}, 5000);
				}
			}));
		}
	}


	minDate() {
		const now = new Date();
		now.setMonth(now.getMonth() - 18); // Subtract 18 months
		return now.toISOString().slice(0, 10);
	}


	ResetRequest() {
		this.submitteddownload = false
		this.downloadreport.reset()
		this.downloadreport.get('directions').setValue("")
		this.downloadreport.get('type').setValue(1)
		this.downloadreport.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})
	}

	showfilter() {
		this.show_filter = !this.show_filter;
		this.show_daily = !this.show_daily;
	}


	resSumry() {
		this.submitted = false;
		this.summerymdrsForm.reset();

		// Properly reset dropdown values
		this.summerymdrsForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate,
			directionSummery: [],
			iduser: [],
			fType: ""
		});

		// Reinitialize the form if needed
		this.summerySmsmdrsForm();
	}

	// resSumry() {
	// 	this.submitted = false;
	// 	this.summerymdrsForm.reset({
	// 		from_date: this.lastdate,
	// 		to_date: this.startdate,
	// 		directionSummery: [],
	// 		iduser: [],
	// 		fType: ''
	// 	});
	// 	this.errMessage = "";
	// 	this.summerySmsmdrsForm();
	// }

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

	ngOnDestroy() {
		this.viewdetails.nativeElement.click();
		this.downloadreportmodal.nativeElement.click();

	}


}
